/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.parser;

import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.sonarsource.slang.api.ParseException;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.impl.TextPointerImpl;

public class ErrorStrategy
extends DefaultErrorStrategy {
    public void reportError(Parser recognizer, RecognitionException e) {
        Token t = recognizer.getCurrentToken();
        String errorMessage = String.format("Unexpected parsing error occurred. Last found valid token: %s at position %s:%s", this.getTokenErrorDisplay(t), t.getLine(), t.getCharPositionInLine());
        TextPointerImpl textPointer = new TextPointerImpl(t.getLine(), t.getCharPositionInLine());
        throw new ParseException(errorMessage, (TextPointer)textPointer);
    }

    public Token recoverInline(Parser recognizer) {
        Token matchedSymbol = this.singleTokenDeletion(recognizer);
        if (matchedSymbol != null) {
            String errorMessage = String.format("Unexpected token found: %s at position %s:%s", matchedSymbol.getText(), matchedSymbol.getLine(), matchedSymbol.getCharPositionInLine());
            throw new ParseException(errorMessage);
        }
        this.singleTokenInsertion(recognizer);
        throw new ParseException("Unexpected parsing error");
    }

    protected void reportMissingToken(Parser recognizer) {
        Token t = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String errorMessage = String.format("missing %s before %s at position %s:%s", expecting.toString(recognizer.getVocabulary()), this.getTokenErrorDisplay(t), t.getLine(), t.getCharPositionInLine());
        throw new ParseException(errorMessage);
    }
}

