/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.sonarsource.analyzer.commons.TokenLocation;
import org.sonarsource.slang.api.ASTConverter;
import org.sonarsource.slang.api.Annotation;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.CatchTree;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.JumpTree;
import org.sonarsource.slang.api.LoopTree;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.api.NativeKind;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.ParameterTree;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.api.UnaryExpressionTree;
import org.sonarsource.slang.impl.AnnotationImpl;
import org.sonarsource.slang.impl.AssignmentExpressionTreeImpl;
import org.sonarsource.slang.impl.BinaryExpressionTreeImpl;
import org.sonarsource.slang.impl.BlockTreeImpl;
import org.sonarsource.slang.impl.CatchTreeImpl;
import org.sonarsource.slang.impl.ClassDeclarationTreeImpl;
import org.sonarsource.slang.impl.CommentImpl;
import org.sonarsource.slang.impl.ExceptionHandlingTreeImpl;
import org.sonarsource.slang.impl.FunctionDeclarationTreeImpl;
import org.sonarsource.slang.impl.FunctionInvocationTreeImpl;
import org.sonarsource.slang.impl.IdentifierTreeImpl;
import org.sonarsource.slang.impl.IfTreeImpl;
import org.sonarsource.slang.impl.ImportDeclarationTreeImpl;
import org.sonarsource.slang.impl.IntegerLiteralTreeImpl;
import org.sonarsource.slang.impl.JumpTreeImpl;
import org.sonarsource.slang.impl.LiteralTreeImpl;
import org.sonarsource.slang.impl.LoopTreeImpl;
import org.sonarsource.slang.impl.MatchCaseTreeImpl;
import org.sonarsource.slang.impl.MatchTreeImpl;
import org.sonarsource.slang.impl.MemberSelectTreeImpl;
import org.sonarsource.slang.impl.ModifierTreeImpl;
import org.sonarsource.slang.impl.NativeTreeImpl;
import org.sonarsource.slang.impl.PackageDeclarationTreeImpl;
import org.sonarsource.slang.impl.ParameterTreeImpl;
import org.sonarsource.slang.impl.ParenthesizedExpressionTreeImpl;
import org.sonarsource.slang.impl.PlaceHolderTreeImpl;
import org.sonarsource.slang.impl.ReturnTreeImpl;
import org.sonarsource.slang.impl.StringLiteralTreeImpl;
import org.sonarsource.slang.impl.TextPointerImpl;
import org.sonarsource.slang.impl.TextRangeImpl;
import org.sonarsource.slang.impl.TextRanges;
import org.sonarsource.slang.impl.ThrowTreeImpl;
import org.sonarsource.slang.impl.TokenImpl;
import org.sonarsource.slang.impl.TopLevelTreeImpl;
import org.sonarsource.slang.impl.TreeMetaDataProvider;
import org.sonarsource.slang.impl.UnaryExpressionTreeImpl;
import org.sonarsource.slang.impl.VariableDeclarationTreeImpl;
import org.sonarsource.slang.parser.ErrorStrategy;
import org.sonarsource.slang.parser.SLangBaseVisitor;
import org.sonarsource.slang.parser.SLangLexer;
import org.sonarsource.slang.parser.SLangParser;
import org.sonarsource.slang.parser.SNativeKind;

public class SLangConverter
implements ASTConverter {
    private static final Set<Integer> KEYWORD_TOKEN_TYPES = new HashSet<Integer>(Arrays.asList(20, 23, 24, 25, 26, 27, 28, 30, 31));
    private static final Map<String, UnaryExpressionTree.Operator> UNARY_OPERATOR_MAP = SLangConverter.unaryOperatorMap();
    private static final Map<String, BinaryExpressionTree.Operator> BINARY_OPERATOR_MAP = SLangConverter.binaryOperatorMap();
    private static final Map<String, AssignmentExpressionTree.Operator> ASSIGNMENT_OPERATOR_MAP = SLangConverter.assignmentOperatorMap();

    public Tree parse(String slangCode) {
        CommonTokenStream antlrTokens = SLangConverter.getTokenStream(slangCode);
        ArrayList<Comment> comments = new ArrayList<Comment>();
        ArrayList<org.sonarsource.slang.api.Token> tokens = new ArrayList<org.sonarsource.slang.api.Token>();
        for (int index = 0; index < antlrTokens.size(); ++index) {
            Token token = antlrTokens.get(index);
            TextRange textRange = SLangConverter.getSlangTextRange(token);
            if (token.getChannel() == 1) {
                comments.add((Comment)SLangConverter.comment(token, textRange));
                continue;
            }
            Token.Type type = Token.Type.OTHER;
            if (KEYWORD_TOKEN_TYPES.contains(token.getType())) {
                type = Token.Type.KEYWORD;
            } else if (token.getType() == 44) {
                type = Token.Type.STRING_LITERAL;
            }
            tokens.add((org.sonarsource.slang.api.Token)new TokenImpl(textRange, token.getText(), type));
        }
        SLangParser parserAnnotation = new SLangParser((TokenStream)SLangConverter.getTokenStream(slangCode));
        parserAnnotation.setErrorHandler((ANTLRErrorStrategy)new ErrorStrategy());
        SlangParseTreeAnnotationsVisitor annotationsVisitor = new SlangParseTreeAnnotationsVisitor();
        annotationsVisitor.visit((ParseTree)parserAnnotation.slangFile());
        SLangParser parser = new SLangParser((TokenStream)antlrTokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new ErrorStrategy());
        SLangParseTreeVisitor slangVisitor = new SLangParseTreeVisitor(comments, tokens, annotationsVisitor.annotations);
        return (Tree)slangVisitor.visit((ParseTree)parser.slangFile());
    }

    private static CommonTokenStream getTokenStream(String slangCode) {
        SLangLexer lexer = new SLangLexer((CharStream)CharStreams.fromString((String)slangCode));
        CommonTokenStream antlrTokens = new CommonTokenStream((TokenSource)lexer);
        antlrTokens.fill();
        return antlrTokens;
    }

    private static CommentImpl comment(Token token, TextRange range) {
        TextPointer contentEnd;
        String contentText;
        String text = token.getText();
        if (text.startsWith("//")) {
            contentText = text.substring(2);
            contentEnd = range.end();
        } else {
            contentText = text.substring(2, text.length() - 2);
            contentEnd = new TextPointerImpl(range.end().line(), range.end().lineOffset() - 2);
        }
        TextPointerImpl contentStart = new TextPointerImpl(range.start().line(), range.start().lineOffset() + 2);
        return new CommentImpl(token.getText(), contentText, range, (TextRange)new TextRangeImpl((TextPointer)contentStart, contentEnd));
    }

    private static Map<String, UnaryExpressionTree.Operator> unaryOperatorMap() {
        HashMap<String, UnaryExpressionTree.Operator> map = new HashMap<String, UnaryExpressionTree.Operator>();
        map.put("!", UnaryExpressionTree.Operator.NEGATE);
        map.put("+", UnaryExpressionTree.Operator.PLUS);
        map.put("-", UnaryExpressionTree.Operator.MINUS);
        map.put("++", UnaryExpressionTree.Operator.INCREMENT);
        map.put("--", UnaryExpressionTree.Operator.DECREMENT);
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, BinaryExpressionTree.Operator> binaryOperatorMap() {
        HashMap<String, BinaryExpressionTree.Operator> map = new HashMap<String, BinaryExpressionTree.Operator>();
        map.put("&&", BinaryExpressionTree.Operator.CONDITIONAL_AND);
        map.put("||", BinaryExpressionTree.Operator.CONDITIONAL_OR);
        map.put(">", BinaryExpressionTree.Operator.GREATER_THAN);
        map.put(">=", BinaryExpressionTree.Operator.GREATER_THAN_OR_EQUAL_TO);
        map.put("<", BinaryExpressionTree.Operator.LESS_THAN);
        map.put("<=", BinaryExpressionTree.Operator.LESS_THAN_OR_EQUAL_TO);
        map.put("==", BinaryExpressionTree.Operator.EQUAL_TO);
        map.put("!=", BinaryExpressionTree.Operator.NOT_EQUAL_TO);
        map.put("+", BinaryExpressionTree.Operator.PLUS);
        map.put("-", BinaryExpressionTree.Operator.MINUS);
        map.put("*", BinaryExpressionTree.Operator.TIMES);
        map.put("/", BinaryExpressionTree.Operator.DIVIDED_BY);
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, AssignmentExpressionTree.Operator> assignmentOperatorMap() {
        HashMap<String, AssignmentExpressionTree.Operator> map = new HashMap<String, AssignmentExpressionTree.Operator>();
        map.put("=", AssignmentExpressionTree.Operator.EQUAL);
        map.put("+=", AssignmentExpressionTree.Operator.PLUS_EQUAL);
        return Collections.unmodifiableMap(map);
    }

    private static TextRange getSlangTextRange(Token matchToken) {
        TokenLocation location = new TokenLocation(matchToken.getLine(), matchToken.getCharPositionInLine(), matchToken.getText());
        return new TextRangeImpl(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
    }

    private static class SlangParseTreeAnnotationsVisitor
    extends SLangBaseVisitor<Tree> {
        List<Annotation> annotations = new ArrayList<Annotation>();

        private SlangParseTreeAnnotationsVisitor() {
        }

        @Override
        public Tree visitAnnotation(SLangParser.AnnotationContext ctx) {
            String simpleName = ctx.identifier().Identifier().toString();
            ArrayList argumentsText = new ArrayList();
            SLangParser.AnnotationParametersContext argument = ctx.annotationParameters();
            if (argument != null) {
                argumentsText.addAll(argument.annotationParameter().stream().map(RuleContext::getText).collect(Collectors.toList()));
            }
            this.annotations.add((Annotation)new AnnotationImpl(simpleName, argumentsText, (TextRange)new TextRangeImpl(SLangParseTreeVisitor.startOf(ctx.start), SLangParseTreeVisitor.endOf(ctx.stop))));
            return (Tree)super.visitAnnotation(ctx);
        }
    }

    private static class SLangParseTreeVisitor
    extends SLangBaseVisitor<Tree> {
        private final TreeMetaDataProvider metaDataProvider;

        public SLangParseTreeVisitor(List<Comment> comments, List<org.sonarsource.slang.api.Token> tokens, List<Annotation> annotations) {
            this.metaDataProvider = new TreeMetaDataProvider(comments, tokens, annotations);
        }

        @Override
        public Tree visitSlangFile(SLangParser.SlangFileContext ctx) {
            TextRangeImpl textRange = new TextRangeImpl(SLangParseTreeVisitor.startOf(ctx.start), (TextPointer)new TextPointerImpl(ctx.stop.getLine(), ctx.stop.getCharPositionInLine()));
            List<Tree> typeDeclarations = this.list(ctx.typeDeclaration());
            ArrayList<Tree> allDeclarations = new ArrayList<Tree>();
            if (ctx.packageDeclaration() != null) {
                allDeclarations.add((Tree)this.visit((ParseTree)ctx.packageDeclaration()));
            }
            allDeclarations.addAll(this.list(ctx.importDeclaration()));
            allDeclarations.addAll(typeDeclarations);
            org.sonarsource.slang.api.Token firstCpdToken = typeDeclarations.isEmpty() ? null : (org.sonarsource.slang.api.Token)typeDeclarations.get(0).metaData().tokens().get(0);
            return new TopLevelTreeImpl(this.meta((TextRange)textRange), allDeclarations, this.metaDataProvider.allComments(), firstCpdToken);
        }

        @Override
        public Tree visitPackageDeclaration(SLangParser.PackageDeclarationContext ctx) {
            return new PackageDeclarationTreeImpl(this.meta(ctx), Collections.singletonList((Tree)this.visit((ParseTree)ctx.identifier())));
        }

        @Override
        public Tree visitImportDeclaration(SLangParser.ImportDeclarationContext ctx) {
            return new ImportDeclarationTreeImpl(this.meta(ctx), Collections.singletonList((Tree)this.visit((ParseTree)ctx.identifier())));
        }

        @Override
        public Tree visitTypeDeclaration(SLangParser.TypeDeclarationContext ctx) {
            if (ctx.methodDeclaration() != null) {
                return (Tree)this.visit((ParseTree)ctx.methodDeclaration());
            }
            if (ctx.classDeclaration() != null) {
                return (Tree)this.visit((ParseTree)ctx.classDeclaration());
            }
            return (Tree)this.visit((ParseTree)ctx.controlBlock());
        }

        @Override
        public Tree visitClassDeclaration(SLangParser.ClassDeclarationContext ctx) {
            ArrayList<Object> children = new ArrayList<Object>();
            IdentifierTree identifier = null;
            if (ctx.identifier() != null) {
                identifier = (IdentifierTree)this.visit((ParseTree)ctx.identifier());
                children.add(identifier);
            }
            children.addAll(this.list(ctx.typeDeclaration()));
            NativeTreeImpl classDecl = new NativeTreeImpl(this.meta(ctx), (NativeKind)new SNativeKind(ctx), children);
            return new ClassDeclarationTreeImpl(this.meta(ctx), identifier, (Tree)classDecl);
        }

        @Override
        public Tree visitNativeExpression(SLangParser.NativeExpressionContext ctx) {
            return this.nativeTree(ctx, ctx.nativeBlock());
        }

        @Override
        public Tree visitParenthesizedExpression(SLangParser.ParenthesizedExpressionContext ctx) {
            return new ParenthesizedExpressionTreeImpl(this.meta(ctx), (Tree)this.visit((ParseTree)ctx.statement()), SLangParseTreeVisitor.toSlangToken(ctx.LPAREN().getSymbol()), SLangParseTreeVisitor.toSlangToken(ctx.RPAREN().getSymbol()));
        }

        @Override
        public Tree visitMethodDeclaration(SLangParser.MethodDeclarationContext ctx) {
            List<Tree> modifiers = this.list(ctx.methodModifier());
            IdentifierTreeImpl returnType = null;
            IdentifierTree name = null;
            SLangParser.MethodHeaderContext methodHeaderContext = ctx.methodHeader();
            SLangParser.SimpleTypeContext resultContext = methodHeaderContext.simpleType();
            SLangParser.IdentifierContext identifier = methodHeaderContext.methodDeclarator().identifier();
            if (resultContext != null) {
                returnType = new IdentifierTreeImpl(this.meta(resultContext), resultContext.getText());
            }
            boolean isConstructor = false;
            if (identifier != null) {
                name = (IdentifierTree)this.visit((ParseTree)identifier);
                isConstructor = "constructor".equals(name.name());
            }
            ArrayList<Tree> convertedParameters = new ArrayList<Tree>();
            SLangParser.FormalParameterListContext formalParameterListContext = methodHeaderContext.methodDeclarator().formalParameterList();
            if (formalParameterListContext != null) {
                SLangParser.FormalParametersContext formalParameters = formalParameterListContext.formalParameters();
                if (formalParameters != null) {
                    convertedParameters.addAll(this.list(formalParameters.formalParameter()));
                }
                convertedParameters.add((Tree)this.visit((ParseTree)formalParameterListContext.lastFormalParameter()));
            }
            return new FunctionDeclarationTreeImpl(this.meta(ctx), modifiers, isConstructor, (Tree)returnType, name, convertedParameters, (BlockTree)this.visit((ParseTree)ctx.methodBody()), Collections.emptyList());
        }

        @Override
        public Tree visitMethodModifier(SLangParser.MethodModifierContext ctx) {
            ModifierTree.Kind modifierKind = ModifierTree.Kind.PUBLIC;
            if (ctx.PRIVATE() != null) {
                modifierKind = ModifierTree.Kind.PRIVATE;
            } else if (ctx.OVERRIDE() != null) {
                modifierKind = ModifierTree.Kind.OVERRIDE;
            } else if (ctx.nativeExpression() != null) {
                return (Tree)this.visit((ParseTree)ctx.nativeExpression());
            }
            return new ModifierTreeImpl(this.meta(ctx), modifierKind);
        }

        @Override
        public Tree visitMethodInvocation(SLangParser.MethodInvocationContext ctx) {
            ArrayList<Tree> arguments = new ArrayList<Tree>();
            SLangParser.ArgumentListContext argumentListContext = ctx.argumentList();
            if (argumentListContext != null) {
                arguments.addAll(this.list(argumentListContext.statement()));
            }
            return new FunctionInvocationTreeImpl(this.meta(ctx), (Tree)this.visit((ParseTree)ctx.memberSelect()), arguments);
        }

        @Override
        public Tree visitMemberSelect(SLangParser.MemberSelectContext ctx) {
            Tree id = (Tree)this.visit((ParseTree)ctx.identifier());
            if (ctx.memberSelect() != null) {
                IdentifierTree identifier = (IdentifierTree)id;
                return new MemberSelectTreeImpl(this.meta(ctx), (Tree)this.visit((ParseTree)ctx.memberSelect()), identifier);
            }
            return id;
        }

        @Override
        public Tree visitMethodBody(SLangParser.MethodBodyContext ctx) {
            if (ctx.SEMICOLON() != null) {
                return null;
            }
            return (Tree)this.visit((ParseTree)ctx.block());
        }

        @Override
        public Tree visitFormalParameter(SLangParser.FormalParameterContext ctx) {
            IdentifierTree tree = (IdentifierTree)this.visit((ParseTree)ctx.variableDeclaratorId().identifier());
            IdentifierTreeImpl type = null;
            Tree defaultValue = null;
            List<Tree> modifiers = this.list(ctx.parameterModifier());
            if (ctx.simpleType() != null) {
                type = new IdentifierTreeImpl(this.meta(ctx.simpleType()), ctx.simpleType().getText());
            }
            if (ctx.expression() != null) {
                defaultValue = (Tree)this.visit((ParseTree)ctx.expression());
            }
            return new ParameterTreeImpl(this.meta(ctx), tree, (Tree)type, defaultValue, modifiers);
        }

        @Override
        public Tree visitLastFormalParameter(SLangParser.LastFormalParameterContext ctx) {
            return (Tree)this.visit((ParseTree)ctx.formalParameter());
        }

        @Override
        public Tree visitDeclaration(SLangParser.DeclarationContext ctx) {
            IdentifierTree identifier = (IdentifierTree)this.visit((ParseTree)ctx.identifier());
            IdentifierTreeImpl type = null;
            if (ctx.simpleType() != null) {
                type = new IdentifierTreeImpl(this.meta(ctx.simpleType()), ctx.simpleType().getText());
            }
            Tree initializer = null;
            if (ctx.expression() != null) {
                initializer = (Tree)this.visit((ParseTree)ctx.expression());
            }
            boolean isVal = ctx.declarationModifier().VAL() != null;
            return new VariableDeclarationTreeImpl(this.meta(ctx), identifier, (Tree)type, initializer, isVal);
        }

        @Override
        public Tree visitBlock(SLangParser.BlockContext ctx) {
            return new BlockTreeImpl(this.meta(ctx), this.list(ctx.statement()));
        }

        @Override
        public Tree visitIfExpression(SLangParser.IfExpressionContext ctx) {
            org.sonarsource.slang.api.Token ifToken = SLangParseTreeVisitor.toSlangToken(ctx.IF().getSymbol());
            org.sonarsource.slang.api.Token elseToken = null;
            Tree elseBranch = null;
            if (ctx.controlBlock().size() > 1) {
                elseBranch = (Tree)this.visit((ParseTree)ctx.controlBlock(1));
                elseToken = SLangParseTreeVisitor.toSlangToken(ctx.ELSE().getSymbol());
            }
            Tree thenBranch = (Tree)this.visit((ParseTree)ctx.controlBlock(0));
            return new IfTreeImpl(this.meta(ctx), (Tree)this.visit((ParseTree)ctx.statement()), thenBranch, elseBranch, ifToken, elseToken);
        }

        @Override
        public Tree visitMatchExpression(SLangParser.MatchExpressionContext ctx) {
            ArrayList<MatchCaseTree> cases = new ArrayList<MatchCaseTree>();
            for (SLangParser.MatchCaseContext matchCaseContext : ctx.matchCase()) {
                cases.add((MatchCaseTree)this.visit((ParseTree)matchCaseContext));
            }
            TreeMetaData meta = this.meta(ctx);
            Tree expression = ctx.statement() == null ? null : (Tree)this.visit((ParseTree)ctx.statement());
            return new MatchTreeImpl(meta, expression, cases, SLangParseTreeVisitor.toSlangToken(ctx.MATCH().getSymbol()));
        }

        @Override
        public Tree visitMatchCase(SLangParser.MatchCaseContext ctx) {
            Tree expression = ctx.statement() == null ? null : (Tree)this.visit((ParseTree)ctx.statement());
            Tree body = ctx.controlBlock() == null ? null : (Tree)this.visit((ParseTree)ctx.controlBlock());
            return new MatchCaseTreeImpl(this.meta(ctx), expression, body);
        }

        @Override
        public Tree visitForLoop(SLangParser.ForLoopContext ctx) {
            Tree condition = ctx.declaration() == null ? null : (Tree)this.visit((ParseTree)ctx.declaration());
            Tree body = (Tree)this.visit((ParseTree)ctx.controlBlock());
            return new LoopTreeImpl(this.meta(ctx), condition, body, LoopTree.LoopKind.FOR, SLangParseTreeVisitor.toSlangToken(ctx.FOR().getSymbol()));
        }

        @Override
        public Tree visitWhileLoop(SLangParser.WhileLoopContext ctx) {
            Tree condition = (Tree)this.visit((ParseTree)ctx.statement());
            Tree body = (Tree)this.visit((ParseTree)ctx.controlBlock());
            return new LoopTreeImpl(this.meta(ctx), condition, body, LoopTree.LoopKind.WHILE, SLangParseTreeVisitor.toSlangToken(ctx.WHILE().getSymbol()));
        }

        @Override
        public Tree visitDoWhileLoop(SLangParser.DoWhileLoopContext ctx) {
            Tree condition = (Tree)this.visit((ParseTree)ctx.statement());
            Tree body = (Tree)this.visit((ParseTree)ctx.controlBlock());
            return new LoopTreeImpl(this.meta(ctx), condition, body, LoopTree.LoopKind.DOWHILE, SLangParseTreeVisitor.toSlangToken(ctx.DO().getSymbol()));
        }

        @Override
        public Tree visitCatchBlock(SLangParser.CatchBlockContext ctx) {
            ParameterTree parameter = ctx.formalParameter() == null ? null : (ParameterTree)this.visit((ParseTree)ctx.formalParameter());
            Tree body = (Tree)this.visit((ParseTree)ctx.block());
            return new CatchTreeImpl(this.meta(ctx), (Tree)parameter, body, SLangParseTreeVisitor.toSlangToken(ctx.CATCH().getSymbol()));
        }

        @Override
        public Tree visitTryExpression(SLangParser.TryExpressionContext ctx) {
            Tree tryBlock = (Tree)this.visit((ParseTree)ctx.block());
            ArrayList<CatchTree> catchTreeList = new ArrayList<CatchTree>();
            for (SLangParser.CatchBlockContext catchBlockContext : ctx.catchBlock()) {
                catchTreeList.add((CatchTree)this.visit((ParseTree)catchBlockContext));
            }
            org.sonarsource.slang.api.Token tryToken = SLangParseTreeVisitor.toSlangToken(ctx.TRY().getSymbol());
            Tree finallyBlock = ctx.finallyBlock() == null ? null : (Tree)this.visit((ParseTree)ctx.finallyBlock());
            return new ExceptionHandlingTreeImpl(this.meta(ctx), tryBlock, tryToken, catchTreeList, finallyBlock);
        }

        @Override
        public Tree visitNativeBlock(SLangParser.NativeBlockContext ctx) {
            return this.nativeTree(ctx, ctx.statement());
        }

        @Override
        public Tree visitAssignment(SLangParser.AssignmentContext ctx) {
            Tree leftHandSide = (Tree)this.visit((ParseTree)ctx.expression());
            Tree statementOrExpression = this.assignmentTree(ctx.statement(), ctx.assignmentOperator());
            AssignmentExpressionTree.Operator operator = ASSIGNMENT_OPERATOR_MAP.get(ctx.assignmentOperator(0).getText());
            return new AssignmentExpressionTreeImpl(this.meta(ctx), operator, leftHandSide, statementOrExpression);
        }

        @Override
        public Tree visitDisjunction(SLangParser.DisjunctionContext ctx) {
            return this.binaryTree(ctx.conjunction(), ctx.disjunctionOperator());
        }

        @Override
        public Tree visitConjunction(SLangParser.ConjunctionContext ctx) {
            return this.binaryTree(ctx.equalityComparison(), ctx.conjunctionOperator());
        }

        @Override
        public Tree visitEqualityComparison(SLangParser.EqualityComparisonContext ctx) {
            return this.binaryTree(ctx.comparison(), ctx.equalityOperator());
        }

        @Override
        public Tree visitComparison(SLangParser.ComparisonContext ctx) {
            return this.binaryTree(ctx.additiveExpression(), ctx.comparisonOperator());
        }

        @Override
        public Tree visitAdditiveExpression(SLangParser.AdditiveExpressionContext ctx) {
            return this.binaryTree(ctx.multiplicativeExpression(), ctx.additiveOperator());
        }

        @Override
        public Tree visitMultiplicativeExpression(SLangParser.MultiplicativeExpressionContext ctx) {
            return this.binaryTree(ctx.unaryExpression(), ctx.multiplicativeOperator());
        }

        @Override
        public Tree visitUnaryExpression(SLangParser.UnaryExpressionContext ctx) {
            if (ctx.unaryOperator() == null) {
                return (Tree)this.visit((ParseTree)ctx.atomicExpression());
            }
            Tree operand = (Tree)this.visit((ParseTree)ctx.unaryExpression());
            return new UnaryExpressionTreeImpl(this.meta(ctx), UNARY_OPERATOR_MAP.get(ctx.unaryOperator().getText()), operand);
        }

        @Override
        public Tree visitLiteral(SLangParser.LiteralContext ctx) {
            if (ctx.StringLiteral() != null) {
                return new StringLiteralTreeImpl(this.meta(ctx), ctx.getText());
            }
            if (ctx.IntegerLiteral() != null) {
                return new IntegerLiteralTreeImpl(this.meta(ctx), ctx.getText());
            }
            return new LiteralTreeImpl(this.meta(ctx), ctx.getText());
        }

        @Override
        public Tree visitIdentifier(SLangParser.IdentifierContext ctx) {
            if ("__".equals(ctx.getText())) {
                return null;
            }
            if ("_".equals(ctx.getText())) {
                return new PlaceHolderTreeImpl(this.meta(ctx), SLangParseTreeVisitor.toSlangToken(ctx.getStart()));
            }
            return new IdentifierTreeImpl(this.meta(ctx), ctx.getText());
        }

        @Override
        public Tree visitBreakExpression(SLangParser.BreakExpressionContext ctx) {
            IdentifierTree label = null;
            if (ctx.label() != null) {
                label = (IdentifierTree)this.visit((ParseTree)ctx.label());
            }
            return new JumpTreeImpl(this.meta(ctx), SLangParseTreeVisitor.toSlangToken(ctx.BREAK().getSymbol()), JumpTree.JumpKind.BREAK, label);
        }

        @Override
        public Tree visitContinueExpression(SLangParser.ContinueExpressionContext ctx) {
            IdentifierTree label = null;
            if (ctx.label() != null) {
                label = (IdentifierTree)this.visit((ParseTree)ctx.label());
            }
            return new JumpTreeImpl(this.meta(ctx), SLangParseTreeVisitor.toSlangToken(ctx.CONTINUE().getSymbol()), JumpTree.JumpKind.CONTINUE, label);
        }

        @Override
        public Tree visitReturnExpression(SLangParser.ReturnExpressionContext ctx) {
            Tree returnBody = null;
            if (ctx.statement() != null) {
                returnBody = (Tree)this.visit((ParseTree)ctx.statement());
            }
            return new ReturnTreeImpl(this.meta(ctx), SLangParseTreeVisitor.toSlangToken(ctx.RETURN().getSymbol()), returnBody);
        }

        @Override
        public Tree visitThrowExpression(SLangParser.ThrowExpressionContext ctx) {
            Tree throwBody = null;
            if (ctx.statement() != null) {
                throwBody = (Tree)this.visit((ParseTree)ctx.statement());
            }
            return new ThrowTreeImpl(this.meta(ctx), SLangParseTreeVisitor.toSlangToken(ctx.THROW().getSymbol()), throwBody);
        }

        private static TextPointer startOf(Token token) {
            return new TextPointerImpl(token.getLine(), token.getCharPositionInLine());
        }

        private static TextPointer endOf(Token token) {
            return new TextPointerImpl(token.getLine(), token.getCharPositionInLine() + token.getText().length());
        }

        private TreeMetaData meta(ParserRuleContext ctx) {
            return this.meta((TextRange)new TextRangeImpl(SLangParseTreeVisitor.startOf(ctx.start), SLangParseTreeVisitor.endOf(ctx.stop)));
        }

        private TreeMetaData meta(Tree first, Tree last) {
            return this.meta((TextRange)new TextRangeImpl(first.metaData().textRange().start(), last.metaData().textRange().end()));
        }

        private TreeMetaData meta(TextRange textRange) {
            return this.metaDataProvider.metaData(textRange);
        }

        private NativeTree nativeTree(ParserRuleContext ctx, List<? extends ParseTree> rawChildren) {
            List<Tree> children = this.list(rawChildren);
            return new NativeTreeImpl(this.meta(ctx), (NativeKind)new SNativeKind(ctx), children);
        }

        private List<Tree> list(List<? extends ParseTree> rawChildren) {
            return rawChildren.stream().map(arg_0 -> ((SLangParseTreeVisitor)this).visit(arg_0)).collect(Collectors.toList());
        }

        private Tree binaryTree(List<? extends ParseTree> operands, List<? extends ParserRuleContext> operators) {
            Tree result = (Tree)this.visit(operands.get(operands.size() - 1));
            for (int i = operands.size() - 2; i >= 0; --i) {
                Tree left = (Tree)this.visit(operands.get(i));
                BinaryExpressionTree.Operator operator = BINARY_OPERATOR_MAP.get(operators.get(i).getText());
                result = new BinaryExpressionTreeImpl(this.meta(left, result), operator, SLangParseTreeVisitor.operatorToken(operators.get(i)), left, result);
            }
            return result;
        }

        private Tree assignmentTree(List<? extends ParseTree> expressions, List<? extends ParseTree> operators) {
            Tree result = (Tree)this.visit(expressions.get(expressions.size() - 1));
            for (int i = expressions.size() - 2; i >= 0; --i) {
                Tree left = (Tree)this.visit(expressions.get(i));
                AssignmentExpressionTree.Operator operator = ASSIGNMENT_OPERATOR_MAP.get(operators.get(i).getText());
                result = new AssignmentExpressionTreeImpl(this.meta(left, result), operator, left, result);
            }
            return result;
        }

        private static org.sonarsource.slang.api.Token toSlangToken(Token antlrToken) {
            TextRange textRange = SLangConverter.getSlangTextRange(antlrToken);
            return new TokenImpl(textRange, antlrToken.getText(), Token.Type.KEYWORD);
        }

        private static org.sonarsource.slang.api.Token operatorToken(ParserRuleContext parserRuleContext) {
            TextRange textRange = TextRanges.merge(Arrays.asList(SLangConverter.getSlangTextRange(parserRuleContext.start), SLangConverter.getSlangTextRange(parserRuleContext.stop)));
            return new TokenImpl(textRange, parserRuleContext.getText(), Token.Type.OTHER);
        }
    }
}

