/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.parser;

import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.CodeVerifier;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.LiteralTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.parser.SLangConverter;

public class SlangCodeVerifier
implements CodeVerifier {
    public boolean containsCode(String content) {
        Tree tree;
        SLangConverter sLangConverter = new SLangConverter();
        try {
            tree = sLangConverter.parse(content);
        }
        catch (Exception e) {
            tree = null;
        }
        return tree != null && !SlangCodeVerifier.isSimpleExpression(tree);
    }

    private static boolean isSimpleExpression(Tree tree) {
        long all = tree.descendants().count();
        if (all == 0L) {
            return true;
        }
        long remaining = tree.descendants().filter(element -> !(element instanceof IdentifierTree) && !(element instanceof LiteralTree) && !SlangCodeVerifier.simpleBinaryExpressionTree(element)).count();
        double detectedCodeRatio = (double)remaining / (double)all;
        return detectedCodeRatio < 0.3;
    }

    private static boolean simpleBinaryExpressionTree(Tree element) {
        if (element instanceof BinaryExpressionTree) {
            BinaryExpressionTree expression = (BinaryExpressionTree)element;
            return expression.operator().equals((Object)BinaryExpressionTree.Operator.PLUS) || expression.operator().equals((Object)BinaryExpressionTree.Operator.MINUS) || expression.operator().equals((Object)BinaryExpressionTree.Operator.DIVIDED_BY);
        }
        return false;
    }
}

