/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.TreeMetaData;

public class TreeMetaDataProvider {
    public static final Comparator<HasTextRange> COMPARATOR = Comparator.comparing(e -> e.textRange().start());
    private final List<Comment> sortedComments;
    private final List<Token> sortedTokens;

    public TreeMetaDataProvider(List<Comment> comments, List<Token> tokens) {
        this.sortedComments = new ArrayList<Comment>(comments);
        this.sortedComments.sort(COMPARATOR);
        this.sortedTokens = new ArrayList<Token>(tokens);
        this.sortedTokens.sort(COMPARATOR);
    }

    public List<Comment> allComments() {
        return this.sortedComments;
    }

    public TreeMetaData metaData(TextRange textRange) {
        return new TreeMetaDataImpl(textRange);
    }

    private class TreeMetaDataImpl
    implements TreeMetaData {
        private final TextRange textRange;
        private Set<Integer> linesOfCode;

        private TreeMetaDataImpl(TextRange textRange) {
            this.textRange = textRange;
        }

        @Override
        public TextRange textRange() {
            return this.textRange;
        }

        @Override
        public List<Comment> commentsInside() {
            return this.getElementsInsideRange(TreeMetaDataProvider.this.sortedComments);
        }

        @Override
        public List<Token> tokens() {
            return this.getElementsInsideRange(TreeMetaDataProvider.this.sortedTokens);
        }

        private <T extends HasTextRange> List<T> getElementsInsideRange(List<T> sortedList) {
            HasTextRange element;
            ArrayList<HasTextRange> elementsInsideRange = new ArrayList<HasTextRange>();
            HasTextRange key = () -> this.textRange;
            int index = Collections.binarySearch(sortedList, key, COMPARATOR);
            if (index < 0) {
                index = -index - 1;
            }
            for (int i = index; i < sortedList.size() && (element = (HasTextRange)sortedList.get(i)).textRange().isInside(this.textRange); ++i) {
                elementsInsideRange.add(element);
            }
            return elementsInsideRange;
        }

        @Override
        public Set<Integer> linesOfCode() {
            if (this.linesOfCode == null) {
                this.linesOfCode = this.computeLinesOfCode();
            }
            return this.linesOfCode;
        }

        private Set<Integer> computeLinesOfCode() {
            HashSet<Integer> loc = new HashSet<Integer>();
            for (Token token : this.tokens()) {
                TextRange range = token.textRange();
                for (int i = range.start().line(); i <= range.end().line(); ++i) {
                    loc.add(i);
                }
            }
            return loc;
        }
    }
}

