/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.visitors;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.LiteralTree;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.visitors.TreeContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class TreePrinter {
    private TreePrinter() {
    }

    public static String tree2string(List<Tree> trees) {
        return trees.stream().map(TreePrinter::tree2string).collect(Collectors.joining("\n"));
    }

    public static String tree2string(Tree tree) {
        StringBuilder sb = new StringBuilder();
        TreeVisitor<TreeContext> visitor = new TreeVisitor<TreeContext>();
        visitor.register(Tree.class, (ctx, t) -> {
            IntStream.range(0, ctx.ancestors().size()).forEach(i -> sb.append("  "));
            sb.append(t.getClass().getSimpleName());
            if (t instanceof BinaryExpressionTree) {
                sb.append(" ").append(((BinaryExpressionTree)t).operator().name());
            } else if (t instanceof AssignmentExpressionTree) {
                sb.append(" ").append(((AssignmentExpressionTree)t).operator().name());
            } else if (t instanceof LiteralTree) {
                sb.append(" ").append(((LiteralTree)t).value());
            } else if (t instanceof IdentifierTree) {
                sb.append(" ").append(((IdentifierTree)t).name());
            } else if (t instanceof NativeTree) {
                sb.append(" ").append(((NativeTree)t).nativeKind());
            } else if (t instanceof ModifierTree) {
                sb.append(" ").append((Object)((ModifierTree)t).kind());
            }
            sb.append("\n");
        });
        visitor.scan(new TreeContext(), tree);
        return sb.toString();
    }
}

