/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.persistence;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.TreeMetaDataProvider;
import org.sonarsource.slang.persistence.conversion.DeserializationContext;
import org.sonarsource.slang.persistence.conversion.JsonTreeConverter;
import org.sonarsource.slang.persistence.conversion.SerializationContext;

public final class JsonTree {
    private JsonTree() {
    }

    public static String toJson(Tree tree) {
        TreeMetaData metaData = tree.metaData();
        TreeMetaDataProvider provider = new TreeMetaDataProvider(metaData.commentsInside(), metaData.tokens());
        SerializationContext ctx = new SerializationContext(JsonTreeConverter.POLYMORPHIC_CONVERTER);
        return Json.object().add("treeMetaData", (JsonValue)JsonTreeConverter.TREE_METADATA_PROVIDER_TO_JSON.apply((TreeMetaDataProvider)((Object)ctx), provider)).add("tree", ctx.toJson(tree)).toString();
    }

    public static Tree fromJson(String json) {
        JsonObject root = Json.parse((String)json).asObject();
        JsonObject treeMetaData = root.get("treeMetaData").asObject();
        DeserializationContext ctx = new DeserializationContext(JsonTreeConverter.POLYMORPHIC_CONVERTER);
        TreeMetaDataProvider metaDataProvider = (TreeMetaDataProvider)JsonTreeConverter.TREE_METADATA_PROVIDER_FROM_JSON.apply((TreeMetaDataProvider)((Object)ctx), treeMetaData);
        ctx = ctx.withMetaDataProvider(metaDataProvider);
        return ctx.fieldToNullableObject(root, "tree", Tree.class);
    }
}

