/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.persistence.conversion;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.NativeKind;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.TreeMetaDataProvider;
import org.sonarsource.slang.persistence.conversion.PolymorphicConverter;
import org.sonarsource.slang.persistence.conversion.RangeConverter;
import org.sonarsource.slang.persistence.conversion.StringNativeKind;

public class DeserializationContext {
    private static final int MAX_ILLEGAL_ELEMENT_TEXT_LENGTH = 80;
    private final PolymorphicConverter polymorphicConverter;
    private final Deque<String> jsonPath = new LinkedList<String>();
    private TreeMetaDataProvider metaDataProvider = null;

    public DeserializationContext(PolymorphicConverter polymorphicConverter) {
        this.polymorphicConverter = polymorphicConverter;
    }

    public DeserializationContext withMetaDataProvider(TreeMetaDataProvider metaDataProvider) {
        this.metaDataProvider = metaDataProvider;
        return this;
    }

    public void pushPath(String fieldName) {
        this.jsonPath.addLast(fieldName);
    }

    public void popPath() {
        this.jsonPath.removeLast();
    }

    public String path() {
        return String.join((CharSequence)"/", this.jsonPath);
    }

    public TreeMetaData metaData(JsonObject json) {
        return RangeConverter.resolveMetaData(this.metaDataProvider, this.fieldToString(json, "metaData"));
    }

    public RuntimeException newIllegalMemberException(String message, @Nullable Object illegalElement) {
        String elementText = String.valueOf(illegalElement);
        elementText = elementText.substring(0, Math.min(elementText.length(), 80));
        return new IllegalStateException(message + " at '" + this.path() + "' member: " + elementText);
    }

    @Nullable
    public <T extends Tree> T fieldToNullableObject(JsonObject parent, String fieldName, Class<T> expectedClass) {
        JsonValue json = parent.get(fieldName);
        if (json == null || Json.NULL.equals((Object)json)) {
            return null;
        }
        return (T)((Tree)this.object(json, fieldName, expectedClass));
    }

    public <T extends Tree> T fieldToObject(JsonObject parent, String fieldName, Class<T> expectedClass) {
        JsonValue json = parent.get(fieldName);
        if (json == null || Json.NULL.equals((Object)json)) {
            throw this.newIllegalMemberException("Unexpected null value for field '" + fieldName + "'", json);
        }
        return (T)((Tree)this.object(json, fieldName, expectedClass));
    }

    public NativeKind fieldToNativeKind(JsonObject parent, String fieldName) {
        return StringNativeKind.of(this.fieldToString(parent, fieldName, ""));
    }

    public <T extends Enum<T>> T fieldToEnum(JsonObject parent, String fieldName, Class<T> enumType) {
        return Enum.valueOf(enumType, this.fieldToString(parent, fieldName));
    }

    public <T extends Enum<T>> T fieldToEnum(JsonObject parent, String fieldName, String defaultValue, Class<T> enumType) {
        return Enum.valueOf(enumType, this.fieldToString(parent, fieldName, defaultValue));
    }

    public <T extends Tree> List<T> fieldToObjectList(JsonObject parent, String fieldName, Class<T> expectedClass) {
        return this.objectList(parent.get(fieldName), fieldName + "[]", expectedClass);
    }

    public <T extends Tree> List<T> objectList(@Nullable JsonValue value, String memberName, Class<T> expectedClass) {
        return this.objectList(value, (JsonObject jsonChild) -> (Tree)this.object((JsonValue)jsonChild, memberName, expectedClass));
    }

    public <T> List<T> objectList(@Nullable JsonValue value, BiFunction<DeserializationContext, JsonObject, T> converter) {
        return this.objectList(value, (JsonObject jsonChild) -> converter.apply(this, (JsonObject)jsonChild));
    }

    private <T> List<T> objectList(@Nullable JsonValue value, Function<JsonObject, T> converter) {
        if (value == null || value.isNull()) {
            return Collections.emptyList();
        }
        if (!value.isArray()) {
            throw this.newIllegalMemberException("Expect Array instead of " + value.getClass().getSimpleName(), value);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (JsonValue jsonValue : value.asArray()) {
            result.add(converter.apply(jsonValue.asObject()));
        }
        return result;
    }

    public String fieldToNullableString(JsonObject json, String fieldName) {
        JsonValue value = json.get(fieldName);
        if (value == null || Json.NULL.equals((Object)value)) {
            return null;
        }
        return this.fieldToString(json, fieldName);
    }

    public String fieldToString(JsonObject json, String fieldName) {
        JsonValue value = json.get(fieldName);
        if (value == null || Json.NULL.equals((Object)value)) {
            throw this.newIllegalMemberException("Missing non-null value for field '" + fieldName + "'", json);
        }
        if (!value.isString()) {
            throw this.newIllegalMemberException("Expect String instead of '" + value.getClass().getSimpleName() + "' for field '" + fieldName + "'", json);
        }
        return value.asString();
    }

    public String fieldToString(JsonObject json, String fieldName, String defaultValue) {
        return json.getString(fieldName, defaultValue);
    }

    public TextRange fieldToRange(JsonObject json, String fieldName) {
        return RangeConverter.parse(this.fieldToString(json, fieldName));
    }

    public Token fieldToToken(JsonObject json, String fieldName) {
        return RangeConverter.resolveToken(this.metaDataProvider, this.fieldToString(json, fieldName));
    }

    @Nullable
    public Token fieldToNullableToken(JsonObject json, String fieldName) {
        return RangeConverter.resolveToken(this.metaDataProvider, this.fieldToNullableString(json, fieldName));
    }

    private <T> T object(JsonValue json, String memberName, Class<T> expectedClass) {
        this.pushPath(memberName);
        if (!json.isObject()) {
            throw this.newIllegalMemberException("Unexpected value for Tree", json);
        }
        JsonObject jsonObject = json.asObject();
        String jsonType = this.fieldToString(jsonObject, "@type");
        T object = this.polymorphicConverter.fromJson(this, jsonType, jsonObject, memberName, expectedClass);
        this.popPath();
        return object;
    }
}

