/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.complexity.CognitiveComplexity;

@Rule(key="S3776")
public class FunctionCognitiveComplexityCheck
implements SlangCheck {
    private static final int DEFAULT_THRESHOLD = 15;
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    public int threshold = 15;

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            if (tree.name() == null) {
                return;
            }
            CognitiveComplexity complexity = new CognitiveComplexity((Tree)tree);
            if (complexity.value() > this.threshold) {
                String message = String.format("Refactor this method to reduce its Cognitive Complexity from %s to the %s allowed.", complexity.value(), this.threshold);
                List<SecondaryLocation> secondaryLocations = complexity.increments().stream().map(FunctionCognitiveComplexityCheck::secondaryLocation).collect(Collectors.toList());
                Double gap = (double)complexity.value() - (double)this.threshold;
                ctx.reportIssue(tree::rangeToHighlight, message, secondaryLocations, gap);
            }
        });
    }

    private static SecondaryLocation secondaryLocation(CognitiveComplexity.Increment increment) {
        int nestingLevel = increment.nestingLevel();
        String message = "+" + (nestingLevel + 1);
        if (nestingLevel > 0) {
            message = message + " (incl " + nestingLevel + " for nesting)";
        }
        return new SecondaryLocation(increment.token().textRange(), message);
    }
}

