/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.externalreport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rules.RuleType;
import org.sonar.go.externalreport.AbstractReportSensor;
import org.sonar.go.externalreport.ExternalIssue;
import org.sonarsource.slang.utils.LogArg;

public class GoVetReportSensor
extends AbstractReportSensor {
    private static final Logger LOG = LoggerFactory.getLogger(GoVetReportSensor.class);
    public static final String PROPERTY_KEY = "sonar.go.govet.reportPaths";
    private static final Pattern GO_VET_LINE_REGEX = Pattern.compile("(?<file>[^:]+):(?<line>\\d+):(?<message>.*)");
    public static final String LINTER_ID = "govet";
    public static final String LINTER_NAME = "go vet";

    public GoVetReportSensor(AnalysisWarnings analysisWarnings) {
        super(analysisWarnings, LINTER_ID, LINTER_NAME, PROPERTY_KEY);
    }

    @Override
    @Nullable
    ExternalIssue parse(String line) {
        Matcher matcher = GO_VET_LINE_REGEX.matcher(line);
        if (matcher.matches()) {
            String filename = matcher.group("file").trim();
            int lineNumber = Integer.parseInt(matcher.group("line").trim());
            String message = matcher.group("message").trim();
            return new ExternalIssue(LINTER_ID, RuleType.BUG, null, filename, lineNumber, message);
        }
        if (!line.startsWith("exit status")) {
            LOG.debug("{}Unexpected line: {}", LogArg.lazyArg(this::logPrefix), (Object)line);
        }
        return null;
    }
}

