/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S1066")
public class CollapsibleIfStatementsCheck
implements SlangCheck {
    private static final String MESSAGE_TEMPLATE = "Merge this \"%s\" statement with the nested one.";
    private static final String SECONDARY_MESSAGE_TEMPLATE = "Nested \"%s\" statement";

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, (ctx, ifTreeStatement) -> {
            if (ifTreeStatement.elseBranch() == null) {
                CollapsibleIfStatementsCheck.getCollapsibleIfStatement(ifTreeStatement.thenBranch()).ifPresent(innerIfStatement -> {
                    TextRange innerIfRange = innerIfStatement.ifKeyword().textRange();
                    String message = String.format(MESSAGE_TEMPLATE, ifTreeStatement.ifKeyword().text());
                    String secondaryMessage = String.format(SECONDARY_MESSAGE_TEMPLATE, innerIfStatement.ifKeyword().text());
                    ctx.reportIssue((HasTextRange)ifTreeStatement.ifKeyword(), message, new SecondaryLocation(innerIfRange, secondaryMessage));
                });
            }
        });
    }

    private static Optional<IfTree> getCollapsibleIfStatement(Tree tree) {
        if (tree instanceof BlockTree) {
            BlockTree blockTree = (BlockTree)tree;
            return blockTree.statementOrExpressions().size() == 1 ? CollapsibleIfStatementsCheck.getIfStatementWithoutElse(tree.children().get(0)) : Optional.empty();
        }
        return CollapsibleIfStatementsCheck.getIfStatementWithoutElse(tree);
    }

    private static Optional<IfTree> getIfStatementWithoutElse(Tree tree) {
        return tree instanceof IfTree && ((IfTree)tree).elseBranch() == null ? Optional.of((IfTree)tree) : Optional.empty();
    }
}

