/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.util.ArrayList;
import java.util.List;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.LoopTree;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.visitors.TreeContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class CyclomaticComplexityVisitor
extends TreeVisitor<TreeContext> {
    private List<HasTextRange> complexityTrees = new ArrayList<HasTextRange>();

    public CyclomaticComplexityVisitor() {
        this.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            if (tree.name() != null && tree.body() != null) {
                this.complexityTrees.add((HasTextRange)tree);
            }
        });
        this.register(IfTree.class, (ctx, tree) -> this.complexityTrees.add(tree.ifKeyword()));
        this.register(LoopTree.class, (ctx, tree) -> this.complexityTrees.add((HasTextRange)tree));
        this.register(MatchCaseTree.class, (ctx, tree) -> {
            if (tree.expression() != null) {
                this.complexityTrees.add((HasTextRange)tree);
            }
        });
        this.register(BinaryExpressionTree.class, (ctx, tree) -> {
            if (tree.operator() == BinaryExpressionTree.Operator.CONDITIONAL_AND || tree.operator() == BinaryExpressionTree.Operator.CONDITIONAL_OR) {
                this.complexityTrees.add((HasTextRange)tree);
            }
        });
    }

    public List<HasTextRange> complexityTrees(Tree tree) {
        this.complexityTrees = new ArrayList<HasTextRange>();
        this.scan(new TreeContext(), tree);
        return this.complexityTrees;
    }

    @Override
    protected void before(TreeContext ctx, Tree root) {
        this.complexityTrees = new ArrayList<HasTextRange>();
    }
}

