/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.api.utils.Version;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.slang.api.ASTConverter;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.ImportDeclarationTree;
import org.sonarsource.slang.api.PackageDeclarationTree;
import org.sonarsource.slang.api.ParseException;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.plugin.ChecksVisitor;
import org.sonarsource.slang.plugin.CpdVisitor;
import org.sonarsource.slang.plugin.DurationStatistics;
import org.sonarsource.slang.plugin.InputFileContext;
import org.sonarsource.slang.plugin.IssueSuppressionVisitor;
import org.sonarsource.slang.plugin.MetricVisitor;
import org.sonarsource.slang.plugin.SkipNoSonarLinesVisitor;
import org.sonarsource.slang.plugin.SyntaxHighlighter;
import org.sonarsource.slang.plugin.converter.ASTConverterValidation;
import org.sonarsource.slang.visitors.TreeVisitor;

public abstract class SlangSensor
implements Sensor {
    static final Predicate<Tree> EXECUTABLE_LINE_PREDICATE = t -> !(t instanceof PackageDeclarationTree) && !(t instanceof ImportDeclarationTree) && !(t instanceof ClassDeclarationTree) && !(t instanceof FunctionDeclarationTree) && !(t instanceof BlockTree);
    private static final Logger LOG = LoggerFactory.getLogger(SlangSensor.class);
    private static final Pattern EMPTY_FILE_CONTENT_PATTERN = Pattern.compile("\\s*+");
    protected final SonarRuntime sonarRuntime;
    private final NoSonarFilter noSonarFilter;
    private final Language language;
    private FileLinesContextFactory fileLinesContextFactory;

    protected SlangSensor(SonarRuntime sonarRuntime, NoSonarFilter noSonarFilter, FileLinesContextFactory fileLinesContextFactory, Language language) {
        this.sonarRuntime = sonarRuntime;
        this.noSonarFilter = noSonarFilter;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.language = language;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(this.language.getKey()).name(this.language.getName() + " Sensor");
        this.processesFilesIndependently(descriptor);
    }

    protected void processesFilesIndependently(SensorDescriptor descriptor) {
        if (this.sonarRuntime.getProduct() == SonarProduct.SONARLINT || !this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)3))) {
            return;
        }
        try {
            Method method = descriptor.getClass().getMethod("processesFilesIndependently", new Class[0]);
            method.invoke((Object)descriptor, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LOG.warn("Could not call SensorDescriptor.processesFilesIndependently() method", (Throwable)e);
        }
    }

    protected abstract ASTConverter astConverter(SensorContext var1);

    protected abstract Checks<SlangCheck> checks();

    protected abstract String repositoryKey();

    protected Predicate<Tree> executableLineOfCodePredicate() {
        return EXECUTABLE_LINE_PREDICATE;
    }

    private boolean analyseFiles(ASTConverter converter, SensorContext sensorContext, Iterable<InputFile> inputFiles, ProgressReport progressReport, List<TreeVisitor<InputFileContext>> visitors, DurationStatistics statistics) {
        for (InputFile inputFile : inputFiles) {
            if (sensorContext.isCancelled()) {
                return false;
            }
            InputFileContext inputFileContext = new InputFileContext(sensorContext, inputFile);
            try {
                SlangSensor.analyseFile(converter, inputFileContext, inputFile, visitors, statistics);
            }
            catch (ParseException e) {
                SlangSensor.logParsingError(inputFile, e);
                inputFileContext.reportAnalysisParseError(this.repositoryKey(), inputFile, e.getPosition());
            }
            progressReport.nextFile();
        }
        return true;
    }

    private static void analyseFile(ASTConverter converter, InputFileContext inputFileContext, InputFile inputFile, List<TreeVisitor<InputFileContext>> visitors, DurationStatistics statistics) {
        String fileName;
        String content;
        try {
            content = inputFile.contents();
            fileName = inputFile.toString();
        }
        catch (IOException | RuntimeException e) {
            throw SlangSensor.toParseException("read", inputFile, e);
        }
        if (EMPTY_FILE_CONTENT_PATTERN.matcher(content).matches()) {
            return;
        }
        Tree tree = statistics.time("Parse", () -> {
            try {
                return converter.parse(content, fileName);
            }
            catch (RuntimeException e) {
                throw SlangSensor.toParseException("parse", inputFile, e);
            }
        });
        for (TreeVisitor<InputFileContext> visitor : visitors) {
            try {
                String visitorId = visitor.getClass().getSimpleName();
                statistics.time(visitorId, () -> visitor.scan(inputFileContext, tree));
            }
            catch (RuntimeException e) {
                inputFileContext.reportAnalysisError(e.getMessage(), null);
                LOG.error("Cannot analyse '" + inputFile + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static ParseException toParseException(String action, InputFile inputFile, Exception cause) {
        TextPointer position = cause instanceof ParseException ? ((ParseException)cause).getPosition() : null;
        return new ParseException("Cannot " + action + " '" + inputFile + "': " + cause.getMessage(), position, cause);
    }

    private static void logParsingError(InputFile inputFile, ParseException e) {
        TextPointer position = e.getPosition();
        String positionMessage = "";
        if (position != null) {
            positionMessage = String.format("Parse error at position %s:%s", position.line(), position.lineOffset());
        }
        LOG.error("Unable to parse file: {}. {}", (Object)inputFile.uri(), (Object)positionMessage);
        LOG.error(e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SensorContext sensorContext) {
        DurationStatistics statistics = new DurationStatistics(sensorContext.config());
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicate mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasLanguage(this.language.getKey()), fileSystem.predicates().hasType(InputFile.Type.MAIN));
        Iterable inputFiles = fileSystem.inputFiles(mainFilePredicate);
        List<String> filenames = StreamSupport.stream(inputFiles.spliterator(), false).map(InputFile::toString).collect(Collectors.toList());
        ProgressReport progressReport = new ProgressReport("Progress of the " + this.language.getName() + " analysis", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start(filenames);
        boolean success = false;
        ASTConverter converter = ASTConverterValidation.wrap(this.astConverter(sensorContext), sensorContext.config());
        try {
            success = this.analyseFiles(converter, sensorContext, inputFiles, progressReport, this.visitors(sensorContext, statistics), statistics);
        }
        finally {
            if (success) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
            converter.terminate();
        }
        statistics.log();
    }

    private List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        if (sensorContext.runtime().getProduct() == SonarProduct.SONARLINT) {
            return Arrays.asList(new IssueSuppressionVisitor(), new SkipNoSonarLinesVisitor(this.noSonarFilter), new ChecksVisitor(this.checks(), statistics));
        }
        return Arrays.asList(new IssueSuppressionVisitor(), new MetricVisitor(this.fileLinesContextFactory, this.executableLineOfCodePredicate()), new SkipNoSonarLinesVisitor(this.noSonarFilter), new ChecksVisitor(this.checks(), statistics), new CpdVisitor(), new SyntaxHighlighter());
    }
}

