/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.util.function.Predicate;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.go.converter.GoConverter;
import org.sonar.go.plugin.GoCheckList;
import org.sonar.go.plugin.GoLanguage;
import org.sonarsource.slang.api.ASTConverter;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.VariableDeclarationTree;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.plugin.SlangSensor;

public class GoSensor
extends SlangSensor {
    private final Checks<SlangCheck> checks;
    private ASTConverter goConverter = null;

    public GoSensor(SonarRuntime sonarRuntime, CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, GoLanguage language, GoConverter goConverter) {
        super(sonarRuntime, noSonarFilter, fileLinesContextFactory, (Language)language);
        this.checks = checkFactory.create("go");
        this.checks.addAnnotatedChecks(GoCheckList.checks());
        this.goConverter = goConverter;
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("go").name("Code Quality and Security for Go");
    }

    @Override
    protected ASTConverter astConverter(SensorContext sensorContext) {
        return this.goConverter;
    }

    @Override
    protected Checks<SlangCheck> checks() {
        return this.checks;
    }

    @Override
    protected String repositoryKey() {
        return "go";
    }

    @Override
    protected Predicate<Tree> executableLineOfCodePredicate() {
        return super.executableLineOfCodePredicate().and(t -> !(t instanceof VariableDeclarationTree) && !GoSensor.isGenericDeclaration(t));
    }

    private static boolean isGenericDeclaration(Tree tree) {
        return tree instanceof NativeTree && ((NativeTree)tree).nativeKind().toString().contains("GenDecl");
    }
}

