/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.EnumMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.UnaryExpressionTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.ExpressionUtils;

@Rule(key="S1940")
public class BooleanInversionCheck
implements SlangCheck {
    private static final Map<BinaryExpressionTree.Operator, String> OPERATORS = BooleanInversionCheck.createOperatorsMap();

    private static Map<BinaryExpressionTree.Operator, String> createOperatorsMap() {
        EnumMap<BinaryExpressionTree.Operator, String> operatorsMap = new EnumMap<BinaryExpressionTree.Operator, String>(BinaryExpressionTree.Operator.class);
        operatorsMap.put(BinaryExpressionTree.Operator.EQUAL_TO, "!=");
        operatorsMap.put(BinaryExpressionTree.Operator.NOT_EQUAL_TO, "==");
        operatorsMap.put(BinaryExpressionTree.Operator.LESS_THAN, ">=");
        operatorsMap.put(BinaryExpressionTree.Operator.GREATER_THAN, "<=");
        operatorsMap.put(BinaryExpressionTree.Operator.LESS_THAN_OR_EQUAL_TO, ">");
        operatorsMap.put(BinaryExpressionTree.Operator.GREATER_THAN_OR_EQUAL_TO, "<");
        return operatorsMap;
    }

    @Override
    public void initialize(InitContext init) {
        init.register(UnaryExpressionTree.class, (ctx, tree) -> {
            BinaryExpressionTree binaryExpression;
            String oppositeOperator;
            Tree innerExpression = ExpressionUtils.skipParentheses(tree.operand());
            if (tree.operator() == UnaryExpressionTree.Operator.NEGATE && innerExpression instanceof BinaryExpressionTree && (oppositeOperator = OPERATORS.get((Object)(binaryExpression = (BinaryExpressionTree)innerExpression).operator())) != null) {
                String message = String.format("Use the opposite operator (\"%s\") instead.", oppositeOperator);
                ctx.reportIssue((HasTextRange)tree, message);
            }
        });
    }
}

