/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.JumpTree;
import org.sonarsource.slang.api.ReturnTree;
import org.sonarsource.slang.api.ThrowTree;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.impl.TextRangeImpl;

@Rule(key="S126")
public class ElseIfWithoutElseCheck
implements SlangCheck {
    private static final String MESSAGE = "Add the missing \"else\" clause.";

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, (ctx, ifTree) -> {
            if (ifTree.elseBranch() == null || !ElseIfWithoutElseCheck.isTopLevelIf(ctx, ifTree)) {
                return;
            }
            IfTree prevTree = ifTree;
            boolean endsWithReturn = ElseIfWithoutElseCheck.endsWithReturnBreakOrThrow(ifTree);
            while (ifTree.elseBranch() instanceof IfTree) {
                prevTree = ifTree;
                ifTree = (IfTree)ifTree.elseBranch();
                endsWithReturn = endsWithReturn && ElseIfWithoutElseCheck.endsWithReturnBreakOrThrow(ifTree);
            }
            if (!endsWithReturn && ifTree.elseBranch() == null) {
                Token elseToken = prevTree.elseKeyword();
                Token ifToken = ifTree.ifKeyword();
                TextRangeImpl textRange = new TextRangeImpl(elseToken.textRange().start(), ifToken.textRange().end());
                ctx.reportIssue(textRange, MESSAGE);
            }
        });
    }

    private static boolean isTopLevelIf(CheckContext ctx, IfTree ifTree) {
        Tree firstAncestor = ctx.ancestors().getFirst();
        if (firstAncestor instanceof IfTree) {
            return ((IfTree)firstAncestor).elseBranch() != ifTree;
        }
        return true;
    }

    private static boolean endsWithReturnBreakOrThrow(IfTree ifTree) {
        List<Tree> statements;
        Tree thenBranch = ifTree.thenBranch();
        if (thenBranch instanceof BlockTree && !(statements = ((BlockTree)thenBranch).statementOrExpressions()).isEmpty()) {
            Tree lastStmt = statements.get(statements.size() - 1);
            return ElseIfWithoutElseCheck.isReturnBreakOrThrow(lastStmt);
        }
        return ElseIfWithoutElseCheck.isReturnBreakOrThrow(thenBranch);
    }

    private static boolean isReturnBreakOrThrow(Tree tree) {
        return tree instanceof JumpTree || tree instanceof ReturnTree || tree instanceof ThrowTree;
    }
}

