/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import org.sonar.check.Rule;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.ExpressionUtils;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1764")
public class IdenticalBinaryOperandCheck
implements SlangCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(BinaryExpressionTree.class, (ctx, tree) -> {
            if (tree.operator() != BinaryExpressionTree.Operator.PLUS && tree.operator() != BinaryExpressionTree.Operator.TIMES && !ExpressionUtils.containsPlaceHolder(tree) && SyntacticEquivalence.areEquivalent(ExpressionUtils.skipParentheses(tree.leftOperand()), ExpressionUtils.skipParentheses(tree.rightOperand()))) {
                ctx.reportIssue((HasTextRange)tree.rightOperand(), "Correct one of the identical sub-expressions on both sides this operator", new SecondaryLocation(tree.leftOperand()));
            }
        });
    }
}

