/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.freebsd.aarch64;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum SocketOption implements Constant
{
    SO_DEBUG(1L),
    SO_ACCEPTCONN(2L),
    SO_REUSEADDR(4L),
    SO_KEEPALIVE(8L),
    SO_DONTROUTE(16L),
    SO_BROADCAST(32L),
    SO_USELOOPBACK(64L),
    SO_LINGER(128L),
    SO_OOBINLINE(256L),
    SO_REUSEPORT(512L),
    SO_TIMESTAMP(1024L),
    SO_ACCEPTFILTER(4096L),
    SO_SNDBUF(4097L),
    SO_RCVBUF(4098L),
    SO_SNDLOWAT(4099L),
    SO_RCVLOWAT(4100L),
    SO_SNDTIMEO(4101L),
    SO_RCVTIMEO(4102L),
    SO_ERROR(4103L),
    SO_TYPE(4104L),
    SO_NOSIGPIPE(2048L),
    SO_LABEL(4105L),
    SO_PEERLABEL(4112L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 4112L;

    private SocketOption(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<SocketOption, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<SocketOption, String> generateTable() {
            EnumMap<SocketOption, String> map2 = new EnumMap<SocketOption, String>(SocketOption.class);
            map2.put(SO_DEBUG, "SO_DEBUG");
            map2.put(SO_ACCEPTCONN, "SO_ACCEPTCONN");
            map2.put(SO_REUSEADDR, "SO_REUSEADDR");
            map2.put(SO_KEEPALIVE, "SO_KEEPALIVE");
            map2.put(SO_DONTROUTE, "SO_DONTROUTE");
            map2.put(SO_BROADCAST, "SO_BROADCAST");
            map2.put(SO_USELOOPBACK, "SO_USELOOPBACK");
            map2.put(SO_LINGER, "SO_LINGER");
            map2.put(SO_OOBINLINE, "SO_OOBINLINE");
            map2.put(SO_REUSEPORT, "SO_REUSEPORT");
            map2.put(SO_TIMESTAMP, "SO_TIMESTAMP");
            map2.put(SO_ACCEPTFILTER, "SO_ACCEPTFILTER");
            map2.put(SO_SNDBUF, "SO_SNDBUF");
            map2.put(SO_RCVBUF, "SO_RCVBUF");
            map2.put(SO_SNDLOWAT, "SO_SNDLOWAT");
            map2.put(SO_RCVLOWAT, "SO_RCVLOWAT");
            map2.put(SO_SNDTIMEO, "SO_SNDTIMEO");
            map2.put(SO_RCVTIMEO, "SO_RCVTIMEO");
            map2.put(SO_ERROR, "SO_ERROR");
            map2.put(SO_TYPE, "SO_TYPE");
            map2.put(SO_NOSIGPIPE, "SO_NOSIGPIPE");
            map2.put(SO_LABEL, "SO_LABEL");
            map2.put(SO_PEERLABEL, "SO_PEERLABEL");
            return map2;
        }
    }
}

