/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import jnr.constants.platform.Confstr;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.Pathconf;
import jnr.constants.platform.Signal;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.JavaFileStat;
import jnr.posix.JavaLibCHelper;
import jnr.posix.JavaTimes;
import jnr.posix.LibC;
import jnr.posix.MsgHdr;
import jnr.posix.POSIX;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.RLimit;
import jnr.posix.SignalHandler;
import jnr.posix.SocketMacros;
import jnr.posix.SpawnAttribute;
import jnr.posix.SpawnFileAction;
import jnr.posix.Times;
import jnr.posix.Timeval;
import jnr.posix.util.Java5ProcessMaker;
import jnr.posix.util.MethodName;
import jnr.posix.util.Platform;
import jnr.posix.util.ProcessMaker;
import jnr.posix.util.SunMiscSignal;

final class JavaPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final JavaLibCHelper helper;

    JavaPOSIX(POSIXHandler handler) {
        this.handler = handler;
        this.helper = new JavaLibCHelper(handler);
    }

    @Override
    public ProcessMaker newProcessMaker(String ... command) {
        return new Java5ProcessMaker(this.handler, command);
    }

    @Override
    public ProcessMaker newProcessMaker() {
        return new Java5ProcessMaker(this.handler);
    }

    @Override
    public FileStat allocateStat() {
        return new JavaFileStat(this, this.handler);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    public SocketMacros socketMacros() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    @Override
    public int chmod(String filename2, int mode2) {
        return this.helper.chmod(filename2, mode2);
    }

    @Override
    public int fchmod(int fd, int mode2) {
        this.handler.unimplementedError("No fchmod in Java (yet)");
        return -1;
    }

    @Override
    public int chown(String filename2, int user, int group2) {
        return this.helper.chown(filename2, user, group2);
    }

    @Override
    public int fchown(int fd, int user, int group2) {
        this.handler.unimplementedError("No fchown in Java (yet)");
        return -1;
    }

    @Override
    public CharSequence crypt(CharSequence key2, CharSequence salt) {
        return JavaLibCHelper.crypt(key2, salt);
    }

    @Override
    public byte[] crypt(byte[] key2, byte[] salt) {
        return JavaLibCHelper.crypt(key2, salt);
    }

    @Override
    public int exec(String path2, String ... argv2) {
        this.handler.unimplementedError("No exec in Java (yet)");
        return -1;
    }

    @Override
    public int exec(String path2, String[] argv2, String[] envp) {
        this.handler.unimplementedError("No exec in Java (yet)");
        return -1;
    }

    @Override
    public int execv(String path2, String[] argv2) {
        this.handler.unimplementedError("No execv in Java (yet)");
        return -1;
    }

    @Override
    public int execve(String path2, String[] argv2, String[] envp) {
        this.handler.unimplementedError("No execve in Java (yet)");
        return -1;
    }

    @Override
    public FileStat fstat(FileDescriptor descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    @Override
    public FileStat fstat(int descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    @Override
    public int fstat(int fd, FileStat stat2) {
        this.handler.unimplementedError("fstat unimplemented");
        return -1;
    }

    @Override
    public int fstat(FileDescriptor descriptor, FileStat stat2) {
        this.handler.unimplementedError("fstat unimplemented");
        return -1;
    }

    @Override
    public int getegid() {
        return LoginInfo.GID;
    }

    @Override
    public int geteuid() {
        return LoginInfo.UID;
    }

    @Override
    public int getgid() {
        return LoginInfo.GID;
    }

    @Override
    public int getdtablesize() {
        this.handler.unimplementedError("getdtablesize unimplemented");
        return -1;
    }

    @Override
    public String getlogin() {
        return this.helper.getlogin();
    }

    @Override
    public int getpgid() {
        return this.unimplementedInt("getpgid");
    }

    @Override
    public int getpgrp() {
        return this.unimplementedInt("getpgrp");
    }

    @Override
    public int getpid() {
        return this.helper.getpid();
    }

    @Override
    public int getppid() {
        return this.unimplementedInt("getppid");
    }

    @Override
    public Passwd getpwent() {
        return this.helper.getpwent();
    }

    @Override
    public Passwd getpwuid(int which) {
        return this.helper.getpwuid(which);
    }

    @Override
    public Group getgrgid(int which) {
        this.handler.unimplementedError("getgrgid unimplemented");
        return null;
    }

    @Override
    public Passwd getpwnam(String which) {
        this.handler.unimplementedError("getpwnam unimplemented");
        return null;
    }

    @Override
    public Group getgrnam(String which) {
        this.handler.unimplementedError("getgrnam unimplemented");
        return null;
    }

    @Override
    public Group getgrent() {
        this.handler.unimplementedError("getgrent unimplemented");
        return null;
    }

    @Override
    public int setpwent() {
        return this.helper.setpwent();
    }

    @Override
    public int endpwent() {
        return this.helper.endpwent();
    }

    @Override
    public int setgrent() {
        return this.unimplementedInt("setgrent");
    }

    @Override
    public int endgrent() {
        return this.unimplementedInt("endgrent");
    }

    @Override
    public Pointer environ() {
        this.handler.unimplementedError("environ");
        return null;
    }

    @Override
    public String getenv(String envName) {
        return this.helper.getEnv().get(envName);
    }

    @Override
    public int getuid() {
        return LoginInfo.UID;
    }

    @Override
    public int getrlimit(int resource, RLimit rlim) {
        return this.unimplementedInt("getrlimit");
    }

    @Override
    public int getrlimit(int resource, Pointer rlim) {
        return this.unimplementedInt("getrlimit");
    }

    @Override
    public RLimit getrlimit(int resource) {
        this.handler.unimplementedError("getrlimit");
        return null;
    }

    @Override
    public int setrlimit(int resource, RLimit rlim) {
        return this.unimplementedInt("setrlimit");
    }

    @Override
    public int setrlimit(int resource, Pointer rlim) {
        return this.unimplementedInt("setrlimit");
    }

    @Override
    public int setrlimit(int resource, long rlimCur, long rlimMax) {
        return this.unimplementedInt("setrlimit");
    }

    @Override
    public int fork() {
        return -1;
    }

    @Override
    public boolean isatty(FileDescriptor fd) {
        return fd == FileDescriptor.in || fd == FileDescriptor.out || fd == FileDescriptor.err;
    }

    @Override
    public int isatty(int fd) {
        return fd == 0 || fd == 1 || fd == 2 ? 1 : 0;
    }

    @Override
    public int kill(int pid2, int signal2) {
        return this.unimplementedInt("kill");
    }

    @Override
    public int kill(long pid2, int signal2) {
        return this.unimplementedInt("kill");
    }

    @Override
    public SignalHandler signal(Signal sig, SignalHandler handler) {
        return SunMiscSignal.signal(sig, handler);
    }

    @Override
    public int raise(int sig) {
        return this.unimplementedInt("raise");
    }

    @Override
    public int lchmod(String filename2, int mode2) {
        return this.unimplementedInt("lchmod");
    }

    @Override
    public int lchown(String filename2, int user, int group2) {
        return this.unimplementedInt("lchown");
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.helper.link(oldpath, newpath);
    }

    @Override
    public FileStat lstat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.lstat(path2, stat2) < 0) {
            this.handler.error(Errno.ENOENT, "lstat", path2);
        }
        return stat2;
    }

    @Override
    public int lstat(String path2, FileStat stat2) {
        return this.helper.lstat(path2, stat2);
    }

    @Override
    public int mkdir(String path2, int mode2) {
        return this.helper.mkdir(path2, mode2);
    }

    @Override
    public int rmdir(String path2) {
        return this.helper.rmdir(path2);
    }

    @Override
    public String readlink(String path2) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        int result2 = this.helper.readlink(path2, buffer, buffer.capacity());
        if (result2 == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result2);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    @Override
    public int readlink(CharSequence path2, byte[] buf, int bufsize) {
        this.handler.unimplementedError("readlink");
        return -1;
    }

    @Override
    public int readlink(CharSequence path2, ByteBuffer buf, int bufsize) {
        this.handler.unimplementedError("readlink");
        return -1;
    }

    @Override
    public int readlink(CharSequence path2, Pointer bufPtr, int bufsize) {
        this.handler.unimplementedError("readlink");
        return -1;
    }

    @Override
    public int setenv(String envName, String envValue, int overwrite) {
        Map<String, String> env = this.helper.getEnv();
        if (envName.contains("=")) {
            this.handler.error(Errno.EINVAL, "setenv", envName);
            return -1;
        }
        if (overwrite == 0 && env.containsKey(envName)) {
            return 0;
        }
        env.put(envName, envValue);
        return 0;
    }

    @Override
    public FileStat stat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.helper.stat(path2, stat2) < 0) {
            this.handler.error(Errno.ENOENT, "stat", path2);
        }
        return stat2;
    }

    @Override
    public int stat(String path2, FileStat stat2) {
        return this.helper.stat(path2, stat2);
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.helper.symlink(oldpath, newpath);
    }

    @Override
    public int setegid(int egid2) {
        return this.unimplementedInt("setegid");
    }

    @Override
    public int seteuid(int euid2) {
        return this.unimplementedInt("seteuid");
    }

    @Override
    public int setgid(int gid2) {
        return this.unimplementedInt("setgid");
    }

    @Override
    public int getpgid(int pid2) {
        return this.unimplementedInt("getpgid");
    }

    @Override
    public int setpgid(int pid2, int pgid) {
        return this.unimplementedInt("setpgid");
    }

    @Override
    public int setpgrp(int pid2, int pgrp) {
        return this.unimplementedInt("setpgrp");
    }

    @Override
    public int setsid() {
        return this.unimplementedInt("setsid");
    }

    @Override
    public int setuid(int uid2) {
        return this.unimplementedInt("setuid");
    }

    @Override
    public int umask(int mask) {
        return 0;
    }

    @Override
    public int unsetenv(String envName) {
        if (this.helper.getEnv().remove(envName) == null) {
            this.handler.error(Errno.EINVAL, "unsetenv", envName);
            return -1;
        }
        return 0;
    }

    @Override
    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        long mtimeMillis;
        if (mtimeval != null) {
            assert (mtimeval.length == 2);
            mtimeMillis = mtimeval[0] * 1000L + mtimeval[1] / 1000L;
        } else {
            mtimeMillis = System.currentTimeMillis();
        }
        new File(path2).setLastModified(mtimeMillis);
        return 0;
    }

    @Override
    public int utimes(String path2, Pointer times2) {
        return this.unimplementedInt("utimes");
    }

    @Override
    public int futimes(int fd, long[] atimeval, long[] mtimeval) {
        this.handler.unimplementedError("futimes");
        return this.unimplementedInt("futimes");
    }

    @Override
    public int lutimes(String path2, long[] atimeval, long[] mtimeval) {
        this.handler.unimplementedError("lutimes");
        return this.unimplementedInt("lutimes");
    }

    @Override
    public int utimensat(int dirfd, String path2, long[] atimespec, long[] mtimespec, int flag) {
        long mtimeMillis;
        if (mtimespec != null) {
            assert (mtimespec.length == 2);
            mtimeMillis = mtimespec[0] * 1000L + mtimespec[1] / 1000000L;
        } else {
            mtimeMillis = System.currentTimeMillis();
        }
        new File(path2).setLastModified(mtimeMillis);
        return 0;
    }

    @Override
    public int utimensat(int dirfd, String path2, Pointer times2, int flag) {
        return this.unimplementedInt("utimensat");
    }

    @Override
    public int futimens(int fd, long[] atimespec, long[] mtimespec) {
        this.handler.unimplementedError("futimens");
        return this.unimplementedInt("futimens");
    }

    @Override
    public int futimens(int fd, Pointer times2) {
        this.handler.unimplementedError("futimens");
        return this.unimplementedInt("futimens");
    }

    @Override
    public int wait(int[] status2) {
        return this.unimplementedInt("wait");
    }

    @Override
    public int waitpid(int pid2, int[] status2, int flags) {
        return this.unimplementedInt("waitpid");
    }

    @Override
    public int waitpid(long pid2, int[] status2, int flags) {
        return this.unimplementedInt("waitpid");
    }

    @Override
    public int getpriority(int which, int who) {
        return this.unimplementedInt("getpriority");
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.unimplementedInt("setpriority");
    }

    @Override
    public long posix_spawnp(String path2, Collection<? extends SpawnFileAction> fileActions, Collection<? extends CharSequence> argv2, Collection<? extends CharSequence> envp) {
        return this.unimplementedInt("posix_spawnp");
    }

    @Override
    public long posix_spawnp(String path2, Collection<? extends SpawnFileAction> fileActions, Collection<? extends SpawnAttribute> spawnAttributes, Collection<? extends CharSequence> argv2, Collection<? extends CharSequence> envp) {
        return this.unimplementedInt("posix_spawnp");
    }

    @Override
    public int errno() {
        return JavaLibCHelper.errno();
    }

    @Override
    public void errno(int value2) {
        JavaLibCHelper.errno(value2);
    }

    @Override
    public int chdir(String path2) {
        return JavaLibCHelper.chdir(path2);
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public LibC libc() {
        return null;
    }

    private int unimplementedInt(String message2) {
        this.handler.unimplementedError(message2);
        return -1;
    }

    @Override
    public long sysconf(Sysconf name2) {
        switch (name2) {
            case _SC_CLK_TCK: {
                return 1000L;
            }
        }
        this.errno(Errno.EOPNOTSUPP.intValue());
        return -1L;
    }

    @Override
    public int confstr(Confstr name2, ByteBuffer buf, int len) {
        this.errno(Errno.EOPNOTSUPP.intValue());
        return -1;
    }

    @Override
    public int fpathconf(int fd, Pathconf name2) {
        this.errno(Errno.EOPNOTSUPP.intValue());
        return -1;
    }

    @Override
    public Times times() {
        return new JavaTimes();
    }

    @Override
    public int flock(int fd, int mode2) {
        return this.unimplementedInt("flock");
    }

    @Override
    public int dup(int fd) {
        return this.unimplementedInt("dup");
    }

    @Override
    public int dup2(int oldFd, int newFd) {
        return this.unimplementedInt("dup2");
    }

    @Override
    public int fcntlInt(int fd, Fcntl fcntlConst, int arg2) {
        return this.unimplementedInt("fcntl");
    }

    @Override
    public int fcntl(int fd, Fcntl fcntlConst) {
        return this.unimplementedInt("fcntl");
    }

    @Override
    public int fcntl(int fd, Fcntl fcntlConst, int arg2) {
        return this.unimplementedInt("fcntl");
    }

    @Override
    @Deprecated
    public int fcntl(int fd, Fcntl fcntlConst, int ... arg2) {
        return this.unimplementedInt("fcntl");
    }

    @Override
    public int access(CharSequence path2, int amode) {
        this.handler.unimplementedError("access");
        return -1;
    }

    @Override
    public int close(int fd) {
        return this.unimplementedInt("close");
    }

    @Override
    public int unlink(CharSequence path2) {
        this.handler.unimplementedError("unlink");
        return -1;
    }

    @Override
    public int open(CharSequence path2, int flags, int perm) {
        this.handler.unimplementedError("open");
        return -1;
    }

    @Override
    public long read(int fd, byte[] buf, long n) {
        this.handler.unimplementedError("read");
        return -1L;
    }

    @Override
    public long write(int fd, byte[] buf, long n) {
        this.handler.unimplementedError("write");
        return -1L;
    }

    @Override
    public long read(int fd, ByteBuffer buf, long n) {
        this.handler.unimplementedError("read");
        return -1L;
    }

    @Override
    public long write(int fd, ByteBuffer buf, long n) {
        this.handler.unimplementedError("write");
        return -1L;
    }

    @Override
    public long pread(int fd, byte[] buf, long n, long offset2) {
        this.handler.unimplementedError("pread");
        return -1L;
    }

    @Override
    public long pwrite(int fd, byte[] buf, long n, long offset2) {
        this.handler.unimplementedError("pwrite");
        return -1L;
    }

    @Override
    public long pread(int fd, ByteBuffer buf, long n, long offset2) {
        this.handler.unimplementedError("pread");
        return -1L;
    }

    @Override
    public long pwrite(int fd, ByteBuffer buf, long n, long offset2) {
        this.handler.unimplementedError("pwrite");
        return -1L;
    }

    @Override
    public int read(int fd, byte[] buf, int n) {
        this.handler.unimplementedError("read");
        return -1;
    }

    @Override
    public int write(int fd, byte[] buf, int n) {
        this.handler.unimplementedError("write");
        return -1;
    }

    @Override
    public int read(int fd, ByteBuffer buf, int n) {
        this.handler.unimplementedError("read");
        return -1;
    }

    @Override
    public int write(int fd, ByteBuffer buf, int n) {
        this.handler.unimplementedError("write");
        return -1;
    }

    @Override
    public int pread(int fd, byte[] buf, int n, int offset2) {
        this.handler.unimplementedError("pread");
        return -1;
    }

    @Override
    public int pwrite(int fd, byte[] buf, int n, int offset2) {
        this.handler.unimplementedError("pwrite");
        return -1;
    }

    @Override
    public int pread(int fd, ByteBuffer buf, int n, int offset2) {
        this.handler.unimplementedError("pread");
        return -1;
    }

    @Override
    public int pwrite(int fd, ByteBuffer buf, int n, int offset2) {
        this.handler.unimplementedError("pwrite");
        return -1;
    }

    @Override
    public int lseek(int fd, long offset2, int whence) {
        this.handler.unimplementedError("lseek");
        return -1;
    }

    @Override
    public long lseekLong(int fd, long offset2, int whence) {
        this.handler.unimplementedError("lseek");
        return -1L;
    }

    @Override
    public int pipe(int[] fds) {
        this.handler.unimplementedError("pipe");
        return -1;
    }

    @Override
    public int socketpair(int domain, int type2, int protocol, int[] fds) {
        this.handler.unimplementedError("socketpair");
        return -1;
    }

    @Override
    public int sendmsg(int socket2, MsgHdr message2, int flags) {
        this.handler.unimplementedError("sendmsg");
        return -1;
    }

    @Override
    public int recvmsg(int socket2, MsgHdr message2, int flags) {
        this.handler.unimplementedError("recvmsg");
        return -1;
    }

    @Override
    public int truncate(CharSequence path2, long length2) {
        this.handler.unimplementedError("truncate");
        return -1;
    }

    @Override
    public int ftruncate(int fd, long offset2) {
        this.handler.unimplementedError("ftruncate");
        return -1;
    }

    @Override
    public int rename(CharSequence oldName, CharSequence newName) {
        File newFile;
        File oldFile = new File(oldName.toString());
        if (oldFile.renameTo(newFile = new File(newName.toString()))) {
            return 0;
        }
        return -1;
    }

    @Override
    public String getcwd() {
        return System.getProperty("user.dir");
    }

    @Override
    public int fsync(int fd) {
        this.handler.unimplementedError("fsync");
        return this.unimplementedInt("fsync not available for Java");
    }

    @Override
    public int fdatasync(int fd) {
        this.handler.unimplementedError("fdatasync");
        return this.unimplementedInt("fdatasync not available for Java");
    }

    @Override
    public int mkfifo(String filename2, int mode2) {
        this.handler.unimplementedError("mkfifo");
        return this.unimplementedInt("mkfifo not available for Java");
    }

    @Override
    public int daemon(int nochdir, int noclose) {
        this.handler.unimplementedError("daemon");
        return this.unimplementedInt("daemon not available for Java");
    }

    @Override
    public long[] getgroups() {
        this.handler.unimplementedError("getgroups");
        return null;
    }

    @Override
    public int getgroups(int size2, int[] groups2) {
        this.handler.unimplementedError("getgroups");
        return this.unimplementedInt("getgroups not available for Java");
    }

    @Override
    public String nl_langinfo(int item) {
        this.handler.unimplementedError("nl_langinfo");
        return null;
    }

    @Override
    public String setlocale(int category, String locale) {
        this.handler.unimplementedError("setlocale");
        return null;
    }

    @Override
    public String strerror(int code) {
        this.handler.unimplementedError("strerror");
        return null;
    }

    @Override
    public Timeval allocateTimeval() {
        this.handler.unimplementedError("allocateTimeval");
        return null;
    }

    @Override
    public int gettimeofday(Timeval tv) {
        this.handler.unimplementedError("gettimeofday");
        return -1;
    }

    @Override
    public String gethostname() {
        return this.helper.gethostname();
    }

    private static final class FakePasswd
    implements Passwd {
        private FakePasswd() {
        }

        @Override
        public String getLoginName() {
            return LoginInfo.USERNAME;
        }

        @Override
        public String getPassword() {
            return "";
        }

        @Override
        public long getUID() {
            return LoginInfo.UID;
        }

        @Override
        public long getGID() {
            return LoginInfo.GID;
        }

        @Override
        public int getPasswdChangeTime() {
            return 0;
        }

        @Override
        public String getAccessClass() {
            return "";
        }

        @Override
        public String getGECOS() {
            return this.getLoginName();
        }

        @Override
        public String getHome() {
            return "/";
        }

        @Override
        public String getShell() {
            return "/bin/sh";
        }

        @Override
        public int getExpire() {
            return -1;
        }
    }

    private static final class IDHelper {
        private static final String ID_CMD = Platform.IS_SOLARIS ? "/usr/xpg4/bin/id" : "/usr/bin/id";
        private static final int NOBODY = Platform.IS_WINDOWS ? 0 : Short.MAX_VALUE;

        private IDHelper() {
        }

        public static int getInt(String option) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                return Integer.parseInt(r.readLine());
            }
            catch (IOException ex) {
                return NOBODY;
            }
            catch (NumberFormatException ex) {
                return NOBODY;
            }
            catch (SecurityException ex) {
                return NOBODY;
            }
        }

        public static String getString(String option) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                return r.readLine();
            }
            catch (IOException ex) {
                return null;
            }
        }
    }

    static final class LoginInfo {
        public static final int UID = IDHelper.getInt("-u");
        public static final int GID = IDHelper.getInt("-g");
        public static final String USERNAME = IDHelper.getString("-un");

        LoginInfo() {
        }
    }
}

