/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Ptr;
import org.jcodings.exception.CharacterPropertyException;
import org.jcodings.exception.EncodingError;
import org.joni.Config;
import org.joni.NameEntry;
import org.joni.Option;
import org.joni.Regex;
import org.joni.ScanEnvironment;
import org.joni.ScannerSupport;
import org.joni.Syntax;
import org.joni.Token;
import org.joni.WarnCallback;
import org.joni.ast.QuantifierNode;
import org.joni.constants.internal.TokenType;

class Lexer
extends ScannerSupport {
    protected final Regex regex;
    protected final ScanEnvironment env;
    protected final Syntax syntax;
    protected final Token token = new Token();
    private static final int[] send = new int[]{58, 93};

    protected Lexer(Regex regex, Syntax syntax, byte[] bytes2, int p2, int end2, WarnCallback warnings) {
        super(regex.enc, bytes2, p2, end2);
        this.regex = regex;
        this.env = new ScanEnvironment(regex, syntax, warnings);
        this.syntax = this.env.syntax;
    }

    private int fetchRangeQuantifier() {
        int up;
        int low;
        this.mark();
        boolean synAllow = this.syntax.allowInvalidInterval();
        if (!this.left()) {
            if (synAllow) {
                return 1;
            }
            this.newSyntaxException("end pattern at left brace");
        }
        if (!synAllow) {
            this.c = this.peek();
            if (this.c == 41 || this.c == 40 || this.c == 124) {
                this.newSyntaxException("end pattern at left brace");
            }
        }
        if ((low = this.scanUnsignedNumber()) < 0) {
            this.newSyntaxException("too big number for repeat range");
        }
        if (low > Config.MAX_REPEAT_NUM) {
            this.newSyntaxException("too big number for repeat range");
        }
        boolean nonLow = false;
        if (this.p == this._p) {
            if (this.syntax.allowIntervalLowAbbrev()) {
                low = 0;
                nonLow = true;
            } else {
                return this.invalidRangeQuantifier(synAllow);
            }
        }
        if (!this.left()) {
            return this.invalidRangeQuantifier(synAllow);
        }
        this.fetch();
        int ret = 0;
        if (this.c == 44) {
            int prev = this.p;
            up = this.scanUnsignedNumber();
            if (up < 0) {
                this.newValueException("too big number for repeat range");
            }
            if (up > Config.MAX_REPEAT_NUM) {
                this.newValueException("too big number for repeat range");
            }
            if (this.p == prev) {
                if (nonLow) {
                    return this.invalidRangeQuantifier(synAllow);
                }
                up = -1;
            }
        } else {
            if (nonLow) {
                return this.invalidRangeQuantifier(synAllow);
            }
            this.unfetch();
            up = low;
            ret = 2;
        }
        if (!this.left()) {
            return this.invalidRangeQuantifier(synAllow);
        }
        this.fetch();
        if (this.syntax.opEscBraceInterval()) {
            if (this.c != this.syntax.metaCharTable.esc) {
                return this.invalidRangeQuantifier(synAllow);
            }
            if (!this.left()) {
                return this.invalidRangeQuantifier(synAllow);
            }
            this.fetch();
        }
        if (this.c != 125) {
            return this.invalidRangeQuantifier(synAllow);
        }
        if (!QuantifierNode.isRepeatInfinite(up) && low > up) {
            this.newValueException("upper is smaller than lower in repeat range");
        }
        this.token.type = TokenType.INTERVAL;
        this.token.setRepeatLower(low);
        this.token.setRepeatUpper(up);
        return ret;
    }

    private int invalidRangeQuantifier(boolean synAllow) {
        if (synAllow) {
            this.restore();
            return 1;
        }
        this.newSyntaxException("invalid repeat range {lower,upper}");
        return 0;
    }

    private void fetchEscapedValue() {
        if (!this.left()) {
            this.newSyntaxException("end pattern at escape");
        }
        this.fetch();
        switch (this.c) {
            case 77: {
                if (this.syntax.op2EscCapitalMBarMeta()) {
                    if (!this.left()) {
                        this.newSyntaxException("end pattern at meta");
                    }
                    this.fetch();
                    if (this.c != 45) {
                        this.newSyntaxException("invalid meta-code syntax");
                    }
                    if (!this.left()) {
                        this.newSyntaxException("end pattern at meta");
                    }
                    this.fetch();
                    if (this.c == this.syntax.metaCharTable.esc) {
                        this.fetchEscapedValue();
                    }
                    this.c = this.c & 0xFF | 0x80;
                    break;
                }
                this.fetchEscapedValueBackSlash();
                break;
            }
            case 67: {
                if (this.syntax.op2EscCapitalCBarControl()) {
                    if (!this.left()) {
                        this.newSyntaxException("end pattern at control");
                    }
                    this.fetch();
                    if (this.c != 45) {
                        this.newSyntaxException("invalid control-code syntax");
                    }
                    this.fetchEscapedValueControl();
                    break;
                }
                this.fetchEscapedValueBackSlash();
                break;
            }
            case 99: {
                if (this.syntax.opEscCControl()) {
                    this.fetchEscapedValueControl();
                }
            }
            default: {
                this.fetchEscapedValueBackSlash();
            }
        }
    }

    private void fetchEscapedValueBackSlash() {
        this.c = this.env.convertBackslashValue(this.c);
    }

    private void fetchEscapedValueControl() {
        if (!this.left()) {
            if (this.syntax.op3OptionECMAScript()) {
                return;
            }
            this.newSyntaxException("end pattern at control");
        }
        this.fetch();
        if (this.c == 63) {
            this.c = 127;
        } else {
            if (this.c == this.syntax.metaCharTable.esc) {
                this.fetchEscapedValue();
            }
            this.c &= 0x9F;
        }
    }

    private int nameEndCodePoint(int start2) {
        switch (start2) {
            case 60: {
                return 62;
            }
            case 39: {
                return 39;
            }
            case 40: {
                return 41;
            }
            case 123: {
                return 125;
            }
        }
        return 0;
    }

    private boolean fetchNameWithLevel(int startCode, Ptr rbackNum, Ptr rlevel) {
        int src = this.p;
        boolean existLevel = false;
        int isNum = 0;
        int sign2 = 1;
        int endCode = this.nameEndCodePoint(startCode);
        int pnumHead = this.p;
        int nameEnd = this.stop;
        String err = null;
        if (!this.left()) {
            this.newValueException("group name is empty");
        } else {
            this.fetch();
            if (this.c == endCode) {
                this.newValueException("group name is empty");
            }
            if (this.enc.isDigit(this.c)) {
                isNum = 1;
            } else if (this.c == 45) {
                isNum = 2;
                sign2 = -1;
                pnumHead = this.p;
            }
        }
        while (this.left()) {
            nameEnd = this.p;
            this.fetch();
            if (this.c == endCode || this.c == 41 || this.c == 43 || this.c == 45) {
                if (isNum != 2) break;
                err = "invalid group name <%n>";
                break;
            }
            if (isNum == 0) continue;
            if (this.enc.isDigit(this.c)) {
                isNum = 1;
                continue;
            }
            err = "invalid group name <%n>";
        }
        boolean isEndCode = false;
        if (err == null && this.c != endCode) {
            if (this.c == 43 || this.c == 45) {
                int flag;
                int n = flag = this.c == 45 ? -1 : 1;
                if (!this.left()) {
                    this.newValueException(INVALID_CHAR_IN_GROUP_NAME);
                }
                this.fetch();
                if (!this.enc.isDigit(this.c)) {
                    this.newValueException("invalid group name <%n>", src, this.stop);
                }
                this.unfetch();
                int level = this.scanUnsignedNumber();
                if (level < 0) {
                    this.newValueException("too big number");
                }
                rlevel.p = level * flag;
                existLevel = true;
                if (this.left()) {
                    this.fetch();
                    boolean bl = isEndCode = this.c == endCode;
                }
            }
            if (!isEndCode) {
                err = "invalid group name <%n>";
                nameEnd = this.stop;
            }
        }
        if (err == null) {
            if (isNum != 0) {
                this.mark();
                this.p = pnumHead;
                int backNum = this.scanUnsignedNumber();
                this.restore();
                if (backNum < 0) {
                    this.newValueException("too big number");
                } else if (backNum == 0) {
                    this.newValueException("invalid group name <%n>", src, this.stop);
                }
                rbackNum.p = backNum * sign2;
            }
            this.value = nameEnd;
            return existLevel;
        }
        this.newValueException("invalid group name <%n>", src, nameEnd);
        return false;
    }

    private int fetchNameForNamedGroup(int startCode, boolean ref) {
        int src = this.p;
        this.value = 0;
        int isNum = 0;
        int sign2 = 1;
        int endCode = this.nameEndCodePoint(startCode);
        int pnumHead = this.p;
        int nameEnd = this.stop;
        String err = null;
        if (!this.left()) {
            this.newValueException("group name is empty");
        } else {
            this.fetch();
            if (this.c == endCode) {
                this.newValueException("group name is empty");
            }
            if (this.enc.isDigit(this.c)) {
                if (ref) {
                    isNum = 1;
                } else {
                    err = "invalid group name <%n>";
                }
            } else if (this.c == 45) {
                if (ref) {
                    isNum = 2;
                    sign2 = -1;
                    pnumHead = this.p;
                } else {
                    err = "invalid group name <%n>";
                }
            }
        }
        if (err == null) {
            while (this.left()) {
                nameEnd = this.p;
                this.fetch();
                if (this.c == endCode || this.c == 41) {
                    if (isNum != 2) break;
                    err = "invalid group name <%n>";
                    return this.fetchNameTeardown(src, endCode, nameEnd, err);
                }
                if (isNum == 0) continue;
                if (this.enc.isDigit(this.c)) {
                    isNum = 1;
                    continue;
                }
                err = !this.enc.isWord(this.c) ? INVALID_CHAR_IN_GROUP_NAME : "invalid group name <%n>";
                return this.fetchNameTeardown(src, endCode, nameEnd, err);
            }
            if (this.c != endCode) {
                err = "invalid group name <%n>";
                nameEnd = this.stop;
                return this.fetchNameErr(src, nameEnd, err);
            }
            int backNum = 0;
            if (isNum != 0) {
                this.mark();
                this.p = pnumHead;
                backNum = this.scanUnsignedNumber();
                this.restore();
                if (backNum < 0) {
                    this.newValueException("too big number");
                } else if (backNum == 0) {
                    this.newValueException("invalid group name <%n>", src, nameEnd);
                }
                backNum *= sign2;
            }
            this.value = nameEnd;
            return backNum;
        }
        return this.fetchNameTeardown(src, endCode, nameEnd, err);
    }

    private int fetchNameErr(int src, int nameEnd, String err) {
        this.newValueException(err, src, nameEnd);
        return 0;
    }

    private int fetchNameTeardown(int src, int endCode, int nameEnd, String err) {
        while (this.left()) {
            nameEnd = this.p;
            this.fetch();
            if (this.c != endCode && this.c != 41) continue;
        }
        if (!this.left()) {
            nameEnd = this.stop;
        }
        return this.fetchNameErr(src, nameEnd, err);
    }

    private final int fetchNameForNoNamedGroup(int startCode, boolean ref) {
        int src = this.p;
        this.value = 0;
        int sign2 = 1;
        int endCode = this.nameEndCodePoint(startCode);
        int pnumHead = this.p;
        int nameEnd = this.stop;
        String err = null;
        if (!this.left()) {
            this.newValueException("group name is empty");
        } else {
            this.fetch();
            if (this.c == endCode) {
                this.newValueException("group name is empty");
            }
            if (!this.enc.isDigit(this.c)) {
                if (this.c == 45) {
                    sign2 = -1;
                    pnumHead = this.p;
                } else {
                    err = INVALID_CHAR_IN_GROUP_NAME;
                }
            }
        }
        while (this.left()) {
            nameEnd = this.p;
            this.fetch();
            if (this.c == endCode || this.c == 41) break;
            if (this.enc.isDigit(this.c)) continue;
            err = INVALID_CHAR_IN_GROUP_NAME;
        }
        if (err == null && this.c != endCode) {
            err = "invalid group name <%n>";
            nameEnd = this.stop;
        }
        if (err == null) {
            this.mark();
            this.p = pnumHead;
            int backNum = this.scanUnsignedNumber();
            this.restore();
            if (backNum < 0) {
                this.newValueException("too big number");
            } else if (backNum == 0) {
                this.newValueException("invalid group name <%n>", src, nameEnd);
            }
            this.value = nameEnd;
            return backNum *= sign2;
        }
        this.newValueException(err, src, nameEnd);
        return 0;
    }

    protected final int fetchName(int startCode, boolean ref) {
        if (Config.USE_NAMED_GROUP) {
            return this.fetchNameForNamedGroup(startCode, ref);
        }
        return this.fetchNameForNoNamedGroup(startCode, ref);
    }

    private boolean strExistCheckWithEsc(int[] s2, int n, int bad) {
        int p2 = this.p;
        int to = this.stop;
        boolean inEsc = false;
        while (p2 < to) {
            if (inEsc) {
                inEsc = false;
                p2 += this.enc.length(this.bytes, p2, to);
                continue;
            }
            int x = this.enc.mbcToCode(this.bytes, p2, to);
            int q = p2 + this.enc.length(this.bytes, p2, to);
            if (x == s2[0]) {
                int i2;
                for (i2 = 1; i2 < n && q < to && (x = this.enc.mbcToCode(this.bytes, q, to)) == s2[i2]; q += this.enc.length(this.bytes, q, to), ++i2) {
                }
                if (i2 >= n) {
                    return true;
                }
                p2 += this.enc.length(this.bytes, p2, to);
                continue;
            }
            x = this.enc.mbcToCode(this.bytes, p2, to);
            if (x == bad) {
                return false;
            }
            if (x == this.syntax.metaCharTable.esc) {
                inEsc = true;
            }
            p2 = q;
        }
        return false;
    }

    private void fetchTokenInCCFor_charType(boolean flag, int type2) {
        this.token.type = TokenType.CHAR_TYPE;
        this.token.setPropCType(type2);
        this.token.setPropNot(flag);
    }

    private void fetchTokenInCCFor_p() {
        int c2 = this.peek();
        if (c2 == 123 && this.syntax.op2EscPBraceCharProperty()) {
            this.inc();
            this.token.type = TokenType.CHAR_PROPERTY;
            this.token.setPropNot(this.c == 80);
            if (this.left() && this.syntax.op2EscPBraceCircumflexNot()) {
                c2 = this.fetchTo();
                if (c2 == 94) {
                    this.token.setPropNot(!this.token.getPropNot());
                } else {
                    this.unfetch();
                }
            }
        } else {
            this.syntaxWarn("invalid Unicode Property \\<%n>", (char)this.c);
        }
    }

    private void fetchTokenInCCFor_x() {
        if (!this.left()) {
            return;
        }
        int last2 = this.p;
        if (this.peekIs(123) && this.syntax.opEscXBraceHex8()) {
            int c2;
            this.inc();
            int num = this.scanUnsignedHexadecimalNumber(0, 8);
            if (num < 0) {
                this.newValueException("too big wide-char value");
            }
            if (this.left() && this.enc.isXDigit(c2 = this.peek())) {
                this.newValueException("too long wide-char value");
            }
            if (this.p > last2 + this.enc.length(this.bytes, last2, this.stop) && this.left() && this.peekIs(125)) {
                this.inc();
                this.token.type = TokenType.CODE_POINT;
                this.token.base = 16;
                this.token.setCode(num);
            } else {
                this.p = last2;
            }
        } else if (this.syntax.opEscXHex2()) {
            int num = this.scanUnsignedHexadecimalNumber(0, 2);
            if (num < 0) {
                this.newValueException("too big number");
            }
            if (this.p == last2) {
                num = 0;
            }
            this.token.type = TokenType.RAW_BYTE;
            this.token.base = 16;
            this.token.setC(num);
        }
    }

    private void fetchTokenInCCFor_u() {
        if (!this.left()) {
            return;
        }
        int last2 = this.p;
        if (this.syntax.op2EscUHex4()) {
            int num = this.scanUnsignedHexadecimalNumber(4, 4);
            if (num < -1) {
                this.newValueException("too short digits");
            }
            if (num < 0) {
                this.newValueException("too big number");
            }
            if (this.p == last2) {
                num = 0;
            }
            this.token.type = TokenType.CODE_POINT;
            this.token.base = 16;
            this.token.setCode(num);
        }
    }

    private void fetchTokenInCCFor_digit() {
        if (this.syntax.opEscOctal3()) {
            this.unfetch();
            int last2 = this.p;
            int num = this.scanUnsignedOctalNumber(3);
            if (num < 0 || num > 255) {
                this.newValueException("too big number");
            }
            if (this.p == last2) {
                num = 0;
            }
            this.token.type = TokenType.RAW_BYTE;
            this.token.base = 8;
            this.token.setC(num);
        }
    }

    private void fetchTokenInCCFor_posixBracket() {
        if (this.syntax.opPosixBracket() && this.peekIs(58)) {
            this.token.backP = this.p;
            this.inc();
            if (this.strExistCheckWithEsc(send, send.length, 93)) {
                this.token.type = TokenType.POSIX_BRACKET_OPEN;
            } else {
                this.unfetch();
                if (this.syntax.op2CClassSetOp()) {
                    this.token.type = TokenType.CC_CC_OPEN;
                } else {
                    this.env.ccEscWarn("[");
                }
            }
        } else if (this.syntax.op2CClassSetOp()) {
            this.token.type = TokenType.CC_CC_OPEN;
        } else {
            this.env.ccEscWarn("[");
        }
    }

    private void fetchTokenInCCFor_and() {
        if (this.syntax.op2CClassSetOp() && this.left() && this.peekIs(38)) {
            this.inc();
            this.token.type = TokenType.CC_AND;
        }
    }

    protected final TokenType fetchTokenInCC() {
        block24: {
            block26: {
                block25: {
                    block23: {
                        if (!this.left()) {
                            this.token.type = TokenType.EOT;
                            return this.token.type;
                        }
                        this.fetch();
                        this.token.type = TokenType.CHAR;
                        this.token.base = 0;
                        this.token.setC(this.c);
                        this.token.escaped = false;
                        if (this.c != 93) break block23;
                        this.token.type = TokenType.CC_CLOSE;
                        break block24;
                    }
                    if (this.c != 45) break block25;
                    this.token.type = TokenType.CC_RANGE;
                    break block24;
                }
                if (this.c != this.syntax.metaCharTable.esc) break block26;
                if (!this.syntax.backSlashEscapeInCC()) {
                    return this.token.type;
                }
                if (!this.left()) {
                    this.newSyntaxException("end pattern at escape");
                }
                this.fetch();
                this.token.escaped = true;
                this.token.setC(this.c);
                switch (this.c) {
                    case 119: {
                        this.fetchTokenInCCFor_charType(false, 12);
                        break;
                    }
                    case 87: {
                        this.fetchTokenInCCFor_charType(true, 12);
                        break;
                    }
                    case 100: {
                        this.fetchTokenInCCFor_charType(false, 4);
                        break;
                    }
                    case 68: {
                        this.fetchTokenInCCFor_charType(true, 4);
                        break;
                    }
                    case 115: {
                        this.fetchTokenInCCFor_charType(false, 9);
                        break;
                    }
                    case 83: {
                        this.fetchTokenInCCFor_charType(true, 9);
                        break;
                    }
                    case 104: {
                        if (this.syntax.op2EscHXDigit()) {
                            this.fetchTokenInCCFor_charType(false, 11);
                            break;
                        }
                        break block24;
                    }
                    case 72: {
                        if (this.syntax.op2EscHXDigit()) {
                            this.fetchTokenInCCFor_charType(true, 11);
                            break;
                        }
                        break block24;
                    }
                    case 80: 
                    case 112: {
                        if (!this.left()) break;
                        this.fetchTokenInCCFor_p();
                        break;
                    }
                    case 120: {
                        this.fetchTokenInCCFor_x();
                        break;
                    }
                    case 117: {
                        this.fetchTokenInCCFor_u();
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        this.fetchTokenInCCFor_digit();
                        break;
                    }
                    default: {
                        this.unfetch();
                        this.fetchEscapedValue();
                        if (this.token.getC() != this.c) {
                            this.token.setCode(this.c);
                            this.token.type = TokenType.CODE_POINT;
                            break;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            if (this.c == 91) {
                this.fetchTokenInCCFor_posixBracket();
            } else if (this.c == 38) {
                this.fetchTokenInCCFor_and();
            }
        }
        return this.token.type;
    }

    protected final int backrefRelToAbs(int relNo) {
        return this.env.numMem + 1 + relNo;
    }

    private void fetchTokenFor_repeat(int lower, int upper) {
        this.token.type = TokenType.OP_REPEAT;
        this.token.setRepeatLower(lower);
        this.token.setRepeatUpper(upper);
        this.greedyCheck();
    }

    private void fetchTokenFor_openBrace() {
        switch (this.fetchRangeQuantifier()) {
            case 0: {
                this.greedyCheck();
                break;
            }
            case 2: {
                if (this.syntax.fixedIntervalIsGreedyOnly()) {
                    this.possessiveCheck();
                    break;
                }
                this.greedyCheck();
                break;
            }
        }
    }

    private void fetchTokenFor_anchor(int subType) {
        this.token.type = TokenType.ANCHOR;
        this.token.setAnchorSubtype(subType);
    }

    private void fetchTokenFor_xBrace() {
        if (!this.left()) {
            return;
        }
        int last2 = this.p;
        if (this.peekIs(123) && this.syntax.opEscXBraceHex8()) {
            this.inc();
            int num = this.scanUnsignedHexadecimalNumber(0, 8);
            if (num < 0) {
                this.newValueException("too big wide-char value");
            }
            if (this.left() && this.enc.isXDigit(this.peek())) {
                this.newValueException("too long wide-char value");
            }
            if (this.p > last2 + this.enc.length(this.bytes, last2, this.stop) && this.left() && this.peekIs(125)) {
                this.inc();
                this.token.type = TokenType.CODE_POINT;
                this.token.setCode(num);
            } else {
                this.p = last2;
            }
        } else if (this.syntax.opEscXHex2()) {
            int num = this.scanUnsignedHexadecimalNumber(0, 2);
            if (num < 0) {
                this.newValueException("too big number");
            }
            if (this.p == last2) {
                num = 0;
            }
            this.token.type = TokenType.RAW_BYTE;
            this.token.base = 16;
            this.token.setC(num);
        }
    }

    private void fetchTokenFor_uHex() {
        if (!this.left()) {
            return;
        }
        int last2 = this.p;
        if (this.syntax.op2EscUHex4()) {
            int num = this.scanUnsignedHexadecimalNumber(4, 4);
            if (num < -1) {
                this.newValueException("too short digits");
            }
            if (num < 0) {
                this.newValueException("too big number");
            }
            if (this.p == last2) {
                num = 0;
            }
            this.token.type = TokenType.CODE_POINT;
            this.token.base = 16;
            this.token.setCode(num);
        }
    }

    private void fetchTokenFor_digit() {
        this.unfetch();
        int last2 = this.p;
        int num = this.scanUnsignedNumber();
        if (num >= 0 && num <= Config.MAX_BACKREF_NUM && this.syntax.opDecimalBackref() && (num <= this.env.numMem || num <= 9)) {
            if (this.syntax.strictCheckBackref() && (num > this.env.numMem || this.env.memNodes == null || this.env.memNodes[num] == null)) {
                this.newValueException(INVALID_BACKREF);
            }
            this.token.type = TokenType.BACKREF;
            this.token.setBackrefNum(1);
            this.token.setBackrefRef1(num);
            this.token.setBackrefByName(false);
            if (Config.USE_BACKREF_WITH_LEVEL) {
                this.token.setBackrefExistLevel(false);
            }
            return;
        }
        if (this.c == 56 || this.c == 57) {
            this.p = last2;
            this.inc();
            return;
        }
        this.p = last2;
        this.fetchTokenFor_zero();
    }

    private void fetchTokenFor_zero() {
        if (this.syntax.opEscOctal3()) {
            int last2 = this.p;
            int num = this.scanUnsignedOctalNumber(this.c == 48 ? 2 : 3);
            if (num < 0 || num > 255) {
                this.newValueException("too big number");
            }
            if (this.p == last2) {
                num = 0;
            }
            this.token.type = TokenType.RAW_BYTE;
            this.token.base = 8;
            this.token.setC(num);
        } else if (this.c != 48) {
            this.inc();
        }
    }

    private void fetchTokenFor_NamedBackref() {
        if (Config.USE_NAMED_GROUP && this.syntax.op2EscKNamedBackref() && this.left()) {
            this.fetch();
            if (this.c == 60 || this.c == 39) {
                this.fetchNamedBackrefToken();
            } else {
                this.unfetch();
                this.syntaxWarn("invalid back reference");
            }
        }
    }

    private void fetchTokenFor_subexpCall() {
        if (Config.USE_NAMED_GROUP && this.syntax.op2EscGBraceBackref() && this.left()) {
            this.fetch();
            if (this.c == 123) {
                this.fetchNamedBackrefToken();
            } else {
                this.unfetch();
            }
        }
        if (Config.USE_SUBEXP_CALL && this.syntax.op2EscGSubexpCall() && this.left()) {
            this.fetch();
            if (this.c == 60 || this.c == 39) {
                int gNum = -1;
                boolean rel = false;
                int cnext = this.peek();
                int nameEnd = 0;
                if (cnext == 48) {
                    this.inc();
                    if (this.peekIs(this.nameEndCodePoint(this.c))) {
                        this.inc();
                        nameEnd = this.p;
                        gNum = 0;
                    }
                } else if (cnext == 43) {
                    this.inc();
                    rel = true;
                }
                int prev = this.p;
                if (gNum < 0) {
                    gNum = this.fetchName(this.c, true);
                    nameEnd = this.value;
                }
                this.token.type = TokenType.CALL;
                this.token.setCallNameP(prev);
                this.token.setCallNameEnd(nameEnd);
                this.token.setCallGNum(gNum);
                this.token.setCallRel(rel);
            } else {
                this.syntaxWarn("invalid subexp call");
                this.unfetch();
            }
        }
    }

    protected void fetchNamedBackrefToken() {
        int backNum;
        int last2 = this.p;
        if (Config.USE_BACKREF_WITH_LEVEL) {
            Ptr rbackNum = new Ptr();
            Ptr rlevel = new Ptr();
            this.token.setBackrefExistLevel(this.fetchNameWithLevel(this.c, rbackNum, rlevel));
            this.token.setBackrefLevel(rlevel.p);
            backNum = rbackNum.p;
        } else {
            backNum = this.fetchName(this.c, true);
        }
        int nameEnd = this.value;
        if (backNum != 0) {
            if (backNum < 0 && (backNum = this.backrefRelToAbs(backNum)) <= 0) {
                this.newValueException(INVALID_BACKREF);
            }
            if (this.syntax.strictCheckBackref() && (backNum > this.env.numMem || this.env.memNodes == null)) {
                this.newValueException(INVALID_BACKREF);
            }
            this.token.type = TokenType.BACKREF;
            this.token.setBackrefByName(false);
            this.token.setBackrefNum(1);
            this.token.setBackrefRef1(backNum);
        } else {
            NameEntry e = this.regex.nameToGroupNumbers(this.bytes, last2, nameEnd);
            if (e == null) {
                this.newValueException("undefined name <%n> reference", last2, nameEnd);
            }
            if (this.syntax.strictCheckBackref()) {
                if (e.backNum == 1) {
                    if (e.backRef1 > this.env.numMem || this.env.memNodes == null || this.env.memNodes[e.backRef1] == null) {
                        this.newValueException(INVALID_BACKREF);
                    }
                } else {
                    for (int i2 = 0; i2 < e.backNum; ++i2) {
                        if (e.backRefs[i2] <= this.env.numMem && this.env.memNodes != null && this.env.memNodes[e.backRefs[i2]] != null) continue;
                        this.newValueException(INVALID_BACKREF);
                    }
                }
            }
            this.token.type = TokenType.BACKREF;
            this.token.setBackrefByName(true);
            if (e.backNum == 1) {
                this.token.setBackrefNum(1);
                this.token.setBackrefRef1(e.backRef1);
            } else {
                this.token.setBackrefNum(e.backNum);
                this.token.setBackrefRefs(e.backRefs);
            }
        }
    }

    private void fetchTokenFor_charProperty() {
        if (this.peekIs(123) && this.syntax.op2EscPBraceCharProperty()) {
            this.inc();
            this.token.type = TokenType.CHAR_PROPERTY;
            this.token.setPropNot(this.c == 80);
            if (this.left() && this.syntax.op2EscPBraceCircumflexNot()) {
                this.fetch();
                if (this.c == 94) {
                    this.token.setPropNot(!this.token.getPropNot());
                } else {
                    this.unfetch();
                }
            }
        } else {
            this.syntaxWarn("invalid Unicode Property \\<%n>", (char)this.c);
        }
    }

    private void fetchTokenFor_metaChars() {
        if (this.c == this.syntax.metaCharTable.anyChar) {
            this.token.type = TokenType.ANYCHAR;
        } else if (this.c == this.syntax.metaCharTable.anyTime) {
            this.fetchTokenFor_repeat(0, -1);
        } else if (this.c == this.syntax.metaCharTable.zeroOrOneTime) {
            this.fetchTokenFor_repeat(0, 1);
        } else if (this.c == this.syntax.metaCharTable.oneOrMoreTime) {
            this.fetchTokenFor_repeat(1, -1);
        } else if (this.c == this.syntax.metaCharTable.anyCharAnyTime) {
            this.token.type = TokenType.ANYCHAR_ANYTIME;
        }
    }

    protected final void fetchToken() {
        int src = this.p;
        block54: while (true) {
            if (!this.left()) {
                this.token.type = TokenType.EOT;
                return;
            }
            this.token.type = TokenType.STRING;
            this.token.base = 0;
            this.token.backP = this.p;
            this.fetch();
            if (this.c == this.syntax.metaCharTable.esc && !this.syntax.op2IneffectiveEscape()) {
                if (!this.left()) {
                    this.newSyntaxException("end pattern at escape");
                }
                this.token.backP = this.p;
                this.fetch();
                this.token.setC(this.c);
                this.token.escaped = true;
                switch (this.c) {
                    case 42: {
                        if (!this.syntax.opEscAsteriskZeroInf()) break block54;
                        this.fetchTokenFor_repeat(0, -1);
                        break;
                    }
                    case 43: {
                        if (!this.syntax.opEscPlusOneInf()) break block54;
                        this.fetchTokenFor_repeat(1, -1);
                        break;
                    }
                    case 63: {
                        if (!this.syntax.opEscQMarkZeroOne()) break block54;
                        this.fetchTokenFor_repeat(0, 1);
                        break;
                    }
                    case 123: {
                        if (!this.syntax.opEscBraceInterval()) break block54;
                        this.fetchTokenFor_openBrace();
                        break;
                    }
                    case 124: {
                        if (!this.syntax.opEscVBarAlt()) break block54;
                        this.token.type = TokenType.ALT;
                        break;
                    }
                    case 40: {
                        if (!this.syntax.opEscLParenSubexp()) break block54;
                        this.token.type = TokenType.SUBEXP_OPEN;
                        break;
                    }
                    case 41: {
                        if (!this.syntax.opEscLParenSubexp()) break block54;
                        this.token.type = TokenType.SUBEXP_CLOSE;
                        break;
                    }
                    case 119: {
                        if (!this.syntax.opEscWWord()) break block54;
                        this.fetchTokenInCCFor_charType(false, 12);
                        break;
                    }
                    case 87: {
                        if (!this.syntax.opEscWWord()) break block54;
                        this.fetchTokenInCCFor_charType(true, 12);
                        break;
                    }
                    case 98: {
                        if (!this.syntax.opEscBWordBound()) break block54;
                        this.fetchTokenFor_anchor(64);
                        this.token.setAnchorASCIIRange(Option.isAsciiRange(this.env.option) && !Option.isWordBoundAllRange(this.env.option));
                        break;
                    }
                    case 66: {
                        if (!this.syntax.opEscBWordBound()) break block54;
                        this.fetchTokenFor_anchor(128);
                        this.token.setAnchorASCIIRange(Option.isAsciiRange(this.env.option) && !Option.isWordBoundAllRange(this.env.option));
                        break;
                    }
                    case 60: {
                        if (!Config.USE_WORD_BEGIN_END || !this.syntax.opEscLtGtWordBeginEnd()) break block54;
                        this.fetchTokenFor_anchor(256);
                        this.token.setAnchorASCIIRange(Option.isAsciiRange(this.env.option));
                        break;
                    }
                    case 62: {
                        if (!Config.USE_WORD_BEGIN_END || !this.syntax.opEscLtGtWordBeginEnd()) break block54;
                        this.fetchTokenFor_anchor(512);
                        this.token.setAnchorASCIIRange(Option.isAsciiRange(this.env.option));
                        break;
                    }
                    case 115: {
                        if (!this.syntax.opEscSWhiteSpace()) break block54;
                        this.fetchTokenInCCFor_charType(false, 9);
                        break;
                    }
                    case 83: {
                        if (!this.syntax.opEscSWhiteSpace()) break block54;
                        this.fetchTokenInCCFor_charType(true, 9);
                        break;
                    }
                    case 100: {
                        if (!this.syntax.opEscDDigit()) break block54;
                        this.fetchTokenInCCFor_charType(false, 4);
                        break;
                    }
                    case 68: {
                        if (!this.syntax.opEscDDigit()) break block54;
                        this.fetchTokenInCCFor_charType(true, 4);
                        break;
                    }
                    case 104: {
                        if (!this.syntax.op2EscHXDigit()) break block54;
                        this.fetchTokenInCCFor_charType(false, 11);
                        break;
                    }
                    case 72: {
                        if (!this.syntax.op2EscHXDigit()) break block54;
                        this.fetchTokenInCCFor_charType(true, 11);
                        break;
                    }
                    case 65: {
                        if (!this.syntax.opEscAZBufAnchor()) break block54;
                        this.fetchTokenFor_anchor(1);
                        break;
                    }
                    case 90: {
                        if (!this.syntax.opEscAZBufAnchor()) break block54;
                        this.fetchTokenFor_anchor(16);
                        break;
                    }
                    case 122: {
                        if (!this.syntax.opEscAZBufAnchor()) break block54;
                        this.fetchTokenFor_anchor(8);
                        break;
                    }
                    case 71: {
                        if (!this.syntax.opEscCapitalGBeginAnchor()) break block54;
                        this.fetchTokenFor_anchor(4);
                        break;
                    }
                    case 96: {
                        if (!this.syntax.op2EscGnuBufAnchor()) break block54;
                        this.fetchTokenFor_anchor(1);
                        break;
                    }
                    case 39: {
                        if (!this.syntax.op2EscGnuBufAnchor()) break block54;
                        this.fetchTokenFor_anchor(8);
                        break;
                    }
                    case 120: {
                        this.fetchTokenFor_xBrace();
                        break;
                    }
                    case 117: {
                        this.fetchTokenFor_uHex();
                        break;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.fetchTokenFor_digit();
                        break;
                    }
                    case 48: {
                        this.fetchTokenFor_zero();
                        break;
                    }
                    case 107: {
                        this.fetchTokenFor_NamedBackref();
                        break;
                    }
                    case 103: {
                        this.fetchTokenFor_subexpCall();
                        break;
                    }
                    case 81: {
                        if (!this.syntax.op2EscCapitalQQuote()) break block54;
                        this.token.type = TokenType.QUOTE_OPEN;
                        break;
                    }
                    case 80: 
                    case 112: {
                        this.fetchTokenFor_charProperty();
                        break;
                    }
                    case 82: {
                        if (!this.syntax.op2EscCapitalRLinebreak()) break block54;
                        this.token.type = TokenType.LINEBREAK;
                        break;
                    }
                    case 88: {
                        if (!this.syntax.op2EscCapitalXExtendedGraphemeCluster()) break block54;
                        this.token.type = TokenType.EXTENDED_GRAPHEME_CLUSTER;
                        break;
                    }
                    case 75: {
                        if (!this.syntax.op2EscCapitalKKeep()) break block54;
                        this.token.type = TokenType.KEEP;
                        break;
                    }
                    default: {
                        this.unfetch();
                        this.fetchEscapedValue();
                        if (this.token.getC() != this.c) {
                            this.token.type = TokenType.CODE_POINT;
                            this.token.setCode(this.c);
                            break;
                        }
                        this.p = this.token.backP + this.enc.length(this.bytes, this.token.backP, this.stop);
                        break;
                    }
                }
                break;
            }
            this.token.setC(this.c);
            this.token.escaped = false;
            if (Config.USE_VARIABLE_META_CHARS && this.c != 0 && this.syntax.opVariableMetaCharacters()) {
                this.fetchTokenFor_metaChars();
                break;
            }
            switch (this.c) {
                case 46: {
                    if (!this.syntax.opDotAnyChar()) break block54;
                    this.token.type = TokenType.ANYCHAR;
                    break block54;
                }
                case 42: {
                    if (!this.syntax.opAsteriskZeroInf()) break block54;
                    this.fetchTokenFor_repeat(0, -1);
                    break block54;
                }
                case 43: {
                    if (!this.syntax.opPlusOneInf()) break block54;
                    this.fetchTokenFor_repeat(1, -1);
                    break block54;
                }
                case 63: {
                    if (!this.syntax.opQMarkZeroOne()) break block54;
                    this.fetchTokenFor_repeat(0, 1);
                    break block54;
                }
                case 123: {
                    if (!this.syntax.opBraceInterval()) break block54;
                    this.fetchTokenFor_openBrace();
                    break block54;
                }
                case 124: {
                    if (!this.syntax.opVBarAlt()) break block54;
                    this.token.type = TokenType.ALT;
                    break block54;
                }
                case 40: {
                    if (this.peekIs(63) && this.syntax.op2QMarkGroupEffect()) {
                        this.inc();
                        if (this.peekIs(35)) {
                            this.fetch();
                            while (true) {
                                if (!this.left()) {
                                    this.newSyntaxException("end pattern in group");
                                }
                                this.fetch();
                                if (this.c == this.syntax.metaCharTable.esc) {
                                    if (!this.left()) continue;
                                    this.fetch();
                                    continue;
                                }
                                if (this.c == 41) break;
                            }
                            continue block54;
                        }
                        this.unfetch();
                    }
                    if (!this.syntax.opLParenSubexp()) break block54;
                    this.token.type = TokenType.SUBEXP_OPEN;
                    break block54;
                }
                case 41: {
                    if (!this.syntax.opLParenSubexp()) break block54;
                    this.token.type = TokenType.SUBEXP_CLOSE;
                    break block54;
                }
                case 94: {
                    if (!this.syntax.opLineAnchor()) break block54;
                    this.fetchTokenFor_anchor(Option.isSingleline(this.env.option) ? 1 : 2);
                    break block54;
                }
                case 36: {
                    if (!this.syntax.opLineAnchor()) break block54;
                    this.fetchTokenFor_anchor(Option.isSingleline(this.env.option) ? 16 : 32);
                    break block54;
                }
                case 91: {
                    if (!this.syntax.opBracketCC()) break block54;
                    this.token.type = TokenType.CC_OPEN;
                    break block54;
                }
                case 93: {
                    if (src <= this.getBegin()) break block54;
                    this.env.closeBracketWithoutEscapeWarn("]");
                    break block54;
                }
                case 35: {
                    if (!Option.isExtend(this.env.option)) break block54;
                    do {
                        if (!this.left()) continue block54;
                        this.fetch();
                    } while (!this.enc.isNewLine(this.c));
                    continue block54;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    if (!Option.isExtend(this.env.option)) break block54;
                    continue block54;
                }
            }
            break;
        }
    }

    private void greedyCheck() {
        if (this.left() && this.peekIs(63) && this.syntax.opQMarkNonGreedy()) {
            this.fetch();
            this.token.setRepeatGreedy(false);
            this.token.setRepeatPossessive(false);
        } else {
            this.possessiveCheck();
        }
    }

    private void possessiveCheck() {
        if (this.left() && this.peekIs(43) && (this.syntax.op2PlusPossessiveRepeat() && this.token.type != TokenType.INTERVAL || this.syntax.op2PlusPossessiveInterval() && this.token.type == TokenType.INTERVAL)) {
            this.fetch();
            this.token.setRepeatGreedy(true);
            this.token.setRepeatPossessive(true);
        } else {
            this.token.setRepeatGreedy(true);
            this.token.setRepeatPossessive(false);
        }
    }

    protected final int fetchCharPropertyToCType() {
        this.mark();
        while (this.left()) {
            int last2 = this.p;
            this.fetch();
            if (this.c == 125) {
                return this.enc.propertyNameToCType(this.bytes, this._p, last2);
            }
            if (this.c != 40 && this.c != 41 && this.c != 123 && this.c != 124) continue;
            throw new CharacterPropertyException(EncodingError.ERR_INVALID_CHAR_PROPERTY_NAME, this.bytes, this._p, last2);
        }
        this.newValueException("property name never terminated \\p{%n", this._p, this.stop);
        return 0;
    }

    protected final void syntaxWarn(String message2, char c) {
        this.syntaxWarn(message2.replace("<%n>", Character.toString(c)));
    }

    protected final void syntaxWarn(String message2) {
        if (this.env.warnings != WarnCallback.NONE) {
            this.env.warnings.warn(message2 + ": /" + new String(this.bytes, this.getBegin(), this.getEnd() - this.getBegin()) + "/");
        }
    }
}

