/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jruby.EvalType;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.RubyStringBuilder;

@JRubyClass(name={"Struct"})
public class RubyStruct
extends RubyObject {
    public static final String NO_MEMBER_IN_STRUCT = "no member '%1$s' in struct";
    public static final String IDENTIFIER_NEEDS_TO_BE_CONSTANT = "identifier %1$s needs to be constant";
    public static final String UNINITIALIZED_CONSTANT = "uninitialized constant %1$s";
    private static final String KEYWORD_INIT_VAR = "__keyword_init__";
    private static final String SIZE_VAR = "__size__";
    public static final String MEMBER_VAR = "__member__";
    private final IRubyObject[] values;
    private static final byte[] STRUCT_BEG = new byte[]{35, 60, 115, 116, 114, 117, 99, 116, 32};
    private static final byte[] STRUCT_END = new byte[]{58, 46, 46, 46, 62};

    private RubyStruct(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
        int size2 = RubyNumeric.fix2int(RubyStruct.getInternalVariable(rubyClass, SIZE_VAR));
        this.values = new IRubyObject[size2];
        Helpers.fillNil(this.values, runtime2);
    }

    public static RubyClass createStructClass(Ruby runtime2) {
        RubyClass structClass = runtime2.defineClass("Struct", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        structClass.setClassIndex(ClassIndex.STRUCT);
        structClass.includeModule(runtime2.getEnumerable());
        structClass.setReifiedClass(RubyStruct.class);
        structClass.defineAnnotatedMethods(RubyStruct.class);
        return structClass;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.STRUCT;
    }

    private static IRubyObject getInternalVariable(RubyClass type2, String internedName) {
        RubyClass structClass = type2.getRuntime().getStructClass();
        while (type2 != null && type2 != structClass) {
            IRubyObject variable = (IRubyObject)type2.getInternalVariable(internedName);
            if (variable != null) {
                return variable;
            }
            type2 = type2.getSuperClass();
        }
        return type2.getRuntime().getNil();
    }

    private RubyClass classOf() {
        RubyClass metaClass = this.getMetaClass();
        return metaClass instanceof MetaClass ? metaClass.getSuperClass() : metaClass;
    }

    private void modify() {
        this.testFrozen();
    }

    @JRubyMethod
    public IRubyObject deconstruct_keys(ThreadContext context, IRubyObject keysArg) {
        if (keysArg.isNil()) {
            return this.to_h(context, Block.NULL_BLOCK);
        }
        if (!(keysArg instanceof RubyArray)) {
            throw context.runtime.newTypeError(RubyStringBuilder.str(context.runtime, "wrong argument type ", keysArg.getMetaClass(), "(expected Array or nil)"));
        }
        RubyArray keys2 = (RubyArray)keysArg;
        int length2 = keys2.size();
        RubyHash hash2 = RubyHash.newSmallHash(context.runtime);
        if (this.values.length < length2) {
            return hash2;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject value2;
            Object key2 = keys2.eltOk(i2);
            try {
                value2 = this.aref((IRubyObject)key2);
            }
            catch (RaiseException e) {
                return hash2;
            }
            hash2.op_aset(context, (IRubyObject)key2, value2);
        }
        return hash2;
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        int h = this.getType().hashCode();
        IRubyObject[] values2 = this.values;
        for (int i2 = 0; i2 < values2.length; ++i2) {
            h = h << 1 | (h < 0 ? 1 : 0);
            IRubyObject hash2 = context.safeRecurse((ctx, runtime1, obj, recur) -> recur ? RubyFixnum.zero(runtime1) : Helpers.invokedynamic(ctx, obj, MethodNames.HASH), runtime2, values2[i2], "hash", true);
            h = (int)((long)h ^ RubyNumeric.num2long(hash2));
        }
        return runtime2.newFixnum(h);
    }

    private IRubyObject setByName(String name2, IRubyObject value2) {
        RubyArray member = this.__member__();
        this.modify();
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (!member.eltInternal(i2).asJavaString().equals(name2)) continue;
            this.values[i2] = value2;
            return this.values[i2];
        }
        return null;
    }

    private IRubyObject getByName(String name2) {
        RubyArray member = this.__member__();
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (!member.eltInternal(i2).asJavaString().equals(name2)) continue;
            return this.values[i2];
        }
        return null;
    }

    @JRubyMethod(name={"new"}, required=1, rest=true, checkArity=false, meta=true, keywords=true)
    public static RubyClass newInstance(IRubyObject recv, IRubyObject[] args2, Block block) {
        int i2;
        RubyClass newStruct2;
        int i3;
        Ruby runtime2 = recv.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 1, -1);
        String name2 = null;
        boolean nilName = false;
        if (argc > 0) {
            IRubyObject firstArgAsString = args2[0].checkStringType();
            if (!firstArgAsString.isNil()) {
                RubySymbol nameSym = ((RubyString)firstArgAsString).intern();
                if (!nameSym.validConstantName()) {
                    throw runtime2.newNameError(IDENTIFIER_NEEDS_TO_BE_CONSTANT, recv, nameSym.toString());
                }
                name2 = nameSym.idString();
            } else if (args2[0].isNil()) {
                nilName = true;
            }
        }
        RubyArray member = runtime2.newArray();
        IRubyObject keywordInitValue = runtime2.getNil();
        IRubyObject opts = args2[argc - 1];
        if (opts instanceof RubyHash) {
            --argc;
            keywordInitValue = ArgsUtil.extractKeywordArg(runtime2.getCurrentContext(), (RubyHash)opts, "keyword_init");
        }
        HashSet<RubySymbol> tmpMemberSet = new HashSet<RubySymbol>();
        int n = i3 = name2 == null && !nilName ? 0 : 1;
        while (i3 < argc) {
            IRubyObject arg2 = args2[i3];
            RubySymbol sym = arg2 instanceof RubySymbol ? (RubySymbol)arg2 : (arg2 instanceof RubyString ? runtime2.newSymbol(arg2.convertToString().getByteList()) : runtime2.newSymbol(arg2.asJavaString()));
            if (tmpMemberSet.contains(sym)) {
                throw runtime2.newArgumentError("duplicate member: " + sym);
            }
            tmpMemberSet.add(sym);
            member.append(sym);
            ++i3;
        }
        RubyClass superClass = (RubyClass)recv;
        if (name2 == null || nilName) {
            newStruct2 = RubyClass.newClass(runtime2, superClass);
            newStruct2.setAllocator(RubyStruct::new);
            newStruct2.makeMetaClass(superClass.metaClass);
            newStruct2.inherit(superClass);
        } else {
            IRubyObject type2 = superClass.getConstantAt(name2);
            if (type2 != null) {
                ThreadContext context = runtime2.getCurrentContext();
                runtime2.getWarnings().warn(IRubyWarnings.ID.STRUCT_CONSTANT_REDEFINED, context.getFile(), context.getLine(), "redefining constant " + type2);
                superClass.deleteConstant(name2);
            }
            newStruct2 = superClass.defineClassUnder(name2, superClass, RubyStruct::new);
        }
        newStruct2.setReifiedClass(RubyStruct.class);
        newStruct2.setClassIndex(ClassIndex.STRUCT);
        newStruct2.setInternalVariable(SIZE_VAR, member.length());
        newStruct2.setInternalVariable(MEMBER_VAR, member);
        newStruct2.setInternalVariable(KEYWORD_INIT_VAR, keywordInitValue);
        newStruct2.getSingletonClass().defineAnnotatedMethods(StructMethods.class);
        int n2 = i2 = name2 == null && !nilName ? 0 : 1;
        while (!(i2 >= argc || i2 == argc - 1 && args2[i2] instanceof RubyHash)) {
            String memberName = args2[i2].asJavaString();
            int index2 = name2 == null && !nilName ? i2 : i2 - 1;
            newStruct2.addMethod(memberName, new Accessor(newStruct2, memberName, index2));
            String nameAsgn = memberName + '=';
            newStruct2.addMethod(nameAsgn, new Mutator(newStruct2, nameAsgn, index2));
            ++i2;
        }
        if (block.isGiven()) {
            block = block.cloneBlockForEval(newStruct2, EvalType.MODULE_EVAL);
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yieldNonArray(runtime2.getCurrentContext(), newStruct2, newStruct2);
        }
        return newStruct2;
    }

    public static RubyStruct newStruct(IRubyObject recv, IRubyObject[] args2, Block block) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        struct.callInit(args2, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv, Block block) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        struct.callInit(block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv, IRubyObject arg0, Block block) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        struct.callInit(arg0, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        struct.callInit(arg0, arg1, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        struct.callInit(arg0, arg1, arg2, block);
        return struct;
    }

    private void checkSize(int length2) {
        if (length2 > this.values.length) {
            throw this.getRuntime().newArgumentError("struct size differs (" + length2 + " for " + this.values.length + ")");
        }
    }

    private void checkForKeywords(ThreadContext context, boolean keywordInit) {
        if (ThreadContext.hasKeywords(ThreadContext.resetCallInfo(context)) && !keywordInit) {
            context.runtime.getWarnings().warn("Passing only keyword arguments to Struct#initialize will behave differently from Ruby 3.2. Please use a Hash literal like .new({k: v}) instead of .new(k: v).");
        }
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject keywordInit = RubyStruct.getInternalVariable(this.classOf(), KEYWORD_INIT_VAR);
        this.checkForKeywords(context, !keywordInit.isNil());
        ThreadContext.resetCallInfo(context);
        this.modify();
        this.checkSize(args2.length);
        if (keywordInit.isTrue()) {
            if (args2.length != 1) {
                throw context.runtime.newArgumentError(args2.length, 0);
            }
            return this.initialize(context, args2[0]);
        }
        System.arraycopy(args2, 0, this.values, 0, args2.length);
        Helpers.fillNil(this.values, args2.length, this.values.length, context.runtime);
        return context.nil;
    }

    private void setupStructValuesFromHash(ThreadContext context, RubyHash kwArgs) {
        Ruby runtime2 = context.runtime;
        RubyArray __members__ = this.__member__();
        Set entries2 = kwArgs.directEntrySet();
        entries2.stream().forEach(entry -> {
            IRubyObject index2;
            IRubyObject key2 = (IRubyObject)entry.getKey();
            if (!(key2 instanceof RubySymbol)) {
                key2 = runtime2.newSymbol(key2.convertToString().getByteList());
            }
            if ((index2 = __members__.index(context, key2)).isNil()) {
                throw runtime2.newArgumentError(RubyStringBuilder.str(runtime2, "unknown keywords: ", key2));
            }
            this.values[index2.convertToInteger().getIntValue()] = (IRubyObject)entry.getValue();
        });
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 0, nil, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        IRubyObject keywordInit = RubyStruct.getInternalVariable(this.classOf(), KEYWORD_INIT_VAR);
        this.checkForKeywords(context, !keywordInit.isNil());
        ThreadContext.resetCallInfo(context);
        Ruby runtime2 = context.runtime;
        if (keywordInit.isTrue()) {
            IRubyObject maybeKwargs = ArgsUtil.getOptionsArg(runtime2, arg0);
            if (maybeKwargs.isNil()) {
                throw context.runtime.newArgumentError(1, 0);
            }
            this.setupStructValuesFromHash(context, (RubyHash)maybeKwargs);
            return context.nil;
        }
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 1, arg0, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject keywordInit = RubyStruct.getInternalVariable(this.classOf(), KEYWORD_INIT_VAR);
        if (keywordInit.isTrue()) {
            throw context.runtime.newArgumentError(2, 0);
        }
        return this.initializeInternal(context, 2, arg0, arg1, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject keywordInit = RubyStruct.getInternalVariable(this.classOf(), KEYWORD_INIT_VAR);
        if (keywordInit.isTrue()) {
            throw context.runtime.newArgumentError(3, 0);
        }
        return this.initializeInternal(context, 3, arg0, arg1, arg2);
    }

    public IRubyObject initializeInternal(ThreadContext context, int provided, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.modify();
        this.checkSize(provided);
        switch (provided) {
            case 3: {
                this.values[2] = arg2;
            }
            case 2: {
                this.values[1] = arg1;
            }
            case 1: {
                this.values[0] = arg0;
            }
        }
        if (provided < this.values.length) {
            Helpers.fillNil(this.values, provided, this.values.length, context.runtime);
        }
        return context.nil;
    }

    static RubyArray members(RubyClass type2) {
        RubyArray member = RubyStruct.__member__(type2);
        int len = member.getLength();
        IRubyObject[] result2 = new IRubyObject[len];
        for (int i2 = 0; i2 < len; ++i2) {
            result2[i2] = member.eltInternal(i2);
        }
        return RubyArray.newArrayNoCopy(type2.runtime, result2);
    }

    @Deprecated
    public static RubyArray members(IRubyObject recv, Block block) {
        return RubyStruct.members((RubyClass)recv);
    }

    private static RubyArray __member__(RubyClass clazz) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(clazz, MEMBER_VAR);
        assert (!member.isNil()) : "uninitialized struct";
        return member;
    }

    private RubyArray __member__() {
        return RubyStruct.__member__(this.classOf());
    }

    @JRubyMethod(name={"members"})
    public RubyArray members() {
        return RubyStruct.members(this.classOf());
    }

    @Deprecated
    public final RubyArray members19() {
        return this.members();
    }

    @JRubyMethod
    public IRubyObject select(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select", RubyStruct::size);
        }
        RubyArray array = RubyArray.newArray(context.runtime);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (!block.yield(context, this.values[i2]).isTrue()) continue;
            array.append(this.values[i2]);
        }
        return array;
    }

    private static IRubyObject size(ThreadContext context, RubyStruct recv, IRubyObject[] args2) {
        return recv.size();
    }

    public IRubyObject set(IRubyObject value2, int index2) {
        this.modify();
        this.values[index2] = value2;
        return this.values[index2];
    }

    private RaiseException notStructMemberError(IRubyObject name2) {
        return this.getRuntime().newNameError(NO_MEMBER_IN_STRUCT, (IRubyObject)this, name2);
    }

    public final IRubyObject get(int index2) {
        return this.values[index2];
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyStruct struct = (RubyStruct)clone2;
        System.arraycopy(this.values, 0, struct.values, 0, this.values.length);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyStruct)) {
            return context.fals;
        }
        if (this.getType() != other.getType()) {
            return context.fals;
        }
        if (other == this) {
            return context.tru;
        }
        return RecursiveComparator.compare(context, RubyStruct.sites((ThreadContext)context).op_equal, this, other, true);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyStruct)) {
            return context.fals;
        }
        if (this.metaClass != RubyStruct.getMetaClass(other)) {
            return context.fals;
        }
        return RecursiveComparator.compare(context, RubyStruct.sites((ThreadContext)context).eql, this, other, true);
    }

    public RubyBoolean compare(ThreadContext context, CallSite site, IRubyObject other) {
        if (!(other instanceof RubyStruct)) {
            return context.fals;
        }
        RubyStruct struct = (RubyStruct)other;
        if (this.values.length != struct.values.length) {
            return context.fals;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            IRubyObject b2;
            IRubyObject a = this.aref(i2);
            if (site.call(context, a, a, b2 = struct.aref(i2)).isTrue()) continue;
            return context.fals;
        }
        return context.tru;
    }

    private RubyString inspectStruct(ThreadContext context, boolean recur) {
        Ruby runtime2 = context.runtime;
        RubyString buffer = RubyString.newString(runtime2, new ByteList(32));
        buffer.cat(STRUCT_BEG);
        String cname = this.getMetaClass().getRealClass().getName();
        char first2 = cname.charAt(0);
        if (recur || first2 != '#') {
            buffer.cat(cname.getBytes());
        }
        if (recur) {
            return buffer.cat(STRUCT_END);
        }
        RubyArray member = this.__member__();
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (i2 > 0) {
                buffer.cat(44).cat(32);
            } else if (first2 != '#') {
                buffer.cat(32);
            }
            RubySymbol slot = (RubySymbol)member.eltInternal(i2);
            if (slot.validLocalVariableName() || slot.validConstantName()) {
                buffer.catWithCodeRange(RubyString.objAsString(context, slot));
            } else {
                buffer.catWithCodeRange((RubyString)slot.inspect(context));
            }
            buffer.cat(61);
            buffer.catWithCodeRange(RubyStruct.inspect(context, this.values[i2]));
        }
        buffer.cat(62);
        return buffer;
    }

    @JRubyMethod(name={"inspect", "to_s"})
    public RubyString inspect(ThreadContext context) {
        return (RubyString)context.safeRecurse((ctx, self2, obj, recur) -> self2.inspectStruct(ctx, recur), this, this, "inspect", false);
    }

    @Override
    @JRubyMethod(name={"to_a", "deconstruct", "values"})
    public RubyArray to_a(ThreadContext context) {
        return context.runtime.newArray(this.values);
    }

    @Deprecated
    public RubyHash to_h(ThreadContext context) {
        return this.to_h(context, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public RubyHash to_h(ThreadContext context, Block block) {
        RubyHash hash2 = RubyHash.newHash(context.runtime);
        RubyArray members2 = this.__member__();
        if (block.isGiven()) {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                IRubyObject elt = block.yieldValues(context, new IRubyObject[]{members2.eltOk(i2), this.values[i2]});
                IRubyObject key_value_pair = elt.checkArrayType();
                if (key_value_pair == context.nil) {
                    throw context.runtime.newTypeError("wrong element type " + elt.getMetaClass().getRealClass() + " at " + i2 + " (expected array)");
                }
                RubyArray ary = (RubyArray)key_value_pair;
                if (ary.getLength() != 2) {
                    throw context.runtime.newArgumentError("element has wrong array length (expected 2, was " + ary.getLength() + ")");
                }
                hash2.op_aset(context, (IRubyObject)ary.eltInternal(0), (IRubyObject)ary.eltInternal(1));
            }
        } else {
            for (int i3 = 0; i3 < this.values.length; ++i3) {
                hash2.op_aset(context, (IRubyObject)members2.eltOk(i3), this.values[i3]);
            }
        }
        return hash2;
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.values.length);
    }

    public IRubyObject eachInternal(ThreadContext context, Block block) {
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            block.yield(context, this.values[i2]);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each", RubyStruct::size);
    }

    public IRubyObject each_pairInternal(ThreadContext context, Block block) {
        RubyArray member = this.__member__();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            block.yield(context, RubyArray.newArray(context.runtime, member.eltInternal(i2), this.values[i2]));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_pair", RubyStruct::size);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(IRubyObject key2) {
        return this.arefImpl(key2, false);
    }

    private IRubyObject arefImpl(IRubyObject key2, boolean nilOnNoMember) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            String name2 = key2.asJavaString();
            IRubyObject value2 = this.getByName(name2);
            if (value2 == null) {
                if (nilOnNoMember) {
                    return this.getRuntime().getNil();
                }
                throw this.notStructMemberError(key2);
            }
            return value2;
        }
        return this.aref(RubyNumeric.fix2int(key2));
    }

    final IRubyObject aref(int idx) {
        int newIdx;
        int n = newIdx = idx < 0 ? this.values.length + idx : idx;
        if (newIdx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too small for struct(size:" + this.values.length + ")");
        }
        if (newIdx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct(size:" + this.values.length + ")");
        }
        return this.values[newIdx];
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            String name2 = key2.asJavaString();
            IRubyObject val = this.setByName(name2, value2);
            if (val == null) {
                throw this.notStructMemberError(key2);
            }
            return value2;
        }
        return this.aset(RubyNumeric.fix2int(key2), value2);
    }

    private IRubyObject aset(int idx, IRubyObject value2) {
        int newIdx;
        int n = newIdx = idx < 0 ? this.values.length + idx : idx;
        if (newIdx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too small for struct(size:" + this.values.length + ")");
        }
        if (newIdx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct(size:" + this.values.length + ")");
        }
        this.modify();
        this.values[newIdx] = value2;
        return this.values[newIdx];
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        Ruby runtime2 = this.metaClass.runtime;
        int olen = this.values.length;
        RubyArray result2 = this.getRuntime().newArray(args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject arg2 = args2[i2];
            if (arg2 instanceof RubyFixnum) {
                result2.append(this.aref(arg2));
                continue;
            }
            int[] begLen = new int[2];
            if (arg2 instanceof RubyRange && RubyRange.rangeBeginLength(runtime2.getCurrentContext(), (RubyRange)args2[i2], olen, begLen, 1).isTrue()) {
                int j;
                int beg = begLen[0];
                int len = begLen[1];
                int end2 = olen < beg + len ? olen : beg + len;
                for (j = beg; j < end2; ++j) {
                    result2.push(this.aref(j));
                }
                if (beg + len <= j) continue;
                IRubyObject[] tmp = new IRubyObject[beg + len - j];
                Helpers.fillNil(tmp, this.getRuntime());
                result2.push(tmp);
                continue;
            }
            result2.push(this.aref(RubyNumeric.num2int(arg2)));
        }
        return result2;
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0) {
        return this.arefImpl(arg0, true);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject val = this.arefImpl(arg0, true);
        return RubyObject.dig1(context, val, arg1);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject val = this.arefImpl(arg0, true);
        return RubyObject.dig2(context, val, arg1, arg2);
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true, checkArity=false)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        IRubyObject val = this.arefImpl(args2[0], true);
        return argc == 1 ? val : RubyObject.dig(context, val, args2, 1);
    }

    public static void marshalTo(RubyStruct struct, MarshalStream output) throws IOException {
        output.registerLinkTarget(struct);
        output.dumpDefaultObjectHeader('S', struct.getMetaClass());
        RubyArray member = RubyStruct.__member__(struct.classOf());
        output.writeInt(member.size());
        for (int i2 = 0; i2 < member.size(); ++i2) {
            RubySymbol name2 = (RubySymbol)member.eltInternal(i2);
            output.dumpObject(name2);
            output.dumpObject(struct.values[i2]);
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol className;
        Ruby runtime2 = input.getRuntime();
        RubyClass rbClass = RubyStruct.pathToClass(runtime2, (className = input.unique()).asJavaString());
        if (rbClass == null) {
            throw runtime2.newNameError(UNINITIALIZED_CONSTANT, (IRubyObject)runtime2.getStructClass(), className);
        }
        RubyArray member = RubyStruct.__member__(rbClass);
        int len = input.unmarshalInt();
        RubyStruct result2 = (RubyStruct)input.entry(new RubyStruct(runtime2, rbClass));
        for (int i2 = 0; i2 < len; ++i2) {
            RubySymbol slot = input.symbol();
            RubySymbol elem = (RubySymbol)member.eltInternal(i2);
            if (!elem.equals(slot)) {
                throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "struct ", rbClass, " not compatible (:", slot, " for :", elem, ")"));
            }
            result2.aset(i2, input.unmarshalObject());
        }
        return result2;
    }

    private static RubyClass pathToClass(Ruby runtime2, String path2) {
        return (RubyClass)runtime2.getClassFromPath(path2);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject arg2) {
        if (this == arg2) {
            return this;
        }
        RubyStruct original = (RubyStruct)arg2;
        this.checkFrozen();
        System.arraycopy(original.values, 0, this.values, 0, original.values.length);
        return this;
    }

    @Deprecated
    public static RubyArray members19(IRubyObject recv, Block block) {
        return RubyStruct.members(recv, block);
    }

    private static JavaSites.StructSites sites(ThreadContext context) {
        return context.sites.Struct;
    }

    @Override
    @Deprecated
    public RubyArray to_a() {
        return this.getRuntime().newArray(this.values);
    }

    private static class EqualRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        private static final EqualRecursive INSTANCE = new EqualRecursive();

        private EqualRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject other, IRubyObject self2, boolean recur) {
            if (recur) {
                return context.tru;
            }
            IRubyObject[] values2 = ((RubyStruct)self2).values;
            IRubyObject[] otherValues = ((RubyStruct)other).values;
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (RubyObject.equalInternal(context, values2[i2], otherValues[i2])) continue;
                return context.fals;
            }
            return context.tru;
        }
    }

    private static class EqlRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        static final EqlRecursive INSTANCE = new EqlRecursive();

        private EqlRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject other, IRubyObject self2, boolean recur) {
            if (recur) {
                return context.tru;
            }
            IRubyObject[] values2 = ((RubyStruct)self2).values;
            IRubyObject[] otherValues = ((RubyStruct)other).values;
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (RubyObject.eqlInternal(context, values2[i2], otherValues[i2])) continue;
                return context.fals;
            }
            return context.tru;
        }
    }

    public static class Mutator
    extends DynamicMethod {
        private final int index;

        public Mutator(RubyClass newStruct2, String name2, int index2) {
            super((RubyModule)newStruct2, Visibility.PUBLIC, name2);
            this.index = index2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context.runtime, name2, args2, 1, 1);
            return ((RubyStruct)self2).set(args2[0], this.index);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
            return ((RubyStruct)self2).set(arg2, this.index);
        }

        @Override
        public DynamicMethod dup() {
            return new Mutator((RubyClass)this.getImplementationClass(), this.name, this.index);
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class Accessor
    extends DynamicMethod {
        private final int index;

        public Accessor(RubyClass newStruct2, String name2, int index2) {
            super((RubyModule)newStruct2, Visibility.PUBLIC, name2);
            this.index = index2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context.runtime, name2, args2, 0, 0);
            return ((RubyStruct)self2).get(this.index);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return ((RubyStruct)self2).get(this.index);
        }

        @Override
        public DynamicMethod dup() {
            return new Accessor((RubyClass)this.getImplementationClass(), this.name, this.index);
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class StructMethods {
        @JRubyMethod(name={"new", "[]"}, rest=true, keywords=true)
        public static IRubyObject newStruct(IRubyObject recv, IRubyObject[] args2, Block block) {
            return RubyStruct.newStruct(recv, args2, block);
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject newStruct(IRubyObject recv, Block block) {
            return RubyStruct.newStruct(recv, block);
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject newStruct(IRubyObject recv, IRubyObject arg0, Block block) {
            return RubyStruct.newStruct(recv, arg0, block);
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject newStruct(IRubyObject recv, IRubyObject arg0, IRubyObject arg1, Block block) {
            return RubyStruct.newStruct(recv, arg0, arg1, block);
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject newStruct(IRubyObject recv, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return RubyStruct.newStruct(recv, arg0, arg1, arg2, block);
        }

        @JRubyMethod
        public static IRubyObject members(IRubyObject recv, Block block) {
            return RubyStruct.members19(recv, block);
        }

        @JRubyMethod
        public static IRubyObject inspect(IRubyObject recv) {
            IRubyObject keywordInit = RubyStruct.getInternalVariable((RubyClass)recv, RubyStruct.KEYWORD_INIT_VAR);
            if (!keywordInit.isTrue()) {
                return recv.inspect();
            }
            return recv.inspect().convertToString().catString("(keyword_init: true)");
        }

        @JRubyMethod(name={"keyword_init?"})
        public static IRubyObject keyword_init_p(IRubyObject self2) {
            return RubyStruct.getInternalVariable((RubyClass)self2, RubyStruct.KEYWORD_INIT_VAR);
        }
    }
}

