/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import jnr.constants.platform.Errno;
import jnr.posix.POSIXHandler;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.common.IRubyWarnings;
import org.jruby.util.cli.Options;

public class JRubyPOSIXHandler
implements POSIXHandler {
    private final Ruby runtime;
    private final boolean isVerbose;

    public JRubyPOSIXHandler(Ruby runtime2) {
        this.runtime = runtime2;
        boolean verbose = false;
        try {
            verbose = Options.NATIVE_VERBOSE.load();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.isVerbose = verbose;
    }

    @Override
    public void error(Errno error, String extraData) {
        throw this.runtime.newErrnoFromInt(error.intValue(), extraData);
    }

    @Override
    public void error(Errno error, String methodName, String extraData) {
        throw this.runtime.newErrnoFromInt(error.intValue(), methodName, extraData);
    }

    @Override
    public void unimplementedError(String method2) {
        throw this.runtime.newNotImplementedError(method2 + " unsupported or native support failed to load; see https://github.com/jruby/jruby/wiki/Native-Libraries");
    }

    @Override
    public void warn(POSIXHandler.WARNING_ID id2, String message2, Object ... data) {
        IRubyWarnings.ID ourID = id2 == POSIXHandler.WARNING_ID.DUMMY_VALUE_USED ? IRubyWarnings.ID.DUMMY_VALUE_USED : IRubyWarnings.ID.MISCELLANEOUS;
        this.runtime.getWarnings().warn(ourID, message2);
    }

    @Override
    public boolean isVerbose() {
        return this.isVerbose;
    }

    @Override
    public File getCurrentWorkingDirectory() {
        return new File(this.runtime.getCurrentDirectory());
    }

    @Override
    public String[] getEnv() {
        RubyHash hash2 = (RubyHash)this.runtime.getObject().getConstant("ENV");
        String[] env = new String[hash2.size()];
        if (env.length == 0) {
            return env;
        }
        StringBuilder str = new StringBuilder();
        int i2 = 0;
        for (Map.Entry entry : hash2.directEntrySet()) {
            str.setLength(0);
            str.append(entry.getKey()).append('=').append(entry.getValue());
            env[i2] = str.toString();
            ++i2;
        }
        return env;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.runtime.getErrorStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.runtime.getInputStream();
    }

    @Override
    public int getPID() {
        return this.runtime.hashCode();
    }

    @Override
    public PrintStream getOutputStream() {
        return this.runtime.getOutputStream();
    }
}

