/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.bigdecimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.bigdecimal.Multiplication;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.SafeDoubleParser;
import org.jruby.util.StringSupport;

public class RubyBigDecimal
extends RubyNumeric {
    @JRubyConstant
    public static final int ROUND_DOWN = 2;
    @JRubyConstant
    public static final int ROUND_CEILING = 5;
    @JRubyConstant
    public static final int ROUND_UP = 1;
    @JRubyConstant
    public static final int ROUND_HALF_DOWN = 4;
    @JRubyConstant
    public static final int ROUND_HALF_EVEN = 7;
    @JRubyConstant
    public static final int ROUND_HALF_UP = 3;
    @JRubyConstant
    public static final int ROUND_FLOOR = 6;
    @JRubyConstant
    public static final int SIGN_POSITIVE_INFINITE = 3;
    @JRubyConstant
    public static final int SIGN_POSITIVE_ZERO = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_FINITE = -2;
    @JRubyConstant
    public static final int SIGN_NaN = 0;
    @JRubyConstant
    public static final int BASE = 10000;
    @JRubyConstant
    public static final int ROUND_MODE = 256;
    @JRubyConstant
    public static final int SIGN_POSITIVE_FINITE = 2;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_INFINITE = -3;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_ZERO = -1;
    @JRubyConstant
    public static final int EXCEPTION_INFINITY = 1;
    @JRubyConstant
    public static final int EXCEPTION_OVERFLOW = 1;
    @JRubyConstant
    public static final int EXCEPTION_NaN = 2;
    @JRubyConstant
    public static final int EXCEPTION_UNDERFLOW = 4;
    @JRubyConstant
    public static final int EXCEPTION_ZERODIVIDE = 16;
    @JRubyConstant
    public static final int EXCEPTION_ALL = 255;
    private static final ByteList VERSION = ByteList.create("3.1.4");
    private static final short VP_DOUBLE_FIG = 16;
    private static final short RMPD_COMPONENT_FIGURES = 9;
    private static final short BASE_FIG = 9;
    private static final double SQRT_10 = 3.1622776601683795;
    private static final long NEGATIVE_ZERO_LONG_BITS = Double.doubleToLongBits(-0.0);
    private boolean isNaN;
    private int infinitySign;
    private int zeroSign;
    private BigDecimal value;
    private transient BigDecimal absStripTrailingZeros;
    private static final BigDecimal MAX_FIX = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_FIX = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final Pattern FRACTIONAL_DIGIT_GROUPS = Pattern.compile("(\\+| )?(\\d+)(E|F|f)?");

    public static RubyClass createBigDecimal(Ruby runtime2) {
        RubyClass bigDecimal = runtime2.defineClass("BigDecimal", runtime2.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        bigDecimal.setConstant("VERSION", RubyString.newStringShared(runtime2, VERSION));
        runtime2.getKernel().defineAnnotatedMethods(BigDecimalKernelMethods.class);
        bigDecimal.setInternalModuleVariable("vpPrecLimit", RubyFixnum.zero(runtime2));
        bigDecimal.setInternalModuleVariable("vpExceptionMode", RubyFixnum.zero(runtime2));
        bigDecimal.setInternalModuleVariable("vpRoundingMode", runtime2.newFixnum(3));
        bigDecimal.defineAnnotatedMethods(RubyBigDecimal.class);
        bigDecimal.defineAnnotatedConstants(RubyBigDecimal.class);
        RubyBigDecimal POSITIVE_ZERO = new RubyBigDecimal(runtime2, BigDecimal.ZERO, 0, 1);
        RubyBigDecimal NEGATIVE_ZERO = new RubyBigDecimal(runtime2, BigDecimal.ZERO, 0, -1);
        RubyBigDecimal NAN = new RubyBigDecimal(runtime2, BigDecimal.ZERO, true);
        RubyBigDecimal POSITIVE_INFINITY = new RubyBigDecimal(runtime2, BigDecimal.ZERO, 1, 0);
        RubyBigDecimal NEGATIVE_INFINITY = new RubyBigDecimal(runtime2, BigDecimal.ZERO, -1, 0);
        bigDecimal.defineConstant("POSITIVE_ZERO", POSITIVE_ZERO);
        bigDecimal.setConstantVisibility(runtime2, "POSITIVE_ZERO", true);
        bigDecimal.defineConstant("NEGATIVE_ZERO", NEGATIVE_ZERO);
        bigDecimal.setConstantVisibility(runtime2, "NEGATIVE_ZERO", true);
        bigDecimal.defineConstant("NAN", NAN);
        bigDecimal.defineConstant("INFINITY", POSITIVE_INFINITY);
        bigDecimal.defineConstant("NEGATIVE_INFINITY", NEGATIVE_INFINITY);
        bigDecimal.setConstantVisibility(runtime2, "NEGATIVE_INFINITY", true);
        bigDecimal.setReifiedClass(RubyBigDecimal.class);
        return bigDecimal;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = BigDecimal.ZERO;
        this.flags |= FROZEN_F;
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2) {
        super(runtime2, runtime2.getClass("BigDecimal"));
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    public RubyBigDecimal(Ruby runtime2, RubyClass klass, BigDecimal value2) {
        super(runtime2, klass);
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2, int infinitySign) {
        this(runtime2, value2, infinitySign, 0);
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2, int infinitySign, int zeroSign) {
        super(runtime2, runtime2.getClass("BigDecimal"));
        this.isNaN = false;
        this.infinitySign = infinitySign;
        this.zeroSign = zeroSign;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2, boolean isNan) {
        super(runtime2, runtime2.getClass("BigDecimal"));
        this.isNaN = isNan;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    RubyBigDecimal(Ruby runtime2, RubyClass klass, BigDecimal value2, int zeroSign, int infinitySign, boolean isNaN) {
        super(runtime2, klass);
        this.isNaN = isNaN;
        this.infinitySign = infinitySign;
        this.zeroSign = zeroSign;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.BIGDECIMAL;
    }

    @JRubyMethod
    public IRubyObject _dump(ThreadContext context) {
        return RubyString.newUnicodeString(context.runtime, "0:").append(this.asString());
    }

    @JRubyMethod
    public IRubyObject _dump(ThreadContext context, IRubyObject unused) {
        return RubyString.newUnicodeString(context.runtime, "0:").append(this.asString());
    }

    @JRubyMethod(meta=true)
    public static RubyBigDecimal _load(ThreadContext context, IRubyObject recv, IRubyObject from) {
        String precisionAndValue = from.convertToString().asJavaString();
        long m = 0L;
        for (int i2 = 0; i2 != precisionAndValue.length() && precisionAndValue.charAt(i2) != ':'; ++i2) {
            if (!Character.isDigit(precisionAndValue.charAt(i2))) {
                throw context.runtime.newTypeError("load failed: invalid character in the marshaled string");
            }
            m = m * 10L + (long)(precisionAndValue.charAt(i2) - 48);
        }
        String value2 = precisionAndValue.substring(precisionAndValue.indexOf(58) + 1);
        return (RubyBigDecimal)RubyBigDecimal.newInstance(context, recv, (IRubyObject)RubyString.newString(context.runtime, value2), RubyFixnum.newFixnum(context.runtime, m), true, true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject double_fig(ThreadContext context, IRubyObject recv) {
        return context.runtime.newFixnum(16);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject limit(ThreadContext context, IRubyObject recv) {
        return ((RubyModule)recv).searchInternalModuleVariable("vpPrecLimit");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject limit(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        IRubyObject old = RubyBigDecimal.limit(context, recv);
        if (arg2 == context.nil) {
            return old;
        }
        if (!(arg2 instanceof RubyFixnum)) {
            throw context.runtime.newTypeError(arg2, context.runtime.getFixnum());
        }
        if (0L > ((RubyFixnum)arg2).getLongValue()) {
            throw context.runtime.newArgumentError("argument must be positive");
        }
        ((RubyModule)recv).setInternalModuleVariable("vpPrecLimit", arg2);
        return old;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_limit(ThreadContext context, IRubyObject recv, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv, block, "vpPrecLimit");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_exception_mode(ThreadContext context, IRubyObject recv, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv, block, "vpExceptionMode");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_rounding_mode(ThreadContext context, IRubyObject recv, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv, block, "vpRoundingMode");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject interpret_loosely(ThreadContext context, IRubyObject recv, IRubyObject str) {
        return RubyBigDecimal.newInstance(context, recv, str, RubyFixnum.newFixnum(context.runtime, Integer.MAX_VALUE), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject modeExecute(ThreadContext context, RubyModule BigDecimal2, Block block, String intVariableName) {
        IRubyObject current2 = BigDecimal2.searchInternalModuleVariable(intVariableName);
        try {
            IRubyObject iRubyObject = block.yieldSpecific(context);
            return iRubyObject;
        }
        finally {
            BigDecimal2.setInternalModuleVariable(intVariableName, current2);
        }
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject mode(ThreadContext context, IRubyObject recv, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        RubyModule c = (RubyModule)recv;
        args2 = Arity.scanArgs(context.runtime, args2, 1, 1);
        IRubyObject mode2 = args2[0];
        IRubyObject value2 = args2[1];
        if (!(mode2 instanceof RubyFixnum)) {
            throw context.runtime.newTypeError("wrong argument type " + mode2.getMetaClass() + " (expected Fixnum)");
        }
        long longMode = ((RubyFixnum)mode2).getLongValue();
        if ((longMode & 0xFFL) != 0L) {
            if (value2.isNil()) {
                return c.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!(value2 instanceof RubyBoolean)) {
                throw context.runtime.newArgumentError("second argument must be true or false");
            }
            long newExceptionMode = c.searchInternalModuleVariable("vpExceptionMode").convertToInteger().getLongValue();
            boolean enable2 = value2.isTrue();
            if ((longMode & 1L) != 0L) {
                long l = newExceptionMode = enable2 ? newExceptionMode | 1L : newExceptionMode & 0xFFFFFFFFFFFFFFFEL;
            }
            if ((longMode & 2L) != 0L) {
                long l = newExceptionMode = enable2 ? newExceptionMode | 2L : newExceptionMode & 0xFFFFFFFFFFFFFFFDL;
            }
            if ((longMode & 4L) != 0L) {
                long l = newExceptionMode = enable2 ? newExceptionMode | 4L : newExceptionMode & 0xFFFFFFFFFFFFFFFBL;
            }
            if ((longMode & 0x10L) != 0L) {
                newExceptionMode = enable2 ? newExceptionMode | 0x10L : newExceptionMode & 0xFFFFFFFFFFFFFFEFL;
            }
            RubyFixnum fixnumMode = RubyFixnum.newFixnum(runtime2, newExceptionMode);
            c.setInternalModuleVariable("vpExceptionMode", fixnumMode);
            return fixnumMode;
        }
        if (longMode == 256L) {
            if (value2 == context.nil) {
                return c.searchInternalModuleVariable("vpRoundingMode");
            }
            RoundingMode javaRoundingMode = RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context, value2);
            RubyFixnum roundingMode = runtime2.newFixnum(RubyBigDecimal.rubyRoundingModeFromJavaRoundingMode(context, javaRoundingMode));
            c.setInternalModuleVariable("vpRoundingMode", roundingMode);
            return roundingMode;
        }
        throw runtime2.newTypeError("first argument for BigDecimal#mode invalid");
    }

    private static long bigDecimalVar(Ruby runtime2, String variableName) {
        return ((RubyFixnum)runtime2.getClass("BigDecimal").searchInternalModuleVariable(variableName)).getLongValue();
    }

    private static RoundingMode getRoundingMode(Ruby runtime2) {
        IRubyObject mode2 = runtime2.getClass("BigDecimal").searchInternalModuleVariable("vpRoundingMode");
        return RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(runtime2.getCurrentContext(), mode2);
    }

    private static boolean isNaNExceptionMode(Ruby runtime2) {
        return (RubyBigDecimal.bigDecimalVar(runtime2, "vpExceptionMode") & 2L) != 0L;
    }

    private static boolean isInfinityExceptionMode(Ruby runtime2) {
        return (RubyBigDecimal.bigDecimalVar(runtime2, "vpExceptionMode") & 1L) != 0L;
    }

    private static boolean isOverflowExceptionMode(Ruby runtime2) {
        return (RubyBigDecimal.bigDecimalVar(runtime2, "vpExceptionMode") & 1L) != 0L;
    }

    private static boolean isUnderflowExceptionMode(Ruby runtime2) {
        return (RubyBigDecimal.bigDecimalVar(runtime2, "vpExceptionMode") & 4L) != 0L;
    }

    private static boolean isZeroDivideExceptionMode(Ruby runtime2) {
        return (RubyBigDecimal.bigDecimalVar(runtime2, "vpExceptionMode") & 0x10L) != 0L;
    }

    private static RubyBigDecimal cannotBeCoerced(ThreadContext context, IRubyObject value2, boolean must) {
        if (must) {
            throw context.runtime.newTypeError(RubyBigDecimal.errMessageType(context, value2) + " can't be coerced into BigDecimal");
        }
        return null;
    }

    private static String errMessageType(ThreadContext context, IRubyObject value2) {
        if (value2 == null || value2 == context.nil) {
            return "nil";
        }
        if (value2.isImmediate()) {
            return RubyObject.inspect(context, value2).toString();
        }
        return value2.getMetaClass().getBaseName();
    }

    private static BigDecimal toBigDecimal(RubyInteger value2) {
        if (value2 instanceof RubyFixnum) {
            return BigDecimal.valueOf(RubyNumeric.num2long(value2));
        }
        return new BigDecimal(value2.getBigIntegerValue());
    }

    private static RubyBigDecimal getVpRubyObjectWithPrecInner(ThreadContext context, RubyRational value2, RoundingMode mode2) {
        BigDecimal numerator2 = RubyBigDecimal.toBigDecimal(value2.getNumerator());
        BigDecimal denominator2 = RubyBigDecimal.toBigDecimal(value2.getDenominator());
        int len = numerator2.precision() + denominator2.precision();
        int pow2 = len / 4;
        MathContext mathContext = new MathContext((pow2 + 1) * 4, mode2);
        return new RubyBigDecimal(context.runtime, numerator2.divide(denominator2, mathContext));
    }

    private RubyBigDecimal getVpValueWithPrec(ThreadContext context, IRubyObject value2, boolean must) {
        if (value2 instanceof RubyFloat) {
            double doubleValue = ((RubyFloat)value2).getDoubleValue();
            if (Double.isInfinite(doubleValue)) {
                throw context.runtime.newFloatDomainError(doubleValue < 0.0 ? "-Infinity" : "Infinity");
            }
            if (Double.isNaN(doubleValue)) {
                throw context.runtime.newFloatDomainError("NaN");
            }
            MathContext mathContext = new MathContext(16, RubyBigDecimal.getRoundingMode(context.runtime));
            return new RubyBigDecimal(context.runtime, new BigDecimal(value2.toString(), mathContext));
        }
        if (value2 instanceof RubyRational) {
            return RubyBigDecimal.div2Impl(context, ((RubyRational)value2).getNumerator(), ((RubyRational)value2).getDenominator(), this.getPrec() * 9);
        }
        return RubyBigDecimal.getVpValue(context, value2, must);
    }

    private static RubyBigDecimal getVpValue(ThreadContext context, IRubyObject value2, boolean must) {
        switch (((RubyBasicObject)value2).getNativeClassIndex()) {
            case BIGDECIMAL: {
                return (RubyBigDecimal)value2;
            }
            case FIXNUM: {
                return RubyBigDecimal.newInstance(context.runtime, (IRubyObject)context.runtime.getClass("BigDecimal"), (RubyFixnum)value2, MathContext.UNLIMITED);
            }
            case BIGNUM: {
                return RubyBigDecimal.newInstance(context.runtime, (IRubyObject)context.runtime.getClass("BigDecimal"), (RubyBignum)value2, MathContext.UNLIMITED);
            }
            case FLOAT: {
                return RubyBigDecimal.newInstance(context.runtime, (IRubyObject)context.runtime.getClass("BigDecimal"), (RubyFloat)value2, new MathContext(15));
            }
            case RATIONAL: {
                return RubyBigDecimal.newInstance(context.runtime, (IRubyObject)context.runtime.getClass("BigDecimal"), (RubyRational)value2, new MathContext(15));
            }
        }
        return RubyBigDecimal.cannotBeCoerced(context, value2, must);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        return RubyBigDecimal.getVpValue(context, arg2, true);
    }

    private static RubyBigDecimal newInstance(Ruby runtime2, IRubyObject recv, RubyBigDecimal arg2) {
        return new RubyBigDecimal(runtime2, (RubyClass)recv, arg2.value, arg2.zeroSign, arg2.infinitySign, arg2.isNaN);
    }

    private static RubyBigDecimal newInstance(Ruby runtime2, IRubyObject recv, RubyFixnum arg2, MathContext mathContext) {
        long value2 = arg2.getLongValue();
        if (value2 == 0L) {
            return RubyBigDecimal.getZero(runtime2, 1);
        }
        return new RubyBigDecimal(runtime2, (RubyClass)recv, new BigDecimal(value2, mathContext));
    }

    private static RubyBigDecimal newInstance(Ruby runtime2, IRubyObject recv, RubyRational arg2, MathContext mathContext) {
        BigDecimal value2;
        if (arg2.getNumerator().isZero()) {
            return RubyBigDecimal.getZero(runtime2, 1);
        }
        BigDecimal num = RubyBigDecimal.toBigDecimal(arg2.getNumerator());
        BigDecimal den = RubyBigDecimal.toBigDecimal(arg2.getDenominator());
        try {
            value2 = num.divide(den, mathContext);
        }
        catch (ArithmeticException e) {
            value2 = num.divide(den, MathContext.DECIMAL64);
        }
        return new RubyBigDecimal(runtime2, (RubyClass)recv, value2);
    }

    private static RubyBigDecimal newInstance(Ruby runtime2, IRubyObject recv, RubyFloat arg2, MathContext mathContext) {
        if (mathContext.getPrecision() > 16) {
            throw runtime2.newArgumentError("precision too large");
        }
        RubyBigDecimal res = RubyBigDecimal.newFloatSpecialCases(runtime2, arg2);
        if (res != null) {
            return res;
        }
        return new RubyBigDecimal(runtime2, (RubyClass)recv, new BigDecimal(arg2.toString(), mathContext));
    }

    private static RubyBigDecimal newFloatSpecialCases(Ruby runtime2, RubyFloat val) {
        if (val.isNaN()) {
            return RubyBigDecimal.getNaN(runtime2);
        }
        if (val.isInfinite()) {
            return RubyBigDecimal.getInfinity(runtime2, val.getDoubleValue() == Double.POSITIVE_INFINITY ? 1 : -1);
        }
        if (val.isZero()) {
            return RubyBigDecimal.getZero(runtime2, Double.doubleToLongBits(val.getDoubleValue()) == NEGATIVE_ZERO_LONG_BITS ? -1 : 1);
        }
        return null;
    }

    private static RubyBigDecimal newInstance(Ruby runtime2, IRubyObject recv, RubyBignum arg2, MathContext mathContext) {
        BigInteger value2 = arg2.getBigIntegerValue();
        if (value2.equals(BigInteger.ZERO)) {
            return RubyBigDecimal.getZero(runtime2, 1);
        }
        return new RubyBigDecimal(runtime2, (RubyClass)recv, new BigDecimal(value2, mathContext));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IRubyObject newInstance(ThreadContext context, RubyClass recv, RubyString arg2, MathContext mathContext, boolean strict, boolean exception2) {
        BigDecimal decimal;
        char[] str = arg2.decodeString().toCharArray();
        int s2 = 0;
        int e = str.length - 1;
        if (e == 0) {
            switch (str[0]) {
                case '0': {
                    return RubyBigDecimal.getZero(context.runtime, 1);
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return new RubyBigDecimal(context.runtime, recv, BigDecimal.valueOf(str[0] - 48));
                }
            }
        }
        while (s2 <= e && str[s2] <= ' ') {
            ++s2;
        }
        while (s2 <= e && str[e] <= ' ') {
            --e;
        }
        int sign2 = 1;
        switch (s2 <= e ? str[s2] : 32) {
            case 95: {
                if (strict) throw RubyBigDecimal.invalidArgumentError(context, arg2);
                return context.nil;
            }
            case 78: {
                if (!RubyBigDecimal.contentEquals("NaN", str, s2, e)) break;
                return RubyBigDecimal.getNaN(context.runtime);
            }
            case 73: {
                if (!RubyBigDecimal.contentEquals("Infinity", str, s2, e)) break;
                return RubyBigDecimal.getInfinity(context.runtime, 1);
            }
            case 45: {
                if (RubyBigDecimal.contentEquals("-Infinity", str, s2, e)) {
                    return RubyBigDecimal.getInfinity(context.runtime, -1);
                }
                sign2 = -1;
                break;
            }
            case 43: {
                if (!RubyBigDecimal.contentEquals("+Infinity", str, s2, e)) break;
                return RubyBigDecimal.getInfinity(context.runtime, 1);
            }
        }
        int i2 = s2;
        int off = 0;
        boolean dD = false;
        int exp2 = -1;
        int lastSign = -1;
        boolean dotFound = false;
        block24: while (i2 + off <= e) {
            switch (str[i2 + off]) {
                case 'D': 
                case 'd': {
                    if (dD) {
                        e = i2 - 1;
                        continue block24;
                    }
                    str[i2] = 69;
                    dD = true;
                    if (exp2 != -1) {
                        e = i2 - 1;
                        continue block24;
                    }
                    exp2 = i2++;
                    continue block24;
                }
                case '_': {
                    if (i2 + off == e || Character.isDigit(str[i2 + off + 1])) {
                        str[i2] = str[i2 + off];
                        ++off;
                        continue block24;
                    }
                    if (strict) throw RubyBigDecimal.invalidArgumentError(context, arg2);
                    e = i2 + off - 1;
                    break block24;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    if (dotFound) {
                        e = i2 + off - 1;
                        break block24;
                    }
                    dotFound = true;
                    if (i2 + off + 1 > e || Character.isDigit(str[i2 + off + 1])) break;
                    e = i2 + off - 1;
                    break block24;
                }
                case '+': 
                case '-': {
                    lastSign = i2;
                    break;
                }
                case 'E': 
                case 'e': {
                    char c;
                    if (exp2 != -1) {
                        e = i2 - 1;
                        continue block24;
                    }
                    exp2 = i2;
                    if (i2 + off + 1 > e || (c = str[i2 + off + 1]) == '-' || c == '+' || Character.isDigit(c)) break;
                    e = i2 + off - 1;
                    break block24;
                }
                default: {
                    e = i2 - 1;
                    continue block24;
                }
            }
            str[i2] = str[i2 + off];
            ++i2;
        }
        if ((i2 = e + 1) < str.length) {
            while (i2 < str.length && Character.isWhitespace(str[i2++])) {
            }
            if (i2 < str.length && strict) {
                throw RubyBigDecimal.invalidArgumentError(context, arg2);
            }
        }
        e -= off;
        if (exp2 != -1) {
            if (exp2 == e || exp2 + 1 == e && (str[exp2 + 1] == '-' || str[exp2 + 1] == '+')) {
                if (strict) throw RubyBigDecimal.invalidArgumentError(context, arg2);
                if (exp2 == e) {
                    --e;
                }
                if (exp2 + 1 == e) {
                    e -= 2;
                }
            } else if (RubyBigDecimal.isExponentOutOfRange(str, exp2 + 1, e)) {
                if (!RubyBigDecimal.isZeroBase(str, s2, exp2) && str[exp2 + 1] != '-') return RubyBigDecimal.getInfinity(context.runtime, sign2);
                return RubyBigDecimal.getZero(context.runtime, sign2);
            }
        } else if (lastSign > s2) {
            e = lastSign - 1;
        }
        try {
            decimal = new BigDecimal(str, s2, e - s2 + 1, mathContext);
        }
        catch (ArithmeticException ex) {
            return RubyBigDecimal.checkOverUnderFlow(context.runtime, ex, false, strict, exception2);
        }
        catch (NumberFormatException ex) {
            return RubyBigDecimal.handleInvalidArgument(context, arg2, strict, exception2);
        }
        if (decimal.signum() != 0) return new RubyBigDecimal(context.runtime, recv, decimal);
        return RubyBigDecimal.getZero(context.runtime, sign2);
    }

    private static IRubyObject handleInvalidArgument(ThreadContext context, RubyString arg2, boolean strict, boolean exception2) {
        if (!strict) {
            return RubyBigDecimal.getZero(context.runtime, 1);
        }
        if (!exception2) {
            return context.nil;
        }
        throw RubyBigDecimal.invalidArgumentError(context, arg2);
    }

    private static RaiseException invalidArgumentError(ThreadContext context, RubyString arg2) {
        return context.runtime.newArgumentError("invalid value for BigDecimal(): \"" + arg2 + "\"");
    }

    private static boolean contentEquals(String str1, char[] str2, int s2, int e2) {
        int len = str1.length();
        if (len == e2 - s2 + 1) {
            for (int i2 = 0; i2 < len; ++i2) {
                if (str1.charAt(i2) == str2[s2 + i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isZeroBase(char[] str, int off, int end2) {
        for (int i2 = off; i2 < end2; ++i2) {
            if (str[i2] == '0') continue;
            return false;
        }
        return true;
    }

    private static boolean isExponentOutOfRange(char[] str, int off, int end2) {
        int num = 0;
        int sign2 = 1;
        char ch0 = str[off];
        if (ch0 == '-') {
            sign2 = -1;
        } else if (ch0 != '+') {
            num = 48 - ch0;
        }
        int i2 = off + 1;
        int max2 = sign2 == 1 ? -2147483647 : -2147483647;
        int multmax = max2 / 10;
        while (i2 <= end2) {
            int d = str[i2++] - 48;
            if (num < multmax) {
                return true;
            }
            if ((num *= 10) < max2 + d) {
                return true;
            }
            num -= d;
        }
        return false;
    }

    @Deprecated
    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject new_(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "BigDecimal.new is deprecated; use BigDecimal() method instead.");
        return BigDecimalKernelMethods.newBigDecimal(context, recv, arg2);
    }

    @Deprecated
    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject new_(ThreadContext context, IRubyObject recv, IRubyObject arg2, IRubyObject mathArg) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "BigDecimal.new is deprecated; use BigDecimal() method instead.");
        return BigDecimalKernelMethods.newBigDecimal(context, recv, arg2, mathArg);
    }

    @Deprecated
    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject new_(ThreadContext context, IRubyObject recv, IRubyObject arg2, IRubyObject mathArg, IRubyObject opts) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "BigDecimal.new is deprecated; use BigDecimal() method instead.");
        return BigDecimalKernelMethods.newBigDecimal(context, recv, arg2, mathArg, opts);
    }

    private static IRubyObject handleMissingPrecision(ThreadContext context, String name2, boolean strict, boolean exception2) {
        if (!strict) {
            return RubyBigDecimal.getZero(context.runtime, 1);
        }
        if (!exception2) {
            return context.nil;
        }
        throw context.runtime.newArgumentError("can't omit precision for a " + name2 + ".");
    }

    @Deprecated
    public static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
        return (RubyBigDecimal)RubyBigDecimal.newInstance(context, recv, arg2, true, true);
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv, IRubyObject arg2, boolean strict, boolean exception2) {
        switch (((RubyBasicObject)arg2).getNativeClassIndex()) {
            case RATIONAL: {
                return RubyBigDecimal.handleMissingPrecision(context, "Rational", strict, exception2);
            }
            case FLOAT: {
                RubyBigDecimal res = RubyBigDecimal.newFloatSpecialCases(context.runtime, (RubyFloat)arg2);
                if (res != null) {
                    return res;
                }
                return RubyBigDecimal.handleMissingPrecision(context, "Float", strict, exception2);
            }
            case FIXNUM: {
                return RubyBigDecimal.newInstance(context.runtime, recv, (RubyFixnum)arg2, MathContext.UNLIMITED);
            }
            case BIGNUM: {
                return RubyBigDecimal.newInstance(context.runtime, recv, (RubyBignum)arg2, MathContext.UNLIMITED);
            }
            case BIGDECIMAL: {
                return arg2;
            }
            case COMPLEX: {
                RubyComplex c = (RubyComplex)arg2;
                if (((RubyNumeric)c.image()).isZero()) break;
                throw context.runtime.newArgumentError("Unable to make a BigDecimal from non-zero imaginary number");
            }
        }
        IRubyObject maybeString = arg2.checkStringType();
        if (maybeString.isNil()) {
            if (!strict) {
                return RubyBigDecimal.getZero(context.runtime, 1);
            }
            if (!exception2) {
                return context.nil;
            }
            throw context.runtime.newTypeError("no implicit conversion of " + arg2.inspect() + "into to String");
        }
        return RubyBigDecimal.newInstance(context, (RubyClass)recv, maybeString.convertToString(), MathContext.UNLIMITED, strict, exception2);
    }

    public static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv, IRubyObject arg2, IRubyObject mathArg) {
        return (RubyBigDecimal)RubyBigDecimal.newInstance(context, recv, arg2, mathArg, true, true);
    }

    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv, IRubyObject arg2, IRubyObject mathArg, boolean strict, boolean exception2) {
        if (arg2.isNil() || arg2 instanceof RubyBoolean) {
            if (!exception2) {
                return context.nil;
            }
            throw context.runtime.newTypeError("can't convert " + arg2.inspect() + " into BigDecimal");
        }
        int digits2 = (int)mathArg.convertToInteger().getLongValue();
        if (digits2 < 0) {
            if (!strict) {
                return RubyBigDecimal.getZero(context.runtime, 1);
            }
            if (!exception2) {
                return context.nil;
            }
            throw context.runtime.newArgumentError("argument must be positive");
        }
        MathContext mathContext = new MathContext(digits2, RubyBigDecimal.getRoundingMode(context.runtime));
        switch (((RubyBasicObject)arg2).getNativeClassIndex()) {
            case RATIONAL: {
                if (digits2 == Integer.MAX_VALUE) {
                    return RubyBigDecimal.handleMissingPrecision(context, "Rational", strict, exception2);
                }
                return RubyBigDecimal.newInstance(context.runtime, recv, (RubyRational)arg2, mathContext);
            }
            case FLOAT: {
                RubyBigDecimal res = RubyBigDecimal.newFloatSpecialCases(context.runtime, (RubyFloat)arg2);
                if (res != null) {
                    return res;
                }
                if (digits2 == Integer.MAX_VALUE) {
                    return RubyBigDecimal.handleMissingPrecision(context, "Float", strict, exception2);
                }
                return RubyBigDecimal.newInstance(context.runtime, recv, (RubyFloat)arg2, mathContext);
            }
            case FIXNUM: {
                return RubyBigDecimal.newInstance(context.runtime, recv, (RubyFixnum)arg2, mathContext);
            }
            case BIGNUM: {
                return RubyBigDecimal.newInstance(context.runtime, recv, (RubyBignum)arg2, mathContext);
            }
            case BIGDECIMAL: {
                if (digits2 == Integer.MAX_VALUE) {
                    return arg2;
                }
                return RubyBigDecimal.newInstance(context.runtime, recv, (RubyBigDecimal)arg2);
            }
            case COMPLEX: {
                RubyComplex c = (RubyComplex)arg2;
                if (!((RubyNumeric)c.image()).isZero()) {
                    throw context.runtime.newArgumentError("Unable to make a BigDecimal from non-zero imaginary number");
                }
                return RubyBigDecimal.newInstance(context, recv, c.real(), mathArg, strict, exception2);
            }
        }
        IRubyObject maybeString = arg2.checkStringType();
        if (maybeString.isNil()) {
            if (!exception2) {
                return context.nil;
            }
            throw context.runtime.newTypeError("can't convert " + arg2.getMetaClass() + " into BigDecimal");
        }
        return RubyBigDecimal.newInstance(context, (RubyClass)recv, (RubyString)maybeString, MathContext.UNLIMITED, strict, exception2);
    }

    private static RubyBigDecimal getZero(Ruby runtime2, int sign2) {
        String constantName = sign2 < 0 ? "NEGATIVE_ZERO" : "POSITIVE_ZERO";
        return (RubyBigDecimal)runtime2.getClass("BigDecimal").getConstant(constantName);
    }

    private static RubyBigDecimal getNaN(Ruby runtime2) {
        if (RubyBigDecimal.isNaNExceptionMode(runtime2)) {
            throw RubyBigDecimal.newNaNFloatDomainError(runtime2);
        }
        return (RubyBigDecimal)runtime2.getClass("BigDecimal").getConstant("NAN");
    }

    private static RaiseException newNaNFloatDomainError(Ruby runtime2) {
        return runtime2.newFloatDomainError("Computation results to 'NaN'(Not a Number)");
    }

    private static RubyBigDecimal getInfinity(Ruby runtime2, int sign2) {
        return RubyBigDecimal.getInfinity(runtime2, sign2, InfinityErrorMsgType.To);
    }

    private static RubyBigDecimal getInfinity(Ruby runtime2, int sign2, InfinityErrorMsgType type2) {
        if (RubyBigDecimal.isInfinityExceptionMode(runtime2)) {
            throw RubyBigDecimal.newInfinityFloatDomainError(runtime2, sign2, type2);
        }
        String constantName = sign2 < 0 ? "NEGATIVE_INFINITY" : "INFINITY";
        return (RubyBigDecimal)runtime2.getClass("BigDecimal").getConstant(constantName);
    }

    private static RaiseException newInfinityFloatDomainError(Ruby runtime2, int sign2) {
        return RubyBigDecimal.newInfinityFloatDomainError(runtime2, sign2, InfinityErrorMsgType.To);
    }

    private static RaiseException newInfinityFloatDomainError(Ruby runtime2, int sign2, InfinityErrorMsgType type2) {
        if (type2 == InfinityErrorMsgType.To) {
            return runtime2.newFloatDomainError("Computation results to " + (sign2 < 0 ? "'-Infinity'" : "'Infinity'"));
        }
        return runtime2.newFloatDomainError("Computation results in " + (sign2 < 0 ? "'-Infinity'" : "'Infinity'"));
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int prec) {
        if (prec == 0) {
            prec = RubyBigDecimal.getPrecLimit(this.getRuntime());
        }
        if (prec > 0) {
            int exponent2 = this.getExponent();
            if (this.value.scale() > prec - exponent2) {
                this.value = this.value.setScale(prec - exponent2, RoundingMode.HALF_UP);
                this.absStripTrailingZeros = null;
            }
        }
        return this;
    }

    private BigDecimal absStripTrailingZeros() {
        BigDecimal absStripTrailingZeros = this.absStripTrailingZeros;
        if (absStripTrailingZeros == null) {
            this.absStripTrailingZeros = this.value.abs().stripTrailingZeros();
            return this.absStripTrailingZeros;
        }
        return absStripTrailingZeros;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.absStripTrailingZeros().hashCode() * this.value.signum());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (!(original instanceof RubyBigDecimal)) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyBigDecimal orig = (RubyBigDecimal)original;
        this.isNaN = orig.isNaN;
        this.infinitySign = orig.infinitySign;
        this.zeroSign = orig.zeroSign;
        this.value = orig.value;
        return this;
    }

    @JRubyMethod(name={"%", "modulo"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = this.getVpValueWithPrec(context, other, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_mod, other, true);
        }
        if (this.isNaN() || val.isNaN() || this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (val.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (val.isInfinity()) {
            return this;
        }
        if (this.isZero()) {
            return RubyBigDecimal.getZero(context.runtime, this.value.signum());
        }
        BigDecimal modulo2 = this.value.remainder(val.value);
        if (modulo2.signum() * val.value.signum() < 0) {
            modulo2 = modulo2.add(val.value);
        }
        return new RubyBigDecimal(context.runtime, modulo2).setResult();
    }

    @Deprecated
    public IRubyObject op_mod19(ThreadContext context, IRubyObject arg2) {
        return this.op_mod(context, arg2);
    }

    @Override
    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject arg2) {
        return this.remainderInternal(context, this.getVpValueWithPrec(context, arg2, false), arg2);
    }

    @Deprecated
    public IRubyObject remainder19(ThreadContext context, IRubyObject arg2) {
        return this.remainder(context, arg2);
    }

    private IRubyObject remainderInternal(ThreadContext context, RubyBigDecimal val, IRubyObject arg2) {
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).remainder, arg2, true);
        }
        if (val.isInfinity()) {
            return this;
        }
        if (val.isNaN() || val.isZero()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        return new RubyBigDecimal(context.runtime, this.value.remainder(val.value)).setResult();
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject arg2) {
        RubyBigDecimal val = this.getVpValueWithPrec(context, arg2, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_times, arg2, true);
        }
        return this.multImpl(context.runtime, val);
    }

    @Deprecated
    public IRubyObject op_mul19(ThreadContext context, IRubyObject arg2) {
        return this.op_mul(context, arg2);
    }

    @JRubyMethod(name={"mult"})
    public IRubyObject mult2(ThreadContext context, IRubyObject b2, IRubyObject n) {
        int mx = RubyBigDecimal.getPrecisionInt(context.runtime, n);
        if (mx == 0) {
            return this.op_mul(context, b2);
        }
        RubyBigDecimal val = this.getVpValueWithPrec(context, b2, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_times, b2, true);
        }
        return this.multImpl(context.runtime, val).setResult(mx);
    }

    private RubyBigDecimal multImpl(Ruby runtime2, RubyBigDecimal val) {
        BigDecimal result2;
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.getNaN(runtime2);
        }
        if (this.isZero() || val.isZero()) {
            if (this.isInfinity() && val.isZero() || this.isZero() && val.isInfinity()) {
                return RubyBigDecimal.getNaN(runtime2);
            }
            int sign1 = this.isZero() ? this.zeroSign : this.value.signum();
            int sign2 = val.isZero() ? val.zeroSign : val.value.signum();
            return RubyBigDecimal.getZero(runtime2, sign1 * sign2);
        }
        if (this.isInfinity() || val.isInfinity()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            int sign2 = val.isInfinity() ? val.infinitySign : val.value.signum();
            return RubyBigDecimal.getInfinity(runtime2, sign1 * sign2);
        }
        int mx = this.value.precision() + val.value.precision();
        MathContext mathContext = new MathContext(mx, RubyBigDecimal.getRoundingMode(runtime2));
        try {
            result2 = this.value.multiply(val.value, mathContext);
        }
        catch (ArithmeticException ex) {
            return (RubyBigDecimal)RubyBigDecimal.checkOverUnderFlow(runtime2, ex, false, true, true);
        }
        return new RubyBigDecimal(runtime2, result2).setResult();
    }

    private static IRubyObject checkOverUnderFlow(Ruby runtime2, ArithmeticException ex, boolean nullDefault, boolean strict, boolean exception2) {
        String message2 = ex.getMessage();
        if (message2 == null) {
            message2 = "";
        }
        if ((message2 = message2.toLowerCase(Locale.ENGLISH)).contains("underflow")) {
            if (RubyBigDecimal.isUnderflowExceptionMode(runtime2)) {
                return RubyBigDecimal.handleFloatDomainError(runtime2, message2, strict, exception2);
            }
            return RubyBigDecimal.getZero(runtime2, 1);
        }
        if (message2.contains("overflow")) {
            if (RubyBigDecimal.isOverflowExceptionMode(runtime2)) {
                return RubyBigDecimal.handleFloatDomainError(runtime2, message2, strict, exception2);
            }
            return RubyBigDecimal.getInfinity(runtime2, 1);
        }
        if (nullDefault) {
            return null;
        }
        return RubyBigDecimal.handleFloatDomainError(runtime2, message2, strict, exception2);
    }

    private static IRubyObject handleFloatDomainError(Ruby runtime2, String message2, boolean strict, boolean exception2) {
        if (!strict) {
            return RubyBigDecimal.getZero(runtime2, 1);
        }
        if (!exception2) {
            return runtime2.getNil();
        }
        throw runtime2.newFloatDomainError(message2);
    }

    @Deprecated
    public IRubyObject mult219(ThreadContext context, IRubyObject b2, IRubyObject n) {
        return this.mult2(context, b2, n);
    }

    private RubyBigDecimal newPowOfInfinity(ThreadContext context, RubyNumeric exp2) {
        if (Numeric.f_negative_p(context, exp2)) {
            if (this.infinitySign >= 0) {
                return RubyBigDecimal.getZero(context.runtime, 0);
            }
            if (Numeric.f_integer_p(context, exp2)) {
                return RubyBigDecimal.getZero(context.runtime, RubyBigDecimal.isEven(exp2) ? 1 : -1);
            }
            return RubyBigDecimal.getZero(context.runtime, -1);
        }
        if (this.infinitySign >= 0) {
            return RubyBigDecimal.getInfinity(context.runtime, 1);
        }
        if (Numeric.f_integer_p(context, exp2)) {
            return RubyBigDecimal.getInfinity(context.runtime, RubyBigDecimal.isEven(exp2) ? 1 : -1);
        }
        throw context.runtime.newMathDomainError("a non-integral exponent for a negative base");
    }

    private RubyBigDecimal newPowOfZero(ThreadContext context, RubyNumeric exp2) {
        if (Numeric.f_negative_p(context, exp2)) {
            if (this.zeroSign >= 0) {
                return RubyBigDecimal.getInfinity(context.runtime, 1);
            }
            if (Numeric.f_integer_p(context, exp2)) {
                return RubyBigDecimal.getInfinity(context.runtime, RubyBigDecimal.isEven(exp2) ? 1 : -1);
            }
            return RubyBigDecimal.getInfinity(context.runtime, -1);
        }
        if (Numeric.f_zero_p(context, exp2)) {
            return new RubyBigDecimal(context.runtime, BigDecimal.ONE);
        }
        return RubyBigDecimal.getZero(context.runtime, 1);
    }

    private static IRubyObject vpPrecLimit(Ruby runtime2) {
        return runtime2.getClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit");
    }

    private static int getPrecLimit(Ruby runtime2) {
        return RubyNumeric.fix2int(RubyBigDecimal.vpPrecLimit(runtime2));
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_pow(ThreadContext context, IRubyObject exp2) {
        return this.op_power(context, exp2, context.nil);
    }

    @JRubyMethod(name={"power"})
    public IRubyObject op_power(ThreadContext context, IRubyObject exp2) {
        return this.op_power(context, exp2, context.nil);
    }

    @JRubyMethod(name={"power"})
    public IRubyObject op_power(ThreadContext context, IRubyObject exp2, IRubyObject prec) {
        BigDecimal pow2;
        double rem;
        int times2;
        int nx;
        Ruby runtime2 = context.runtime;
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(runtime2);
        }
        if (!(exp2 instanceof RubyNumeric)) {
            throw context.runtime.newTypeError("wrong argument type " + exp2.getMetaClass() + " (expected scalar Numeric)");
        }
        if (!(exp2 instanceof RubyFixnum) && !(exp2 instanceof RubyBignum)) {
            RubyNumeric zero;
            IRubyObject rounded;
            if (exp2 instanceof RubyFloat) {
                double d = RubyNumeric.num2dbl(context, exp2);
                if (d == (double)Math.round(d)) {
                    exp2 = RubyNumeric.fixable(runtime2, d) ? RubyFixnum.newFixnum(runtime2, (long)d) : RubyBignum.newBignorm(runtime2, d);
                }
            } else if (exp2 instanceof RubyRational) {
                if (!Numeric.f_zero_p(context, Numeric.f_numerator(context, exp2)) && Numeric.f_one_p(context, Numeric.f_denominator(context, exp2))) {
                    exp2 = Numeric.f_numerator(context, exp2);
                }
            } else if (exp2 instanceof RubyBigDecimal && ((RubyBigDecimal)exp2).eql_p(context, rounded = ((RubyBigDecimal)exp2).round(context, new IRubyObject[]{zero = RubyNumeric.int2fix(runtime2, 0L)})).isTrue()) {
                exp2 = ((RubyBigDecimal)exp2).to_int();
            }
        }
        if (this.isZero()) {
            return this.newPowOfZero(context, (RubyNumeric)exp2);
        }
        if (Numeric.f_zero_p(context, exp2)) {
            return new RubyBigDecimal(context.runtime, BigDecimal.ONE);
        }
        if (this.isInfinity()) {
            return this.newPowOfInfinity(context, (RubyNumeric)exp2);
        }
        int n = nx = prec.isNil() ? this.getPrec() * 9 : RubyBigDecimal.num2int(prec);
        if (exp2 instanceof RubyBigDecimal) {
            RubyBigDecimal bdExp = (RubyBigDecimal)exp2;
            int ny = bdExp.getPrec() * 9;
            return this.bigdecimal_power_by_bigdecimal(context, exp2, prec.isNil() ? nx + ny : nx);
        }
        if (exp2 instanceof RubyFloat) {
            int ny = 16;
            return this.bigdecimal_power_by_bigdecimal(context, exp2, prec.isNil() ? nx + ny : nx);
        }
        if (exp2 instanceof RubyRational) {
            int ny = nx;
            return this.bigdecimal_power_by_bigdecimal(context, exp2, prec.isNil() ? nx + ny : nx);
        }
        if (exp2 instanceof RubyBignum) {
            BigDecimal absValue = this.value.abs();
            if (absValue.equals(BigDecimal.ONE)) {
                return new RubyBigDecimal(runtime2, BigDecimal.ONE, 0, 1);
            }
            if (absValue.compareTo(BigDecimal.ONE) == -1) {
                if (Numeric.f_negative_p(context, exp2)) {
                    return RubyBigDecimal.getInfinity(runtime2, (RubyBigDecimal.isEven((RubyBignum)exp2) ? 1 : -1) * this.value.signum());
                }
                if (Numeric.f_negative_p(context, this) && RubyBigDecimal.isEven((RubyBignum)exp2)) {
                    return RubyBigDecimal.getZero(runtime2, -1);
                }
                return RubyBigDecimal.getZero(runtime2, 1);
            }
            if (!Numeric.f_negative_p(context, exp2)) {
                return RubyBigDecimal.getInfinity(runtime2, (RubyBigDecimal.isEven((RubyBignum)exp2) ? 1 : -1) * this.value.signum());
            }
            if (this.value.signum() == -1 && RubyBigDecimal.isEven((RubyBignum)exp2)) {
                return RubyBigDecimal.getZero(runtime2, -1);
            }
            return RubyBigDecimal.getZero(runtime2, 1);
        }
        if (!(exp2 instanceof RubyInteger)) {
            BigDecimal expVal = BigDecimal.valueOf(((RubyNumeric)exp2).getDoubleValue());
            BigDecimal[] divAndRem = expVal.divideAndRemainder(BigDecimal.ONE);
            times2 = divAndRem[0].intValueExact();
            rem = divAndRem[1].doubleValue();
        } else {
            times2 = RubyNumeric.fix2int(exp2);
            rem = 0.0;
        }
        if (times2 < 0) {
            if (this.isZero()) {
                return RubyBigDecimal.getInfinity(context.runtime, this.value.signum());
            }
            pow2 = this.powNegative(times2);
        } else {
            pow2 = this.value.pow(times2);
        }
        if (rem > 0.0) {
            double remPow = Math.pow(this.value.doubleValue(), rem);
            pow2 = pow2.multiply(BigDecimal.valueOf(remPow));
        }
        if (!prec.isNil()) {
            pow2 = pow2.setScale(nx, RubyBigDecimal.getRoundingMode(context.runtime));
        }
        return new RubyBigDecimal(runtime2, pow2);
    }

    private IRubyObject bigdecimal_power_by_bigdecimal(ThreadContext context, IRubyObject exp2, int precision2) {
        RubyModule bigMath = context.getRuntime().getModule("BigMath");
        RubyBigDecimal log_x = (RubyBigDecimal)bigMath.callMethod(context, "log", new IRubyObject[]{this, RubyFixnum.newFixnum(context.getRuntime(), precision2 + 1)});
        RubyBigDecimal multipled = (RubyBigDecimal)log_x.mult2(context, exp2, RubyFixnum.newFixnum(context.getRuntime(), precision2 + 1));
        return bigMath.callMethod(context, "exp", new IRubyObject[]{multipled, RubyFixnum.newFixnum(context.getRuntime(), precision2)});
    }

    private BigDecimal powNegative(int times2) {
        int mp = this.getPrec() * 10 * (-times2 + 1);
        int precision2 = (mp + 8) / 9 * 9;
        BigDecimal pow2 = this.value.pow(times2, new MathContext(precision2 * 2, RoundingMode.DOWN));
        BigDecimal tmp = pow2.abs().stripTrailingZeros();
        int exponent2 = tmp.precision() - tmp.scale();
        precision2 = exponent2 < 0 ? (precision2 += Math.abs(exponent2) / 9 * 9) : (precision2 -= (exponent2 + 8) / 9 * 9);
        pow2 = pow2.setScale(precision2, RoundingMode.DOWN);
        return pow2;
    }

    @Override
    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject b2) {
        return this.addInternal(context, this.getVpValueWithPrec(context, b2, false), b2, RubyBigDecimal.vpPrecLimit(context.runtime));
    }

    @Deprecated
    public IRubyObject op_plus19(ThreadContext context, IRubyObject b2) {
        return this.op_plus(context, b2);
    }

    @JRubyMethod(name={"add"})
    public IRubyObject add2(ThreadContext context, IRubyObject b2, IRubyObject digits2) {
        return this.addInternal(context, this.getVpValueWithPrec(context, b2, false), b2, digits2);
    }

    @Deprecated
    public IRubyObject add219(ThreadContext context, IRubyObject b2, IRubyObject digits2) {
        return this.add2(context, b2, digits2);
    }

    private IRubyObject addInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b2, IRubyObject digits2) {
        Ruby runtime2 = context.runtime;
        int prec = RubyBigDecimal.getPositiveInt(context, digits2);
        if (val == null) {
            RubyBigDecimal ret = (RubyBigDecimal)this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_plus, b2, true);
            if (ret != null) {
                ret.setResult(prec);
            }
            return ret;
        }
        RubyBigDecimal res = this.addSpecialCases(context, val);
        if (res != null) {
            return res;
        }
        MathContext mathContext = new MathContext(prec, RubyBigDecimal.getRoundingMode(runtime2));
        return new RubyBigDecimal(runtime2, this.value.add(val.value, mathContext)).setResult(prec);
    }

    private static int getPositiveInt(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyFixnum) {
            int value2 = RubyNumeric.fix2int(arg2);
            if (value2 < 0) {
                throw context.runtime.newArgumentError("argument must be positive");
            }
            return value2;
        }
        throw context.runtime.newTypeError(arg2, context.runtime.getFixnum());
    }

    private RubyBigDecimal addSpecialCases(ThreadContext context, RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (this.isZero()) {
            if (val.isZero()) {
                return RubyBigDecimal.getZero(context.runtime, this.zeroSign == val.zeroSign ? this.zeroSign : 1);
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.getInfinity(context.runtime, val.infinitySign);
            }
            return new RubyBigDecimal(context.runtime, val.value);
        }
        int sign2 = this.infinitySign * val.infinitySign;
        if (sign2 > 0) {
            return RubyBigDecimal.getInfinity(context.runtime, this.infinitySign);
        }
        if (sign2 < 0) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (sign2 == 0 && (sign2 = this.infinitySign + val.infinitySign) != 0) {
            return RubyBigDecimal.getInfinity(context.runtime, sign2);
        }
        return null;
    }

    @Override
    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @Override
    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getInfinity(context.runtime, -this.infinitySign);
        }
        if (this.isZero()) {
            return RubyBigDecimal.getZero(context.runtime, -this.zeroSign);
        }
        return new RubyBigDecimal(context.runtime, this.value.negate());
    }

    @Override
    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject b2) {
        return this.subInternal(context, this.getVpValueWithPrec(context, b2, false), b2, 0);
    }

    @Deprecated
    public IRubyObject op_minus19(ThreadContext context, IRubyObject b2) {
        return this.op_minus(context, b2);
    }

    @JRubyMethod(name={"sub"})
    public IRubyObject sub2(ThreadContext context, IRubyObject b2, IRubyObject n) {
        return this.subInternal(context, this.getVpValueWithPrec(context, b2, false), b2, RubyBigDecimal.getPositiveInt(context, n));
    }

    @Deprecated
    public IRubyObject sub219(ThreadContext context, IRubyObject b2, IRubyObject n) {
        return this.sub2(context, b2, n);
    }

    private IRubyObject subInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b2, int prec) {
        if (val == null) {
            return ((RubyBigDecimal)this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_minus, b2, true)).setResult(prec);
        }
        RubyBigDecimal res = this.subSpecialCases(context, val);
        return res != null ? res : new RubyBigDecimal(context.runtime, this.value.subtract(val.value)).setResult(prec);
    }

    private RubyBigDecimal subSpecialCases(ThreadContext context, RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (this.isZero()) {
            if (val.isZero()) {
                return RubyBigDecimal.getZero(context.runtime, this.zeroSign * val.zeroSign);
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.getInfinity(context.runtime, val.infinitySign * -1);
            }
            return new RubyBigDecimal(context.runtime, val.value.negate());
        }
        int sign2 = this.infinitySign * val.infinitySign;
        if (sign2 > 0) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (sign2 < 0) {
            return RubyBigDecimal.getInfinity(context.runtime, this.infinitySign);
        }
        if (sign2 == 0) {
            if (this.isInfinity()) {
                return this;
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.getInfinity(context.runtime, val.infinitySign * -1);
            }
            sign2 = this.infinitySign + val.infinitySign;
            if (sign2 != 0) {
                return RubyBigDecimal.getInfinity(context.runtime, sign2);
            }
        }
        return null;
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_divide(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = this.getVpValueWithPrec(context, other, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_quo, other, true);
        }
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        RubyBigDecimal div2 = this.divSpecialCases(context, val);
        if (div2 != null) {
            return div2;
        }
        return this.quoImpl(context, val);
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject op_quo(ThreadContext context, IRubyObject other) {
        return this.op_divide(context, other);
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject op_quo(ThreadContext context, IRubyObject object, IRubyObject digits2) {
        int n = RubyBigDecimal.num2int(digits2);
        if (n > 0) {
            return this.op_div(context, object, digits2);
        }
        return this.op_divide(context, object);
    }

    private RubyBigDecimal quoImpl(ThreadContext context, RubyBigDecimal that) {
        int limit2;
        int mxb;
        Ruby runtime2 = context.runtime;
        int mx = this.getPrecisionScale()[0];
        if (mx < (mxb = that.getPrecisionScale()[0])) {
            mx = mxb;
        }
        if (32 > (mx *= 2)) {
            mx = 32;
        }
        if ((limit2 = RubyBigDecimal.getPrecLimit(runtime2)) > 0 && limit2 < mx) {
            mx = limit2;
        }
        mx = (mx + 8) / 9 * 9;
        RoundingMode mode2 = RubyBigDecimal.getRoundingMode(runtime2);
        MathContext mathContext = new MathContext(mx * 2, mode2);
        BigDecimal ret = RubyBigDecimal.divide(this.value, that.value, mathContext).setScale(mx, mode2);
        return new RubyBigDecimal(context.runtime, ret).setResult(limit2);
    }

    private static BigDecimal divide(BigDecimal target2, BigDecimal divisor, MathContext mc) {
        long diffScale;
        assert (mc.getPrecision() != 0);
        long trailingZeros = (long)mc.getPrecision() + 1L + (long)divisor.precision() - (long)target2.precision();
        long newScale = diffScale = (long)target2.scale() - (long)divisor.scale();
        BigInteger[] quotAndRem = new BigInteger[]{target2.unscaledValue()};
        BigInteger divScaled = divisor.unscaledValue();
        if (trailingZeros > 0L) {
            quotAndRem[0] = quotAndRem[0].multiply(Multiplication.powerOf10(trailingZeros));
            newScale += trailingZeros;
        }
        quotAndRem = quotAndRem[0].divideAndRemainder(divScaled);
        BigInteger integerQuot = quotAndRem[0];
        if (quotAndRem[1].signum() != 0) {
            int compRem = RubyBigDecimal.shiftLeftOneBit(quotAndRem[1]).compareTo(divScaled);
            integerQuot = integerQuot.multiply(BigInteger.TEN).add(BigInteger.valueOf(quotAndRem[0].signum() * (5 + compRem)));
            ++newScale;
        }
        return new BigDecimal(integerQuot, RubyBigDecimal.safeLongToInt(newScale), mc);
    }

    private static BigInteger shiftLeftOneBit(BigInteger i2) {
        return i2.shiftLeft(1);
    }

    private static int safeLongToInt(long longValue) {
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Out of int range: " + longValue);
        }
        return (int)longValue;
    }

    private static RubyBigDecimal div2Impl(ThreadContext context, RubyNumeric a, RubyNumeric b2, int ix) {
        RubyBigDecimal thiz = RubyBigDecimal.getVpValue(context, a, true);
        RubyBigDecimal that = RubyBigDecimal.getVpValue(context, b2, true);
        if (thiz.isNaN() || that.isNaN()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        RubyBigDecimal div2 = thiz.divSpecialCases(context, that);
        if (div2 != null) {
            return div2;
        }
        int mx = thiz.value.precision() + that.value.precision() + 2;
        MathContext mathContext = new MathContext((mx * 2 + 2) * 9, RubyBigDecimal.getRoundingMode(context.runtime));
        return new RubyBigDecimal(context.runtime, thiz.value.divide(that.value, mathContext)).setResult(ix);
    }

    @Deprecated
    public IRubyObject op_quo19(ThreadContext context, IRubyObject other) {
        return this.op_quo(context, other);
    }

    @Deprecated
    public IRubyObject op_quo20(ThreadContext context, IRubyObject other) {
        return this.op_quo(context, other);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return this.op_div(context, other, context.nil);
    }

    private RubyInteger idiv(ThreadContext context, RubyRational val) {
        if (this.isNaN()) {
            throw RubyBigDecimal.newNaNFloatDomainError(context.runtime);
        }
        if (this.isInfinity()) {
            throw RubyBigDecimal.newInfinityFloatDomainError(context.runtime, this.infinitySign);
        }
        if (val.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        BigDecimal result2 = this.value.multiply(RubyBigDecimal.toBigDecimal(val.getDenominator())).divideToIntegralValue(RubyBigDecimal.toBigDecimal(val.getNumerator()));
        return RubyBigDecimal.toInteger(context.runtime, result2);
    }

    private static RubyInteger toInteger(Ruby runtime2, BigDecimal result2) {
        if (result2.compareTo(MAX_FIX) <= 0 && result2.compareTo(MIN_FIX) >= 0) {
            return RubyFixnum.newFixnum(runtime2, result2.longValue());
        }
        return RubyBignum.newBignum(runtime2, result2.toBigInteger());
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other, IRubyObject digits2) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(context, other, false);
        if (digits2.isNil()) {
            if (val == null) {
                return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).div, other, true);
            }
            if (this.isNaN() || val.isNaN()) {
                throw RubyBigDecimal.newNaNFloatDomainError(context.runtime);
            }
            if (this.isInfinity()) {
                if (val.isInfinity()) {
                    throw RubyBigDecimal.newNaNFloatDomainError(context.runtime);
                }
                throw RubyBigDecimal.newInfinityFloatDomainError(context.runtime, this.infinitySign);
            }
            if (val.isZero()) {
                throw context.runtime.newZeroDivisionError();
            }
            if (val.isInfinity()) {
                return RubyFixnum.zero(context.runtime);
            }
            return RubyBigDecimal.toInteger(context.runtime, this.value.divideToIntegralValue(val.value));
        }
        int scale2 = RubyNumeric.fix2int(digits2);
        if (scale2 == 0) {
            return this.op_divide(context, other);
        }
        val = RubyBigDecimal.getVpValue(context, other, true);
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        RubyBigDecimal div2 = this.divSpecialCases(context, val);
        if (div2 != null) {
            return div2;
        }
        MathContext mathContext = new MathContext(scale2, RubyBigDecimal.getRoundingMode(context.runtime));
        return new RubyBigDecimal(context.runtime, this.value.divide(val.value, mathContext)).setResult(scale2);
    }

    private RubyBigDecimal divSpecialCases(ThreadContext context, RubyBigDecimal val) {
        if (this.isInfinity()) {
            if (val.isInfinity()) {
                return RubyBigDecimal.getNaN(context.runtime);
            }
            return RubyBigDecimal.getInfinity(context.runtime, this.infinitySign * val.value.signum());
        }
        if (val.isInfinity()) {
            return RubyBigDecimal.getZero(context.runtime, this.value.signum() * val.infinitySign);
        }
        if (val.isZero()) {
            if (this.isZero()) {
                return RubyBigDecimal.getNaN(context.runtime);
            }
            if (RubyBigDecimal.isZeroDivideExceptionMode(context.runtime)) {
                throw context.runtime.newFloatDomainError("Divide by zero");
            }
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            return RubyBigDecimal.getInfinity(context.runtime, sign1 * val.zeroSign, InfinityErrorMsgType.In);
        }
        if (this.isZero()) {
            return RubyBigDecimal.getZero(context.runtime, this.zeroSign * val.value.signum());
        }
        return null;
    }

    @Deprecated
    public final IRubyObject op_div19(ThreadContext context, IRubyObject r) {
        return this.op_div(context, r);
    }

    @Deprecated
    public final IRubyObject op_div19(ThreadContext context, IRubyObject other, IRubyObject digits2) {
        return this.op_div(context, other, digits2);
    }

    private IRubyObject cmp(ThreadContext context, IRubyObject arg2, char op) {
        RubyBigDecimal rb = arg2 instanceof RubyRational ? this.getVpValueWithPrec(context, arg2, false) : RubyBigDecimal.getVpValue(context, arg2, false);
        if (rb == null) {
            String id2 = "!=";
            switch (op) {
                case '*': {
                    if (RubyBigDecimal.falsyEqlCheck(context, arg2)) {
                        return context.nil;
                    }
                    return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_cmp, arg2, false);
                }
                case '=': {
                    if (RubyBigDecimal.falsyEqlCheck(context, arg2)) {
                        return context.fals;
                    }
                    IRubyObject res = this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_eql, arg2, false);
                    return RubyBoolean.newBoolean(context, res != context.nil && res != context.fals);
                }
                case '!': {
                    if (!RubyBigDecimal.falsyEqlCheck(context, arg2)) break;
                    return context.tru;
                }
                case 'G': {
                    id2 = ">=";
                    break;
                }
                case 'L': {
                    id2 = "<=";
                    break;
                }
                case '<': {
                    id2 = "<";
                    break;
                }
                case '>': {
                    id2 = ">";
                }
            }
            IRubyObject cmp2 = this.callCoerced(context, id2, arg2);
            if (cmp2 == context.nil) {
                throw context.runtime.newArgumentError("comparison of BigDecimal with " + RubyBigDecimal.errMessageType(context, arg2) + " failed");
            }
            return cmp2;
        }
        if (this.isNaN() || rb.isNaN()) {
            return op == '*' ? context.nil : context.fals;
        }
        int e = this.infinitySign != 0 || rb.infinitySign != 0 ? this.infinitySign - rb.infinitySign : this.value.compareTo(rb.value);
        switch (op) {
            case '*': {
                return context.runtime.newFixnum(e);
            }
            case '=': {
                return RubyBoolean.newBoolean(context, e == 0);
            }
            case '!': {
                return RubyBoolean.newBoolean(context, e != 0);
            }
            case 'G': {
                return RubyBoolean.newBoolean(context, e >= 0);
            }
            case '>': {
                return RubyBoolean.newBoolean(context, e > 0);
            }
            case 'L': {
                return RubyBoolean.newBoolean(context, e <= 0);
            }
            case '<': {
                return RubyBoolean.newBoolean(context, e < 0);
            }
        }
        return context.nil;
    }

    private static boolean falsyEqlCheck(ThreadContext context, IRubyObject arg2) {
        return arg2 == context.nil || arg2 == context.fals || arg2 == context.tru;
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '*');
    }

    @Override
    @JRubyMethod(name={"eql?", "=="})
    public IRubyObject eql_p(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '=');
    }

    @Override
    @JRubyMethod(name={"==="})
    public IRubyObject op_eqq(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '=');
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '<');
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'L');
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '>');
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'G');
    }

    @JRubyMethod
    public IRubyObject abs() {
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getInfinity(this.getRuntime(), 1);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    @JRubyMethod
    public IRubyObject ceil(ThreadContext context, IRubyObject arg2) {
        this.checkFloatDomain();
        int n = RubyNumeric.fix2int(arg2);
        if (this.value.scale() <= n) {
            return this;
        }
        return new RubyBigDecimal(context.runtime, this.value.setScale(n, RoundingMode.CEILING));
    }

    @Override
    @JRubyMethod
    public IRubyObject ceil(ThreadContext context) {
        this.checkFloatDomain();
        BigInteger ceil2 = this.value.setScale(0, RoundingMode.CEILING).toBigInteger();
        if (ceil2.compareTo(BigInteger.valueOf(ceil2.intValue())) == 0) {
            return RubyInteger.int2fix(context.runtime, ceil2.intValue());
        }
        return RubyBignum.newBignum(context.runtime, ceil2);
    }

    @Override
    public IRubyObject coerce(IRubyObject other) {
        return this.coerce(this.getRuntime().getCurrentContext(), other);
    }

    @JRubyMethod
    public RubyArray coerce(ThreadContext context, IRubyObject other) {
        return context.runtime.newArray((IRubyObject)RubyBigDecimal.getVpValue(context, other, true), (IRubyObject)this);
    }

    @Override
    public double getDoubleValue() {
        return SafeDoubleParser.doubleValue(this.value);
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    @Override
    public int getIntValue() {
        return this.value.intValue();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.value.toBigInteger();
    }

    public BigDecimal getBigDecimalValue() {
        return this.value;
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyInteger value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyFloat value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyBignum value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    @Override
    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        RubyBigDecimal val = this.getVpValueWithPrec(context, other, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).divmod, other, true);
        }
        if (this.isNaN() || val.isNaN() || this.isInfinity() && val.isInfinity()) {
            return RubyArray.newArray(runtime2, RubyBigDecimal.getNaN(runtime2), RubyBigDecimal.getNaN(runtime2));
        }
        if (val.isZero()) {
            throw runtime2.newZeroDivisionError();
        }
        if (this.isInfinity()) {
            int sign2 = this.infinitySign == val.value.signum() ? 1 : -1;
            return RubyArray.newArray(runtime2, RubyBigDecimal.getInfinity(runtime2, sign2), RubyBigDecimal.getNaN(runtime2));
        }
        if (val.isInfinity()) {
            return RubyArray.newArray(runtime2, RubyBigDecimal.getZero(runtime2, val.value.signum()), this);
        }
        if (this.isZero()) {
            return RubyArray.newArray(runtime2, RubyBigDecimal.getZero(runtime2, this.value.signum()), RubyBigDecimal.getZero(runtime2, this.value.signum()));
        }
        BigDecimal[] divmod2 = this.value.divideAndRemainder(val.value);
        BigDecimal div2 = divmod2[0];
        BigDecimal mod = divmod2[1];
        if (mod.signum() * val.value.signum() < 0) {
            div2 = div2.subtract(BigDecimal.ONE);
            mod = mod.add(val.value);
        }
        return RubyArray.newArray(runtime2, new RubyBigDecimal(runtime2, div2), new RubyBigDecimal(runtime2, mod));
    }

    @JRubyMethod
    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.getExponent());
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        return this.getRuntime().newBoolean(!this.isNaN() && !this.isInfinity());
    }

    private RubyBigDecimal floorNaNInfinityCheck(ThreadContext context) {
        if (this.isNaN()) {
            throw RubyBigDecimal.newNaNFloatDomainError(context.runtime);
        }
        if (this.isInfinity()) {
            throw RubyBigDecimal.newInfinityFloatDomainError(context.runtime, this.infinitySign);
        }
        return null;
    }

    private RubyBigDecimal floorImpl(ThreadContext context, int n) {
        return this.value.scale() > n ? new RubyBigDecimal(context.runtime, this.value.setScale(n, RoundingMode.FLOOR)) : this;
    }

    @Override
    @JRubyMethod
    public IRubyObject floor(ThreadContext context) {
        RubyBigDecimal res = this.floorNaNInfinityCheck(context);
        if (res != null) {
            return res;
        }
        return this.floorImpl(context, 0).to_int(context.runtime);
    }

    @JRubyMethod
    public IRubyObject floor(ThreadContext context, IRubyObject arg2) {
        RubyBigDecimal res = this.floorNaNInfinityCheck(context);
        if (res != null) {
            return res;
        }
        return this.floorImpl(context, RubyNumeric.fix2int(arg2));
    }

    @JRubyMethod
    public IRubyObject frac(ThreadContext context) {
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(context.runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getInfinity(context.runtime, this.infinitySign);
        }
        if (this.value.scale() > 0 && this.value.precision() < this.value.scale()) {
            return new RubyBigDecimal(context.runtime, this.value);
        }
        return new RubyBigDecimal(context.runtime, this.value.subtract(((RubyBigDecimal)this.fix()).value));
    }

    @Override
    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p(ThreadContext context) {
        return this.infinitySign == 0 ? context.nil : context.runtime.newFixnum(this.infinitySign);
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return this.toStringImpl(context.runtime, null);
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isNaN());
    }

    @Override
    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero() ? context.nil : this;
    }

    @Deprecated
    public IRubyObject nonzero_p() {
        return this.isZero() ? this.getRuntime().getNil() : this;
    }

    @JRubyMethod
    public IRubyObject n_significant_digits(ThreadContext context) {
        if (this.value.equals(BigDecimal.ZERO)) {
            return RubyFixnum.zero(context.runtime);
        }
        return context.runtime.newFixnum(this.value.stripTrailingZeros().precision());
    }

    @JRubyMethod
    public IRubyObject precision(ThreadContext context) {
        return this.precision_scale(context).aref(context, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod
    public IRubyObject scale(ThreadContext context) {
        return this.precision_scale(context).aref(context, (IRubyObject)RubyFixnum.one(context.runtime));
    }

    @JRubyMethod
    public RubyArray precision_scale(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        int[] ary = this.getPrecisionScale();
        return runtime2.newArray((IRubyObject)runtime2.newFixnum(ary[0]), (IRubyObject)runtime2.newFixnum(ary[1]));
    }

    private int[] getPrecisionScale() {
        int precision2 = 0;
        int scale2 = 0;
        String plainString = this.value.toPlainString();
        if (!this.value.equals(BigDecimal.ZERO)) {
            if (plainString.indexOf(".") == -1) {
                precision2 = plainString.replace("-", "").length();
            } else {
                String[] params = plainString.split("\\.");
                if (new BigDecimal(params[1]).equals(BigDecimal.ZERO)) {
                    precision2 = params[0].replace("-", "").length();
                } else {
                    precision2 = this.value.precision() > this.value.scale() ? this.value.precision() : this.value.scale();
                    scale2 = this.value.scale();
                }
            }
        }
        return new int[]{precision2, scale2};
    }

    private int getPrec() {
        int[] precisionScale = this.getPrecisionScale();
        if (precisionScale[0] > precisionScale[1]) {
            return (precisionScale[0] + (9 - (precisionScale[0] - precisionScale[1])) + 8) / 9;
        }
        if (this.getExponent() > -9) {
            return (this.value.toString().length() - 2 + 8) / 9;
        }
        return (this.value.unscaledValue().toString().length() + 8) / 9;
    }

    @Deprecated
    @JRubyMethod
    public IRubyObject precs(ThreadContext context) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "BigDecimal#precs is deprecated and will be removed in the future; use BigDecimal#precision instead.");
        return RubyArray.newArray(context.runtime, context.runtime.newFixnum(this.getSignificantDigits().length()), context.runtime.newFixnum((this.getAllDigits().length() / 4 + 1) * 4));
    }

    @JRubyMethod(name={"round"}, optional=2, checkArity=false)
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        RubyBigDecimal bigDecimal;
        int argc = Arity.checkArgumentCount(context, args2, 0, 2);
        Ruby runtime2 = context.runtime;
        if (this.isNaN()) {
            if (argc == 0) {
                throw RubyBigDecimal.newNaNFloatDomainError(runtime2);
            }
            return RubyBigDecimal.getNaN(runtime2);
        }
        if (this.isInfinity()) {
            if (argc == 0) {
                throw RubyBigDecimal.newInfinityFloatDomainError(runtime2, this.infinitySign);
            }
            return RubyBigDecimal.getInfinity(runtime2, this.infinitySign);
        }
        RoundingMode mode2 = RubyBigDecimal.getRoundingMode(runtime2);
        int scale2 = 0;
        boolean roundToInt = false;
        switch (argc) {
            case 2: {
                mode2 = RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context, args2[1]);
                scale2 = RubyBigDecimal.num2int(args2[0]);
                break;
            }
            case 1: {
                if (ArgsUtil.getOptionsArg(runtime2, args2[0]) == context.nil) {
                    scale2 = RubyBigDecimal.num2int(args2[0]);
                    if (scale2 >= 1) break;
                    roundToInt = true;
                    break;
                }
                mode2 = RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context, args2[0]);
                break;
            }
            case 0: {
                roundToInt = true;
            }
        }
        if (scale2 < 0) {
            BigDecimal normalized = this.value.movePointRight(scale2);
            BigDecimal rounded = normalized.setScale(0, mode2);
            bigDecimal = new RubyBigDecimal(runtime2, rounded.movePointLeft(scale2));
        } else {
            bigDecimal = new RubyBigDecimal(runtime2, this.value.setScale(scale2, mode2));
        }
        return roundToInt ? bigDecimal.to_int(runtime2) : bigDecimal;
    }

    public IRubyObject round(ThreadContext context, IRubyObject scale2, IRubyObject mode2) {
        return this.round(context, new IRubyObject[]{scale2, mode2});
    }

    private static int rubyRoundingModeFromJavaRoundingMode(ThreadContext context, RoundingMode mode2) {
        if (mode2.equals((Object)RoundingMode.UP)) {
            return 1;
        }
        if (mode2.equals((Object)RoundingMode.DOWN)) {
            return 2;
        }
        if (mode2.equals((Object)RoundingMode.HALF_UP)) {
            return 3;
        }
        if (mode2.equals((Object)RoundingMode.HALF_DOWN)) {
            return 4;
        }
        if (mode2.equals((Object)RoundingMode.CEILING)) {
            return 5;
        }
        if (mode2.equals((Object)RoundingMode.FLOOR)) {
            return 6;
        }
        if (mode2.equals((Object)RoundingMode.HALF_EVEN)) {
            return 7;
        }
        throw context.runtime.newArgumentError("invalid rounding mode");
    }

    private static RoundingMode javaRoundingModeFromRubyRoundingMode(ThreadContext context, IRubyObject arg2) {
        if (arg2 == context.nil) {
            return RubyBigDecimal.getRoundingMode(context.runtime);
        }
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, arg2);
        if (opts != context.nil) {
            arg2 = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "half");
            if (arg2 == null || arg2 == context.nil) {
                return RubyBigDecimal.getRoundingMode(context.runtime);
            }
            String roundingMode = arg2 instanceof RubySymbol ? arg2.asJavaString() : arg2.toString();
            switch (roundingMode) {
                case "up": {
                    return RoundingMode.HALF_UP;
                }
                case "down": {
                    return RoundingMode.HALF_DOWN;
                }
                case "even": {
                    return RoundingMode.HALF_EVEN;
                }
            }
            throw context.runtime.newArgumentError("invalid rounding mode (" + roundingMode + ")");
        }
        if (arg2 instanceof RubySymbol) {
            String roundingMode;
            switch (roundingMode = arg2.asJavaString()) {
                case "up": {
                    return RoundingMode.UP;
                }
                case "down": 
                case "truncate": {
                    return RoundingMode.DOWN;
                }
                case "half_up": 
                case "default": {
                    return RoundingMode.HALF_UP;
                }
                case "half_down": {
                    return RoundingMode.HALF_DOWN;
                }
                case "half_even": 
                case "even": 
                case "banker": {
                    return RoundingMode.HALF_EVEN;
                }
                case "ceiling": 
                case "ceil": {
                    return RoundingMode.CEILING;
                }
                case "floor": {
                    return RoundingMode.FLOOR;
                }
            }
            throw context.runtime.newArgumentError("invalid rounding mode (" + roundingMode + ")");
        }
        int ordinal = RubyBigDecimal.num2int(arg2);
        switch (ordinal) {
            case 1: {
                return RoundingMode.UP;
            }
            case 2: {
                return RoundingMode.DOWN;
            }
            case 3: {
                return RoundingMode.HALF_UP;
            }
            case 4: {
                return RoundingMode.HALF_DOWN;
            }
            case 5: {
                return RoundingMode.CEILING;
            }
            case 6: {
                return RoundingMode.FLOOR;
            }
            case 7: {
                return RoundingMode.HALF_EVEN;
            }
        }
        throw context.runtime.newArgumentError("invalid rounding mode");
    }

    @JRubyMethod
    public IRubyObject sign() {
        if (this.isNaN()) {
            return this.getMetaClass().getConstant("SIGN_NaN");
        }
        if (this.isInfinity()) {
            return this.getMetaClass().getConstant(this.infinitySign < 0 ? "SIGN_NEGATIVE_INFINITE" : "SIGN_POSITIVE_INFINITE");
        }
        if (this.isZero()) {
            return this.getMetaClass().getConstant(this.zeroSign < 0 ? "SIGN_NEGATIVE_ZERO" : "SIGN_POSITIVE_ZERO");
        }
        return this.getMetaClass().getConstant(this.value.signum() < 0 ? "SIGN_NEGATIVE_FINITE" : "SIGN_POSITIVE_FINITE");
    }

    private RubyFixnum signValue(Ruby runtime2) {
        if (this.isNaN()) {
            return RubyFixnum.zero(runtime2);
        }
        if (this.isInfinity()) {
            return runtime2.newFixnum(this.infinitySign);
        }
        if (this.isZero()) {
            return runtime2.newFixnum(this.zeroSign);
        }
        return runtime2.newFixnum(this.value.signum());
    }

    @JRubyMethod
    public RubyArray split(ThreadContext context) {
        return RubyArray.newArray(context.runtime, this.signValue(context.runtime), context.runtime.newString(this.splitDigits()), context.runtime.newFixnum(10), this.exponent());
    }

    private String splitDigits() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInfinity()) {
            return "Infinity";
        }
        if (this.isZero()) {
            return "0";
        }
        return this.getSignificantDigits();
    }

    private String getSignificantDigits() {
        return this.absStripTrailingZeros().unscaledValue().toString();
    }

    private String getAllDigits() {
        return this.value.unscaledValue().abs().toString();
    }

    private int getExponent() {
        if (this.isZero() || this.isNaN() || this.isInfinity()) {
            return 0;
        }
        BigDecimal val = this.absStripTrailingZeros();
        return val.precision() - val.scale();
    }

    @JRubyMethod
    public IRubyObject sqrt(IRubyObject arg2) {
        Ruby runtime2 = this.getRuntime();
        if (this.isNaN()) {
            throw runtime2.newFloatDomainError("sqrt of 'NaN'(Not a Number)");
        }
        if (this.isInfinity() && this.infinitySign < 0 || this.value.signum() < 0) {
            throw runtime2.newFloatDomainError("sqrt of negative value");
        }
        if (this.isInfinity() && this.infinitySign > 0) {
            return RubyBigDecimal.getInfinity(runtime2, 1);
        }
        int n = RubyNumeric.num2int(this.precision(runtime2.getCurrentContext())) * (RubyBigDecimal.getPrecisionInt(runtime2, arg2) + 1);
        return new RubyBigDecimal(runtime2, RubyBigDecimal.bigSqrt(this.value, new MathContext(n, RoundingMode.HALF_UP))).setResult();
    }

    private static int getPrecisionInt(Ruby runtime2, IRubyObject v) {
        int n = RubyNumeric.num2int(v);
        if (n < 0) {
            throw runtime2.newArgumentError("negative precision");
        }
        return n;
    }

    @JRubyMethod
    public IRubyObject to_f() {
        return this.toFloat(this.getRuntime(), true);
    }

    private RubyFloat toFloat(Ruby runtime2, boolean checkFlow) {
        if (this.isNaN()) {
            return RubyFloat.newFloat(runtime2, Double.NaN);
        }
        if (this.isInfinity()) {
            return RubyFloat.newFloat(runtime2, this.infinitySign < 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (this.isZero()) {
            return RubyFloat.newFloat(runtime2, this.zeroSign < 0 ? -0.0 : 0.0);
        }
        int exponent2 = this.getExponent();
        if (exponent2 > 324) {
            if (checkFlow && RubyBigDecimal.isOverflowExceptionMode(runtime2)) {
                throw runtime2.newFloatDomainError("BigDecimal to Float conversion");
            }
            return RubyFloat.newFloat(this.getRuntime(), this.value.signum() > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
        }
        if (exponent2 < -323) {
            if (checkFlow && RubyBigDecimal.isUnderflowExceptionMode(runtime2)) {
                throw runtime2.newFloatDomainError("BigDecimal to Float conversion");
            }
            return RubyFloat.newFloat(this.getRuntime(), 0.0);
        }
        return RubyFloat.newFloat(runtime2, SafeDoubleParser.doubleValue(this.value));
    }

    @Override
    public RubyFloat convertToFloat() {
        return this.toFloat(this.getRuntime(), false);
    }

    public final IRubyObject to_int() {
        return this.to_int(this.getRuntime());
    }

    @Override
    @JRubyMethod(name={"to_i", "to_int"})
    public IRubyObject to_int(ThreadContext context) {
        return this.to_int(context.runtime);
    }

    final RubyInteger to_int(Ruby runtime2) {
        this.checkFloatDomain();
        try {
            return RubyFixnum.newFixnum(runtime2, this.value.longValueExact());
        }
        catch (ArithmeticException ex) {
            return RubyBignum.bignorm(runtime2, this.value.toBigInteger());
        }
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.to_int(this.getRuntime());
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        this.checkFloatDomain();
        int scale2 = Math.abs(this.value.scale());
        BigInteger numerator2 = this.value.scaleByPowerOfTen(scale2).toBigInteger();
        BigInteger denominator2 = BigInteger.TEN.pow(scale2);
        return RubyRational.newInstance(context, RubyBignum.newBignum(context.runtime, numerator2), RubyBignum.newBignum(context.runtime, denominator2));
    }

    @Deprecated
    public IRubyObject to_int19() {
        return this.to_int();
    }

    private static String removeTrailingZeroes(String str) {
        int l;
        for (l = str.length(); l > 0 && str.charAt(l - 1) == '0'; --l) {
        }
        return str.substring(0, l);
    }

    public static boolean formatHasLeadingPlus(String format) {
        return format.length() > 0 && format.charAt(0) == '+';
    }

    public static boolean formatHasLeadingSpace(String format) {
        return format.length() > 0 && format.charAt(0) == ' ';
    }

    public static boolean formatHasFloatingPointNotation(String format) {
        return format.length() > 0 && (format.charAt(format.length() - 1) == 'F' || format.charAt(format.length() - 1) == 'f');
    }

    public static int formatFractionalDigitGroups(String format) {
        Matcher match2 = FRACTIONAL_DIGIT_GROUPS.matcher(format);
        return match2.matches() ? Integer.parseInt(match2.group(2)) : 0;
    }

    private static boolean posSpace(String arg2) {
        return arg2 == null ? false : RubyBigDecimal.formatHasLeadingSpace(arg2);
    }

    private static boolean posSign(String arg2) {
        return arg2 == null ? false : RubyBigDecimal.formatHasLeadingPlus(arg2) || RubyBigDecimal.posSpace(arg2);
    }

    private static int groups(String arg2) {
        return arg2 == null ? 0 : RubyBigDecimal.formatFractionalDigitGroups(arg2);
    }

    @Override
    public final boolean isZero() {
        return !this.isNaN() && !this.isInfinity() && this.value.signum() == 0;
    }

    private boolean isNaN() {
        return this.isNaN;
    }

    private boolean isInfinity() {
        return this.infinitySign != 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private static StringBuilder appendSign(StringBuilder buff, String str, int signum) {
        if (signum == -1) {
            buff.append('-');
        } else if (signum == 1 && RubyBigDecimal.posSign(str)) {
            buff.append(RubyBigDecimal.posSpace(str) ? (char)' ' : '+');
        }
        return buff;
    }

    private CharSequence engineeringValue(String arg2) {
        String s2 = RubyBigDecimal.removeTrailingZeroes(this.unscaledValue());
        StringBuilder build = new StringBuilder();
        RubyBigDecimal.appendSign(build, arg2, this.value.signum()).append('0').append('.');
        int groups2 = RubyBigDecimal.groups(arg2);
        if (groups2 == 0) {
            build.append(s2.isEmpty() ? "0" : s2);
        } else {
            int len = s2.length();
            String sep = "";
            for (int index2 = 0; index2 < len; index2 += groups2) {
                int next = index2 + groups2;
                build.append(sep).append(s2.substring(index2, next > len ? len : next));
                sep = " ";
            }
        }
        build.append('e').append(this.getExponent());
        return build;
    }

    private CharSequence floatingPointValue(String arg2) {
        List<String> values2 = StringSupport.split(this.absStripTrailingZeros().toPlainString(), '.');
        String whole = values2.size() > 0 ? values2.get(0) : "0";
        String after = values2.size() > 1 ? values2.get(1) : "0";
        StringBuilder build = new StringBuilder();
        RubyBigDecimal.appendSign(build, arg2, this.value.signum());
        int groups2 = RubyBigDecimal.groups(arg2);
        if (groups2 == 0) {
            build.append(whole);
            if (after != null) {
                build.append('.').append(after);
            }
        } else {
            int next;
            int index2;
            int len = whole.length();
            String sep = "";
            for (index2 = 0; index2 < len; index2 += groups2) {
                next = index2 + groups2;
                if (next > len) {
                    next = len;
                }
                build.append(sep).append(whole.substring(index2, next));
                sep = " ";
            }
            if (after != null) {
                build.append('.');
                len = after.length();
                sep = "";
                for (index2 = 0; index2 < len; index2 += groups2) {
                    next = index2 + groups2;
                    if (next > len) {
                        next = len;
                    }
                    build.append(sep).append(after.substring(index2, next));
                    sep = " ";
                }
            }
        }
        return build;
    }

    @Override
    public IRubyObject to_s() {
        return this.toStringImpl(this.getRuntime(), null);
    }

    @JRubyMethod
    public RubyString to_s(ThreadContext context) {
        return this.toStringImpl(context.runtime, null);
    }

    @JRubyMethod
    public RubyString to_s(ThreadContext context, IRubyObject arg2) {
        return this.toStringImpl(context.runtime, arg2 == context.nil ? null : arg2.toString());
    }

    private RubyString toStringImpl(Ruby runtime2, String arg2) {
        if (this.isNaN()) {
            return RubyString.newUSASCIIString(runtime2, "NaN");
        }
        if (this.isInfinity()) {
            if (arg2 != null && this.infinitySign >= 0) {
                if (RubyBigDecimal.formatHasLeadingSpace(arg2)) {
                    return RubyString.newUSASCIIString(runtime2, " Infinity");
                }
                if (RubyBigDecimal.formatHasLeadingPlus(arg2)) {
                    return RubyString.newUSASCIIString(runtime2, "+Infinity");
                }
            }
            return RubyString.newUSASCIIString(runtime2, RubyBigDecimal.infinityString(this.infinitySign));
        }
        if (this.isZero()) {
            if (this.zeroSign < 0) {
                return RubyString.newUSASCIIString(runtime2, "-0.0");
            }
            if (arg2 != null && RubyBigDecimal.formatHasLeadingSpace(arg2)) {
                return RubyString.newUSASCIIString(runtime2, " 0.0");
            }
            if (arg2 != null && RubyBigDecimal.formatHasLeadingPlus(arg2)) {
                return RubyString.newUSASCIIString(runtime2, "+0.0");
            }
            return RubyString.newUSASCIIString(runtime2, "0.0");
        }
        boolean asEngineering = arg2 == null || !RubyBigDecimal.formatHasFloatingPointNotation(arg2);
        return RubyString.newUSASCIIString(runtime2, (asEngineering ? this.engineeringValue(arg2) : this.floatingPointValue(arg2)).toString());
    }

    @Override
    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.infinityString(this.infinitySign);
        }
        if (this.isZero()) {
            return this.zeroSign < 0 ? "-0.0" : "0.0";
        }
        return this.engineeringValue(null).toString();
    }

    @Deprecated
    public IRubyObject to_s(IRubyObject[] args2) {
        return this.toStringImpl(this.getRuntime(), args2.length == 0 ? null : (args2[0].isNil() ? null : args2[0].toString()));
    }

    @JRubyMethod
    public IRubyObject fix() {
        return this.truncateInternal(this.getRuntime(), 0);
    }

    private RubyBigDecimal truncateInternal(Ruby runtime2, int arg2) {
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(runtime2);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getInfinity(runtime2, this.infinitySign);
        }
        int precision2 = this.value.precision() - this.value.scale() + arg2;
        if (precision2 > 0) {
            return new RubyBigDecimal(runtime2, this.value.round(new MathContext(precision2, RoundingMode.DOWN)));
        }
        return RubyBigDecimal.getZero(runtime2, this.zeroSign);
    }

    @Override
    @JRubyMethod
    public IRubyObject truncate(ThreadContext context) {
        return this.truncateInternal(context.runtime, 0).to_int(context.runtime);
    }

    @JRubyMethod
    public IRubyObject truncate(ThreadContext context, IRubyObject arg2) {
        return this.truncateInternal(context.runtime, RubyNumeric.fix2int(arg2));
    }

    @Override
    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isZero());
    }

    @Deprecated
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.isZero());
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == BigDecimal.class || target2 == Number.class) {
            return (T)this.value;
        }
        return super.toJava(target2);
    }

    public static BigDecimal bigSqrt(BigDecimal squarD, MathContext rootMC) {
        int biLen;
        int sign2 = squarD.signum();
        if (sign2 == -1) {
            throw new ArithmeticException("Square root of a negative number: " + squarD);
        }
        if (sign2 == 0) {
            return squarD.round(rootMC);
        }
        int prec = rootMC.getPrecision();
        if (prec == 0) {
            throw new IllegalArgumentException("Most roots won't have infinite precision = 0");
        }
        int BITS = 62;
        int nInit = 16;
        MathContext nMC = new MathContext(18, RoundingMode.HALF_DOWN);
        BigInteger bi = squarD.unscaledValue();
        int shift2 = Math.max(0, biLen - BITS + ((biLen = bi.bitLength()) % 2 == 0 ? 0 : 1));
        bi = bi.shiftRight(shift2);
        double root = Math.sqrt(SafeDoubleParser.doubleValue(bi));
        BigDecimal halfBack = new BigDecimal(BigInteger.ONE.shiftLeft(shift2 / 2));
        int scale2 = squarD.scale();
        if (scale2 % 2 == 1) {
            root *= 3.1622776601683795;
        }
        scale2 = (int)Math.ceil((double)scale2 / 2.0);
        BigDecimal x = new BigDecimal(root, nMC);
        x = x.multiply(halfBack, nMC);
        if (scale2 != 0) {
            x = x.movePointLeft(scale2);
        }
        if (prec < nInit) {
            return x.round(rootMC);
        }
        BigDecimal TWO = BigDecimal.valueOf(2L);
        BigDecimal v = BigDecimal.ONE.divide(TWO.multiply(x), nMC);
        ArrayList<Integer> nPrecs = new ArrayList<Integer>();
        assert (nInit > 3) : "Never ending loop!";
        int m = prec + 1;
        while (m > nInit) {
            nPrecs.add(m);
            m = m / 2 + (m > 100 ? 1 : 2);
        }
        for (int i2 = nPrecs.size() - 1; i2 > -1; --i2) {
            nMC = new MathContext((Integer)nPrecs.get(i2), i2 % 2 == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN);
            BigDecimal e = squarD.subtract(x.multiply(x, nMC), nMC);
            if (i2 == 0) {
                x = x.add(e.multiply(v, rootMC), rootMC);
                break;
            }
            x = x.add(e.multiply(v, nMC));
            BigDecimal g = BigDecimal.ONE.subtract(TWO.multiply(x).multiply(v, nMC));
            v = v.add(g.multiply(v, nMC));
        }
        return x;
    }

    private void checkFloatDomain() {
        if (this.isNaN()) {
            throw this.getRuntime().newFloatDomainError("NaN");
        }
        if (this.isInfinity()) {
            throw this.getRuntime().newFloatDomainError(RubyBigDecimal.infinityString(this.infinitySign));
        }
    }

    static String infinityString(int infinitySign) {
        return infinitySign == -1 ? "-Infinity" : "Infinity";
    }

    private static boolean isEven(RubyNumeric x) {
        if (x instanceof RubyFixnum) {
            return (((RubyFixnum)x).getLongValue() & 1L) == 0L;
        }
        if (x instanceof RubyBignum) {
            return !((RubyBignum)x).getBigIntegerValue().testBit(0);
        }
        return false;
    }

    @Deprecated
    public static IRubyObject ver(ThreadContext context, IRubyObject recv) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "BigDecimal.ver is deprecated; use BigDecimal::VERSION instead");
        return RubyString.newStringShared(context.runtime, VERSION);
    }

    @Deprecated
    public RubyBigDecimal(Ruby runtime2, RubyBigDecimal rbd) {
        this(runtime2, runtime2.getClass("BigDecimal"), rbd);
    }

    @Deprecated
    public RubyBigDecimal(Ruby runtime2, RubyClass klass, RubyBigDecimal rbd) {
        super(runtime2, klass);
        this.isNaN = rbd.isNaN;
        this.infinitySign = rbd.infinitySign;
        this.zeroSign = rbd.zeroSign;
        this.value = rbd.value;
        this.flags |= FROZEN_F;
    }

    private static JavaSites.BigDecimalSites sites(ThreadContext context) {
        return context.sites.BigDecimal;
    }

    private static enum InfinityErrorMsgType {
        To,
        In;

    }

    public static class BigDecimalKernelMethods {
        @JRubyMethod(name={"BigDecimal"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(ThreadContext context, IRubyObject recv, IRubyObject arg2) {
            return BigDecimalKernelMethods.newBigDecimal(context, recv, arg2, RubyFixnum.newFixnum(context.runtime, Integer.MAX_VALUE));
        }

        @JRubyMethod(name={"BigDecimal"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
            Ruby runtime2 = context.runtime;
            RubyClass bigDecimal = runtime2.getClass("BigDecimal");
            IRubyObject maybeOpts = ArgsUtil.getOptionsArg(runtime2, arg1, false);
            if (maybeOpts.isNil()) {
                return RubyBigDecimal.newInstance(context, (IRubyObject)bigDecimal, arg0, arg1, true, true);
            }
            IRubyObject exObj = ArgsUtil.extractKeywordArg(context, "exception", maybeOpts);
            boolean exception2 = exObj.isNil() ? true : exObj.isTrue();
            return RubyBigDecimal.newInstance(context, (IRubyObject)bigDecimal, arg0, RubyFixnum.newFixnum(context.runtime, Integer.MAX_VALUE), true, exception2);
        }

        @JRubyMethod(name={"BigDecimal"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1, IRubyObject opts) {
            Ruby runtime2 = context.runtime;
            IRubyObject maybeOpts = ArgsUtil.getOptionsArg(runtime2, opts, false);
            if (maybeOpts.isNil()) {
                throw runtime2.newArgumentError(3, 1, 2);
            }
            IRubyObject exObj = ArgsUtil.extractKeywordArg(context, "exception", maybeOpts);
            boolean exception2 = exObj.isNil() ? true : exObj.isTrue();
            return RubyBigDecimal.newInstance(context, (IRubyObject)context.runtime.getClass("BigDecimal"), arg0, arg1, true, exception2);
        }
    }
}

