/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyObjectInputStream
extends RubyObject {
    JRubyObjectInputStreamImpl impl;

    public static RubyClass createJRubyObjectInputStream(Ruby runtime2) {
        RubyClass result2 = runtime2.defineClass("JRubyObjectInputStream", runtime2.getObject(), JRubyObjectInputStream::new);
        result2.defineAnnotatedMethods(JRubyObjectInputStream.class);
        return result2;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args2, Block block) {
        IRubyObject obj = ((RubyClass)recv).allocate();
        obj.callMethod(recv.getRuntime().getCurrentContext(), "initialize", args2, block);
        return obj;
    }

    public JRubyObjectInputStream(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject wrappedStream) {
        InputStream stream = wrappedStream.toJava(InputStream.class);
        try {
            this.impl = new JRubyObjectInputStreamImpl(this.getRuntime(), stream);
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"read_object"}, alias={"readObject"})
    public IRubyObject readObject() {
        try {
            return Java.getInstance(this.getRuntime(), this.impl.readObject());
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw this.getRuntime().newNameError(cnfe.getLocalizedMessage(), cnfe.getMessage(), cnfe);
        }
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        try {
            this.impl.close();
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        return this;
    }

    static class JRubyObjectInputStreamImpl
    extends ObjectInputStream {
        protected final Ruby runtime;

        public JRubyObjectInputStreamImpl(Ruby runtime2, InputStream in) throws IOException {
            super(in);
            this.runtime = runtime2;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, this.runtime.getJRubyClassLoader());
        }
    }
}

