/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.RubySymbol;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveKeywordArgInstr
extends ReceiveArgBase
implements FixedArityInstr {
    public final RubySymbol key;

    public ReceiveKeywordArgInstr(Variable result2, Variable keyword, RubySymbol key2) {
        super(Operation.RECV_KW_ARG, result2, keyword);
        this.key = key2;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.getKey()};
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        scope.setReceivesKeywordArgs();
        return true;
    }

    public String getId() {
        return this.key.idString();
    }

    public RubySymbol getKey() {
        return this.key;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ReceiveKeywordArgInstr(ii.getRenamedVariable(this.result), ii.getRenamedVariable(this.getKeywords()), this.getKey());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getKey());
    }

    public static ReceiveKeywordArgInstr decode(IRReaderDecoder d) {
        return new ReceiveKeywordArgInstr(d.decodeVariable(), d.decodeVariable(), d.decodeSymbol());
    }

    @Override
    public IRubyObject receiveArg(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject[] args2, boolean ruby2keyword) {
        IRubyObject keywords = (IRubyObject)this.getKeywords().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.receiveKeywordArg(keywords, this.getKey());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveKeywordArgInstr(this);
    }
}

