/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jcodings.Encoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyFile;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.ir.persistence.IRReader;
import org.jruby.ir.persistence.IRReaderStream;
import org.jruby.ir.persistence.util.IRFileExpert;
import org.jruby.management.ParserStats;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserProvider;
import org.jruby.parser.ParserProviderDefault;
import org.jruby.parser.ParserServiceLoader;
import org.jruby.parser.ParserType;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

public class ParserManager {
    public static final boolean PARSER_TIMING = Options.PARSER_SUMMARY.load();
    public static final boolean PARSER_WASM = Options.PARSER_WASM.load();
    private final Ruby runtime;
    private final Parser parser;
    private final ParserStats parserStats;

    public ParserManager(Ruby runtime2) {
        ParserProvider provider;
        this.runtime = runtime2;
        try {
            provider = ParserServiceLoader.provider(Options.PARSER_PRISM.load() != false || Options.PARSER_WASM.load() != false);
            provider.initialize(runtime2.getJRubyHome() + "/lib/libprism." + ParserManager.getLibraryExtension());
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("warning: Problem loading requested parser. Falling back to default parser.\nOriginal error message: " + e.getMessage());
            provider = new ParserProviderDefault();
        }
        runtime2.getIRManager().setBuilderFactory(provider.getBuilderFactory());
        this.parser = provider.getParser(runtime2);
        this.parserStats = new ParserStats(runtime2);
    }

    private static String getLibraryExtension() {
        if (Platform.IS_WINDOWS) {
            return "dll";
        }
        if (Platform.IS_MAC) {
            return "dylib";
        }
        return "so";
    }

    public Parser getParser() {
        return this.parser;
    }

    public ParseResult parseEval(String fileName, int lineNumber, String source2, DynamicScope scope) {
        return this.parseEval(fileName, lineNumber, new ByteList(this.encodeToBytes(source2), this.runtime.getDefaultEncoding()), scope);
    }

    public ParseResult parseEval(String fileName, int lineNumber, ByteList source2, DynamicScope scope) {
        long nanos = 0L;
        this.parserStats.addEvalParse();
        if (PARSER_TIMING) {
            nanos = System.nanoTime();
        }
        ParseResult result2 = this.parser.parse(fileName, lineNumber, source2, scope, ParserType.EVAL);
        if (PARSER_TIMING) {
            this.parserStats.addParseTime(System.nanoTime() - nanos);
        }
        return result2;
    }

    public ParseResult parseMainFile(String fileName, int lineNumber, InputStream in, Encoding encoding2, DynamicScope scope, ParserType type2) {
        long nanos = 0L;
        this.parserStats.addLoadParse();
        if (PARSER_TIMING) {
            nanos = System.nanoTime();
        }
        ParseResult result2 = RubyInstanceConfig.IR_READING ? this.loadFileFromIRPersistence(fileName, lineNumber, in, encoding2, scope, type2) : this.parser.parse(fileName, lineNumber, in, encoding2, scope, type2);
        if (PARSER_TIMING) {
            this.parserStats.addParseTime(System.nanoTime() - nanos);
        }
        return result2;
    }

    public ParseResult parseFile(String fileName, int lineNumber, InputStream in, Encoding encoding2) {
        return this.parseMainFile(fileName, lineNumber, in, encoding2, null, ParserType.NORMAL);
    }

    private ParseResult loadFileFromIRPersistence(String fileName, int lineNumber, InputStream in, Encoding encoding2, DynamicScope scope, ParserType type2) {
        try {
            return IRReader.load(this.runtime.getIRManager(), new IRReaderStream(this.runtime.getIRManager(), IRFileExpert.getIRPersistedFile((String)fileName), fileName));
        }
        catch (IOException e) {
            if (type2 == ParserType.MAIN || type2 == ParserType.INLINE) {
                return this.parseMainFile(fileName, lineNumber, in, encoding2, scope, type2);
            }
            return this.parseFile(fileName, lineNumber, in, encoding2);
        }
    }

    public ParserStats getParserStats() {
        return this.parserStats;
    }

    private byte[] encodeToBytes(String string2) {
        Charset charset = this.runtime.getDefaultCharset();
        return charset == null ? string2.getBytes() : string2.getBytes(charset);
    }

    public IRubyObject getLineStub(ThreadContext context, IRubyObject arg2) {
        ByteList contents = ((RubyString)RubyFile.read(context, arg2, new IRubyObject[]{arg2}, Block.NULL_BLOCK)).getByteList();
        int begin2 = contents.begin();
        int length2 = contents.realSize();
        byte[] bytes2 = contents.unsafeBytes();
        int lineCount = 0;
        for (int i2 = begin2; i2 < length2; ++i2) {
            if (bytes2[i2] != 10) continue;
            ++lineCount;
        }
        ParseResult result2 = this.parseFile("", Options.PARSER_PRISM.load() != false ? 0 : -1, new LoadServiceResourceInputStream(contents.bytes()), contents.getEncoding());
        return this.parser.getLineStub(context, result2, lineCount);
    }

    public ParseResult addGetsLoop(Ruby runtime2, ParseResult oldRoot, boolean printing, boolean processLineEndings, boolean split2) {
        return this.parser.addGetsLoop(runtime2, oldRoot, printing, processLineEndings, split2);
    }
}

