/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashSet;
import java.util.Set;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.RubyStruct;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RecursiveComparator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> IRubyObject compare(ThreadContext context, T invokable, IRubyObject a, IRubyObject b2, boolean eql2) {
        if (a == b2) {
            return context.tru;
        }
        boolean clear2 = false;
        try {
            if (a instanceof RubyHash && b2 instanceof RubyHash || a instanceof RubyArray && b2 instanceof RubyArray || a instanceof RubyStruct && b2 instanceof RubyStruct) {
                Pair pair = new Pair(a, b2);
                Set<Pair> seen = context.getRecursiveSet();
                if (seen == null) {
                    seen = new HashSet<Pair>(4);
                    context.setRecursiveSet(seen);
                    clear2 = true;
                } else if (seen.contains(pair)) {
                    RubyBoolean rubyBoolean = context.tru;
                    return rubyBoolean;
                }
                seen.add(pair);
            }
            if (a instanceof RubyHash) {
                RubyHash hash2 = (RubyHash)a;
                RubyBoolean rubyBoolean = hash2.compare(context, (RubyHash.VisitorWithState)invokable, b2, eql2);
                return rubyBoolean;
            }
            if (a instanceof RubyArray) {
                RubyArray array = (RubyArray)a;
                RubyBoolean rubyBoolean = array.compare(context, (CallSite)invokable, b2);
                return rubyBoolean;
            }
            if (a instanceof RubyStruct) {
                RubyStruct struct = (RubyStruct)a;
                RubyBoolean rubyBoolean = struct.compare(context, (CallSite)invokable, b2);
                return rubyBoolean;
            }
            IRubyObject iRubyObject = ((CallSite)invokable).call(context, a, a, b2);
            return iRubyObject;
        }
        finally {
            if (clear2) {
                context.setRecursiveSet(null);
            }
        }
    }

    public static class Pair {
        final int a;
        final int b;

        public Pair(IRubyObject a, IRubyObject b2) {
            this.a = System.identityHashCode(a);
            this.b = System.identityHashCode(b2);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Pair) {
                Pair pair = (Pair)other;
                return this.a == pair.a && this.b == pair.b;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.a + this.b;
        }
    }
}

