/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import com.headius.backport9.modules.Module;
import com.headius.backport9.modules.Modules;
import java.io.FileDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import jnr.constants.platform.Fcntl;
import jnr.enxio.channels.NativeSelectableChannel;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Pointer;
import jnr.posix.FileStat;
import jnr.posix.HANDLE;
import jnr.posix.JavaLibCHelper;
import jnr.posix.POSIX;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.javasupport.JavaUtil;
import org.jruby.platform.Platform;
import org.jruby.runtime.Helpers;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.NonBlockingHashMapLong;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class FilenoUtil {
    public static final int FIRST_FAKE_FD = 100000;
    protected final AtomicInteger internalFilenoIndex = new AtomicInteger(100000);
    private final NonBlockingHashMapLong<ChannelFD> filenoMap = new NonBlockingHashMapLong();
    private final POSIX posix;
    private final WinC winc;
    static final Logger LOG = LoggerFactory.getLogger(FilenoUtil.class);

    public FilenoUtil(POSIX posix) {
        this.posix = posix;
        this.winc = posix.isNative() && Platform.IS_WINDOWS ? (WinC)LibraryLoader.create(WinC.class).load("msvcrt") : null;
    }

    public static FileDescriptor getDescriptorFromChannel(Channel channel) {
        block11: {
            if (ReflectiveAccess.SEL_CH_IMPL_GET_FD_HANDLE != null && ReflectiveAccess.SEL_CH_IMPL.test(channel)) {
                try {
                    return (FileDescriptor)ReflectiveAccess.SEL_CH_IMPL_GET_FD.apply(channel);
                }
                catch (Exception exception2) {
                    break block11;
                }
            }
            if (ReflectiveAccess.FILE_CHANNEL_IMPL_GET_FD_HANDLE != null && ReflectiveAccess.FILE_CHANNEL_IMPL.test(channel)) {
                try {
                    return (FileDescriptor)ReflectiveAccess.FILE_CHANNEL_IMPL_GET_FD.apply(channel);
                }
                catch (Exception exception3) {
                    break block11;
                }
            }
            if (ReflectiveAccess.FILE_DESCRIPTOR_SET_FILENO_HANDLE != null) {
                FileDescriptor unixFD = new FileDescriptor();
                try {
                    if (channel instanceof UnixSocketChannel) {
                        ReflectiveAccess.FILE_DESCRIPTOR_SET_FILENO.accept(unixFD, ((UnixSocketChannel)channel).getFD());
                        return unixFD;
                    }
                    if (channel instanceof UnixServerSocketChannel) {
                        ReflectiveAccess.FILE_DESCRIPTOR_SET_FILENO.accept(unixFD, ((UnixServerSocketChannel)channel).getFD());
                        return unixFD;
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
            }
        }
        return new FileDescriptor();
    }

    public ChannelFD getWrapperFromFileno(int fileno2) {
        ChannelFD fd = this.filenoMap.get(fileno2);
        if (fd != null && !fd.ch.isOpen() && !FilenoUtil.isFake(fileno2)) {
            int ret;
            if (Platform.IS_WINDOWS) {
                FileStat stat2 = this.posix.allocateStat();
                ret = this.posix.fstat(fileno2, stat2);
            } else {
                ret = this.posix.fcntl(fileno2, Fcntl.F_GETFD);
            }
            if (ret >= 0) {
                this.filenoMap.remove(fileno2);
                fd = null;
            }
        }
        return fd;
    }

    public void registerWrapper(int fileno2, ChannelFD wrapper) {
        if (fileno2 == -1) {
            return;
        }
        this.filenoMap.put(fileno2, wrapper);
    }

    public void unregisterWrapper(int fileno2) {
        if (fileno2 == -1) {
            return;
        }
        this.filenoMap.remove(fileno2);
    }

    public int getNumberOfWrappers() {
        return this.filenoMap.size();
    }

    public int getNewFileno() {
        return this.internalFilenoIndex.getAndIncrement();
    }

    public static boolean isFake(int fileno2) {
        return fileno2 < 0 || fileno2 >= 100000;
    }

    public static int filenoFrom(Channel channel) {
        if (channel instanceof NativeSelectableChannel) {
            return ((NativeSelectableChannel)channel).getFD();
        }
        return FilenoUtil.getFilenoUsingReflection(channel);
    }

    private static int getFilenoUsingReflection(Channel channel) {
        if (ReflectiveAccess.FILE_DESCRIPTOR_GET_FILENO_HANDLE != null) {
            return FilenoUtil.filenoFrom(FilenoUtil.getDescriptorFromChannel(channel));
        }
        return -1;
    }

    public static int filenoFrom(FileDescriptor fd) {
        if (fd.valid()) {
            try {
                return ReflectiveAccess.FILE_DESCRIPTOR_GET_FILENO.applyAsInt(fd);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return -1;
    }

    private static HANDLE handleFrom(Channel channel) {
        if (channel instanceof NativeSelectableChannel) {
            return HANDLE.valueOf(((NativeSelectableChannel)channel).getFD());
        }
        return FilenoUtil.getHandleUsingReflection(channel);
    }

    private static HANDLE getHandleUsingReflection(Channel channel) {
        if (ReflectiveAccess.FILE_DESCRIPTOR_GET_FILENO_HANDLE != null) {
            return JavaLibCHelper.gethandle(FilenoUtil.getDescriptorFromChannel(channel));
        }
        return HANDLE.valueOf(-1L);
    }

    public int filenoFromHandleIn(Channel channel, int flags2) {
        if (this.winc == null) {
            return -1;
        }
        HANDLE hndl = FilenoUtil.handleFrom(channel);
        if (!hndl.isValid()) {
            return -1;
        }
        return this.winc._open_osfhandle(hndl.toPointer(), flags2);
    }

    public int closeFilenoHandle(int fd) {
        if (fd != -1) {
            return this.winc._close(fd);
        }
        return -1;
    }

    private static class ReflectiveAccess {
        private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
        private static final Predicate<Object> SEL_CH_IMPL;
        private static final MethodHandle SEL_CH_IMPL_GET_FD_HANDLE;
        private static final Function<Object, FileDescriptor> SEL_CH_IMPL_GET_FD;
        private static final Predicate<Object> FILE_CHANNEL_IMPL;
        private static final MethodHandle FILE_CHANNEL_IMPL_GET_FD_HANDLE;
        private static final Function<Object, FileDescriptor> FILE_CHANNEL_IMPL_GET_FD;
        private static final MethodHandle FILE_DESCRIPTOR_SET_FILENO_HANDLE;
        private static final ObjIntConsumer<FileDescriptor> FILE_DESCRIPTOR_SET_FILENO;
        private static final MethodHandle FILE_DESCRIPTOR_GET_FILENO_HANDLE;
        private static final ToIntFunction<FileDescriptor> FILE_DESCRIPTOR_GET_FILENO;

        private ReflectiveAccess() {
        }

        private static FileDescriptor fileChannelImplGetFD(Object obj) {
            try {
                return FILE_CHANNEL_IMPL_GET_FD_HANDLE.invoke(obj);
            }
            catch (Throwable t) {
                Helpers.throwException(t);
                return null;
            }
        }

        private static int fileDescriptorGetFileno(FileDescriptor obj) {
            try {
                return FILE_DESCRIPTOR_GET_FILENO_HANDLE.invoke(obj);
            }
            catch (Throwable t) {
                Helpers.throwException(t);
                return -1;
            }
        }

        private static void fileDescriptorSetFileno(FileDescriptor obj, int i2) {
            try {
                FILE_DESCRIPTOR_SET_FILENO_HANDLE.invoke(obj, i2);
            }
            catch (Throwable t) {
                Helpers.throwException(t);
            }
        }

        private static FileDescriptor selChImplGetFD(Object obj) {
            try {
                return SEL_CH_IMPL_GET_FD_HANDLE.invoke(obj);
            }
            catch (Throwable t) {
                Helpers.throwException(t);
                return null;
            }
        }

        static {
            SEL_CH_IMPL_GET_FD = ReflectiveAccess::selChImplGetFD;
            FILE_CHANNEL_IMPL_GET_FD = ReflectiveAccess::fileChannelImplGetFD;
            FILE_DESCRIPTOR_SET_FILENO = ReflectiveAccess::fileDescriptorSetFileno;
            FILE_DESCRIPTOR_GET_FILENO = ReflectiveAccess::fileDescriptorGetFileno;
            MethodHandle selChImplGetFD = null;
            Predicate<Object> isSelChImpl = null;
            try {
                Class<?> selChImpl = Class.forName("sun.nio.ch.SelChImpl");
                isSelChImpl = selChImpl::isInstance;
                Method getFD = selChImpl.getDeclaredMethod("getFD", new Class[0]);
                selChImplGetFD = JavaUtil.getHandleSafe(getFD, ReflectiveAccess.class, LOOKUP);
            }
            catch (Throwable selChImpl) {
                // empty catch block
            }
            SEL_CH_IMPL = isSelChImpl;
            SEL_CH_IMPL_GET_FD_HANDLE = selChImplGetFD;
            Predicate<Object> isFileChannelImpl = null;
            MethodHandle fileChannelGetFD = null;
            try {
                Class<?> fileChannelImpl = Class.forName("sun.nio.ch.FileChannelImpl");
                isFileChannelImpl = fileChannelImpl::isInstance;
                Field fd = fileChannelImpl.getDeclaredField("fd");
                fileChannelGetFD = JavaUtil.getGetterSafe(fd, ReflectiveAccess.class, LOOKUP);
            }
            catch (Throwable fileChannelImpl) {
                // empty catch block
            }
            FILE_CHANNEL_IMPL = isFileChannelImpl;
            FILE_CHANNEL_IMPL_GET_FD_HANDLE = fileChannelGetFD;
            MethodHandle fdGetFileno = null;
            MethodHandle fdSetFileno = null;
            try {
                Field fd = FileDescriptor.class.getDeclaredField("fd");
                fdGetFileno = JavaUtil.getGetterSafe(fd, ReflectiveAccess.class, LOOKUP);
                fdSetFileno = JavaUtil.getSetterSafe(fd, ReflectiveAccess.class, LOOKUP);
            }
            catch (Throwable fd) {
                // empty catch block
            }
            FILE_DESCRIPTOR_GET_FILENO_HANDLE = fdGetFileno;
            FILE_DESCRIPTOR_SET_FILENO_HANDLE = fdSetFileno;
            if ((selChImplGetFD == null || fileChannelGetFD == null || fdGetFileno == null) && Options.NATIVE_VERBOSE.load().booleanValue()) {
                Module module = Modules.getModule(ReflectiveAccess.class);
                String moduleName = module.getName();
                if (moduleName == null) {
                    moduleName = "ALL-UNNAMED";
                }
                LOG.warn("Native IO integration requires open access to the JDK IO subsystem\nPass '--add-opens java.base/sun.nio.ch=" + moduleName + " --add-opens java.base/java.io=" + moduleName + "' to enable.", new Object[0]);
            }
        }
    }

    public static interface WinC {
        public int _open_osfhandle(Pointer var1, int var2);

        public int _close(int var1);
    }
}

