/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.checks;

import java.util.List;
import java.util.Set;
import org.sonarsource.ruby.converter.RubyNativeKind;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.ParameterTree;
import org.sonarsource.slang.checks.UnusedFunctionParameterCheck;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.utils.FunctionUtils;
import org.sonarsource.slang.impl.BlockTreeImpl;
import org.sonarsource.slang.impl.TopLevelTreeImpl;

public class UnusedFunctionParameterRubyCheck
extends UnusedFunctionParameterCheck {
    private static final RubyNativeKind SUPER_NATIVE_KIND = new RubyNativeKind("zsuper");

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, functionDeclarationTree) -> {
            if (functionDeclarationTree.isConstructor() || this.shouldBeIgnored((CheckContext)ctx, (FunctionDeclarationTree)functionDeclarationTree) || UnusedFunctionParameterRubyCheck.hasCallToSuper(functionDeclarationTree)) {
                return;
            }
            List<ParameterTree> unusedParameters = UnusedFunctionParameterRubyCheck.getUnusedParameters(functionDeclarationTree);
            if (unusedParameters.isEmpty()) {
                return;
            }
            Set<String> stringLiteralTokens = FunctionUtils.getStringsTokens(functionDeclarationTree, "\\s|#\\{|}|:");
            unusedParameters.stream().filter(param -> !stringLiteralTokens.contains(param.identifier().name())).forEach(identifier -> this.reportUnusedParameters((CheckContext)ctx, unusedParameters));
        });
    }

    private static boolean hasCallToSuper(FunctionDeclarationTree functionDeclarationTree) {
        return functionDeclarationTree.descendants().filter(NativeTree.class::isInstance).map(NativeTree.class::cast).map(NativeTree::nativeKind).anyMatch(SUPER_NATIVE_KIND::equals);
    }

    @Override
    protected boolean isValidFunctionForRule(CheckContext ctx, FunctionDeclarationTree tree) {
        return UnusedFunctionParameterRubyCheck.parentIsBlockUnderTopLevel(ctx) || super.isValidFunctionForRule(ctx, tree);
    }

    private static boolean parentIsBlockUnderTopLevel(CheckContext ctx) {
        return ctx.parent() instanceof BlockTreeImpl && ctx.ancestors().size() == 2 && ctx.ancestors().getLast() instanceof TopLevelTreeImpl;
    }
}

