/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.converter;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.jruby.RubySymbol;
import org.sonarsource.ruby.converter.AstNode;
import org.sonarsource.ruby.converter.RubyNativeKind;
import org.sonarsource.ruby.converter.impl.RubyPartialExceptionHandlingTree;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.CatchTree;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.JumpTree;
import org.sonarsource.slang.api.LiteralTree;
import org.sonarsource.slang.api.LoopTree;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.api.UnaryExpressionTree;
import org.sonarsource.slang.impl.AssignmentExpressionTreeImpl;
import org.sonarsource.slang.impl.BinaryExpressionTreeImpl;
import org.sonarsource.slang.impl.BlockTreeImpl;
import org.sonarsource.slang.impl.CatchTreeImpl;
import org.sonarsource.slang.impl.ClassDeclarationTreeImpl;
import org.sonarsource.slang.impl.ExceptionHandlingTreeImpl;
import org.sonarsource.slang.impl.FunctionDeclarationTreeImpl;
import org.sonarsource.slang.impl.IdentifierTreeImpl;
import org.sonarsource.slang.impl.IfTreeImpl;
import org.sonarsource.slang.impl.IntegerLiteralTreeImpl;
import org.sonarsource.slang.impl.JumpTreeImpl;
import org.sonarsource.slang.impl.LiteralTreeImpl;
import org.sonarsource.slang.impl.LoopTreeImpl;
import org.sonarsource.slang.impl.MatchCaseTreeImpl;
import org.sonarsource.slang.impl.MatchTreeImpl;
import org.sonarsource.slang.impl.ModifierTreeImpl;
import org.sonarsource.slang.impl.NativeTreeImpl;
import org.sonarsource.slang.impl.ParameterTreeImpl;
import org.sonarsource.slang.impl.ParenthesizedExpressionTreeImpl;
import org.sonarsource.slang.impl.ReturnTreeImpl;
import org.sonarsource.slang.impl.StringLiteralTreeImpl;
import org.sonarsource.slang.impl.TextRangeImpl;
import org.sonarsource.slang.impl.TextRanges;
import org.sonarsource.slang.impl.ThrowTreeImpl;
import org.sonarsource.slang.impl.TreeMetaDataProvider;
import org.sonarsource.slang.impl.UnaryExpressionTreeImpl;
import org.sonarsource.slang.impl.VariableDeclarationTreeImpl;

public class RubyVisitor {
    private static final String KEYWORD_ATTRIBUTE = "keyword";
    private static final List<String> EXCEPTION_BLOCK_TYPES = Arrays.asList("resbody", "rescue", "ensure");
    private static final Map<String, BinaryExpressionTree.Operator> BINARY_OPERATOR_MAP = new HashMap<String, BinaryExpressionTree.Operator>();
    private static final Map<String, UnaryExpressionTree.Operator> UNARY_OPERATOR_MAP;
    private static final Map<String, ModifierTree.Kind> MODIFIER_MAP;
    private static final Set<String> LOCAL_SCOPE_TYPES;
    private final TreeMetaDataProvider metaDataProvider;
    private Deque<String> nodeTypeStack = new ArrayDeque<String>();
    private Deque<Set<String>> localVariables = new ArrayDeque<Set<String>>();

    public RubyVisitor(TreeMetaDataProvider metaDataProvider) {
        this.metaDataProvider = metaDataProvider;
        this.localVariables.push(new HashSet());
    }

    public void beforeVisit(AstNode node) {
        this.nodeTypeStack.push(node.type());
        if (LOCAL_SCOPE_TYPES.contains(node.type())) {
            this.localVariables.push(new HashSet());
        }
    }

    public void afterVisit(AstNode node) {
        this.nodeTypeStack.pop();
        if (LOCAL_SCOPE_TYPES.contains(node.type())) {
            this.localVariables.pop();
        }
    }

    public Tree visitNode(AstNode node, List<?> children2) {
        switch (node.type()) {
            case "and": {
                return this.createLogicalOperation(node, children2, BinaryExpressionTree.Operator.CONDITIONAL_AND);
            }
            case "arg": 
            case "optarg": 
            case "restarg": 
            case "kwarg": 
            case "kwoptarg": 
            case "kwrestarg": 
            case "blockarg": 
            case "procarg0": 
            case "shadowarg": {
                return this.createParameterTree(node, children2);
            }
            case "begin": {
                return this.createFromBeginNode(node, children2);
            }
            case "kwbegin": {
                return this.createFromKwBeginNode(node, children2);
            }
            case "case": {
                return this.createMatchTree(node, children2);
            }
            case "casgn": {
                return this.createFromCasgn(node, children2);
            }
            case "const": {
                return this.createFromConst(node, children2);
            }
            case "class": {
                return this.createClassDeclarationTree(node, children2);
            }
            case "def": 
            case "defs": {
                return this.createFunctionDeclarationTree(node, children2);
            }
            case "cvasgn": 
            case "gvasgn": 
            case "ivasgn": 
            case "lvasgn": {
                return this.createFromAssign(node, children2);
            }
            case "if": {
                return this.createIfTree(node, children2);
            }
            case "indexasgn": {
                return this.createFromIndexasgn(node, children2);
            }
            case "int": {
                return this.createIntegerLiteralTree(node);
            }
            case "cvar": 
            case "lvar": 
            case "ivar": {
                return this.createFromVar(node, children2);
            }
            case "masgn": {
                return this.createFromMasgn(node, children2);
            }
            case "mlhs": {
                return this.createFromMlhs(node, children2);
            }
            case "op_asgn": {
                return this.createFromOpAsgn(node, children2);
            }
            case "break": {
                return this.createJumpTree(node, children2, JumpTree.JumpKind.BREAK);
            }
            case "next": {
                return this.createJumpTree(node, children2, JumpTree.JumpKind.CONTINUE);
            }
            case "return": {
                return this.createReturnTree(node, children2);
            }
            case "or": {
                return this.createLogicalOperation(node, children2, BinaryExpressionTree.Operator.CONDITIONAL_OR);
            }
            case "send": {
                return this.createFromSendNode(node, children2);
            }
            case "true": 
            case "false": {
                return new LiteralTreeImpl(this.metaData(node), node.type());
            }
            case "when": {
                return this.createCaseTree(node, children2);
            }
            case "str": {
                return this.createStringLiteralTree(node, children2);
            }
            case "rescue": {
                return this.createExceptionHandlingTree(node, children2);
            }
            case "resbody": {
                return this.createCatchTree(node, children2);
            }
            case "ensure": {
                return this.updateExceptionHandlingWithFinally(node, children2);
            }
            case "while_post": 
            case "until_post": {
                return this.createLoopTree(node, children2, LoopTree.LoopKind.DOWHILE);
            }
            case "while": 
            case "until": {
                return this.createLoopTree(node, children2, LoopTree.LoopKind.WHILE);
            }
            case "for": {
                return this.createForLoopTree(node, children2);
            }
        }
        return this.createNativeTree(node, children2);
    }

    private Tree createLoopTree(AstNode node, List<?> children2, LoopTree.LoopKind kind) {
        Tree condition = (Tree)children2.get(0);
        Tree body = (Tree)children2.get(1);
        if (body == null) {
            TextRange endRange = this.getTokenByAttribute(node, "end").textRange();
            body = this.createEmptyBlockTree(condition.textRange().end(), endRange.start());
        }
        return new LoopTreeImpl(this.metaData(node), condition, body, kind, this.getTokenByAttribute(node, KEYWORD_ATTRIBUTE));
    }

    private Tree createForLoopTree(AstNode node, List<?> children2) {
        Tree variables = (Tree)children2.get(0);
        Tree expression = (Tree)children2.get(1);
        TextRange conditionRange = TextRanges.merge(Arrays.asList(variables.textRange(), expression.textRange()));
        RubyNativeKind nativeKind = new RubyNativeKind(node.type());
        NativeTreeImpl condition = new NativeTreeImpl(this.metaDataProvider.metaData(conditionRange), nativeKind, Arrays.asList(variables, expression));
        Tree body = (Tree)children2.get(2);
        if (body == null) {
            TextRange endRange = this.getTokenByAttribute(node, "end").textRange();
            body = this.createEmptyBlockTree(condition.textRange().end(), endRange.start());
        }
        return new LoopTreeImpl(this.metaData(node), condition, body, LoopTree.LoopKind.FOR, this.getTokenByAttribute(node, KEYWORD_ATTRIBUTE));
    }

    private Tree createFromKwBeginNode(AstNode node, List<?> children2) {
        if (children2.size() == 1 && children2.get(0) instanceof RubyPartialExceptionHandlingTree) {
            RubyPartialExceptionHandlingTree partialExceptionTree = (RubyPartialExceptionHandlingTree)children2.get(0);
            TreeMetaData treeMetaData = this.metaData(node);
            List<CatchTree> catchTrees = partialExceptionTree.catchBlocks();
            Tree tryBlock = partialExceptionTree.tryBlock();
            if (tryBlock == null) {
                List<Tree> exceptionChildren = partialExceptionTree.children();
                TextPointer to = exceptionChildren.isEmpty() ? treeMetaData.textRange().end() : exceptionChildren.get(0).textRange().start();
                tryBlock = this.createEmptyBlockTree(treeMetaData.textRange().start(), to);
            }
            Tree finallyBlock = partialExceptionTree.finallyBlock();
            if (!treeMetaData.commentsInside().isEmpty()) {
                TextRange endRange = this.getTokenByAttribute(node, "end").textRange();
                if (finallyBlock instanceof BlockTree && ((BlockTree)finallyBlock).statementOrExpressions().isEmpty()) {
                    TextPointer from = finallyBlock.metaData().textRange().start();
                    finallyBlock = this.createEmptyBlockTree(from, endRange.start());
                    endRange = finallyBlock.textRange();
                }
                catchTrees = this.updateEmptyBlockRanges(catchTrees, endRange, catchTree -> catchTree.catchBlock() instanceof BlockTree && ((BlockTree)catchTree.catchBlock()).statementOrExpressions().isEmpty(), (catchTree, newBlockTree) -> new CatchTreeImpl(newBlockTree.metaData(), catchTree.catchParameter(), (Tree)newBlockTree, catchTree.keyword()));
            }
            return new ExceptionHandlingTreeImpl(treeMetaData, tryBlock, treeMetaData.tokens().get(0), catchTrees, finallyBlock);
        }
        return this.createFromBeginNode(node, children2);
    }

    private Tree updateExceptionHandlingWithFinally(AstNode node, List<?> children2) {
        Tree body;
        if (!this.isValidTryCatchBlock()) {
            return this.createNativeTree(node, children2);
        }
        Tree finallyBlock = (Tree)children2.get(1);
        if (finallyBlock == null) {
            Token keyword = this.getTokenByAttribute(node, KEYWORD_ATTRIBUTE);
            finallyBlock = this.createEmptyBlockTree(keyword.textRange().start(), this.metaData(node).textRange().end());
        }
        RubyPartialExceptionHandlingTree exceptionHandlingTree = (body = (Tree)children2.get(0)) instanceof RubyPartialExceptionHandlingTree ? (RubyPartialExceptionHandlingTree)body : new RubyPartialExceptionHandlingTree(body, Collections.emptyList());
        exceptionHandlingTree.setFinallyBlock(finallyBlock);
        return exceptionHandlingTree;
    }

    private Tree createExceptionHandlingTree(AstNode node, List<?> children2) {
        if (!this.isValidTryCatchBlock()) {
            return this.createNativeTree(node, children2);
        }
        List<CatchTree> catchTrees = children2.stream().skip(1L).filter(CatchTree.class::isInstance).map(CatchTree.class::cast).collect(Collectors.toList());
        TreeMetaData treeMetaData = this.metaData(node);
        this.lookForTokenByAttribute(node, "else").map(elseToken -> {
            Tree lastClause = (Tree)children2.get(children2.size() - 1);
            if (lastClause == null) {
                lastClause = this.createEmptyBlockTree(elseToken.textRange().start(), treeMetaData.textRange().end());
            }
            TreeMetaData fullElseClauseMeta = this.metaDataProvider.metaData(TextRanges.merge(Arrays.asList(elseToken.textRange(), lastClause.textRange())));
            return new CatchTreeImpl(fullElseClauseMeta, null, lastClause, (Token)elseToken);
        }).ifPresent(catchTrees::add);
        Tree tryBlock = (Tree)children2.get(0);
        return new RubyPartialExceptionHandlingTree(tryBlock, catchTrees);
    }

    private Tree createCatchTree(AstNode node, List<?> children2) {
        if (!this.isValidTryCatchBlock()) {
            return this.createNativeTree(node, children2);
        }
        Token keyword = this.getTokenByAttribute(node, KEYWORD_ATTRIBUTE);
        List<Tree> catchParameterChildren = children2.stream().limit(2L).filter(Objects::nonNull).map(Tree.class::cast).collect(Collectors.toList());
        Tree catchParameter = null;
        if (catchParameterChildren.size() == 1) {
            catchParameter = (Tree)catchParameterChildren.get(0);
        } else if (!catchParameterChildren.isEmpty()) {
            List<TextRange> textRanges = catchParameterChildren.stream().map(Tree::textRange).collect(Collectors.toList());
            TextRange catchParameterRange = TextRanges.merge(textRanges);
            catchParameter = new NativeTreeImpl(this.metaDataProvider.metaData(catchParameterRange), new RubyNativeKind(node.type()), catchParameterChildren);
        }
        Tree body = (Tree)children2.get(2);
        if (body == null) {
            body = new BlockTreeImpl(this.metaData(node), Collections.emptyList());
        }
        return new CatchTreeImpl(this.metaData(node), catchParameter, body, keyword);
    }

    private Tree createFromAssign(AstNode node, List<?> children2) {
        IdentifierTree identifier = this.identifierFromSymbol(node, (RubySymbol)children2.get(0));
        if (children2.size() == 2) {
            return this.assignmentOrDeclaration(node, identifier, (Tree)children2.get(1));
        }
        return identifier;
    }

    private Tree createFromCasgn(AstNode node, List<?> children2) {
        IdentifierTree identifier = this.identifierFromSymbol(node, (RubySymbol)children2.get(1));
        if (children2.get(0) == null) {
            if (children2.size() == 3) {
                return this.assignmentOrDeclaration(node, identifier, (Tree)children2.get(2));
            }
            return identifier;
        }
        return this.createNativeTree(node, children2);
    }

    private Tree assignmentOrDeclaration(AstNode node, IdentifierTree identifier, Tree rhs) {
        return this.assignmentOrDeclaration(this.metaData(node), identifier, rhs);
    }

    private Tree assignmentOrDeclaration(TreeMetaData metaData, IdentifierTree identifier, Tree rhs) {
        if (RubyVisitor.isLocalVariable(identifier) && this.localVariables.peek().add(identifier.name())) {
            return new VariableDeclarationTreeImpl(metaData, identifier, null, rhs, false);
        }
        return new AssignmentExpressionTreeImpl(metaData, AssignmentExpressionTree.Operator.EQUAL, identifier, rhs);
    }

    private static boolean isLocalVariable(IdentifierTree identifier) {
        return !identifier.name().startsWith("@") && !identifier.name().startsWith("$") && !identifier.name().startsWith("_");
    }

    private Tree createFromOpAsgn(AstNode node, List<?> children2) {
        Token operatorToken = this.getTokenByAttribute(node, "operator");
        if (operatorToken.text().equals("+")) {
            return new AssignmentExpressionTreeImpl(this.metaData(node), AssignmentExpressionTree.Operator.PLUS_EQUAL, (Tree)children2.get(0), (Tree)children2.get(2));
        }
        return this.createNativeTree(node, children2);
    }

    private Tree createFromMlhs(AstNode node, List<?> children2) {
        return this.createNativeTree(node, children2, "array");
    }

    private Tree createFromMasgn(AstNode node, List<?> children2) {
        List lhsChild = RubyVisitor.getChildIfArray((Tree)children2.get(0)).stream().filter(IdentifierTree.class::isInstance).map(IdentifierTree.class::cast).collect(Collectors.toList());
        List<Tree> rhsChild = RubyVisitor.getChildIfArray((Tree)children2.get(1));
        if (lhsChild.isEmpty() || rhsChild.isEmpty() || lhsChild.size() != rhsChild.size()) {
            return new AssignmentExpressionTreeImpl(this.metaData(node), AssignmentExpressionTree.Operator.EQUAL, (Tree)children2.get(0), (Tree)children2.get(1));
        }
        ArrayList<Tree> assignments = new ArrayList<Tree>();
        for (int i2 = 0; i2 < lhsChild.size(); ++i2) {
            IdentifierTree id2 = (IdentifierTree)lhsChild.get(i2);
            assignments.add(this.assignmentOrDeclaration(id2.metaData(), id2, rhsChild.get(i2)));
        }
        return this.createNativeTree(node, assignments);
    }

    private static List<Tree> getChildIfArray(Tree node) {
        NativeTree nativeNode;
        if (node instanceof NativeTree && (nativeNode = (NativeTree)node).nativeKind().equals(new RubyNativeKind("array"))) {
            return nativeNode.children();
        }
        return Collections.emptyList();
    }

    private Tree createFromVar(AstNode node, List<?> children2) {
        return this.identifierFromSymbol(node, (RubySymbol)children2.get(0));
    }

    private Tree createFromIndexasgn(AstNode node, List<?> children2) {
        if (children2.size() > 2) {
            TreeMetaData metaData = this.metaData(node);
            Token firstToken = metaData.tokens().get(0);
            TextRange closeBracketRange = node.textRangeForAttribute("end");
            TextRange lhsRange = TextRanges.merge(Arrays.asList(firstToken.textRange(), closeBracketRange));
            TreeMetaData lhsMeta = this.metaDataProvider.metaData(lhsRange);
            List<Tree> lhsChildren = children2.subList(0, children2.size() - 1).stream().filter(Tree.class::isInstance).map(Tree.class::cast).collect(Collectors.toList());
            NativeTreeImpl lhs = new NativeTreeImpl(lhsMeta, new RubyNativeKind("index"), lhsChildren);
            return new AssignmentExpressionTreeImpl(metaData, AssignmentExpressionTree.Operator.EQUAL, lhs, (Tree)children2.get(children2.size() - 1));
        }
        return this.createNativeTree(node, children2, "index");
    }

    private Tree createParameterTree(AstNode node, List<?> children2) {
        if (children2.isEmpty() || !(children2.get(0) instanceof RubySymbol)) {
            return this.createNativeTree(node, children2);
        }
        IdentifierTree identifierTree = this.identifierFromSymbol(node, (RubySymbol)children2.get(0));
        Tree defaultValue = null;
        if ("optarg".equals(node.type()) || "kwoptarg".equals(node.type())) {
            defaultValue = (Tree)children2.get(1);
        }
        return new ParameterTreeImpl(this.metaData(node), identifierTree, null, defaultValue);
    }

    private Tree createCaseTree(AstNode node, List<?> children2) {
        Tree expression = (Tree)children2.get(0);
        Tree body = (Tree)children2.get(1);
        if (body == null) {
            body = new BlockTreeImpl(this.metaData(node), Collections.emptyList());
        }
        return new MatchCaseTreeImpl(this.metaData(node), expression, body);
    }

    private Tree createMatchTree(AstNode node, List<?> children2) {
        Token caseKeywordToken = this.getTokenByAttribute(node, KEYWORD_ATTRIBUTE);
        List<MatchCaseTree> whens = children2.stream().filter(MatchCaseTree.class::isInstance).map(MatchCaseTree.class::cast).collect(Collectors.toList());
        TreeMetaData treeMetaData = this.metaData(node);
        this.lookForTokenByAttribute(node, "else").map(elseKeywordToken -> {
            Tree elseBody = (Tree)children2.get(children2.size() - 1);
            if (elseBody == null) {
                elseBody = this.createEmptyBlockTree(elseKeywordToken.textRange().end(), treeMetaData.textRange().end());
            }
            TextRangeImpl textRange = new TextRangeImpl(elseKeywordToken.textRange().start(), elseBody.textRange().end());
            return new MatchCaseTreeImpl(this.metaDataProvider.metaData(textRange), null, elseBody);
        }).ifPresent(whens::add);
        if (!treeMetaData.commentsInside().isEmpty()) {
            TextRange endRange = node.textRangeForAttribute("end");
            whens = this.updateEmptyBlockRanges(whens, endRange, caseTree -> caseTree.body() instanceof BlockTree && ((BlockTree)caseTree.body()).statementOrExpressions().isEmpty(), (caseTree, newBlockTree) -> new MatchCaseTreeImpl(newBlockTree.metaData(), caseTree.expression(), (Tree)newBlockTree));
        }
        return new MatchTreeImpl(treeMetaData, (Tree)children2.get(0), whens, caseKeywordToken);
    }

    private Tree createStringLiteralTree(AstNode node, List<?> children2) {
        if (this.hasDynamicStringParent()) {
            return this.createNativeTree(node, children2);
        }
        String value2 = (String)children2.get(0);
        if ("(Analysis of Ruby)".equals(value2)) {
            return this.createNativeTree(node, children2);
        }
        TextRange begin2 = node.textRangeForAttribute("begin");
        TextRange end2 = node.textRangeForAttribute("end");
        TreeMetaData treeMetaData = begin2 != null && end2 != null ? this.metaDataProvider.metaData(new TextRangeImpl(begin2.start(), end2.end())) : this.metaData(node);
        return new StringLiteralTreeImpl(treeMetaData, node.source(), value2);
    }

    private boolean hasDynamicStringParent() {
        return this.nodeTypeStack.stream().anyMatch("dstr"::equals);
    }

    private boolean isValidTryCatchBlock() {
        for (String parentType : this.nodeTypeStack) {
            if (EXCEPTION_BLOCK_TYPES.contains(parentType)) continue;
            return "kwbegin".equals(parentType);
        }
        return false;
    }

    private <T extends Tree> List<T> updateEmptyBlockRanges(List<T> trees, @Nullable TextRange endRange, Predicate<T> hasEmptyBlock, BiFunction<T, BlockTree, T> createNewTree) {
        TextRange nextRange = endRange;
        ArrayList<Tree> newTrees = new ArrayList<Tree>(trees.size());
        ListIterator<T> iterator = trees.listIterator(trees.size());
        while (iterator.hasPrevious()) {
            Tree tree = (Tree)iterator.previous();
            if (nextRange != null && hasEmptyBlock.test(tree)) {
                BlockTree newBlockTree = this.createEmptyBlockTree(tree.textRange().start(), nextRange.start());
                Tree newCatchTree = (Tree)createNewTree.apply(tree, newBlockTree);
                newTrees.add(newCatchTree);
            } else {
                newTrees.add(tree);
            }
            nextRange = tree.textRange();
        }
        Collections.reverse(newTrees);
        return newTrees;
    }

    private Tree createLogicalOperation(AstNode node, List<?> children2, BinaryExpressionTree.Operator operator) {
        Tree left2 = (Tree)children2.get(0);
        Tree right = (Tree)children2.get(1);
        Token operatorToken = this.getTokenByAttribute(node, "operator");
        return new BinaryExpressionTreeImpl(this.metaData(node), operator, operatorToken, left2, right);
    }

    private Tree createFromBeginNode(AstNode node, List<?> children2) {
        Optional<Token> beginToken = this.lookForTokenByAttribute(node, "begin");
        Optional<Token> endToken = this.lookForTokenByAttribute(node, "end");
        if (beginToken.isPresent() && endToken.isPresent() && children2.size() == 1 && beginToken.get().text().equals("(")) {
            return new ParenthesizedExpressionTreeImpl(this.metaData(node), (Tree)children2.get(0), beginToken.get(), endToken.get());
        }
        List<Tree> nonNullChildren = this.convertChildren(node, children2);
        RubyVisitor.setModifiers(nonNullChildren);
        return new BlockTreeImpl(this.metaData(node), nonNullChildren);
    }

    private static void setModifiers(List<Tree> children2) {
        ModifierTree currentModifierTree = null;
        for (Tree child : children2) {
            if (child instanceof ModifierTree) {
                currentModifierTree = (ModifierTree)child;
                continue;
            }
            if (currentModifierTree == null || !(child instanceof FunctionDeclarationTree)) continue;
            ((FunctionDeclarationTreeImpl)child).setModifiers(Arrays.asList(currentModifierTree));
        }
    }

    private Tree createFromSendNode(AstNode node, List<?> children2) {
        Object callee = children2.get(1);
        if (callee instanceof RubySymbol) {
            String calleeSymbol = ((RubySymbol)callee).asJavaString();
            if (UNARY_OPERATOR_MAP.containsKey(calleeSymbol)) {
                Tree argument = (Tree)children2.get(0);
                return new UnaryExpressionTreeImpl(this.metaData(node), UNARY_OPERATOR_MAP.get(calleeSymbol), argument);
            }
            if (BINARY_OPERATOR_MAP.containsKey(calleeSymbol)) {
                Tree left2 = (Tree)children2.get(0);
                Tree right = (Tree)children2.get(2);
                Token operatorToken = this.getTokenByAttribute(node, "selector");
                return new BinaryExpressionTreeImpl(this.metaData(node), BINARY_OPERATOR_MAP.get(calleeSymbol), operatorToken, left2, right);
            }
            if (MODIFIER_MAP.containsKey(calleeSymbol)) {
                return this.createModifierTree(MODIFIER_MAP.get(calleeSymbol), node, children2);
            }
            if ("raise".equals(calleeSymbol)) {
                return this.createThrowTree(node, children2);
            }
        }
        return this.createNativeTree(node, children2);
    }

    private Tree createModifierTree(ModifierTree.Kind modifier, AstNode node, List<?> children2) {
        if (children2.size() <= 2) {
            return new ModifierTreeImpl(this.metaData(node), modifier);
        }
        TreeMetaData metadata = this.metaData(node);
        TreeMetaData modifierMetadata = this.metaDataProvider.metaData(metadata.tokens().get(0).textRange());
        ModifierTreeImpl modifierTree = new ModifierTreeImpl(modifierMetadata, modifier);
        ArrayList<Tree> newChildren = new ArrayList<Tree>();
        newChildren.add(modifierTree);
        newChildren.addAll(this.convertChildren(node, children2.subList(2, children2.size())));
        RubyVisitor.setModifiers(newChildren);
        return new NativeTreeImpl(metadata, new RubyNativeKind("modifier"), newChildren);
    }

    private Tree createThrowTree(AstNode node, List<?> children2) {
        Tree body = null;
        if (children2.size() > 3) {
            List<Tree> raiseChildren = this.convertChildren(node, children2.subList(2, children2.size()));
            body = new NativeTreeImpl(this.metaData(node), new RubyNativeKind("raise"), raiseChildren);
        } else if (children2.size() > 2) {
            body = (Tree)children2.get(2);
        }
        return new ThrowTreeImpl(this.metaData(node), this.getTokenByAttribute(node, "selector"), body);
    }

    private FunctionDeclarationTree createFunctionDeclarationTree(AstNode node, List<?> children2) {
        BlockTree body;
        boolean isSingletonMethod = node.type().equals("defs");
        List<Tree> nativeChildren = isSingletonMethod ? Collections.singletonList((Tree)children2.get(0)) : Collections.emptyList();
        int childrenIndexShift = isSingletonMethod ? 1 : 0;
        IdentifierTree name2 = this.identifierFromSymbol(node, (RubySymbol)children2.get(0 + childrenIndexShift));
        boolean isConstructor = "initialize".equals(name2.identifier());
        Object args2 = children2.get(1 + childrenIndexShift);
        List<Tree> parameters2 = args2 != null ? ((Tree)args2).children() : Collections.emptyList();
        Tree rubyBodyBlock = (Tree)children2.get(2 + childrenIndexShift);
        if (rubyBodyBlock instanceof BlockTree) {
            body = (BlockTree)rubyBodyBlock;
        } else if (rubyBodyBlock != null) {
            List<Tree> statements = Collections.singletonList(rubyBodyBlock);
            body = new BlockTreeImpl(rubyBodyBlock.metaData(), statements);
        } else {
            body = new BlockTreeImpl(this.metaData(node), Collections.emptyList());
        }
        return new FunctionDeclarationTreeImpl(this.metaData(node), Collections.emptyList(), isConstructor, null, name2, parameters2, body, nativeChildren);
    }

    private ClassDeclarationTree createClassDeclarationTree(AstNode node, List<?> children2) {
        IdentifierTree classNameIdentifier;
        NativeTree nativeTree = this.createNativeTree(node, children2);
        if (nativeTree == null) {
            throw new IllegalStateException("Failed to create ClassDeclarationTree for node " + node.asString());
        }
        Object nameChild = children2.get(0);
        if (nameChild instanceof IdentifierTree) {
            classNameIdentifier = (IdentifierTree)nameChild;
        } else {
            List<Tree> nameChildren = ((Tree)nameChild).children();
            classNameIdentifier = (IdentifierTree)nameChildren.get(nameChildren.size() - 1);
        }
        return new ClassDeclarationTreeImpl(this.metaData(node), classNameIdentifier, nativeTree);
    }

    private LiteralTree createIntegerLiteralTree(AstNode node) {
        return new IntegerLiteralTreeImpl(this.metaData(node), node.source());
    }

    private Tree createFromConst(AstNode node, List<?> children2) {
        IdentifierTree identifier = this.identifierFromSymbol(node, (RubySymbol)children2.get(1));
        if (children2.get(0) == null) {
            return identifier;
        }
        ArrayList newChildren = new ArrayList(children2);
        newChildren.set(newChildren.size() - 1, identifier);
        return this.createNativeTree(node, newChildren);
    }

    private Tree createIfTree(AstNode node, List<?> children2) {
        Optional<Token> mainKeyword = this.lookForTokenByAttribute(node, KEYWORD_ATTRIBUTE);
        if (!mainKeyword.isPresent()) {
            Tree condition = (Tree)children2.get(0);
            Tree thenBranch = (Tree)children2.get(1);
            Tree elseBranch = (Tree)children2.get(2);
            Token ifToken = this.previousToken(thenBranch.textRange(), "?");
            Token elseToken = this.previousToken(elseBranch.textRange(), ":");
            return new IfTreeImpl(this.metaData(node), condition, thenBranch, elseBranch, ifToken, elseToken);
        }
        Token operator = mainKeyword.get();
        Tree condition = (Tree)children2.get(0);
        Tree thenCandidate = (Tree)children2.get(1);
        Token elseKeyword = this.lookForTokenByAttribute(node, "else").orElse(null);
        Tree elseCandidate = (Tree)children2.get(2);
        if ("unless".equals(operator.text())) {
            Tree swap = thenCandidate;
            thenCandidate = elseCandidate;
            elseCandidate = swap;
        }
        Tree thenBranch = this.getThenBranch(node, operator, elseKeyword, thenCandidate);
        Tree elseBranch = this.getElseBranch(node, elseKeyword, elseCandidate);
        return new IfTreeImpl(this.metaData(node), condition, thenBranch, elseBranch, operator, elseKeyword);
    }

    private Token previousToken(TextRange textRange, String expectedTokenValue) {
        return this.metaDataProvider.previousToken(textRange, expectedTokenValue).orElseThrow(() -> new IllegalStateException(String.format("Unable to locate token with value '%s' before position [Line:%d,Offset:%d].", expectedTokenValue, textRange.start().line(), textRange.start().lineOffset())));
    }

    private Tree getThenBranch(AstNode node, Token mainKeyword, @Nullable Token elseKeyword, @Nullable Tree thenBranch) {
        if (thenBranch != null) {
            return thenBranch;
        }
        if (elseKeyword == null) {
            return new BlockTreeImpl(this.metaData(node), Collections.emptyList());
        }
        return this.createEmptyBlockTree(mainKeyword.textRange().start(), elseKeyword.textRange().start());
    }

    private Tree getElseBranch(AstNode node, @Nullable Token elseKeyword, @Nullable Tree elseBranch) {
        if (elseBranch != null) {
            boolean isFinalElseBranch;
            boolean bl = isFinalElseBranch = elseKeyword != null && elseKeyword.text().equals("else");
            if (isFinalElseBranch && elseBranch instanceof IfTree) {
                return new BlockTreeImpl(elseBranch.metaData(), Collections.singletonList(elseBranch));
            }
            return elseBranch;
        }
        if (elseKeyword != null) {
            return this.createEmptyBlockTree(elseKeyword.textRange().start(), this.metaData(node).textRange().end());
        }
        return null;
    }

    private BlockTree createEmptyBlockTree(TextPointer from, TextPointer to) {
        TextRangeImpl emptyBlockRange = new TextRangeImpl(from, to);
        return new BlockTreeImpl(this.metaDataProvider.metaData(emptyBlockRange), Collections.emptyList());
    }

    private Tree createJumpTree(AstNode node, List<?> children2, JumpTree.JumpKind kind) {
        if (!children2.isEmpty()) {
            return this.createNativeTree(node, children2);
        }
        Token keyword = this.getTokenByAttribute(node, KEYWORD_ATTRIBUTE);
        return new JumpTreeImpl(this.metaData(node), keyword, kind, null);
    }

    private Tree createReturnTree(AstNode node, List<?> children2) {
        Token keyword = this.getTokenByAttribute(node, KEYWORD_ATTRIBUTE);
        Tree expression = null;
        if (children2.size() == 1) {
            expression = (Tree)children2.get(0);
        } else if (!children2.isEmpty()) {
            List<Tree> childTrees = this.convertChildren(node, children2);
            TextRange childRange = TextRanges.merge(childTrees.stream().map(Tree::textRange).collect(Collectors.toList()));
            expression = new NativeTreeImpl(this.metaDataProvider.metaData(childRange), new RubyNativeKind("returnExpression"), childTrees);
        }
        return new ReturnTreeImpl(this.metaData(node), keyword, expression);
    }

    @CheckForNull
    private NativeTree createNativeTree(AstNode node, List<?> children2, String type2) {
        List<Tree> nonNullChildren = this.convertChildren(node, children2);
        return new NativeTreeImpl(this.metaData(node), new RubyNativeKind(type2), nonNullChildren);
    }

    private List<Tree> convertChildren(AstNode node, List<?> children2) {
        return children2.stream().flatMap(child -> this.treeForChild(node, child)).collect(Collectors.toList());
    }

    @CheckForNull
    private NativeTree createNativeTree(AstNode node, List<?> children2) {
        if (node.textRange() == null) {
            return null;
        }
        return this.createNativeTree(node, children2, node.type());
    }

    private Stream<Tree> treeForChild(AstNode node, @Nullable Object child) {
        if (child instanceof Tree) {
            return Stream.of((Tree)child);
        }
        if (child instanceof RubySymbol) {
            return Stream.of(this.identifierFromSymbol(node, (RubySymbol)child));
        }
        if (child != null) {
            return Stream.of(this.createNativeTree(node, Collections.emptyList(), String.valueOf(child)));
        }
        return Stream.empty();
    }

    private TreeMetaData metaData(AstNode node) {
        TextRange textRange = node.textRange();
        if (textRange == null) {
            throw new IllegalStateException("Attempt to retrieve metadata for null location. Node: " + node.asString());
        }
        return this.metaDataProvider.metaData(textRange);
    }

    private Optional<Token> lookForTokenByAttribute(AstNode node, String attribute) {
        TextRange mainKeywordTextRange = node.textRangeForAttribute(attribute);
        if (mainKeywordTextRange != null) {
            return Optional.of(this.metaDataProvider.metaData(mainKeywordTextRange).tokens().get(0));
        }
        return Optional.empty();
    }

    private Token getTokenByAttribute(AstNode node, String attribute) {
        Optional<Token> token = this.lookForTokenByAttribute(node, attribute);
        return token.orElseThrow(() -> new IllegalStateException(String.format("No attribute '%s' found for node of type '%s'", attribute, node.type())));
    }

    private IdentifierTree identifierFromSymbol(AstNode node, RubySymbol rubySymbol) {
        String name2 = rubySymbol.asJavaString();
        TextRange textRange = node.textRangeForAttribute("name");
        if (textRange == null) {
            textRange = node.textRange();
        }
        if (textRange == null) {
            throw new IllegalStateException("Missing range for identifier. Node: " + node.asString());
        }
        return new IdentifierTreeImpl(this.metaDataProvider.metaData(textRange), name2);
    }

    static {
        BINARY_OPERATOR_MAP.put("==", BinaryExpressionTree.Operator.EQUAL_TO);
        BINARY_OPERATOR_MAP.put("!=", BinaryExpressionTree.Operator.NOT_EQUAL_TO);
        BINARY_OPERATOR_MAP.put("<", BinaryExpressionTree.Operator.LESS_THAN);
        BINARY_OPERATOR_MAP.put(">", BinaryExpressionTree.Operator.GREATER_THAN);
        BINARY_OPERATOR_MAP.put("<=", BinaryExpressionTree.Operator.LESS_THAN_OR_EQUAL_TO);
        BINARY_OPERATOR_MAP.put(">=", BinaryExpressionTree.Operator.GREATER_THAN_OR_EQUAL_TO);
        BINARY_OPERATOR_MAP.put("||", BinaryExpressionTree.Operator.CONDITIONAL_OR);
        BINARY_OPERATOR_MAP.put("&&", BinaryExpressionTree.Operator.CONDITIONAL_AND);
        BINARY_OPERATOR_MAP.put("+", BinaryExpressionTree.Operator.PLUS);
        BINARY_OPERATOR_MAP.put("-", BinaryExpressionTree.Operator.MINUS);
        BINARY_OPERATOR_MAP.put("*", BinaryExpressionTree.Operator.TIMES);
        BINARY_OPERATOR_MAP.put("/", BinaryExpressionTree.Operator.DIVIDED_BY);
        UNARY_OPERATOR_MAP = new HashMap<String, UnaryExpressionTree.Operator>();
        UNARY_OPERATOR_MAP.put("!", UnaryExpressionTree.Operator.NEGATE);
        UNARY_OPERATOR_MAP.put("+@", UnaryExpressionTree.Operator.PLUS);
        UNARY_OPERATOR_MAP.put("-@", UnaryExpressionTree.Operator.MINUS);
        MODIFIER_MAP = new HashMap<String, ModifierTree.Kind>();
        MODIFIER_MAP.put("public", ModifierTree.Kind.PUBLIC);
        MODIFIER_MAP.put("private", ModifierTree.Kind.PRIVATE);
        MODIFIER_MAP.put("protected", ModifierTree.Kind.PROTECTED);
        LOCAL_SCOPE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("def", "defs", "class")));
    }
}

