/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.converter.adapter;

import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;
import org.sonarsource.analyzer.commons.TokenLocation;
import org.sonarsource.ruby.converter.adapter.JRubyObjectAdapter;
import org.sonarsource.ruby.converter.adapter.SourceMapAdapter;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.impl.CommentImpl;
import org.sonarsource.slang.impl.TextRanges;

public class CommentAdapter
extends JRubyObjectAdapter<IRubyObject> {
    private static final String MULTILINE_COMMENT_START = "=begin";
    private static final String MULTILINE_COMMENT_END = "=end";

    public CommentAdapter(Ruby runtime2, IRubyObject underlyingRubyObject) {
        super(runtime2, underlyingRubyObject);
    }

    public Comment toSlangComment() {
        String text = this.getFromUnderlying("text", String.class);
        TextRange initialTextRange = this.getTextRange();
        if (text.startsWith("#")) {
            String contentText = text.substring(1);
            int newStartLineOffset = initialTextRange.start().lineOffset() + 1;
            TextRange contentRange = TextRanges.range(initialTextRange.start().line(), newStartLineOffset, initialTextRange.end().line(), initialTextRange.end().lineOffset());
            return new CommentImpl(text, contentText, initialTextRange, contentRange);
        }
        TokenLocation textLocation = new TokenLocation(initialTextRange.start().line(), 0, text);
        TextRange trimmedTextRange = TextRanges.range(textLocation.startLine(), textLocation.startLineOffset(), textLocation.endLine(), textLocation.endLineOffset());
        String contentText = CommentAdapter.getContentText(text);
        TextRange contentRange = CommentAdapter.getContentTextRange(text, textLocation, contentText);
        return new CommentImpl(text, contentText, trimmedTextRange, contentRange);
    }

    static String getContentText(String text) {
        int contentEnd;
        int contentStart = 0;
        if (text.startsWith(MULTILINE_COMMENT_START)) {
            contentStart = MULTILINE_COMMENT_START.length();
        }
        for (contentEnd = text.length(); contentEnd > 0 && text.charAt(contentEnd - 1) <= ' '; --contentEnd) {
        }
        int expectedEnd = contentEnd - MULTILINE_COMMENT_END.length();
        if (text.indexOf(MULTILINE_COMMENT_END, expectedEnd) == expectedEnd) {
            contentEnd = expectedEnd;
        }
        return text.substring(contentStart, contentEnd);
    }

    static TextRange getContentTextRange(String text, TokenLocation textLocation, String contentText) {
        int contentStartIndex = text.indexOf(contentText);
        String whitespacesContentPrefix = text.substring(0, contentStartIndex);
        TokenLocation prefixLocation = new TokenLocation(textLocation.startLine(), textLocation.startLineOffset(), whitespacesContentPrefix);
        TokenLocation contentLocation = new TokenLocation(prefixLocation.endLine(), prefixLocation.endLineOffset(), contentText);
        return TextRanges.range(contentLocation.startLine(), contentLocation.startLineOffset(), contentLocation.endLine(), contentLocation.endLineOffset());
    }

    private TextRange getTextRange() {
        IRubyObject location = this.getFromUnderlying("location", IRubyObject.class);
        SourceMapAdapter sourceMapAdapter = new SourceMapAdapter(this.runtime, location);
        return sourceMapAdapter.getRange().toTextRange();
    }
}

