/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.config.Configuration;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.JSONParser;
import org.sonarsource.ruby.plugin.RubyExclusionsFileFilter;

public class SimpleCovSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCovSensor.class);
    private final RubyExclusionsFileFilter rubyExclusionsFileFilter;

    public SimpleCovSensor(RubyExclusionsFileFilter rubyExclusionsFileFilter) {
        this.rubyExclusionsFileFilter = rubyExclusionsFileFilter;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("SimpleCov Sensor for Ruby coverage").onlyOnLanguage("ruby");
    }

    public void execute(SensorContext context) {
        try {
            Map<Path, String> reports = SimpleCovSensor.getReportFilesAndContents(context);
            if (reports.isEmpty()) {
                return;
            }
            JSONParser parser = new JSONParser();
            HashMap<String, Map<Integer, Integer>> mergedCoverages = new HashMap<String, Map<Integer, Integer>>();
            reports.forEach((path2, report) -> SimpleCovSensor.safeReadCoverageReport(parser, mergedCoverages, path2, report));
            this.saveCoverage(context, mergedCoverages);
        }
        catch (IOException e) {
            LOG.error("Error reading coverage reports", (Throwable)e);
        }
    }

    private static void safeReadCoverageReport(JSONParser parser, Map<String, Map<Integer, Integer>> mergedCoverages, Path reportPath, String report) {
        try {
            JSONObject parseResult = (JSONObject)parser.parse(report);
            SimpleCovSensor.mergeFileCoverages(mergedCoverages, parseResult);
        }
        catch (Exception e) {
            LOG.error("Cannot read coverage report file, expecting standard SimpleCov JSON formatter output: '{}'", (Object)reportPath, (Object)e);
        }
    }

    private void saveCoverage(SensorContext context, Map<String, Map<Integer, Integer>> mergedCoverages) {
        FileSystem fileSystem = context.fileSystem();
        FilePredicates predicates = fileSystem.predicates();
        for (Map.Entry<String, Map<Integer, Integer>> coverageForFile : mergedCoverages.entrySet()) {
            String filePath = coverageForFile.getKey();
            InputFile inputFile = fileSystem.inputFile(predicates.hasAbsolutePath(filePath));
            if (inputFile != null) {
                try {
                    SimpleCovSensor.saveNewCoverage(context, coverageForFile.getValue(), inputFile);
                }
                catch (IllegalStateException e) {
                    LOG.error("Invalid coverage information on file: '{}'", (Object)filePath, (Object)e);
                }
                continue;
            }
            if (!this.rubyExclusionsFileFilter.isNotExcluded(filePath)) continue;
            LOG.warn("File '{}' is present in coverage report but cannot be found in filesystem", (Object)filePath);
        }
    }

    private static void saveNewCoverage(SensorContext context, Map<Integer, Integer> hitsPerLines, InputFile inputFile) {
        NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
        for (Map.Entry<Integer, Integer> hitsPerLine : hitsPerLines.entrySet()) {
            if (hitsPerLine.getValue() == null) continue;
            newCoverage.lineHits(hitsPerLine.getKey().intValue(), hitsPerLine.getValue().intValue());
        }
        newCoverage.save();
    }

    private static void mergeFileCoverages(Map<String, Map<Integer, Integer>> coveragePerFiles, Map<String, JSONObject> upperJsonObjects) {
        upperJsonObjects.forEach((key2, value2) -> {
            JSONObject testFrameworkCoverage;
            if ("coverage".equals(key2)) {
                SimpleCovSensor.mergeFrameworkCoveragesFromJsonFormatter(coveragePerFiles, value2);
            }
            if ((testFrameworkCoverage = (JSONObject)value2.get("coverage")) != null) {
                LOG.warn("Importing SimpleCov resultset JSON will not be supported from simplecov 18.0. Consider using the JSON formatter, available from SimpleCov 20.0");
                SimpleCovSensor.mergeFrameworkCoveragesFromResultSet(coveragePerFiles, testFrameworkCoverage);
            }
        });
    }

    private static void mergeFrameworkCoveragesFromJsonFormatter(Map<String, Map<Integer, Integer>> coveragePerFiles, Map<String, JSONObject> fileCoverageObject) {
        fileCoverageObject.forEach((key2, value2) -> {
            JSONArray hitsPerLine = (JSONArray)value2.get("lines");
            SimpleCovSensor.mergeHitPerLines(coveragePerFiles, key2, hitsPerLine);
        });
    }

    private static void mergeFrameworkCoveragesFromResultSet(Map<String, Map<Integer, Integer>> coveragePerFiles, Map<String, JSONArray> testFrameworkCoveragePerFiles) {
        testFrameworkCoveragePerFiles.forEach((key2, value2) -> SimpleCovSensor.mergeHitPerLines(coveragePerFiles, key2, value2));
    }

    private static void mergeHitPerLines(Map<String, Map<Integer, Integer>> coveragePerFiles, String currentFile, JSONArray hitsPerLine) {
        Map fileCoverage = coveragePerFiles.computeIfAbsent(currentFile, key2 -> new HashMap());
        for (int i2 = 0; i2 < hitsPerLine.size(); ++i2) {
            Object hits = hitsPerLine.get(i2);
            int line = i2 + 1;
            Integer currentHits = fileCoverage.getOrDefault(line, 0);
            if (hits instanceof Long) {
                fileCoverage.put(line, SimpleCovSensor.mergeHitsForLine(((Long)hits).intValue(), currentHits));
                continue;
            }
            if (hits != null) continue;
            fileCoverage.put(line, SimpleCovSensor.mergeHitsForLine(null, currentHits));
        }
    }

    @CheckForNull
    static Integer mergeHitsForLine(@Nullable Integer first2, @Nullable Integer second) {
        if (first2 == null) {
            if (second == null || second == 0) {
                return null;
            }
            return second;
        }
        if (second == null) {
            if (first2 == 0) {
                return null;
            }
            return first2;
        }
        return first2 + second;
    }

    private static Map<Path, String> getReportFilesAndContents(SensorContext context) throws IOException {
        HashMap<Path, String> reports = new HashMap<Path, String>();
        Configuration config = context.config();
        FileSystem fs = context.fileSystem();
        for (String reportPath : config.getStringArray("sonar.ruby.coverage.reportPaths")) {
            String trimmedPath = reportPath.trim();
            String report = SimpleCovSensor.fileContent(fs, trimmedPath);
            if (report != null) {
                reports.put(Paths.get(trimmedPath, new String[0]), report);
                continue;
            }
            if (!config.hasKey("sonar.ruby.coverage.reportPaths")) continue;
            LOG.error("SimpleCov report not found: '{}'", (Object)trimmedPath);
        }
        return reports;
    }

    @CheckForNull
    private static String fileContent(FileSystem fs, String reportPath) throws IOException {
        InputFile report = fs.inputFile(fs.predicates().hasPath(reportPath));
        if (report != null && report.isFile()) {
            return report.contents();
        }
        File reportFile = fs.resolvePath(reportPath);
        if (reportFile.isFile()) {
            return new String(Files.readAllBytes(reportFile.toPath()), StandardCharsets.UTF_8);
        }
        return null;
    }
}

