/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.CodeVerifier;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.impl.TextRanges;

@Rule(key="S125")
public class CommentedCodeCheck
implements SlangCheck {
    private CodeVerifier codeVerifier;
    private static final String MESSAGE = "Remove this commented out code.";

    public CommentedCodeCheck(CodeVerifier codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> {
            List<List<Comment>> groupedComments = CommentedCodeCheck.groupComments(tree.allComments());
            groupedComments.forEach(comments -> {
                String content = comments.stream().map(Comment::contentText).collect(Collectors.joining("\n"));
                if (this.codeVerifier.containsCode(content)) {
                    List<TextRange> textRanges = comments.stream().map(HasTextRange::textRange).toList();
                    ctx.reportIssue(TextRanges.merge(textRanges), MESSAGE);
                }
            });
        });
    }

    private static List<List<Comment>> groupComments(List<Comment> comments) {
        ArrayList<List<Comment>> groups2 = new ArrayList<List<Comment>>();
        List<Comment> currentGroup = null;
        for (Comment comment : comments) {
            if (currentGroup == null) {
                currentGroup = CommentedCodeCheck.initNewGroup(comment);
                continue;
            }
            if (CommentedCodeCheck.areAdjacent(currentGroup.get(currentGroup.size() - 1), comment)) {
                currentGroup.add(comment);
                continue;
            }
            groups2.add(currentGroup);
            currentGroup = CommentedCodeCheck.initNewGroup(comment);
        }
        if (currentGroup != null) {
            groups2.add(currentGroup);
        }
        return groups2;
    }

    private static List<Comment> initNewGroup(Comment comment) {
        ArrayList<Comment> group2 = new ArrayList<Comment>();
        group2.add(comment);
        return group2;
    }

    private static boolean areAdjacent(Comment commentA, Comment commentB) {
        return commentA.textRange().start().line() + 1 == commentB.textRange().start().line();
    }
}

