/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.Language;
import org.sonarsource.slang.checks.utils.PropertyDefaultValue;
import org.sonarsource.slang.checks.utils.PropertyDefaultValues;

@Rule(key="S104")
public class TooManyLinesOfCodeFileCheck
implements SlangCheck {
    private static final int DEFAULT_MAX = 1000;
    private static final String DEFAULT_MAX_VALUE = "1000";
    @RuleProperty(key="Max", description="Maximum authorized lines of code in a file.")
    @PropertyDefaultValues(value={@PropertyDefaultValue(language=Language.RUBY, defaultValue="1000"), @PropertyDefaultValue(language=Language.SCALA, defaultValue="1000"), @PropertyDefaultValue(language=Language.GO, defaultValue="750")})
    public int max = 1000;

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> {
            int numberOfLinesOfCode = tree.metaData().linesOfCode().size();
            if (numberOfLinesOfCode > this.max) {
                String message2 = String.format("File \"%s\" has %s lines, which is greater than %s authorized. Split it into smaller files.", ctx.filename(), numberOfLinesOfCode, this.max);
                ctx.reportFileIssue(message2);
            }
        });
    }
}

