/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.CatchTree;
import org.sonarsource.slang.api.ExceptionHandlingTree;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.BaseTreeImpl;

public class ExceptionHandlingTreeImpl
extends BaseTreeImpl
implements ExceptionHandlingTree {
    private final Tree tryBlock;
    private final List<CatchTree> catchBlocks;
    private final Tree finallyBlock;
    private final Token tryKeyword;

    public ExceptionHandlingTreeImpl(TreeMetaData metaData, Tree tryBlock, Token tryKeyword, List<CatchTree> catchBlocks, @Nullable Tree finallyBlock) {
        super(metaData);
        this.tryBlock = tryBlock;
        this.catchBlocks = catchBlocks;
        this.finallyBlock = finallyBlock;
        this.tryKeyword = tryKeyword;
    }

    @Override
    public Tree tryBlock() {
        return this.tryBlock;
    }

    @Override
    public List<CatchTree> catchBlocks() {
        return this.catchBlocks;
    }

    @Override
    @CheckForNull
    public Tree finallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public Token tryKeyword() {
        return this.tryKeyword;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children2 = new ArrayList<Tree>();
        children2.add(this.tryBlock);
        children2.addAll(this.catchBlocks);
        if (this.finallyBlock != null) {
            children2.add(this.finallyBlock);
        }
        return children2;
    }
}

