/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.persistence.conversion;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.HashMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.sonarsource.slang.persistence.conversion.DeserializationContext;
import org.sonarsource.slang.persistence.conversion.SerializationContext;

public class PolymorphicConverter {
    private final HashMap<Class<?>, Serialize<?>> toJsonConverter = new HashMap();
    private final HashMap<String, Deserialize<?>> fromJsonConverter = new HashMap();
    private final HashMap<Class<?>, String> jsonTypeByJavaClass = new HashMap();

    public <T> void register(Class<T> treeClass, String jsonType, Serialize<T> treeToJson, Deserialize<T> jsonToTree) {
        this.toJsonConverter.put(treeClass, treeToJson);
        this.fromJsonConverter.put(jsonType, jsonToTree);
        this.jsonTypeByJavaClass.put(treeClass, jsonType);
    }

    public String getJsonType(Object object) {
        return this.jsonTypeByJavaClass.get(object.getClass());
    }

    public <T> JsonValue toJson(SerializationContext ctx, @Nullable T object) {
        if (object == null) {
            return Json.NULL;
        }
        Class<?> objectClass = object.getClass();
        Serialize<?> converter = this.toJsonConverter.get(objectClass);
        if (converter == null) {
            throw new IllegalStateException("Unsupported tree class: " + objectClass.getName());
        }
        return (JsonValue)converter.apply(ctx, object);
    }

    public <T> T fromJson(DeserializationContext ctx, String jsonType, JsonObject json, String memberName, Class<T> expectedClass) {
        ctx.pushPath(jsonType);
        Deserialize<?> converter = this.fromJsonConverter.get(jsonType);
        if (converter == null) {
            throw ctx.newIllegalMemberException("Invalid '@type' value", jsonType);
        }
        Object object = converter.apply(ctx, json);
        if (!expectedClass.isInstance(object)) {
            throw ctx.newIllegalMemberException("Unexpected '" + object.getClass().getName() + "' type for member '" + memberName + "' instead of '" + expectedClass.getName() + "'", json);
        }
        ctx.popPath();
        return expectedClass.cast(object);
    }

    @FunctionalInterface
    public static interface Serialize<T>
    extends BiFunction<SerializationContext, T, JsonValue> {
    }

    @FunctionalInterface
    public static interface Deserialize<T>
    extends BiFunction<DeserializationContext, JsonObject, T> {
    }
}

