/*
 * Decompiled with CFR 0.152.
 */
package qilin.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import qilin.core.PTAScene;
import qilin.core.PointsToAnalysis;
import qilin.core.builder.CallGraphBuilder;
import qilin.core.builder.ExceptionHandler;
import qilin.core.builder.callgraph.OnFlyCallGraph;
import qilin.core.context.Context;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ArrayElement;
import qilin.core.pag.CallSite;
import qilin.core.pag.ContextAllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.Field;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.SparkField;
import qilin.core.pag.VarNode;
import qilin.core.sets.HybridPointsToSet;
import qilin.core.sets.PointsToSet;
import qilin.core.sets.PointsToSetInternal;
import qilin.core.sets.UnmodifiablePointsToSet;
import qilin.core.solver.Propagator;
import qilin.parm.ctxcons.CtxConstructor;
import qilin.parm.heapabst.HeapAbstractor;
import qilin.parm.select.CtxSelector;
import qilin.util.PTAUtils;
import sootup.core.jimple.basic.Local;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.types.Type;
import sootup.core.views.View;

public abstract class PTA
implements PointsToAnalysis {
    protected PTAScene scene;
    protected AllocNode rootNode;
    protected PAG pag;
    protected OnFlyCallGraph callGraph;
    protected CallGraphBuilder cgb;
    protected ExceptionHandler eh;
    private Set<SootMethod> nakedReachables = null;

    public PTA(PTAScene scene) {
        this.scene = scene;
        this.pag = this.createPAG();
        this.cgb = this.createCallGraphBuilder();
        this.eh = new ExceptionHandler(this);
        AllocNode rootBase = this.pag.makeAllocNode("ROOT", (Type)PTAUtils.getClassType("java.lang.Object"), null);
        this.rootNode = new ContextAllocNode(rootBase, CtxConstructor.emptyContext);
    }

    protected abstract PAG createPAG();

    protected abstract CallGraphBuilder createCallGraphBuilder();

    public void run() {
        this.pureRun();
    }

    public void pureRun() {
        this.getPropagator().propagate();
    }

    public PAG getPag() {
        return this.pag;
    }

    public View getView() {
        return this.scene.getView();
    }

    public PTAScene getScene() {
        return this.scene;
    }

    public CallGraphBuilder getCgb() {
        return this.cgb;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.eh;
    }

    public OnFlyCallGraph getCallGraph() {
        if (this.callGraph == null) {
            this.callGraph = this.cgb.getCICallGraph();
        }
        return this.callGraph;
    }

    public Collection<ContextMethod> getReachableMethods() {
        return this.cgb.getReachableMethods();
    }

    public Collection<SootMethod> getNakedReachableMethods() {
        if (this.nakedReachables == null) {
            this.nakedReachables = new HashSet<SootMethod>();
            this.cgb.getReachableMethods().forEach(momc -> this.nakedReachables.add(momc.method()));
        }
        return this.nakedReachables;
    }

    protected abstract Propagator getPropagator();

    public abstract Node parameterize(Node var1, Context var2);

    public abstract ContextMethod parameterize(SootMethod var1, Context var2);

    public abstract AllocNode getRootNode();

    public abstract Context emptyContext();

    public abstract Context createCalleeCtx(ContextMethod var1, AllocNode var2, CallSite var3, SootMethod var4);

    public abstract HeapAbstractor heapAbstractor();

    public abstract CtxConstructor ctxConstructor();

    public abstract CtxSelector ctxSelector();

    @Override
    public PointsToSet reachingObjects(SootMethod m, Local l) {
        HybridPointsToSet ret = new HybridPointsToSet();
        this.pag.getVarNodes(m, l).forEach(vn -> ret.addAll(vn.getP2Set(), null));
        return new UnmodifiablePointsToSet(this, ret);
    }

    @Override
    public PointsToSet reachingObjects(Node n) {
        PointsToSetInternal ret;
        if (n instanceof ContextVarNode) {
            ContextVarNode cvn = (ContextVarNode)n;
            ret = cvn.getP2Set();
        } else if (n instanceof ContextField) {
            ContextField cf = (ContextField)n;
            ret = cf.getP2Set();
        } else {
            VarNode varNode = (VarNode)n;
            ret = new HybridPointsToSet();
            if (this.pag.getContextVarNodeMap().containsKey(varNode)) {
                this.pag.getContextVarNodeMap().get(varNode).values().forEach(vn -> ret.addAll(vn.getP2Set(), null));
            }
        }
        return new UnmodifiablePointsToSet(this, ret);
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s) {
        return this.reachingObjectsInternal(s, (SparkField)ArrayElement.v());
    }

    @Override
    public PointsToSet reachingObjects(Context c, SootMethod m, Local l) {
        ContextVarNode n = this.pag.findContextVarNode(m, l, c);
        PointsToSetInternal pts = n == null ? HybridPointsToSet.getEmptySet() : n.getP2Set();
        return new UnmodifiablePointsToSet(this, pts);
    }

    @Override
    public PointsToSet reachingObjects(SootMethod m, Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(m, l), f);
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s, SootField f) {
        if (f.isStatic()) {
            throw new RuntimeException("The parameter f must be an *instance* field.");
        }
        return this.reachingObjectsInternal(s, (SparkField)new Field(f));
    }

    @Override
    public PointsToSet reachingObjects(Context c, SootMethod m, Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(c, m, l), f);
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        PointsToSetInternal ret;
        if (f.isStatic()) {
            GlobalVarNode n = this.pag.findGlobalVarNode(f);
            ret = n == null ? HybridPointsToSet.getEmptySet() : n.getP2Set();
        } else {
            ret = new HybridPointsToSet();
            Field sparkField = new Field(f);
            this.pag.getContextFieldVarNodeMap().values().stream().filter(map -> map.containsKey(sparkField)).forEach(map -> {
                ContextField contextField = (ContextField)map.get(sparkField);
                ret.addAll(contextField.getP2Set(), null);
            });
        }
        return new UnmodifiablePointsToSet(this, ret);
    }

    public PointsToSet reachingObjectsInternal(PointsToSet bases, SparkField f) {
        HybridPointsToSet ret = new HybridPointsToSet();
        this.pag.getContextFieldVarNodeMap().values().stream().filter(map -> map.containsKey(f)).forEach(map -> {
            ContextField contextField = (ContextField)map.get(f);
            AllocNode base = contextField.getBase();
            if (bases.contains(base)) {
                ret.addAll(contextField.getP2Set(), null);
            }
        });
        return new UnmodifiablePointsToSet(this, ret);
    }

    public PointsToSet reachingObjectsInternal(AllocNode heap, SparkField f) {
        HybridPointsToSet ret = new HybridPointsToSet();
        this.pag.getContextFieldVarNodeMap().values().stream().filter(map -> map.containsKey(f)).forEach(map -> {
            ContextField contextField = (ContextField)map.get(f);
            AllocNode base = contextField.getBase();
            if (heap.equals(base)) {
                ret.addAll(contextField.getP2Set(), null);
            }
        });
        return new UnmodifiablePointsToSet(this, ret);
    }
}

