/*
 * Decompiled with CFR 0.152.
 */
package qilin.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.builder.FakeMainFactory;
import qilin.core.builder.callgraph.OnFlyCallGraph;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.core.JavaIdentifierFactory;

public class PTAScene {
    private final View view;
    private OnFlyCallGraph callgraph;
    private final FakeMainFactory fakeMainFactory;
    public final Set<SootMethod> nativeBuilt = DataFactory.createSet();
    public final Set<SootMethod> reflectionBuilt = DataFactory.createSet();
    public final Set<SootMethod> arraycopyBuilt = DataFactory.createSet();

    public PTAScene(View view, String mainClassSig) {
        this.view = view;
        SootClass mainClass = this.getSootClass(mainClassSig);
        this.fakeMainFactory = new FakeMainFactory(view, mainClass);
    }

    public SootMethod getFakeMainMethod() {
        return this.fakeMainFactory.getFakeMain();
    }

    public JStaticFieldRef getFieldCurrentThread() {
        return this.fakeMainFactory.getFieldCurrentThread();
    }

    public Value getFieldGlobalThrow() {
        return this.fakeMainFactory.getFieldGlobalThrow();
    }

    public void setCallGraph(OnFlyCallGraph cg) {
        this.callgraph = cg;
    }

    public View getView() {
        return this.view;
    }

    public OnFlyCallGraph getCallGraph() {
        return this.callgraph;
    }

    public SootMethod getMethod(String methodSignature) {
        MethodSignature mthdSig = JavaIdentifierFactory.getInstance().parseMethodSignature(methodSignature);
        return (SootMethod)this.view.getMethod(mthdSig).get();
    }

    public Collection<SootClass> getApplicationClasses() {
        Collection classes = this.view.getClasses();
        return classes.stream().filter(SootClass::isApplicationClass).collect(Collectors.toSet());
    }

    public Collection<SootClass> getLibraryClasses() {
        Collection classes = this.view.getClasses();
        return classes.stream().filter(SootClass::isLibraryClass).collect(Collectors.toSet());
    }

    public boolean containsMethod(String methodSignature) {
        MethodSignature mthdSig = JavaIdentifierFactory.getInstance().parseMethodSignature(methodSignature);
        return this.view.getMethod(mthdSig).isPresent();
    }

    public boolean containsField(String fieldSignature) {
        FieldSignature fieldSig = JavaIdentifierFactory.getInstance().parseFieldSignature(fieldSignature);
        return this.view.getField(fieldSig).isPresent();
    }

    public Collection<? extends SootClass> getClasses() {
        return this.view.getClasses();
    }

    public Collection<SootClass> getPhantomClasses() {
        return Collections.emptySet();
    }

    public SootClass getSootClass(String className) {
        ClassType classType = PTAUtils.getClassType(className);
        return (SootClass)this.view.getClass(classType).get();
    }

    public boolean containsClass(String className) {
        ClassType classType = PTAUtils.getClassType(className);
        Optional oclazz = this.view.getClass(classType);
        return oclazz.isPresent();
    }

    public SootField getField(String fieldSignature) {
        FieldSignature fieldSig = JavaIdentifierFactory.getInstance().parseFieldSignature(fieldSignature);
        return (SootField)this.view.getField(fieldSig).get();
    }

    public boolean isApplicationMethod(SootMethod sm) {
        ClassType classType = sm.getDeclaringClassType();
        Optional osc = this.view.getClass(classType);
        return osc.map(SootClass::isApplicationClass).orElse(false);
    }
}

