/*
 * Decompiled with CFR 0.152.
 */
package qilin.core;

import java.util.Map;
import java.util.Optional;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import qilin.util.queue.ChunkedQueue;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.Type;
import sootup.core.views.View;

public class VirtualCalls {
    private final Map<Type, Map<MethodSubSignature, SootMethod>> typeToVtbl;
    protected View view;

    public VirtualCalls(View view) {
        this.view = view;
        this.typeToVtbl = DataFactory.createMap(view.getClasses().size());
    }

    public SootMethod resolveSpecial(JSpecialInvokeExpr iie, MethodSubSignature subSig, SootMethod container) {
        return this.resolveSpecial(iie, subSig, container, false);
    }

    public SootMethod resolveSpecial(JSpecialInvokeExpr iie, MethodSubSignature subSig, SootMethod container, boolean appOnly) {
        MethodSignature methodSig = iie.getMethodSignature();
        if (this.view.getTypeHierarchy().isSubtype((Type)methodSig.getDeclClassType(), (Type)container.getDeclaringClassType()) && container.getDeclaringClassType() != methodSig.getDeclClassType() && !methodSig.getName().equals("<init>") && !subSig.toString().equals("void <clinit>()")) {
            SootClass cls = (SootClass)this.view.getClass(container.getDeclaringClassType()).get();
            ClassType superClsType = (ClassType)cls.getSuperclass().get();
            return this.resolveNonSpecial(superClsType, subSig, appOnly);
        }
        Optional otgt = this.view.getMethod(methodSig);
        if (!otgt.isPresent()) {
            System.out.println("Wrarning: signature " + methodSig + " does not have a concrete method.");
        }
        return (SootMethod)otgt.get();
    }

    public SootMethod resolveNonSpecial(ClassType t, MethodSubSignature subSig) {
        return this.resolveNonSpecial(t, subSig, false);
    }

    public SootMethod resolveNonSpecial(ClassType t, MethodSubSignature subSig, boolean appOnly) {
        Map vtbl = this.typeToVtbl.computeIfAbsent((Type)t, k -> DataFactory.createMap(8));
        SootMethod ret = (SootMethod)vtbl.get(subSig);
        if (ret != null) {
            return ret;
        }
        SootClass cls = (SootClass)this.view.getClass(t).get();
        if (appOnly && cls.isLibraryClass()) {
            return null;
        }
        Optional om = cls.getMethod(subSig);
        if (om.isPresent()) {
            SootMethod m = (SootMethod)om.get();
            if (!m.isAbstract()) {
                ret = m;
            }
        } else {
            Optional oc = cls.getSuperclass();
            if (oc.isPresent()) {
                ClassType ct = (ClassType)oc.get();
                SootClass c = (SootClass)this.view.getClass(ct).get();
                ret = this.resolveNonSpecial(c.getType(), subSig);
            }
        }
        if (ret == null) {
            return null;
        }
        vtbl.put(subSig, ret);
        return ret;
    }

    public void resolve(Type t, Type declaredType, MethodSubSignature subSig, SootMethod container, ChunkedQueue<SootMethod> targets) {
        this.resolve(t, declaredType, null, subSig, container, targets);
    }

    public void resolve(Type t, Type declaredType, Type sigType, MethodSubSignature subSig, SootMethod container, ChunkedQueue<SootMethod> targets) {
        this.resolve(t, declaredType, sigType, subSig, container, targets, false);
    }

    public void resolve(Type t, Type declaredType, Type sigType, MethodSubSignature subSig, SootMethod container, ChunkedQueue<SootMethod> targets, boolean appOnly) {
        if (declaredType instanceof ArrayType) {
            declaredType = PTAUtils.getClassType("java.lang.Object");
        }
        if (sigType instanceof ArrayType) {
            sigType = PTAUtils.getClassType("java.lang.Object");
        }
        if (t instanceof ArrayType) {
            t = PTAUtils.getClassType("java.lang.Object");
        }
        if (declaredType != null && !PTAUtils.canStoreType(this.view, t, declaredType)) {
            return;
        }
        if (sigType != null && !PTAUtils.canStoreType(this.view, t, sigType)) {
            return;
        }
        if (t instanceof ClassType) {
            SootMethod target = this.resolveNonSpecial((ClassType)t, subSig, appOnly);
            if (target != null) {
                targets.add(target);
            }
        } else if (!(t instanceof NullType)) {
            throw new RuntimeException("oops " + t);
        }
    }
}

