/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.context.Context;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.ExceptionThrowSite;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.sets.P2SetVisitor;
import qilin.core.sets.PointsToSetInternal;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.types.Type;

public class ExceptionHandler {
    protected final Map<Node, Collection<ExceptionThrowSite>> throwNodeToSites;
    protected PTA pta;
    protected PAG pag;

    public ExceptionHandler(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
        this.throwNodeToSites = DataFactory.createMap(pta.getView().getClasses().size());
    }

    public Collection<ExceptionThrowSite> throwSitesLookUp(VarNode throwNode) {
        return this.throwNodeToSites.getOrDefault(throwNode, Collections.emptySet());
    }

    public boolean addThrowSite(Node throwNode, ExceptionThrowSite ets) {
        Collection throwSites = this.throwNodeToSites.computeIfAbsent(throwNode, k -> DataFactory.createSet());
        return throwSites.add(ets);
    }

    public void exceptionDispatch(PointsToSetInternal p2set, final ExceptionThrowSite site) {
        p2set.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                ExceptionHandler.this.dispatch((AllocNode)n, site);
            }
        });
    }

    public void dispatch(AllocNode throwObj, ExceptionThrowSite site) {
        Type type = throwObj.getType();
        ContextMethod momc = site.container();
        SootMethod sm = momc.method();
        Context context = momc.context();
        MethodPAG mpag = this.pag.getMethodPAG(sm);
        MethodNodeFactory nodeFactory = mpag.nodeFactory();
        VarNode throwNode = site.getThrowNode();
        List trapList = mpag.stmt2wrapperedTraps.getOrDefault(site.getUnit(), Collections.emptyList());
        for (Trap trap : trapList) {
            if (!PTAUtils.canStoreType(this.pta.getView(), type, (Type)trap.getExceptionType())) continue;
            Stmt handler = trap.getHandlerStmt();
            assert (handler instanceof JIdentityStmt);
            JIdentityStmt handlerStmt = (JIdentityStmt)handler;
            Node caughtParam = nodeFactory.getNode((Value)handlerStmt.getRightOp());
            Node dst = this.pta.parameterize(caughtParam, context);
            this.pag.addEdge(throwObj, dst);
            this.recordImplictEdge(throwNode, caughtParam, mpag);
            return;
        }
        VarNode methodThrowNode = nodeFactory.caseMethodThrow();
        Node dst = this.pta.parameterize(methodThrowNode, context);
        this.pag.addEdge(throwObj, dst);
        this.recordImplictEdge(throwNode, methodThrowNode, mpag);
    }

    private void recordImplictEdge(Node src, Node dst, MethodPAG mpag) {
        if (src instanceof ContextVarNode) {
            src = ((ContextVarNode)src).base();
        }
        mpag.addExceptionEdge(src, dst);
    }
}

