/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import qilin.CoreConfig;
import qilin.core.PTAScene;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ArrayElement;
import qilin.core.pag.Field;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.Parm;
import qilin.core.pag.VarNode;
import qilin.util.PTAUtils;
import qilin.util.queue.UniqueQueue;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.constant.StringConstant;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JExitMonitorStmt;
import sootup.core.jimple.visitor.AbstractStmtVisitor;
import sootup.core.jimple.visitor.Visitor;
import sootup.core.model.FieldModifier;
import sootup.core.model.Position;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.language.JavaJimple;

public class MethodNodeFactory {
    protected PAG pag;
    protected MethodPAG mpag;
    protected SootMethod method;
    private final PTAScene scene;

    public MethodNodeFactory(PAG pag, MethodPAG mpag) {
        this.pag = pag;
        this.mpag = mpag;
        this.method = mpag.getMethod();
        this.scene = pag.getPta().getScene();
    }

    public Node getNode(Value v) {
        if (v instanceof Local) {
            Local l = (Local)v;
            return this.caseLocal(l);
        }
        if (v instanceof JCastExpr) {
            JCastExpr castExpr = (JCastExpr)v;
            return this.caseCastExpr(castExpr);
        }
        if (v instanceof JNewExpr) {
            JNewExpr ne = (JNewExpr)v;
            return this.caseNewExpr(ne);
        }
        if (v instanceof JStaticFieldRef) {
            JStaticFieldRef sfr = (JStaticFieldRef)v;
            return this.caseStaticFieldRef(sfr);
        }
        if (v instanceof JNewArrayExpr) {
            JNewArrayExpr nae = (JNewArrayExpr)v;
            return this.caseNewArrayExpr(nae);
        }
        if (v instanceof JArrayRef) {
            JArrayRef ar = (JArrayRef)v;
            return this.caseArrayRef(ar);
        }
        if (v instanceof ClassConstant) {
            ClassConstant cc = (ClassConstant)v;
            return this.caseClassConstant(cc);
        }
        if (v instanceof StringConstant) {
            StringConstant sc = (StringConstant)v;
            return this.caseStringConstant(sc);
        }
        if (v instanceof JCaughtExceptionRef) {
            JCaughtExceptionRef cef = (JCaughtExceptionRef)v;
            return this.caseCaughtExceptionRef(cef);
        }
        if (v instanceof JParameterRef) {
            JParameterRef pr = (JParameterRef)v;
            return this.caseParameterRef(pr);
        }
        if (v instanceof NullConstant) {
            NullConstant nc = (NullConstant)v;
            return this.caseNullConstant(nc);
        }
        if (v instanceof JInstanceFieldRef) {
            JInstanceFieldRef ifr = (JInstanceFieldRef)v;
            return this.caseInstanceFieldRef(ifr);
        }
        if (v instanceof JThisRef) {
            return this.caseThis();
        }
        if (v instanceof JNewMultiArrayExpr) {
            JNewMultiArrayExpr nmae = (JNewMultiArrayExpr)v;
            return this.caseNewMultiArrayExpr(nmae);
        }
        System.out.println(v + ";;" + v.getClass());
        return null;
    }

    public final void handleStmt(Stmt s) {
        if (s.containsInvokeExpr()) {
            this.mpag.addCallStmt(s);
            this.handleInvokeStmt(s);
        } else {
            this.handleIntraStmt(s);
        }
    }

    protected void handleInvokeStmt(Stmt s) {
        JAssignStmt assignStmt;
        LValue l;
        AbstractInvokeExpr ie = s.getInvokeExpr();
        int numArgs = ie.getArgCount();
        for (int i = 0; i < numArgs; ++i) {
            Immediate arg = ie.getArg(i);
            if (!(arg.getType() instanceof ReferenceType) || arg instanceof NullConstant) continue;
            this.getNode((Value)arg);
        }
        if (s instanceof JAssignStmt && (l = (assignStmt = (JAssignStmt)s).getLeftOp()).getType() instanceof ReferenceType) {
            this.getNode((Value)l);
        }
        if (ie instanceof AbstractInstanceInvokeExpr) {
            AbstractInstanceInvokeExpr aie = (AbstractInstanceInvokeExpr)ie;
            this.getNode((Value)aie.getBase());
        }
    }

    private void resolveClinit(JStaticFieldRef staticFieldRef) {
        FieldSignature fieldSig = staticFieldRef.getFieldSignature();
        ClassType classType = fieldSig.getDeclClassType();
        if (PTAUtils.isFakeMainClass(classType)) {
            return;
        }
        SootClass sootClass = (SootClass)this.scene.getView().getClass(classType).get();
        this.clinitsOf(sootClass).forEach(this.mpag::addTriggeredClinit);
    }

    private void handleIntraStmt(Stmt s) {
        s.accept((Visitor)new AbstractStmtVisitor<Object>(){

            public void caseAssignStmt(@Nonnull JAssignStmt stmt) {
                LValue l = stmt.getLeftOp();
                Value r = stmt.getRightOp();
                if (l instanceof JStaticFieldRef) {
                    MethodNodeFactory.this.resolveClinit((JStaticFieldRef)l);
                } else if (r instanceof JStaticFieldRef) {
                    MethodNodeFactory.this.resolveClinit((JStaticFieldRef)r);
                }
                if (!(l.getType() instanceof ReferenceType)) {
                    return;
                }
                if (r instanceof JCastExpr && !(((JCastExpr)r).getOp().getType() instanceof ReferenceType)) {
                    return;
                }
                if (!(r.getType() instanceof ReferenceType)) {
                    return;
                }
                Node dest = MethodNodeFactory.this.getNode((Value)l);
                Node src = MethodNodeFactory.this.getNode(r);
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            public void caseIdentityStmt(@Nonnull JIdentityStmt stmt) {
                if (!(stmt.getLeftOp().getType() instanceof ReferenceType)) {
                    return;
                }
                Node dest = MethodNodeFactory.this.getNode((Value)stmt.getLeftOp());
                Node src = MethodNodeFactory.this.getNode((Value)stmt.getRightOp());
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            public void caseExitMonitorStmt(@Nonnull JExitMonitorStmt stmt) {
                this.defaultCaseStmt((Stmt)stmt);
            }

            public void caseReturnStmt(@Nonnull JReturnStmt stmt) {
                if (!(stmt.getOp().getType() instanceof ReferenceType)) {
                    return;
                }
                Node retNode = MethodNodeFactory.this.getNode((Value)stmt.getOp());
                MethodNodeFactory.this.mpag.addInternalEdge(retNode, MethodNodeFactory.this.caseRet());
            }

            public void caseThrowStmt(@Nonnull JThrowStmt stmt) {
                if (!CoreConfig.v().getPtaConfig().preciseExceptions) {
                    MethodNodeFactory.this.mpag.addInternalEdge(MethodNodeFactory.this.getNode((Value)stmt.getOp()), MethodNodeFactory.this.getNode(MethodNodeFactory.this.scene.getFieldGlobalThrow()));
                }
            }
        });
    }

    private VarNode caseLocal(Local l) {
        return this.pag.makeLocalVarNode(l, l.getType(), this.method);
    }

    private AllocNode caseNewArrayExpr(JNewArrayExpr nae) {
        return this.pag.makeAllocNode(nae, nae.getType(), this.method);
    }

    private AllocNode caseNewExpr(JNewExpr ne) {
        SootClass cl = this.scene.getSootClass(ne.getType().toString());
        this.clinitsOf(cl).forEach(this.mpag::addTriggeredClinit);
        return this.pag.makeAllocNode(ne, (Type)ne.getType(), this.method);
    }

    private FieldRefNode caseInstanceFieldRef(JInstanceFieldRef ifr) {
        FieldSignature fieldSig = ifr.getFieldSignature();
        Optional osf = this.scene.getView().getField(fieldSig);
        SootField sf = !osf.isPresent() ? new SootField(fieldSig, Collections.singleton(FieldModifier.PUBLIC), (Position)NoPositionInformation.getInstance()) : (SootField)osf.get();
        Local base = ifr.getBase();
        return this.pag.makeFieldRefNode(this.pag.makeLocalVarNode(base, base.getType(), this.method), new Field(sf));
    }

    private VarNode caseNewMultiArrayExpr(JNewMultiArrayExpr nmae) {
        Type t;
        ArrayType type = (ArrayType)nmae.getType();
        int pos = 0;
        AllocNode prevAn = this.pag.makeAllocNode(JavaJimple.getInstance().newNewArrayExpr((Type)type, nmae.getSize(pos)), (Type)type, this.method);
        LocalVarNode prevVn = this.pag.makeLocalVarNode(prevAn.getNewExpr(), prevAn.getType(), this.method);
        this.mpag.addInternalEdge(prevAn, prevVn);
        LocalVarNode ret = prevVn;
        while ((t = type.getElementType()) instanceof ArrayType) {
            type = (ArrayType)t;
            Object sizeVal = ++pos < nmae.getSizeCount() ? nmae.getSize(pos) : IntConstant.getInstance((int)1);
            AllocNode an = this.pag.makeAllocNode(JavaJimple.getInstance().newNewArrayExpr((Type)type, (Immediate)sizeVal), (Type)type, this.method);
            LocalVarNode vn = this.pag.makeLocalVarNode(an.getNewExpr(), an.getType(), this.method);
            this.mpag.addInternalEdge(an, vn);
            this.mpag.addInternalEdge(vn, this.pag.makeFieldRefNode(prevVn, ArrayElement.v()));
            prevVn = vn;
        }
        return ret;
    }

    private VarNode caseCastExpr(JCastExpr ce) {
        Node opNode = this.getNode((Value)ce.getOp());
        LocalVarNode castNode = this.pag.makeLocalVarNode(ce, ce.getType(), this.method);
        this.mpag.addInternalEdge(opNode, castNode);
        return castNode;
    }

    public VarNode caseThis() {
        ClassType type = this.method.isStatic() ? PTAUtils.getClassType("java.lang.Object") : this.method.getDeclaringClassType();
        LocalVarNode ret = this.pag.makeLocalVarNode(new Parm(this.method, -1), (Type)type, this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public VarNode caseParm(int index) {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Parm(this.method, index), this.method.getParameterType(index), this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public VarNode caseRet() {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Parm(this.method, -2), this.method.getReturnType(), this.method);
        ret.setInterProcSource();
        return ret;
    }

    public VarNode caseMethodThrow() {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Parm(this.method, -3), (Type)PTAUtils.getClassType("java.lang.Throwable"), this.method);
        ret.setInterProcSource();
        return ret;
    }

    public final FieldRefNode caseArray(VarNode base) {
        return this.pag.makeFieldRefNode(base, ArrayElement.v());
    }

    private Node caseCaughtExceptionRef(JCaughtExceptionRef cer) {
        if (CoreConfig.v().getPtaConfig().preciseExceptions) {
            return this.pag.makeLocalVarNode(cer, cer.getType(), this.method);
        }
        return this.getNode(this.scene.getFieldGlobalThrow());
    }

    private FieldRefNode caseArrayRef(JArrayRef ar) {
        return this.caseArray(this.caseLocal(ar.getBase()));
    }

    private VarNode caseParameterRef(JParameterRef pr) {
        return this.caseParm(pr.getIndex());
    }

    private VarNode caseStaticFieldRef(JStaticFieldRef sfr) {
        return this.pag.makeGlobalVarNode(sfr.getFieldSignature(), sfr.getType());
    }

    private Node caseNullConstant(NullConstant nr) {
        return null;
    }

    private VarNode caseStringConstant(StringConstant sc) {
        AllocNode stringConstantNode = this.pag.makeStringConstantNode(sc);
        GlobalVarNode stringConstantVar = this.pag.makeGlobalVarNode(sc, (Type)PTAUtils.getClassType("java.lang.String"));
        this.mpag.addInternalEdge(stringConstantNode, stringConstantVar);
        LocalVarNode vn = this.pag.makeLocalVarNode(sc, (Type)PTAUtils.getClassType("java.lang.String"), this.method);
        this.mpag.addInternalEdge(stringConstantVar, vn);
        return vn;
    }

    public LocalVarNode makeInvokeStmtThrowVarNode(Stmt invoke, SootMethod method) {
        return this.pag.makeLocalVarNode(invoke, (Type)PTAUtils.getClassType("java.lang.Throwable"), method);
    }

    public final VarNode caseClassConstant(ClassConstant cc) {
        AllocNode classConstant = this.pag.makeClassConstantNode(cc);
        GlobalVarNode classConstantVar = this.pag.makeGlobalVarNode(cc, (Type)PTAUtils.getClassType("java.lang.Class"));
        this.mpag.addInternalEdge(classConstant, classConstantVar);
        LocalVarNode vn = this.pag.makeLocalVarNode(cc, (Type)PTAUtils.getClassType("java.lang.Class"), this.method);
        this.mpag.addInternalEdge(classConstantVar, vn);
        return vn;
    }

    public Set<SootMethod> clinitsOf(SootClass cl) {
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        HashSet<SootClass> visit = new HashSet<SootClass>();
        UniqueQueue worklist = new UniqueQueue();
        Optional curr = Optional.of(cl.getType());
        while (curr.isPresent()) {
            ClassType ct = curr.get();
            SootClass sc = (SootClass)this.scene.getView().getClass(ct).get();
            worklist.add(sc);
            curr = sc.getSuperclass();
        }
        while (!worklist.isEmpty()) {
            SootClass sc = (SootClass)worklist.poll();
            if (!visit.add(sc)) continue;
            Set itfs = sc.getInterfaces();
            for (ClassType itf : itfs) {
                Optional xsc = this.scene.getView().getClass(itf);
                xsc.ifPresent(worklist::add);
            }
        }
        for (SootClass sc : visit) {
            MethodSubSignature subclinit = JavaIdentifierFactory.getInstance().parseMethodSubSignature("void <clinit>()");
            Optional initStart = sc.getMethod(subclinit);
            initStart.ifPresent(ret::add);
        }
        return ret;
    }
}

