/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder.callgraph;

import qilin.core.builder.callgraph.Kind;
import qilin.core.context.Context;
import qilin.core.pag.ContextMethod;
import qilin.util.Invalidable;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.expr.JVirtualInvokeExpr;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;

public final class Edge
implements Invalidable {
    private ContextMethod src;
    private ContextMethod tgt;
    private Stmt srcUnit;
    private final Kind kind;
    private boolean invalid = false;
    private Edge nextByUnit = this;
    private Edge prevByUnit = this;
    private Edge nextBySrc = this;
    private Edge prevBySrc = this;
    private Edge nextByTgt = this;
    private Edge prevByTgt = this;

    public Edge(ContextMethod src, Stmt srcUnit, ContextMethod tgt, Kind kind) {
        this.src = src;
        this.srcUnit = srcUnit;
        this.tgt = tgt;
        this.kind = kind;
    }

    public Edge(ContextMethod src, Stmt srcUnit, ContextMethod tgt) {
        this.kind = Edge.ieToKind(srcUnit.getInvokeExpr());
        this.src = src;
        this.srcUnit = srcUnit;
        this.tgt = tgt;
    }

    public SootMethod src() {
        return this.src == null ? null : this.src.method();
    }

    public Context srcCtxt() {
        return this.src == null ? null : this.src.context();
    }

    public ContextMethod getSrc() {
        return this.src;
    }

    public Stmt srcUnit() {
        return this.srcUnit;
    }

    public Stmt srcStmt() {
        return this.srcUnit;
    }

    public SootMethod tgt() {
        return this.tgt == null ? null : this.tgt.method();
    }

    public Context tgtCtxt() {
        return this.tgt == null ? null : this.tgt.context();
    }

    public ContextMethod getTgt() {
        return this.tgt;
    }

    public Kind kind() {
        return this.kind;
    }

    public static Kind ieToKind(AbstractInvokeExpr ie) {
        if (ie instanceof JVirtualInvokeExpr) {
            return Kind.VIRTUAL;
        }
        if (ie instanceof JSpecialInvokeExpr) {
            return Kind.SPECIAL;
        }
        if (ie instanceof JInterfaceInvokeExpr) {
            return Kind.INTERFACE;
        }
        if (ie instanceof JStaticInvokeExpr) {
            return Kind.STATIC;
        }
        throw new RuntimeException();
    }

    public boolean isExplicit() {
        return Kind.isExplicit(this.kind);
    }

    public boolean isInstance() {
        return Kind.isInstance(this.kind);
    }

    public boolean isVirtual() {
        return Kind.isVirtual(this.kind);
    }

    public boolean isSpecial() {
        return Kind.isSpecial(this.kind);
    }

    public boolean isClinit() {
        return Kind.isClinit(this.kind);
    }

    public boolean isStatic() {
        return Kind.isStatic(this.kind);
    }

    public boolean isThreadRunCall() {
        return Kind.isThread(this.kind);
    }

    public boolean passesParameters() {
        return Kind.passesParameters(this.kind);
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void invalidate() {
        this.src = null;
        this.srcUnit = null;
        this.tgt = null;
        this.invalid = true;
    }

    public int hashCode() {
        if (this.invalid) {
            return 0;
        }
        int ret = this.tgt.hashCode() + 20 + (this.kind == null ? 0 : this.kind.getNumber());
        if (this.src != null) {
            ret = ret * 32 + this.src.hashCode();
        }
        if (this.srcUnit != null) {
            ret = ret * 32 + this.srcUnit.hashCode();
        }
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Edge)) {
            return false;
        }
        Edge o = (Edge)other;
        return o.src == this.src && o.srcUnit == this.srcUnit && o.tgt == this.tgt && o.kind == this.kind;
    }

    public String toString() {
        return this.kind + " edge: " + this.srcUnit + " in " + this.src + " ==> " + this.tgt;
    }

    void insertAfterByUnit(Edge other) {
        this.nextByUnit = other.nextByUnit;
        this.nextByUnit.prevByUnit = this;
        other.nextByUnit = this;
        this.prevByUnit = other;
    }

    void insertAfterBySrc(Edge other) {
        this.nextBySrc = other.nextBySrc;
        this.nextBySrc.prevBySrc = this;
        other.nextBySrc = this;
        this.prevBySrc = other;
    }

    void insertAfterByTgt(Edge other) {
        this.nextByTgt = other.nextByTgt;
        this.nextByTgt.prevByTgt = this;
        other.nextByTgt = this;
        this.prevByTgt = other;
    }

    void insertBeforeByUnit(Edge other) {
        this.prevByUnit = other.prevByUnit;
        this.prevByUnit.nextByUnit = this;
        other.prevByUnit = this;
        this.nextByUnit = other;
    }

    void insertBeforeBySrc(Edge other) {
        this.prevBySrc = other.prevBySrc;
        this.prevBySrc.nextBySrc = this;
        other.prevBySrc = this;
        this.nextBySrc = other;
    }

    void insertBeforeByTgt(Edge other) {
        this.prevByTgt = other.prevByTgt;
        this.prevByTgt.nextByTgt = this;
        other.prevByTgt = this;
        this.nextByTgt = other;
    }

    void remove() {
        this.invalid = true;
        this.nextByUnit.prevByUnit = this.prevByUnit;
        this.prevByUnit.nextByUnit = this.nextByUnit;
        this.nextBySrc.prevBySrc = this.prevBySrc;
        this.prevBySrc.nextBySrc = this.nextBySrc;
        this.nextByTgt.prevByTgt = this.prevByTgt;
        this.prevByTgt.nextByTgt = this.nextByTgt;
    }

    Edge nextByUnit() {
        return this.nextByUnit;
    }

    Edge nextBySrc() {
        return this.nextBySrc;
    }

    Edge nextByTgt() {
        return this.nextByTgt;
    }

    Edge prevByUnit() {
        return this.prevByUnit;
    }

    Edge prevBySrc() {
        return this.prevBySrc;
    }

    Edge prevByTgt() {
        return this.prevByTgt;
    }
}

