/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder.callgraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import qilin.core.builder.callgraph.Edge;
import qilin.core.builder.callgraph.Kind;
import qilin.core.pag.ContextMethod;
import qilin.util.DataFactory;
import qilin.util.queue.ChunkedQueue;
import qilin.util.queue.QueueReader;
import sootup.callgraph.MutableCallGraph;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;

public class OnFlyCallGraph
implements MutableCallGraph,
Iterable<Edge> {
    protected Set<MethodSignature> methods = DataFactory.createSet();
    protected Map<MethodSignature, Set<MethodSignature>> calls = DataFactory.createMap();
    protected int callCnt = 0;
    protected Set<Edge> edges = new LinkedHashSet<Edge>();
    protected ChunkedQueue<Edge> stream = new ChunkedQueue();
    protected QueueReader<Edge> reader = this.stream.reader();
    protected Map<ContextMethod, Edge> srcMethodToEdge = new LinkedHashMap<ContextMethod, Edge>();
    protected Map<Stmt, Edge> srcUnitToEdge = new LinkedHashMap<Stmt, Edge>();
    protected Map<ContextMethod, Edge> tgtToEdge = new LinkedHashMap<ContextMethod, Edge>();
    protected Edge dummy = new Edge(null, null, null, Kind.INVALID);

    public boolean addEdge(Edge e) {
        if (!this.edges.add(e)) {
            return false;
        }
        MethodSignature srcSig = (MethodSignature)e.getSrc().method().getSignature();
        MethodSignature tgtSig = (MethodSignature)e.getTgt().method().getSignature();
        this.addMethod(srcSig);
        this.addMethod(tgtSig);
        this.addCall(srcSig, tgtSig);
        this.stream.add(e);
        Edge position = this.srcUnitToEdge.get(e.srcUnit());
        if (position == null) {
            this.srcUnitToEdge.put(e.srcUnit(), e);
            position = this.dummy;
        }
        e.insertAfterByUnit(position);
        position = this.srcMethodToEdge.get(e.getSrc());
        if (position == null) {
            this.srcMethodToEdge.put(e.getSrc(), e);
            position = this.dummy;
        }
        e.insertAfterBySrc(position);
        position = this.tgtToEdge.get(e.getTgt());
        if (position == null) {
            this.tgtToEdge.put(e.getTgt(), e);
            position = this.dummy;
        }
        e.insertAfterByTgt(position);
        return true;
    }

    public boolean removeAllEdgesOutOf(Stmt u) {
        boolean hasRemoved = false;
        HashSet<Edge> edgesToRemove = new HashSet<Edge>();
        QueueReader<Edge> edgeRdr = this.listener();
        while (edgeRdr.hasNext()) {
            Edge e = edgeRdr.next();
            if (e.srcUnit() != u) continue;
            e.remove();
            this.removeEdge(e, false);
            edgesToRemove.add(e);
            hasRemoved = true;
        }
        if (hasRemoved) {
            this.reader.remove(edgesToRemove);
        }
        return hasRemoved;
    }

    public boolean swapEdgesOutOf(Stmt out, Stmt in) {
        boolean hasSwapped = false;
        Iterator<Edge> edgeRdr = this.edgesOutOf(out);
        while (edgeRdr.hasNext()) {
            Edge e = edgeRdr.next();
            ContextMethod src = e.getSrc();
            ContextMethod tgt = e.getTgt();
            this.removeEdge(e);
            e.remove();
            this.addEdge(new Edge(src, in, tgt));
            hasSwapped = true;
        }
        return hasSwapped;
    }

    public boolean removeEdge(Edge e) {
        return this.removeEdge(e, true);
    }

    public boolean removeEdge(Edge e, boolean removeInEdgeList) {
        if (!this.edges.remove(e)) {
            return false;
        }
        MethodSignature srcSig = (MethodSignature)e.getSrc().method().getSignature();
        MethodSignature tgtSig = (MethodSignature)e.getTgt().method().getSignature();
        Set tgtSigs = this.calls.getOrDefault(srcSig, Collections.emptySet());
        assert (!tgtSigs.isEmpty());
        tgtSigs.remove(tgtSig);
        e.remove();
        if (this.srcUnitToEdge.get(e.srcUnit()) == e) {
            if (e.nextByUnit().srcUnit() == e.srcUnit()) {
                this.srcUnitToEdge.put(e.srcUnit(), e.nextByUnit());
            } else {
                this.srcUnitToEdge.remove(e.srcUnit());
            }
        }
        if (this.srcMethodToEdge.get(e.getSrc()) == e) {
            if (e.nextBySrc().getSrc() == e.getSrc()) {
                this.srcMethodToEdge.put(e.getSrc(), e.nextBySrc());
            } else {
                this.srcMethodToEdge.remove(e.getSrc());
            }
        }
        if (this.tgtToEdge.get(e.getTgt()) == e) {
            if (e.nextByTgt().getTgt() == e.getTgt()) {
                this.tgtToEdge.put(e.getTgt(), e.nextByTgt());
            } else {
                this.tgtToEdge.remove(e.getTgt());
            }
        }
        if (removeInEdgeList) {
            this.reader.remove(e);
        }
        return true;
    }

    public boolean removeEdges(Collection<Edge> edges) {
        if (!this.edges.removeAll(edges)) {
            return false;
        }
        for (Edge e : edges) {
            this.removeEdge(e, false);
        }
        this.reader.remove(edges);
        return true;
    }

    public boolean isEntryMethod(SootMethod method) {
        return !this.tgtToEdge.containsKey(method);
    }

    public Edge findEdge(Stmt u, SootMethod callee) {
        Edge e = this.srcUnitToEdge.get(u);
        if (e != null) {
            while (e.srcUnit() == u && e.kind() != Kind.INVALID) {
                if (e.tgt() == callee) {
                    return e;
                }
                e = e.nextByUnit();
            }
        }
        return null;
    }

    public Iterator<ContextMethod> sourceMethods() {
        return this.srcMethodToEdge.keySet().iterator();
    }

    public Iterator<Edge> edgesOutOf(Stmt u) {
        return new TargetsOfUnitIterator(u);
    }

    public Iterator<Edge> edgesOutOf(ContextMethod m) {
        return new TargetsOfMethodIterator(m);
    }

    public Iterator<Edge> edgesInto(ContextMethod m) {
        return new CallersOfMethodIterator(m);
    }

    public QueueReader<Edge> listener() {
        return this.reader.clone();
    }

    public QueueReader<Edge> newListener() {
        return this.stream.reader();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        QueueReader<Edge> reader = this.listener();
        while (reader.hasNext()) {
            Edge e = reader.next();
            out.append(e.toString()).append('\n');
        }
        return out.toString();
    }

    public int size() {
        return this.edges.size();
    }

    @Override
    public Iterator<Edge> iterator() {
        return this.edges.iterator();
    }

    public void addMethod(@Nonnull MethodSignature calledMethod) {
        this.methods.add(calledMethod);
    }

    public void addCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod) {
        Set targets = this.calls.computeIfAbsent(sourceMethod, k -> DataFactory.createSet());
        if (targets.add(targetMethod)) {
            ++this.callCnt;
        }
    }

    @Nonnull
    public Set<MethodSignature> getMethodSignatures() {
        return new HashSet<MethodSignature>(this.methods);
    }

    @Nonnull
    public MutableCallGraph copy() {
        throw new UnsupportedOperationException();
    }

    public boolean containsMethod(@Nonnull MethodSignature method) {
        return this.methods.contains(method);
    }

    public boolean containsCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod) {
        return this.calls.containsKey(sourceMethod) && this.calls.get(sourceMethod).contains(targetMethod);
    }

    public int callCount() {
        return this.callCnt;
    }

    public String exportAsDot() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Set<MethodSignature> callsFrom(@Nonnull MethodSignature sourceMethod) {
        return this.calls.getOrDefault(sourceMethod, Collections.emptySet());
    }

    @Nonnull
    public Set<MethodSignature> callsTo(@Nonnull MethodSignature targetMethod) {
        throw new UnsupportedOperationException();
    }

    class CallersOfMethodIterator
    implements Iterator<Edge> {
        private final ContextMethod m;
        private Edge position;

        CallersOfMethodIterator(ContextMethod m) {
            this.m = m;
            if (m == null) {
                throw new RuntimeException();
            }
            this.position = OnFlyCallGraph.this.tgtToEdge.get(m);
            if (this.position == null) {
                this.position = OnFlyCallGraph.this.dummy;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.position == OnFlyCallGraph.this.dummy) {
                return false;
            }
            if (!this.position.getTgt().equals(this.m)) {
                return false;
            }
            return this.position.kind() != Kind.INVALID;
        }

        @Override
        public Edge next() {
            Edge ret = this.position;
            this.position = this.position.nextByTgt();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class TargetsOfMethodIterator
    implements Iterator<Edge> {
        private final ContextMethod m;
        private Edge position;

        TargetsOfMethodIterator(ContextMethod m) {
            this.m = m;
            if (m == null) {
                throw new RuntimeException();
            }
            this.position = OnFlyCallGraph.this.srcMethodToEdge.get(m);
            if (this.position == null) {
                this.position = OnFlyCallGraph.this.dummy;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.position == OnFlyCallGraph.this.dummy) {
                return false;
            }
            if (!this.position.getSrc().equals(this.m)) {
                return false;
            }
            return this.position.kind() != Kind.INVALID;
        }

        @Override
        public Edge next() {
            Edge ret = this.position;
            this.position = this.position.nextBySrc();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class TargetsOfUnitIterator
    implements Iterator<Edge> {
        private final Stmt u;
        private Edge position;

        TargetsOfUnitIterator(Stmt u) {
            this.u = u;
            if (u == null) {
                throw new RuntimeException();
            }
            this.position = OnFlyCallGraph.this.srcUnitToEdge.get(u);
            if (this.position == null) {
                this.position = OnFlyCallGraph.this.dummy;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.position.srcUnit() != this.u) {
                return false;
            }
            return this.position.kind() != Kind.INVALID;
        }

        @Override
        public Edge next() {
            Edge ret = this.position;
            this.position = this.position.nextByUnit();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

