/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.context;

import qilin.core.context.ContextElement;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ClassConstantNode;
import qilin.core.pag.StringConstantNode;
import qilin.util.PTAUtils;
import sootup.core.model.SootMethod;
import sootup.core.types.ClassType;
import sootup.core.types.Type;

public class TypeContextElement
implements ContextElement {
    private final Type type;

    private TypeContextElement(Type type) {
        this.type = type;
    }

    public static TypeContextElement getTypeContextElement(AllocNode a) {
        SootMethod declaringMethod = a.getMethod();
        ClassType declType = PTAUtils.getClassType("java.lang.Object");
        if (declaringMethod != null) {
            declType = declaringMethod.getDeclaringClassType();
        } else if (a instanceof ClassConstantNode) {
            declType = PTAUtils.getClassType("java.lang.System");
        } else if (a instanceof StringConstantNode) {
            declType = PTAUtils.getClassType("java.lang.String");
        }
        return new TypeContextElement((Type)declType);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeContextElement other = (TypeContextElement)obj;
        if (this.type == null) {
            return other.type == null;
        }
        return this.type.equals(other.type);
    }

    public String toString() {
        return "TypeContext: " + this.type;
    }
}

