/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.pag;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTAScene;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import qilin.util.queue.ChunkedQueue;
import qilin.util.queue.QueueReader;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;

public class MethodPAG {
    private final ChunkedQueue<Node> internalEdges = new ChunkedQueue();
    private final QueueReader<Node> internalReader = this.internalEdges.reader();
    private final Set<SootMethod> clinits = DataFactory.createSet();
    private final Collection<Stmt> invokeStmts = DataFactory.createSet();
    public Body body;
    private final Map<Node, Set<Node>> exceptionEdges = DataFactory.createMap();
    protected MethodNodeFactory nodeFactory;
    protected final PTAScene ptaScene;
    SootMethod method;
    public final Map<Stmt, List<Trap>> stmt2wrapperedTraps = DataFactory.createMap();
    public final Map<Node, Map<Stmt, List<Trap>>> node2wrapperedTraps = DataFactory.createMap();

    public MethodPAG(PAG pag, SootMethod m, Body body) {
        this.ptaScene = pag.getPta().getScene();
        this.method = m;
        this.nodeFactory = new MethodNodeFactory(pag, this);
        this.body = body;
        this.build();
    }

    public SootMethod getMethod() {
        return this.method;
    }

    public MethodNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    public Collection<Stmt> getInvokeStmts() {
        return this.invokeStmts;
    }

    public boolean addCallStmt(Stmt unit) {
        return this.invokeStmts.add(unit);
    }

    protected void build() {
        if (((MethodSignature)this.method.getSignature()).toString().equals("<org.apache.xerces.parsers.XML11Configuration: boolean getFeature0(java.lang.String)>")) {
            return;
        }
        this.buildException();
        this.buildNormal();
        this.addMiscEdges();
    }

    protected void buildNormal() {
        if (this.method.isStatic() && !PTAUtils.isFakeMainMethod(this.method)) {
            SootClass sc = (SootClass)this.ptaScene.getView().getClass(this.method.getDeclaringClassType()).get();
            this.nodeFactory.clinitsOf(sc).forEach(this::addTriggeredClinit);
        }
        for (Stmt unit : this.body.getStmts()) {
            try {
                this.nodeFactory.handleStmt(unit);
            }
            catch (Exception e) {
                System.out.println("Warning:" + e + " in " + this.getClass());
            }
        }
    }

    protected void buildException() {
        if (!CoreConfig.v().getPtaConfig().preciseExceptions) {
            return;
        }
    }

    private void addStmtTrap(Node src, Stmt stmt, Trap trap) {
        Map stmt2Traps = this.node2wrapperedTraps.computeIfAbsent(src, k -> DataFactory.createMap());
        List trapList = stmt2Traps.computeIfAbsent(stmt, k -> DataFactory.createList());
        trapList.add(trap);
        this.stmt2wrapperedTraps.computeIfAbsent(stmt, k -> DataFactory.createList()).add(trap);
    }

    protected void addMiscEdges() {
        if (((MethodSignature)this.method.getSignature()).toString().equals("<java.lang.ref.Reference: void <init>(java.lang.Object,java.lang.ref.ReferenceQueue)>")) {
            SootClass sootClass = this.ptaScene.getSootClass("java.lang.ref.Reference");
            SootField sf = (SootField)sootClass.getField("pending").get();
            JStaticFieldRef sfr = Jimple.newStaticFieldRef((FieldSignature)((FieldSignature)sf.getSignature()));
            this.addInternalEdge(this.nodeFactory.caseThis(), this.nodeFactory.getNode((Value)sfr));
        }
    }

    public void addInternalEdge(Node src, Node dst) {
        if (src == null) {
            return;
        }
        this.internalEdges.add(src);
        this.internalEdges.add(dst);
    }

    public QueueReader<Node> getInternalReader() {
        return this.internalReader;
    }

    public void addTriggeredClinit(SootMethod clinit) {
        this.clinits.add(clinit);
    }

    public Iterator<SootMethod> triggeredClinits() {
        return this.clinits.iterator();
    }

    public void addExceptionEdge(Node from, Node to) {
        this.exceptionEdges.computeIfAbsent(from, k -> DataFactory.createSet()).add(to);
    }

    public Map<Node, Set<Node>> getExceptionEdges() {
        return this.exceptionEdges;
    }
}

