/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.pag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.builder.CallGraphBuilder;
import qilin.core.context.Context;
import qilin.core.natives.NativeMethodDriver;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ClassConstantNode;
import qilin.core.pag.ContextAllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.FieldValNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.SparkField;
import qilin.core.pag.StringConstantNode;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.core.reflection.NopReflectionModel;
import qilin.core.reflection.ReflectionModel;
import qilin.core.reflection.TamiflexModel;
import qilin.util.ArrayNumberer;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import qilin.util.Triple;
import qilin.util.queue.ChunkedQueue;
import qilin.util.queue.QueueReader;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.StringConstant;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.stmt.FallsThroughStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.java.core.language.JavaJimple;

public class PAG {
    protected final NativeMethodDriver nativeDriver;
    protected final ReflectionModel reflectionModel;
    protected final Map<VarNode, Map<Context, ContextVarNode>> contextVarNodeMap;
    protected final Map<AllocNode, Map<Context, ContextAllocNode>> contextAllocNodeMap;
    protected final Map<SootMethod, Map<Context, ContextMethod>> contextMethodMap;
    protected final Map<MethodPAG, Set<Context>> addedContexts;
    protected final Map<Context, Map<SparkField, ContextField>> contextFieldMap;
    protected ArrayNumberer<AllocNode> allocNodeNumberer = new ArrayNumberer();
    protected ArrayNumberer<ValNode> valNodeNumberer = new ArrayNumberer();
    protected ArrayNumberer<FieldRefNode> fieldRefNodeNumberer = new ArrayNumberer();
    private static AtomicInteger maxFinishNumber = new AtomicInteger(0);
    protected final Map<Object, AllocNode> valToAllocNode;
    protected final Map<Object, ValNode> valToValNode;
    protected final Map<SootMethod, MethodPAG> methodToPag;
    protected final Set<FieldSignature> globals;
    protected final Set<Triple<SootMethod, Local, Type>> locals;
    protected ChunkedQueue<Node> edgeQueue;
    protected final Map<ValNode, Set<ValNode>> simple;
    protected final Map<ValNode, Set<ValNode>> simpleInv;
    protected final Map<FieldRefNode, Set<VarNode>> load;
    protected final Map<VarNode, Set<FieldRefNode>> loadInv;
    protected final Map<AllocNode, Set<VarNode>> alloc;
    protected final Map<VarNode, Set<AllocNode>> allocInv;
    protected final Map<VarNode, Set<FieldRefNode>> store;
    protected final Map<FieldRefNode, Set<VarNode>> storeInv;
    protected final PTA pta;

    public PAG(PTA pta) {
        this.pta = pta;
        this.simple = DataFactory.createMap();
        this.simpleInv = DataFactory.createMap();
        this.load = DataFactory.createMap();
        this.loadInv = DataFactory.createMap();
        this.alloc = DataFactory.createMap();
        this.allocInv = DataFactory.createMap();
        this.store = DataFactory.createMap();
        this.storeInv = DataFactory.createMap();
        this.nativeDriver = new NativeMethodDriver(pta.getScene());
        this.reflectionModel = this.createReflectionModel();
        this.contextVarNodeMap = DataFactory.createMap(16000);
        this.contextAllocNodeMap = DataFactory.createMap(6000);
        this.contextMethodMap = DataFactory.createMap(6000);
        this.addedContexts = DataFactory.createMap();
        this.contextFieldMap = DataFactory.createMap(6000);
        this.valToAllocNode = DataFactory.createMap(10000);
        this.valToValNode = DataFactory.createMap(100000);
        this.methodToPag = DataFactory.createMap();
        this.globals = DataFactory.createSet(100000);
        this.locals = DataFactory.createSet(100000);
    }

    public void setEdgeQueue(ChunkedQueue<Node> edgeQueue) {
        this.edgeQueue = edgeQueue;
    }

    public Map<AllocNode, Set<VarNode>> getAlloc() {
        return this.alloc;
    }

    public Map<ValNode, Set<ValNode>> getSimple() {
        return this.simple;
    }

    public Map<ValNode, Set<ValNode>> getSimpleInv() {
        return this.simpleInv;
    }

    public Map<FieldRefNode, Set<VarNode>> getLoad() {
        return this.load;
    }

    public Map<FieldRefNode, Set<VarNode>> getStoreInv() {
        return this.storeInv;
    }

    public PTA getPta() {
        return this.pta;
    }

    public CallGraphBuilder getCgb() {
        return this.pta.getCgb();
    }

    public QueueReader<Node> edgeReader() {
        return this.edgeQueue.reader();
    }

    protected <K, V> boolean addToMap(Map<K, Set<V>> m, K key, V value) {
        Set valueList = m.computeIfAbsent(key, k -> DataFactory.createSet(4));
        return valueList.add(value);
    }

    private boolean addAllocEdge(AllocNode from, VarNode to) {
        if (this.addToMap(this.alloc, from, to)) {
            this.addToMap(this.allocInv, to, from);
            return true;
        }
        return false;
    }

    private boolean addSimpleEdge(ValNode from, ValNode to) {
        if (this.addToMap(this.simple, from, to)) {
            this.addToMap(this.simpleInv, to, from);
            return true;
        }
        return false;
    }

    private boolean addStoreEdge(VarNode from, FieldRefNode to) {
        if (this.addToMap(this.storeInv, to, from)) {
            this.addToMap(this.store, from, to);
            return true;
        }
        return false;
    }

    private boolean addLoadEdge(FieldRefNode from, VarNode to) {
        if (this.addToMap(this.load, from, to)) {
            this.addToMap(this.loadInv, to, from);
            return true;
        }
        return false;
    }

    public void addGlobalPAGEdge(Node from, Node to) {
        from = this.pta.parameterize(from, this.pta.emptyContext());
        to = this.pta.parameterize(to, this.pta.emptyContext());
        this.addEdge(from, to);
    }

    public final void addEdge(Node from, Node to) {
        if (this.addEdgeIntenal(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
        }
    }

    private boolean addEdgeIntenal(Node from, Node to) {
        if (from instanceof ValNode) {
            if (to instanceof ValNode) {
                return this.addSimpleEdge((ValNode)from, (ValNode)to);
            }
            return this.addStoreEdge((VarNode)from, (FieldRefNode)to);
        }
        if (from instanceof FieldRefNode) {
            return this.addLoadEdge((FieldRefNode)from, (VarNode)to);
        }
        AllocNode heap = (AllocNode)from;
        return this.addAllocEdge(heap, (VarNode)to);
    }

    protected <K, V> Set<V> lookup(Map<K, Set<V>> m, K key) {
        return m.getOrDefault(key, Collections.emptySet());
    }

    public Set<VarNode> allocLookup(AllocNode key) {
        return this.lookup(this.alloc, key);
    }

    public Set<AllocNode> allocInvLookup(VarNode key) {
        return this.lookup(this.allocInv, key);
    }

    public Set<ValNode> simpleLookup(ValNode key) {
        return this.lookup(this.simple, key);
    }

    public Set<ValNode> simpleInvLookup(ValNode key) {
        return this.lookup(this.simpleInv, key);
    }

    public Set<FieldRefNode> loadInvLookup(VarNode key) {
        return this.lookup(this.loadInv, key);
    }

    public Set<VarNode> loadLookup(FieldRefNode key) {
        return this.lookup(this.load, key);
    }

    public Set<FieldRefNode> storeLookup(VarNode key) {
        return this.lookup(this.store, key);
    }

    public Set<VarNode> storeInvLookup(FieldRefNode key) {
        return this.lookup(this.storeInv, key);
    }

    public static int nextFinishNumber() {
        return maxFinishNumber.incrementAndGet();
    }

    public ArrayNumberer<AllocNode> getAllocNodeNumberer() {
        return this.allocNodeNumberer;
    }

    public ArrayNumberer<FieldRefNode> getFieldRefNodeNumberer() {
        return this.fieldRefNodeNumberer;
    }

    public ArrayNumberer<ValNode> getValNodeNumberer() {
        return this.valNodeNumberer;
    }

    public Collection<ValNode> getValNodes() {
        return this.valToValNode.values();
    }

    public Collection<AllocNode> getAllocNodes() {
        return this.valToAllocNode.values();
    }

    public Set<FieldSignature> getGlobalPointers() {
        return this.globals;
    }

    public Set<Triple<SootMethod, Local, Type>> getLocalPointers() {
        return this.locals;
    }

    public ValNode findValNode(Object value, SootMethod containingMethod) {
        if (value instanceof Local) {
            Local local = (Local)value;
            Triple<SootMethod, Local, Type> localTriple = new Triple<SootMethod, Local, Type>(containingMethod, local, local.getType());
            return this.valToValNode.get(localTriple);
        }
        return this.valToValNode.get(value);
    }

    public AllocNode findAllocNode(Object obj) {
        return this.valToAllocNode.get(obj);
    }

    public AllocNode makeAllocNode(Object newExpr, Type type, SootMethod m) {
        AllocNode ret;
        if (type instanceof ClassType) {
            ClassType rt = (ClassType)type;
            View view = this.pta.getView();
            Optional osc = view.getClass(rt);
            if (osc.isPresent() && ((SootClass)osc.get()).isAbstract()) {
                boolean usesReflectionLog;
                boolean bl = usesReflectionLog = CoreConfig.v().getAppConfig().REFLECTION_LOG != null;
                if (!usesReflectionLog) {
                    throw new RuntimeException("Attempt to create allocnode with abstract type " + rt);
                }
            }
        }
        if ((ret = this.valToAllocNode.get(newExpr)) == null) {
            ret = new AllocNode(newExpr, type, m);
            this.valToAllocNode.put(newExpr, ret);
            this.allocNodeNumberer.add(ret);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("NewExpr " + newExpr + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public AllocNode makeStringConstantNode(StringConstant sc) {
        AllocNode ret;
        StringConstant stringConstant = sc;
        if (!CoreConfig.v().getPtaConfig().stringConstants) {
            stringConstant = JavaJimple.getInstance().newStringConstant("STRING_NODE");
        }
        if ((ret = this.valToAllocNode.get(stringConstant)) == null) {
            ret = new StringConstantNode(stringConstant);
            this.valToAllocNode.put(stringConstant, ret);
            this.allocNodeNumberer.add(ret);
        }
        return ret;
    }

    public AllocNode makeClassConstantNode(ClassConstant cc) {
        AllocNode ret = this.valToAllocNode.get(cc);
        if (ret == null) {
            ret = new ClassConstantNode(cc);
            this.valToAllocNode.put(cc, ret);
            this.allocNodeNumberer.add(ret);
        }
        return ret;
    }

    public GlobalVarNode makeGlobalVarNode(Object value, Type type) {
        GlobalVarNode ret = (GlobalVarNode)this.valToValNode.get(value);
        if (ret == null) {
            ret = (GlobalVarNode)this.valToValNode.computeIfAbsent(value, k -> new GlobalVarNode(value, type));
            this.valNodeNumberer.add(ret);
            if (value instanceof FieldSignature) {
                this.globals.add((FieldSignature)value);
            }
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public LocalVarNode makeLocalVarNode(Object value, Type type, SootMethod method) {
        Triple<SootMethod, Object, Type> localTriple = new Triple<SootMethod, Object, Type>(method, value, type);
        LocalVarNode ret = (LocalVarNode)this.valToValNode.get(localTriple);
        if (ret == null) {
            ret = new LocalVarNode(value, type, method);
            this.valToValNode.put(localTriple, ret);
            this.valNodeNumberer.add(ret);
            if (value instanceof Local) {
                Local local = (Local)value;
                this.locals.add(new Triple<SootMethod, Local, Type>(method, local, type));
            }
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public FieldValNode makeFieldValNode(SparkField field) {
        FieldValNode ret = (FieldValNode)this.valToValNode.get(field);
        if (ret == null) {
            ret = new FieldValNode(field);
            this.valToValNode.put(field, ret);
            this.valNodeNumberer.add(ret);
        }
        return ret;
    }

    public FieldRefNode makeFieldRefNode(VarNode base, SparkField field) {
        FieldRefNode ret = base.dot(field);
        if (ret == null) {
            ret = new FieldRefNode(base, field);
            this.fieldRefNodeNumberer.add(ret);
        }
        return ret;
    }

    public ContextVarNode makeContextVarNode(VarNode base, Context context) {
        Map contextMap = this.contextVarNodeMap.computeIfAbsent(base, k1 -> DataFactory.createMap());
        ContextVarNode ret = (ContextVarNode)contextMap.get(context);
        if (ret == null) {
            ret = new ContextVarNode(base, context);
            contextMap.put(context, ret);
            this.valNodeNumberer.add(ret);
        }
        return ret;
    }

    public ContextAllocNode makeContextAllocNode(AllocNode allocNode, Context context) {
        Map contextMap = this.contextAllocNodeMap.computeIfAbsent(allocNode, k1 -> DataFactory.createMap());
        ContextAllocNode ret = (ContextAllocNode)contextMap.get(context);
        if (ret == null) {
            ret = new ContextAllocNode(allocNode, context);
            contextMap.put(context, ret);
            this.allocNodeNumberer.add(ret);
        }
        return ret;
    }

    public ContextMethod makeContextMethod(Context context, SootMethod method) {
        Map contextMap = this.contextMethodMap.computeIfAbsent(method, k1 -> DataFactory.createMap());
        return contextMap.computeIfAbsent(context, k -> new ContextMethod(method, context));
    }

    public AllocNode getAllocNode(Object val) {
        return this.valToAllocNode.get(val);
    }

    public Map<MethodPAG, Set<Context>> getMethod2ContextsMap() {
        return this.addedContexts;
    }

    public Collection<ContextField> getContextFields() {
        return this.contextFieldMap.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
    }

    public Map<VarNode, Map<Context, ContextVarNode>> getContextVarNodeMap() {
        return this.contextVarNodeMap;
    }

    public Map<AllocNode, Map<Context, ContextAllocNode>> getContextAllocNodeMap() {
        return this.contextAllocNodeMap;
    }

    public Map<SootMethod, Map<Context, ContextMethod>> getContextMethodMap() {
        return this.contextMethodMap;
    }

    public Map<Context, Map<SparkField, ContextField>> getContextFieldVarNodeMap() {
        return this.contextFieldMap;
    }

    public ContextField makeContextField(Context context, FieldValNode fieldValNode) {
        SparkField field = fieldValNode.getField();
        Map field2odotf = this.contextFieldMap.computeIfAbsent(context, k -> DataFactory.createMap());
        ContextField ret = (ContextField)field2odotf.get(field);
        if (ret == null) {
            ret = new ContextField(context, field);
            field2odotf.put(field, ret);
            this.valNodeNumberer.add(ret);
        }
        return ret;
    }

    public Collection<VarNode> getVarNodes(SootMethod m, Local local) {
        LocalVarNode lvn = this.findLocalVarNode(m, local, local.getType());
        Map<Context, ContextVarNode> subMap = this.contextVarNodeMap.get(lvn);
        if (subMap == null) {
            return Collections.emptySet();
        }
        return new HashSet<VarNode>(subMap.values());
    }

    public GlobalVarNode findGlobalVarNode(Object value) {
        if (value instanceof Local) {
            System.out.println("Warning: find global varnode for local value:" + value);
            return null;
        }
        return (GlobalVarNode)this.valToValNode.get(value);
    }

    public LocalVarNode findLocalVarNode(SootMethod m, Object value, Type type) {
        Triple<SootMethod, Object, Type> key = new Triple<SootMethod, Object, Type>(m, value, type);
        ValNode ret = this.valToValNode.get(key);
        if (ret instanceof LocalVarNode) {
            return (LocalVarNode)ret;
        }
        return null;
    }

    public ContextVarNode findContextVarNode(SootMethod m, Local baseValue, Context context) {
        LocalVarNode lvn = this.findLocalVarNode(m, baseValue, baseValue.getType());
        Map<Context, ContextVarNode> contextMap = this.contextVarNodeMap.get(lvn);
        return contextMap == null ? null : contextMap.get(context);
    }

    protected ReflectionModel createReflectionModel() {
        ReflectionModel model = CoreConfig.v().getAppConfig().REFLECTION_LOG != null && CoreConfig.v().getAppConfig().REFLECTION_LOG.length() > 0 ? new TamiflexModel(this.pta.getScene()) : new NopReflectionModel(this.pta.getScene());
        return model;
    }

    public MethodPAG getMethodPAG(SootMethod m) {
        if (this.methodToPag.containsKey(m)) {
            return this.methodToPag.get(m);
        }
        if (m.isConcrete()) {
            this.reflectionModel.buildReflection(m);
        }
        if (m.isNative()) {
            this.nativeDriver.buildNative(m);
        } else if (this.pta.getScene().arraycopyBuilt.add(m)) {
            this.handleArrayCopy(m);
        }
        Body body = PTAUtils.getMethodBody(m);
        return this.methodToPag.computeIfAbsent(m, k -> new MethodPAG(this, m, body));
    }

    private void handleArrayCopy(SootMethod method) {
        Map<Stmt, Collection> newUnits = DataFactory.createMap();
        Body body = PTAUtils.getMethodBody(method);
        Body.BodyBuilder builder = Body.builder((Body)body, Collections.emptySet());
        int localCount = body.getLocalCount();
        for (Stmt s : body.getStmts()) {
            Immediate dstArr;
            Immediate srcArr;
            JStaticInvokeExpr sie;
            String sig;
            AbstractInvokeExpr invokeExpr;
            if (!s.containsInvokeExpr() || !((invokeExpr = s.getInvokeExpr()) instanceof JStaticInvokeExpr) || !(sig = (sie = (JStaticInvokeExpr)invokeExpr).getMethodSignature().toString()).equals("<java.lang.System: void arraycopy(java.lang.Object,int,java.lang.Object,int,int)>") || PTAUtils.isPrimitiveArrayType((srcArr = sie.getArg(0)).getType())) continue;
            ClassType objType = PTAUtils.getClassType("java.lang.Object");
            if (srcArr.getType() == objType) {
                Local localSrc = Jimple.newLocal((String)("intermediate/" + localCount++), (Type)new ArrayType((Type)objType, 1));
                builder.addLocal(localSrc);
                newUnits.computeIfAbsent(s, k -> new HashSet()).add(new JAssignStmt((LValue)localSrc, (Value)srcArr, StmtPositionInfo.getNoStmtPositionInfo()));
                srcArr = localSrc;
            }
            if (PTAUtils.isPrimitiveArrayType((dstArr = sie.getArg(2)).getType())) continue;
            if (dstArr.getType() == objType) {
                Local localDst = Jimple.newLocal((String)("intermediate/" + localCount++), (Type)new ArrayType((Type)objType, 1));
                builder.addLocal(localDst);
                newUnits.computeIfAbsent(s, k -> new HashSet()).add(new JAssignStmt((LValue)localDst, (Value)dstArr, StmtPositionInfo.getNoStmtPositionInfo()));
                dstArr = localDst;
            }
            JArrayRef src = JavaJimple.getInstance().newArrayRef((Local)srcArr, (Immediate)IntConstant.getInstance((int)0));
            JArrayRef dst = JavaJimple.getInstance().newArrayRef((Local)dstArr, (Immediate)IntConstant.getInstance((int)0));
            Local local = Jimple.newLocal((String)("nativeArrayCopy" + localCount++), (Type)PTAUtils.getClassType("java.lang.Object"));
            builder.addLocal(local);
            newUnits.computeIfAbsent(s, k -> DataFactory.createSet()).add(new JAssignStmt((LValue)local, (Value)src, StmtPositionInfo.getNoStmtPositionInfo()));
            newUnits.computeIfAbsent(s, k -> DataFactory.createSet()).add(new JAssignStmt((LValue)dst, (Value)local, StmtPositionInfo.getNoStmtPositionInfo()));
        }
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        for (Stmt unit : newUnits.keySet()) {
            for (JAssignStmt succ : (Collection)newUnits.get(unit)) {
                stmtGraph.insertBefore(unit, (FallsThroughStmt)succ);
            }
        }
        PTAUtils.updateMethodBody(method, builder.build());
    }

    public void resetPointsToSet() {
        this.addedContexts.clear();
        this.contextVarNodeMap.values().stream().flatMap(m -> m.values().stream()).forEach(ValNode::discardP2Set);
        this.contextFieldMap.values().stream().flatMap(m -> m.values().stream()).forEach(ValNode::discardP2Set);
        this.valToValNode.values().forEach(ValNode::discardP2Set);
        this.addedContexts.clear();
    }
}

