/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.pag;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import qilin.core.context.Context;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.SparkField;
import qilin.core.pag.ValNode;
import qilin.util.DataFactory;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;

public abstract class VarNode
extends ValNode {
    protected Object variable;
    protected Map<SparkField, FieldRefNode> fields;
    protected boolean interProcTarget = false;
    protected boolean interProcSource = false;

    protected VarNode(Object variable, Type t) {
        super(t);
        if (!(t instanceof ReferenceType)) {
            throw new RuntimeException("Attempt to create VarNode of type " + t);
        }
        this.variable = variable;
    }

    public Context context() {
        return null;
    }

    public Collection<FieldRefNode> getAllFieldRefs() {
        if (this.fields == null) {
            return Collections.emptyList();
        }
        return this.fields.values();
    }

    public FieldRefNode dot(SparkField field) {
        return this.fields == null ? null : this.fields.get(field);
    }

    public Object getVariable() {
        return this.variable;
    }

    public void setInterProcTarget() {
        this.interProcTarget = true;
    }

    public boolean isInterProcTarget() {
        return this.interProcTarget;
    }

    public void setInterProcSource() {
        this.interProcSource = true;
    }

    public boolean isInterProcSource() {
        return this.interProcSource;
    }

    public abstract VarNode base();

    public abstract SootMethod getMethod();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addField(FieldRefNode frn, SparkField field) {
        if (this.fields == null) {
            VarNode varNode = this;
            synchronized (varNode) {
                if (this.fields == null) {
                    this.fields = DataFactory.createMap();
                }
            }
        }
        this.fields.put(field, frn);
    }
}

