/*
 * Decompiled with CFR 0.152.
 */
package qilin.driver;

import java.lang.management.ManagementFactory;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.driver.PTAFactory;
import qilin.driver.PTAOption;
import qilin.driver.PTAPattern;
import qilin.pta.PTAConfig;
import qilin.util.MemoryWatcher;
import qilin.util.PTAUtils;
import qilin.util.Stopwatch;
import sootup.core.views.View;

public class Main {
    public static PTA run(String[] args) {
        new PTAOption().parseCommandLine(args);
        CoreConfig.ApplicationConfiguration appConfig = PTAConfig.v().getAppConfig();
        if (appConfig.MAIN_CLASS == null) {
            appConfig.MAIN_CLASS = PTAUtils.findMainFromMetaInfo(appConfig.APP_PATH);
        }
        View view = PTAUtils.createView();
        PTAPattern ptaPattern = PTAConfig.v().getPtaConfig().ptaPattern;
        PTA pta = PTAFactory.createPTA(ptaPattern, view, appConfig.MAIN_CLASS);
        if (PTAConfig.v().getOutConfig().dumpJimple) {
            String jimplePath = PTAConfig.v().getAppConfig().APP_PATH.replace(".jar", "");
            PTAUtils.dumpJimple(pta.getScene(), jimplePath);
            System.out.println("Jimple files have been dumped to: " + jimplePath);
        }
        pta.run();
        return pta;
    }

    public static void mainRun(String[] args) {
        Stopwatch ptaTimer = Stopwatch.newAndStart("Main PTA (including pre-analysis)");
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        String s = jvmName.split("@")[0];
        long pid = Long.parseLong(s);
        MemoryWatcher memoryWatcher = new MemoryWatcher(pid, "Main PTA");
        memoryWatcher.start();
        Main.run(args);
        ptaTimer.stop();
        System.out.println(ptaTimer);
        memoryWatcher.stop();
        System.out.println(memoryWatcher);
    }

    public static void main(String[] args) {
        Main.mainRun(args);
    }
}

