/*
 * Decompiled with CFR 0.152.
 */
package qilin.driver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import qilin.driver.ContextKind;
import qilin.util.Util;

public class PTAPattern {
    private ContextKind ctxKind;
    private Approach approach;
    private int k;
    private int hk;

    public PTAPattern(String ptacmd) {
        this.parsePTACommand(ptacmd);
    }

    private Pattern getSupportPTAPattern() {
        String approachPtn = "(" + String.join((CharSequence)"|", Approach.approachAliases()) + ")";
        String ctxLenPtn = "(\\d*)";
        String ctxKindPtn = "(" + String.join((CharSequence)"|", ContextKind.contextAliases()) + ")";
        String heapLenPtn = "(\\+?(\\d*)h(eap)?)?";
        String regexPattern = "^(" + approachPtn + "-)?" + ctxLenPtn + ctxKindPtn + heapLenPtn + "$";
        return Pattern.compile(regexPattern);
    }

    private void parsePTACommand(String ptacmd) {
        Pattern pattern = this.getSupportPTAPattern();
        Matcher matcher = pattern.matcher(ptacmd);
        if (!matcher.find()) {
            throw new RuntimeException("Unsupported PTA: " + ptacmd + " !");
        }
        String approachString = matcher.group(2);
        String kString = matcher.group(3);
        String typeString = matcher.group(4);
        String hkString = matcher.group(6);
        this.approach = Approach.toApproach(approachString);
        this.k = kString.equals("") ? 1 : Integer.parseInt(kString);
        this.ctxKind = ContextKind.toCtxKind(typeString);
        int n = hkString == null ? -1 : (this.hk = hkString.equals("") ? 1 : Integer.parseInt(hkString));
        if (this.k == 0) {
            this.ctxKind = ContextKind.INSENS;
        }
        if (this.hk == -1) {
            this.hk = this.k - 1;
        }
        this.validateApproachCompatibility();
        this.validateContextLength();
    }

    private void validateApproachCompatibility() {
        switch (this.ctxKind) {
            case HYBOBJ: {
                if (this.approach == Approach.DATADRIVEN || this.approach == Approach.NONE || this.approach == Approach.TUNNELING) break;
                throw new RuntimeException("Approach <" + this.approach.toString() + " > is currently not designed for hybrid sensitivity");
            }
            case HYBTYPE: {
                if (this.approach == Approach.NONE) break;
                throw new RuntimeException("Approach <" + this.approach.toString() + " > is currently not designed for hybrid sensitivity");
            }
            case TYPE: {
                if (this.approach == Approach.NONE || this.approach == Approach.TUNNELING) break;
                throw new RuntimeException("Approach <" + this.approach.toString() + "> is currently not designed for type sensitivity.");
            }
            case CALLSITE: {
                if (this.approach == Approach.NONE || this.approach == Approach.ZIPPER || this.approach == Approach.MAHJONG || this.approach == Approach.DATADRIVEN || this.approach == Approach.TUNNELING || this.approach == Approach.SELECTX) break;
                throw new RuntimeException("Approach <" + this.approach.toString() + "> is currently not designed for call-site sensitivity.");
            }
            case OBJECT: {
                if (this.approach == Approach.EAGLE || this.approach == Approach.ZIPPER || this.approach == Approach.TURNER || this.approach == Approach.DATADRIVEN || this.approach == Approach.TUNNELING || this.approach == Approach.MERCURIAL || this.approach == Approach.MAHJONG || this.approach == Approach.BEAN || this.approach == Approach.NONE) break;
                throw new RuntimeException("Approach <" + this.approach.toString() + "> is currently not designed for object sensitivity.");
            }
            case INSENS: {
                if (this.approach == Approach.SPARK || this.approach == Approach.NONE) break;
                throw new RuntimeException("Approach <" + this.approach.toString() + "> is currently not designed for context insensitive pointer analysis.");
            }
        }
    }

    private void validateContextLength() {
        if (this.ctxKind == ContextKind.INSENS) {
            return;
        }
        if (this.hk > this.k) {
            throw new RuntimeException("Heap context depth cannot exceed method context depth!");
        }
        if (this.hk < this.k - 1 && (this.ctxKind == ContextKind.OBJECT || this.ctxKind == ContextKind.TYPE)) {
            throw new RuntimeException("Heap context depth can only be k or k-1 for object/type-sensitive analysis!");
        }
    }

    public ContextKind getContextKind() {
        return this.ctxKind;
    }

    public Approach getApproach() {
        return this.approach;
    }

    public int getContextDepth() {
        return this.k;
    }

    public int getHeapContextDepth() {
        return this.hk;
    }

    public String toString() {
        if (this.ctxKind == ContextKind.INSENS) {
            return "insensitive";
        }
        StringBuilder builder = new StringBuilder();
        if (!this.approach.toString().isEmpty()) {
            builder.append((Object)this.approach);
            builder.append('-');
        }
        builder.append(this.k);
        builder.append(this.ctxKind.toString());
        builder.append('+');
        builder.append(this.hk);
        builder.append("heap");
        return builder.toString();
    }

    public static enum Approach {
        NONE,
        SPARK,
        BEAN,
        ZIPPER,
        EAGLE,
        TURNER,
        DATADRIVEN,
        TUNNELING,
        MERCURIAL,
        MAHJONG,
        SELECTX;

        static final Map<String, Approach> approaches;

        public static Collection<String> approachAliases() {
            return approaches.keySet();
        }

        public static Approach toApproach(String name) {
            return approaches.getOrDefault(name, NONE);
        }

        public String toString() {
            switch (this) {
                case DATADRIVEN: {
                    return "data-driven";
                }
                case TUNNELING: {
                    return "tunneling";
                }
                case BEAN: {
                    return "bean";
                }
                case ZIPPER: {
                    return "zipper";
                }
                case EAGLE: {
                    return "eagle";
                }
                case TURNER: {
                    return "turner";
                }
                case MERCURIAL: {
                    return "mercurial";
                }
                case MAHJONG: {
                    return "mahjong";
                }
                case SELECTX: {
                    return "selectx";
                }
                case SPARK: {
                    return "spark";
                }
            }
            return "";
        }

        static {
            approaches = new HashMap<String, Approach>();
            Util.add(approaches, BEAN, "bean", "B");
            Util.add(approaches, ZIPPER, "zipper", "Z");
            Util.add(approaches, EAGLE, "eagle", "E");
            Util.add(approaches, TURNER, "turner", "T");
            Util.add(approaches, MERCURIAL, "mercurial", "hg");
            Util.add(approaches, MAHJONG, "mahjong", "M");
            Util.add(approaches, DATADRIVEN, "datadriven", "D");
            Util.add(approaches, TUNNELING, "tunneling", "t");
            Util.add(approaches, SELECTX, "selectx", "s");
            Util.add(approaches, SPARK, "insens", "ci");
        }
    }
}

