/*
 * Decompiled with CFR 0.152.
 */
package qilin.parm.heapabst;

import java.util.Set;
import qilin.core.pag.AllocNode;
import qilin.core.pag.MergedNewExpr;
import qilin.core.pag.PAG;
import qilin.parm.heapabst.HeapAbstractor;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.core.views.View;

public class HeuristicAbstractor
implements HeapAbstractor {
    private final PAG pag;
    private final View view;
    private final Set<Type> mergedTypes = DataFactory.createSet();

    public HeuristicAbstractor(PAG pag) {
        this.pag = pag;
        this.view = pag.getPta().getView();
        this.mergedTypes.add((Type)PTAUtils.getClassType("java.lang.StringBuffer"));
        this.mergedTypes.add((Type)PTAUtils.getClassType("java.lang.StringBuilder"));
    }

    @Override
    public AllocNode abstractHeap(AllocNode heap) {
        Type type = heap.getType();
        if (this.mergedTypes.contains(type) || PTAUtils.isThrowable(this.view, type) && this.mergedTypes.add(type)) {
            return this.pag.makeAllocNode(MergedNewExpr.v((ReferenceType)type), type, null);
        }
        return heap;
    }
}

