/*
 * Decompiled with CFR 0.152.
 */
package qilin.parm.heapabst;

import java.util.Map;
import java.util.Set;
import qilin.core.pag.AllocNode;
import qilin.core.pag.PAG;
import qilin.parm.heapabst.HeapAbstractor;
import qilin.util.PTAUtils;
import sootup.core.model.SootMethod;
import sootup.core.types.Type;
import sootup.core.views.View;

public class MahjongAbstractor
implements HeapAbstractor {
    private final Set<Object> mergedHeap;
    private final Map<Object, Object> heapModelMap;
    private final PAG pag;
    private final View view;

    public MahjongAbstractor(PAG pag, Set<Object> mergedHeap, Map<Object, Object> heapModelMap) {
        this.pag = pag;
        this.view = pag.getPta().getView();
        this.mergedHeap = mergedHeap;
        this.heapModelMap = heapModelMap;
    }

    @Override
    public AllocNode abstractHeap(AllocNode heap) {
        Object newExpr = heap.getNewExpr();
        Type type = heap.getType();
        SootMethod m = heap.getMethod();
        Object mergedIr = this.heapModelMap.get(newExpr);
        if (this.mergedHeap.contains(mergedIr)) {
            return this.pag.makeAllocNode(mergedIr, type, null);
        }
        if (PTAUtils.isThrowable(this.view, type)) {
            return this.pag.makeAllocNode("Merged " + type, type, null);
        }
        return this.pag.makeAllocNode(newExpr, type, m);
    }
}

